/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.variant.ApplicationAndroidResources;
import com.android.build.api.variant.ApplicationVariantBuilder;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.api.variant.impl.ApplicationAndroidResourcesImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.AbstractAppTaskManager;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.DeviceTestCreationConfig;
import com.android.build.gradle.internal.component.TestComponentCreationConfig;
import com.android.build.gradle.internal.component.TestFixturesCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.dsl.AbstractPublishing;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.ComponentPublishingInfo;
import com.android.build.gradle.internal.publishing.PublishedConfigSpec;
import com.android.build.gradle.internal.publishing.VariantPublishingInfo;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.AnchorTaskNames;
import com.android.build.gradle.internal.tasks.AppMetadataTask;
import com.android.build.gradle.internal.tasks.ApplicationTaskManager;
import com.android.build.gradle.internal.tasks.AsarsToCompatSplitsTask;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTask;
import com.android.build.gradle.internal.tasks.AssetPackUtilKt;
import com.android.build.gradle.internal.tasks.BundleIdeModelProducerTask;
import com.android.build.gradle.internal.tasks.BundleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.BundleToApkTask;
import com.android.build.gradle.internal.tasks.BundleToStandaloneApkTask;
import com.android.build.gradle.internal.tasks.ClassesClasspathUtils;
import com.android.build.gradle.internal.tasks.CompileArtProfileTask;
import com.android.build.gradle.internal.tasks.ExpandArtProfileWildcardsTask;
import com.android.build.gradle.internal.tasks.ExtractApksTask;
import com.android.build.gradle.internal.tasks.ExtractPrivacySandboxCompatApks;
import com.android.build.gradle.internal.tasks.ExtractVersionControlInfoTask;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask;
import com.android.build.gradle.internal.tasks.GenerateAdditionalApkSplitForDeploymentViaApk;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.GeneratePrivacySandboxSdkRuntimeConfigFile;
import com.android.build.gradle.internal.tasks.GenerateRuntimeEnabledSdkTableTask;
import com.android.build.gradle.internal.tasks.InstallVariantViaBundleTask;
import com.android.build.gradle.internal.tasks.LinkManifestForAssetPackTask;
import com.android.build.gradle.internal.tasks.ListingFileRedirectTask;
import com.android.build.gradle.internal.tasks.MergeArtProfileTask;
import com.android.build.gradle.internal.tasks.MergeNativeDebugMetadataTask;
import com.android.build.gradle.internal.tasks.MergeStartupProfileTask;
import com.android.build.gradle.internal.tasks.PackageBundleTask;
import com.android.build.gradle.internal.tasks.ParseIntegrityConfigTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.PerModuleReportDependenciesTask;
import com.android.build.gradle.internal.tasks.ProcessAssetPackManifestTask;
import com.android.build.gradle.internal.tasks.SdkDependencyDataGeneratorTask;
import com.android.build.gradle.internal.tasks.SigningConfigVersionsWriterTask;
import com.android.build.gradle.internal.tasks.SigningConfigWriterTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureNamespacesTask;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.tasks.factory.TaskConfigAction;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.factory.TaskManagerConfig;
import com.android.build.gradle.internal.tasks.factory.TaskProviderCallback;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadataWriterTask;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.BuildPrivacySandboxSdkApks;
import com.android.build.gradle.tasks.ExtractSupportedLocalesTask;
import com.android.build.gradle.tasks.GenerateLocaleConfigTask;
import com.android.builder.core.ComponentType;
import com.android.builder.errors.IssueReporter;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B]\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001c\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\bH\u0014J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u001c\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00032\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u001c\u0010!\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\bH\u0002J \u0010\"\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)H\u0014R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/build/gradle/internal/tasks/ApplicationTaskManager;", "Lcom/android/build/gradle/internal/AbstractAppTaskManager;", "Lcom/android/build/api/variant/ApplicationVariantBuilder;", "Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;", "project", "Lorg/gradle/api/Project;", "variants", "", "Lcom/android/build/gradle/internal/variant/ComponentInfo;", "testComponents", "Lcom/android/build/gradle/internal/component/TestComponentCreationConfig;", "testFixturesComponents", "Lcom/android/build/gradle/internal/component/TestFixturesCreationConfig;", "globalConfig", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "localConfig", "Lcom/android/build/gradle/internal/tasks/factory/TaskManagerConfig;", "extension", "Lcom/android/build/gradle/BaseExtension;", "<init>", "(Lorg/gradle/api/Project;Ljava/util/Collection;Ljava/util/Collection;Ljava/util/Collection;Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;Lcom/android/build/gradle/internal/tasks/factory/TaskManagerConfig;Lcom/android/build/gradle/BaseExtension;)V", "doCreateTasksForVariant", "", "variantInfo", "createBundleTask", "component", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "handleMicroApp", "appVariant", "createGenerateMicroApkDataTask", "config", "Lorg/gradle/api/file/FileCollection;", "createAssetPackTasks", "createDynamicBundleTask", "createSoftwareComponent", "componentName", "", "publication", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$PublishedConfigType;", "createInstallTask", "creationConfig", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "gradle-core"})
public final class ApplicationTaskManager
extends AbstractAppTaskManager<ApplicationVariantBuilder, ApplicationCreationConfig> {
    @NotNull
    private final Collection<ComponentInfo<ApplicationVariantBuilder, ApplicationCreationConfig>> variants;

    public ApplicationTaskManager(@NotNull Project project, @NotNull Collection<? extends ComponentInfo<ApplicationVariantBuilder, ApplicationCreationConfig>> variants, @NotNull Collection<? extends TestComponentCreationConfig> testComponents, @NotNull Collection<? extends TestFixturesCreationConfig> testFixturesComponents, @NotNull GlobalTaskCreationConfig globalConfig2, @NotNull TaskManagerConfig localConfig, @NotNull BaseExtension extension2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        Intrinsics.checkNotNullParameter(testComponents, (String)"testComponents");
        Intrinsics.checkNotNullParameter(testFixturesComponents, (String)"testFixturesComponents");
        Intrinsics.checkNotNullParameter((Object)globalConfig2, (String)"globalConfig");
        Intrinsics.checkNotNullParameter((Object)localConfig, (String)"localConfig");
        Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
        super(project, variants, testComponents, testFixturesComponents, globalConfig2, localConfig, extension2);
        this.variants = variants;
    }

    @Override
    protected void doCreateTasksForVariant(@NotNull ComponentInfo<ApplicationVariantBuilder, ApplicationCreationConfig> variantInfo2) {
        Intrinsics.checkNotNullParameter(variantInfo2, (String)"variantInfo");
        this.createCommonTasks(variantInfo2);
        ApplicationCreationConfig variant = variantInfo2.getVariant();
        this.createBundleTask(variant);
        this.taskFactory.register(new FeatureSetMetadataWriterTask.CreationAction(variant));
        this.createValidateSigningTask(variant);
        this.taskFactory.register(new SigningConfigWriterTask.CreationAction(variant));
        this.taskFactory.register(new SigningConfigVersionsWriterTask.CreationAction(variant));
        TaskProvider[] taskProviderArray = new TaskProvider[]{variant.getTaskContainer().getPreBuildTask()};
        TaskFactoryUtils.dependsOn(this.taskFactory.register(new AppMetadataTask.CreationAction(variant)), taskProviderArray);
        if (!((Collection)this.globalConfig.getAssetPacks()).isEmpty()) {
            this.createAssetPackTasks(variant);
        }
        this.taskFactory.register(new MergeArtProfileTask.CreationAction(variant));
        Function1 function1 = doCreateTasksForVariant.r8DexStartupOptimizationEnabled.1.INSTANCE;
        Provider r8DexStartupOptimizationEnabled2 = variant.getExperimentalProperties().map(new Transformer(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object transform(Object in) {
                return this.function.invoke(in);
            }
        });
        Function1 function12 = doCreateTasksForVariant.d8DexStartupOptimizationEnabled.1.INSTANCE;
        Provider d8DexStartupOptimizationEnabled2 = variant.getExperimentalProperties().map(new /* invalid duplicate definition of identical inner class */);
        if (((Boolean)r8DexStartupOptimizationEnabled2.get()).booleanValue() || ((Boolean)d8DexStartupOptimizationEnabled2.get()).booleanValue()) {
            this.taskFactory.register(new MergeStartupProfileTask.CreationAction(variant));
        }
        if (variant.getOptimizationCreationConfig().getMinifiedEnabled()) {
            ClassesClasspathUtils classpathUtils = this.getClassPathUtils(variant);
            this.taskFactory.register(new ExpandArtProfileWildcardsTask.CreationAction(variant, classpathUtils));
        }
        this.taskFactory.register(new CompileArtProfileTask.CreationAction(variant));
        ApplicationAndroidResourcesImpl applicationAndroidResourcesImpl = variant.getAndroidResources();
        ApplicationAndroidResources applicationAndroidResources = applicationAndroidResourcesImpl instanceof ApplicationAndroidResources ? (ApplicationAndroidResources)applicationAndroidResourcesImpl : null;
        boolean bl = applicationAndroidResources != null ? applicationAndroidResources.getGenerateLocaleConfig() : false;
        if (bl) {
            this.taskFactory.register(new ExtractSupportedLocalesTask.CreationAction(variant));
            this.taskFactory.register(new GenerateLocaleConfigTask.CreationAction(variant));
        }
        if (variant.getBuildFeatures().getDataBinding() && this.globalConfig.getHasDynamicFeatures()) {
            this.taskFactory.register(new DataBindingExportFeatureNamespacesTask.CreationAction(variant));
        }
        this.taskFactory.register(new AsarsToCompatSplitsTask.CreationAction(variant));
        this.createDynamicBundleTask(variantInfo2);
        this.handleMicroApp(variant);
        if (variant.getIncludeVcsInfo() == null && !variantInfo2.getVariantBuilder().getDebuggable() || Intrinsics.areEqual((Object)variant.getIncludeVcsInfo(), (Object)true)) {
            this.taskFactory.register(new ExtractVersionControlInfoTask.CreationAction(variant));
        }
        VariantPublishingInfo variantPublishingInfo = variant.getPublishInfo();
        Intrinsics.checkNotNull((Object)variantPublishingInfo);
        VariantPublishingInfo publishInfo = variantPublishingInfo;
        for (ComponentPublishingInfo component2 : publishInfo.getComponents()) {
            AndroidArtifacts.PublishedConfigType configType = component2.getType() == AbstractPublishing.Type.APK ? AndroidArtifacts.PublishedConfigType.APK_PUBLICATION : AndroidArtifacts.PublishedConfigType.AAB_PUBLICATION;
            this.createSoftwareComponent(variant, component2.getComponentName(), configType);
        }
    }

    private final void createBundleTask(ComponentCreationConfig component2) {
        this.taskFactory.register(component2.computeTaskNameInternal("bundle"), null, (TaskConfigAction<? super Task>)new TaskConfigAction<Task>(component2){
            final /* synthetic */ ComponentCreationConfig $component;
            {
                this.$component = $component;
            }

            public void configure(Task task) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                task.setDescription("Assembles bundle for variant " + this.$component.getName());
                Object[] objectArray = new Object[]{this.$component.getArtifacts().get((SingleArtifact)SingleArtifact.BUNDLE.INSTANCE)};
                task.dependsOn(objectArray);
            }
        }, new TaskProviderCallback<Task>(component2){
            final /* synthetic */ ComponentCreationConfig $component;
            {
                this.$component = $component;
            }

            public void handleProvider(TaskProvider<Task> taskProvider) {
                Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
                this.$component.getTaskContainer().setBundleTask(taskProvider);
            }
        });
    }

    private final void handleMicroApp(ApplicationCreationConfig appVariant) {
        ComponentType componentType = appVariant.getComponentType();
        if (componentType.isBaseModule()) {
            Boolean unbundledWearApp = appVariant.isWearAppUnbundled();
            if (!Intrinsics.areEqual((Object)unbundledWearApp, (Object)true) && appVariant.getEmbedsMicroApp()) {
                Configuration configuration = appVariant.getVariantDependencies().getWearAppConfiguration();
                if (configuration == null) {
                    throw new IllegalStateException("Wear app with no wearApp configuration".toString());
                }
                Configuration wearApp = configuration;
                if (!wearApp.getAllDependencies().isEmpty()) {
                    Action setApkArtifact2 = handleMicroApp.setApkArtifact.1.INSTANCE;
                    Function1 function1 = (Function1)new Function1<ArtifactView.ViewConfiguration, Unit>((Action<AttributeContainer>)setApkArtifact2){
                        final /* synthetic */ Action<AttributeContainer> $setApkArtifact;
                        {
                            this.$setApkArtifact = $setApkArtifact;
                            super(1);
                        }

                        public final void invoke(ArtifactView.ViewConfiguration config2) {
                            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
                            config2.attributes(this.$setApkArtifact);
                        }
                    };
                    FileCollection files2 = wearApp.getIncoming().artifactView(new Action(function1){
                        private final /* synthetic */ Function1 function;
                        {
                            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                            this.function = function;
                        }

                        public final /* synthetic */ void execute(Object p0) {
                            this.function.invoke(p0);
                        }
                    }).getFiles();
                    this.createGenerateMicroApkDataTask(appVariant, files2);
                }
            } else if (Intrinsics.areEqual((Object)unbundledWearApp, (Object)true)) {
                ApplicationTaskManager.createGenerateMicroApkDataTask$default(this, appVariant, null, 2, null);
            }
        }
    }

    private final void createGenerateMicroApkDataTask(ApplicationCreationConfig appVariant, FileCollection config2) {
        TaskProvider generateMicroApkTask = this.taskFactory.register(new GenerateApkDataTask.CreationAction(appVariant, config2));
        TaskProvider[] taskProviderArray = new TaskProvider[]{generateMicroApkTask};
        TaskFactoryUtils.dependsOn(appVariant.getTaskContainer().getResourceGenTask(), taskProviderArray);
    }

    static /* synthetic */ void createGenerateMicroApkDataTask$default(ApplicationTaskManager applicationTaskManager, ApplicationCreationConfig applicationCreationConfig, FileCollection fileCollection2, int n, Object object) {
        if ((n & 2) != 0) {
            fileCollection2 = null;
        }
        applicationTaskManager.createGenerateMicroApkDataTask(applicationCreationConfig, fileCollection2);
    }

    private final void createAssetPackTasks(ApplicationCreationConfig appVariant) {
        Configuration assetPackFilesConfiguration = (Configuration)this.project.getConfigurations().maybeCreate("assetPackFiles");
        Configuration assetPackManifestConfiguration = (Configuration)this.project.getConfigurations().maybeCreate("assetPackManifest");
        Set<String> assetPacks = this.globalConfig.getAssetPacks();
        IssueReporter issueReporter2 = appVariant.getServices().getIssueReporter();
        Intrinsics.checkNotNull((Object)assetPackFilesConfiguration);
        Intrinsics.checkNotNull((Object)assetPackManifestConfiguration);
        AssetPackUtilKt.populateAssetPacksConfigurations(this.project, issueReporter2, assetPacks, assetPackFilesConfiguration, assetPackManifestConfiguration);
        if (!((Collection)assetPacks).isEmpty()) {
            ArtifactCollection assetPackManifest = assetPackManifestConfiguration.getIncoming().getArtifacts();
            FileCollection assetFiles = assetPackFilesConfiguration.getIncoming().getFiles();
            ApkCreationConfig apkCreationConfig = appVariant;
            Intrinsics.checkNotNull((Object)assetPackManifest);
            this.taskFactory.register(new ProcessAssetPackManifestTask.CreationAction(apkCreationConfig, assetPackManifest));
            this.taskFactory.register(new LinkManifestForAssetPackTask.CreationAction(appVariant));
            VariantCreationConfig variantCreationConfig = appVariant;
            Intrinsics.checkNotNull((Object)assetFiles);
            this.taskFactory.register(new AssetPackPreBundleTask.CreationAction(variantCreationConfig, assetFiles));
        }
    }

    private final void createDynamicBundleTask(ComponentInfo<ApplicationVariantBuilder, ApplicationCreationConfig> variantInfo2) {
        ApplicationCreationConfig variant = variantInfo2.getVariant();
        if (this.globalConfig.getNamespacedAndroidResources()) {
            return;
        }
        this.taskFactory.register(new PerModuleBundleTask.CreationAction(variant));
        boolean debuggable = variantInfo2.getVariantBuilder().getDebuggable();
        boolean includeSdkInfoInApk = variantInfo2.getVariantBuilder().getDependenciesInfo().getIncludeInApk();
        boolean includeSdkInfoInBundle = variantInfo2.getVariantBuilder().getDependenciesInfo().getIncludeInBundle();
        if (!debuggable) {
            this.taskFactory.register(new PerModuleReportDependenciesTask.CreationAction(variant));
        }
        if (variant.getComponentType().isBaseModule()) {
            this.taskFactory.register(new ParseIntegrityConfigTask.CreationAction(variant));
            this.taskFactory.register(new PackageBundleTask.CreationAction(variant));
            if (!debuggable) {
                if (includeSdkInfoInBundle) {
                    this.taskFactory.register(new BundleReportDependenciesTask.CreationAction(variant));
                }
                if (includeSdkInfoInApk && variant.getServices().getProjectOptions().get(BooleanOption.INCLUDE_DEPENDENCY_INFO_IN_APKS)) {
                    this.taskFactory.register(new SdkDependencyDataGeneratorTask.CreationAction(variant));
                }
            }
            this.taskFactory.register(new FinalizeBundleTask.CreationAction(variant));
            if (variant.getPrivacySandboxCreationConfig() != null) {
                this.taskFactory.register(new GeneratePrivacySandboxSdkRuntimeConfigFile.CreationAction(variant));
                this.taskFactory.register(new GenerateRuntimeEnabledSdkTableTask.CreationAction(variant));
                variant.getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT).setInitialContent$gradle_core((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE, variant.getArtifacts(), InternalArtifactType.PRIVACY_SANDBOX_SDK_R_PACKAGE_JAR.INSTANCE);
                this.taskFactory.register(new GenerateAdditionalApkSplitForDeploymentViaApk.CreationAction(variant));
                this.taskFactory.register(new ExtractPrivacySandboxCompatApks.CreationAction(variant));
            }
            this.taskFactory.register(new BundleIdeModelProducerTask.CreationAction(variant));
            this.taskFactory.register(new ListingFileRedirectTask.CreationAction(variant, "Bundle", (Artifact.Single<RegularFile>)((Artifact.Single)InternalArtifactType.BUNDLE_IDE_MODEL.INSTANCE), (Artifact.Single<RegularFile>)((Artifact.Single)InternalArtifactType.BUNDLE_IDE_REDIRECT_FILE.INSTANCE)));
            this.taskFactory.register(new BundleToApkTask.CreationAction(variant));
            this.taskFactory.register(new BundleToStandaloneApkTask.CreationAction(variant));
            this.taskFactory.register(new ExtractApksTask.CreationAction(variant));
            this.taskFactory.register(new ListingFileRedirectTask.CreationAction(variant, "ApksFromBundle", (Artifact.Single<RegularFile>)((Artifact.Single)InternalArtifactType.APK_FROM_BUNDLE_IDE_MODEL.INSTANCE), (Artifact.Single<RegularFile>)((Artifact.Single)InternalArtifactType.APK_FROM_BUNDLE_IDE_REDIRECT_FILE.INSTANCE)));
            Function1 function1 = (Function1)new Function1<Task, Unit>(variant){
                final /* synthetic */ ApplicationCreationConfig $variant;
                {
                    this.$variant = $variant;
                    super(1);
                }

                public final void invoke(Task it) {
                    Object[] objectArray = new Object[]{this.$variant.getArtifacts().get(InternalArtifactType.EXTRACTED_APKS.INSTANCE)};
                    it.dependsOn(objectArray);
                }
            };
            this.taskFactory.register(AnchorTaskNames.INSTANCE.getExtractApksAnchorTaskName(variant), (Action<? super Task>)new /* invalid duplicate definition of identical inner class */);
            this.taskFactory.register(new MergeNativeDebugMetadataTask.CreationAction(variant));
            function1 = new Function1(variant){
                final /* synthetic */ ApplicationCreationConfig $variant;
                {
                    this.$variant = $variant;
                    super(1);
                }

                public final void invoke(Task task) {
                    Object[] objectArray = new Object[]{this.$variant.getArtifacts().get(InternalArtifactType.MERGED_NATIVE_DEBUG_METADATA.INSTANCE)};
                    task.dependsOn(objectArray);
                }
            };
            variant.getTaskContainer().getAssembleTask().configure(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private final void createSoftwareComponent(ApplicationCreationConfig appVariant, String componentName, AndroidArtifacts.PublishedConfigType publication) {
        AdhocComponentWithVariants component2 = this.localConfig.getComponentFactory().adhoc(componentName);
        Configuration configuration = appVariant.getVariantDependencies().getElements(new PublishedConfigSpec(publication, componentName, false));
        Intrinsics.checkNotNull((Object)configuration);
        Configuration config2 = configuration;
        Function1 function1 = createSoftwareComponent.1.INSTANCE;
        component2.addVariantsFromConfiguration(config2, new /* invalid duplicate definition of identical inner class */);
        this.project.getComponents().add((Object)component2);
    }

    @Override
    protected void createInstallTask(@NotNull ApkCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        if (creationConfig.getPrivacySandboxCreationConfig() != null && !creationConfig.getComponentType().isForTesting()) {
            this.taskFactory.register(new BuildPrivacySandboxSdkApks.CreationAction((ApplicationCreationConfig)creationConfig));
        }
        if (!this.globalConfig.getHasDynamicFeatures() || creationConfig instanceof DeviceTestCreationConfig) {
            super.createInstallTask(creationConfig);
        } else {
            this.taskFactory.register(new InstallVariantViaBundleTask.CreationAction(creationConfig));
        }
    }
}

