/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.VERIFICATION, secondaryTaskCategories={TaskCategory.MANIFEST})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\u0005H\u0007J\b\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckManifest;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "manifestRequired", "", "manifestFile", "Lorg/gradle/api/file/RegularFileProperty;", "fakeOutputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getFakeOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "isManifestRequiredButNotPresent", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class CheckManifest
extends NonIncrementalTask {
    private boolean manifestRequired;
    private RegularFileProperty manifestFile;

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getFakeOutputDir();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Input
    public final boolean isManifestRequiredButNotPresent() {
        if (!this.manifestRequired) return false;
        RegularFileProperty regularFileProperty = this.manifestFile;
        if (regularFileProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manifestFile");
            regularFileProperty = null;
        }
        if (((File)regularFileProperty.getAsFile().get()).isFile()) return false;
        return true;
    }

    @Override
    protected void doTaskAction() {
        if (this.isManifestRequiredButNotPresent()) {
            String string = this.getVariantName();
            RegularFileProperty regularFileProperty = this.manifestFile;
            if (regularFileProperty == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"manifestFile");
                regularFileProperty = null;
            }
            String string2 = "Main manifest is missing for variant " + string + ". Expected path: " + ((File)regularFileProperty.getAsFile().get()).getAbsolutePath();
            throw new IllegalStateException(string2.toString());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckManifest$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/CheckManifest;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<CheckManifest, ComponentCreationConfig> {
        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("check", "Manifest");
        }

        @Override
        @NotNull
        public Class<CheckManifest> getType() {
            return CheckManifest.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<CheckManifest> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getTaskContainer().setCheckManifestTask(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("out").on(InternalArtifactType.CHECK_MANIFEST_RESULT.INSTANCE);
        }

        @Override
        public void configure(@NotNull CheckManifest task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.manifestRequired = this.creationConfig.getComponentType().getRequiresManifest();
            task.manifestFile = this.creationConfig.getServices().regularFileProperty();
        }
    }
}

