/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.AvdSnapshotHandler;
import com.android.build.gradle.internal.testing.AdbHelper;
import com.android.build.gradle.internal.testing.EmulatorVersionMetadata;
import com.android.build.gradle.internal.testing.QemuExecutor;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003BCDB\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u0012\u001a\b\u0002\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0017\u0012\u0004\u0012\u00020\u00180\u0013\u00a2\u0006\u0004\b\u0019\u0010\u001aJ$\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010)\u001a\u00020\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0002J(\u0010+\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020\u0005J\"\u00100\u001a\u000201*\u0002022\u0006\u0010-\u001a\u00020.2\f\u00103\u001a\b\u0012\u0004\u0012\u00020104H\u0002J&\u00105\u001a\u0002012\u0006\u0010)\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00142\u0006\u00106\u001a\u0002072\u0006\u0010-\u001a\u00020.J \u00108\u001a\u0002012\u0006\u00109\u001a\u00020\u00052\u0006\u00106\u001a\u0002072\u0006\u0010-\u001a\u00020.H\u0002JT\u0010:\u001a\u0002H;\"\u0004\b\u0000\u0010;2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.2!\u0010=\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b>\u0012\b\b?\u0012\u0004\b\b(@\u0012\u0004\u0012\u0002H;0\u0013\u00a2\u0006\u0002\u0010AR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0017\u0012\u0004\u0012\u00020\u00180\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010!\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001b\u0010$\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010 \u001a\u0004\b%\u0010&\u00a8\u0006E"}, d2={"Lcom/android/build/gradle/internal/AvdSnapshotHandler;", "", "showFullEmulatorKernelLogging", "", "emulatorGpuFlag", "", "deviceBootAndSnapshotCheckTimeoutSec", "", "adbHelper", "Lcom/android/build/gradle/internal/testing/AdbHelper;", "emulatorDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "qemuExecutor", "Lcom/android/build/gradle/internal/testing/QemuExecutor;", "extraWaitAfterBootCompleteMs", "executor", "Ljava/util/concurrent/ExecutorService;", "metadataFactory", "Lkotlin/Function1;", "Ljava/io/File;", "Lcom/android/build/gradle/internal/testing/EmulatorVersionMetadata;", "processFactory", "", "Ljava/lang/ProcessBuilder;", "<init>", "(ZLjava/lang/String;Ljava/lang/Long;Lcom/android/build/gradle/internal/testing/AdbHelper;Lorg/gradle/api/provider/Provider;Lcom/android/build/gradle/internal/testing/QemuExecutor;JLjava/util/concurrent/ExecutorService;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "Ljava/lang/Long;", "emulatorMetadata", "getEmulatorMetadata", "()Lcom/android/build/gradle/internal/testing/EmulatorVersionMetadata;", "emulatorMetadata$delegate", "Lkotlin/Lazy;", "timeoutSeconds", "getTimeoutSeconds", "()J", "emulatorExecutable", "getEmulatorExecutable", "()Ljava/io/File;", "emulatorExecutable$delegate", "getEmulatorCommand", "avdName", "additionalParams", "checkSnapshotLoadable", "avdLocation", "logger", "Lcom/android/utils/ILogger;", "snapshotName", "waitUntilTimeout", "", "Ljava/lang/Process;", "onTimeout", "Lkotlin/Function0;", "generateSnapshot", "avdManager", "Lcom/android/sdklib/internal/avd/AvdManager;", "deleteSnapshotForDevice", "deviceName", "startEmulatorThenStop", "T", "createSnapshot", "onDeviceReady", "Lkotlin/ParameterName;", "name", "onlineDeviceSerial", "(ZLjava/lang/String;Ljava/io/File;Lcom/android/utils/ILogger;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "EmulatorStartFailedException", "EmulatorSnapshotCannotCreatedException", "EmulatorException", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAvdSnapshotHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvdSnapshotHandler.kt\ncom/android/build/gradle/internal/AvdSnapshotHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,450:1\n1#2:451\n37#3:452\n36#3,3:453\n*S KotlinDebug\n*F\n+ 1 AvdSnapshotHandler.kt\ncom/android/build/gradle/internal/AvdSnapshotHandler\n*L\n102#1:452\n102#1:453,3\n*E\n"})
public final class AvdSnapshotHandler {
    private final boolean showFullEmulatorKernelLogging;
    @NotNull
    private final String emulatorGpuFlag;
    @Nullable
    private final Long deviceBootAndSnapshotCheckTimeoutSec;
    @NotNull
    private final AdbHelper adbHelper;
    @NotNull
    private final Provider<Directory> emulatorDir;
    @NotNull
    private final QemuExecutor qemuExecutor;
    private final long extraWaitAfterBootCompleteMs;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final Function1<File, EmulatorVersionMetadata> metadataFactory;
    @NotNull
    private final Function1<List<String>, ProcessBuilder> processFactory;
    @NotNull
    private final Lazy emulatorMetadata$delegate;
    @NotNull
    private final Lazy emulatorExecutable$delegate;

    public AvdSnapshotHandler(boolean showFullEmulatorKernelLogging, @NotNull String emulatorGpuFlag, @Nullable Long deviceBootAndSnapshotCheckTimeoutSec, @NotNull AdbHelper adbHelper2, @NotNull Provider<Directory> emulatorDir, @NotNull QemuExecutor qemuExecutor, long extraWaitAfterBootCompleteMs, @NotNull ExecutorService executor2, @NotNull Function1<? super File, EmulatorVersionMetadata> metadataFactory, @NotNull Function1<? super List<String>, ProcessBuilder> processFactory2) {
        Intrinsics.checkNotNullParameter((Object)emulatorGpuFlag, (String)"emulatorGpuFlag");
        Intrinsics.checkNotNullParameter((Object)adbHelper2, (String)"adbHelper");
        Intrinsics.checkNotNullParameter(emulatorDir, (String)"emulatorDir");
        Intrinsics.checkNotNullParameter((Object)qemuExecutor, (String)"qemuExecutor");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        Intrinsics.checkNotNullParameter(metadataFactory, (String)"metadataFactory");
        Intrinsics.checkNotNullParameter(processFactory2, (String)"processFactory");
        this.showFullEmulatorKernelLogging = showFullEmulatorKernelLogging;
        this.emulatorGpuFlag = emulatorGpuFlag;
        this.deviceBootAndSnapshotCheckTimeoutSec = deviceBootAndSnapshotCheckTimeoutSec;
        this.adbHelper = adbHelper2;
        this.emulatorDir = emulatorDir;
        this.qemuExecutor = qemuExecutor;
        this.extraWaitAfterBootCompleteMs = extraWaitAfterBootCompleteMs;
        this.executor = executor2;
        this.metadataFactory = metadataFactory;
        this.processFactory = processFactory2;
        this.emulatorMetadata$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EmulatorVersionMetadata>(this){
            final /* synthetic */ AvdSnapshotHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final EmulatorVersionMetadata invoke() {
                Object object = (Directory)AvdSnapshotHandler.access$getEmulatorDir$p(this.this$0).getOrNull();
                if (object == null || (object = object.getAsFile()) == null) {
                    throw new IllegalStateException("Emulator dir does not exist".toString());
                }
                Object emulatorDirectory2 = object;
                return (EmulatorVersionMetadata)AvdSnapshotHandler.access$getMetadataFactory$p(this.this$0).invoke(emulatorDirectory2);
            }
        }));
        this.emulatorExecutable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ AvdSnapshotHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final File invoke() {
                AvdSnapshotHandler.access$getEmulatorMetadata(this.this$0);
                Object object = (Directory)AvdSnapshotHandler.access$getEmulatorDir$p(this.this$0).getOrNull();
                if (object == null || (object = object.getAsFile()) == null) {
                    throw new IllegalStateException("Emulator dir does not exist".toString());
                }
                Object emulatorDirectory2 = object;
                return FilesKt.resolve((File)emulatorDirectory2, (String)"emulator");
            }
        }));
    }

    public /* synthetic */ AvdSnapshotHandler(boolean bl, String string, Long l, AdbHelper adbHelper2, Provider provider2, QemuExecutor qemuExecutor, long l2, ExecutorService executorService, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            l2 = 5000L;
        }
        if ((n & 0x80) != 0) {
            ExecutorService executorService2 = Executors.newCachedThreadPool();
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newCachedThreadPool(...)");
            executorService = executorService2;
        }
        if ((n & 0x100) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x200) != 0) {
            function12 = 2.INSTANCE;
        }
        this(bl, string, l, adbHelper2, (Provider<Directory>)provider2, qemuExecutor, l2, executorService, (Function1<? super File, EmulatorVersionMetadata>)function1, (Function1<? super List<String>, ProcessBuilder>)function12);
    }

    private final EmulatorVersionMetadata getEmulatorMetadata() {
        Lazy lazy = this.emulatorMetadata$delegate;
        return (EmulatorVersionMetadata)lazy.getValue();
    }

    private final long getTimeoutSeconds() {
        Long l = this.deviceBootAndSnapshotCheckTimeoutSec;
        return l != null ? l : 600L;
    }

    @NotNull
    public final File getEmulatorExecutable() {
        Lazy lazy = this.emulatorExecutable$delegate;
        return (File)lazy.getValue();
    }

    private final List<String> getEmulatorCommand(String avdName, List<String> additionalParams) {
        String string;
        SpreadBuilder spreadBuilder = new SpreadBuilder(11);
        spreadBuilder.add((Object)this.getEmulatorExecutable().getAbsolutePath());
        spreadBuilder.add((Object)("@" + avdName));
        spreadBuilder.add((Object)"-no-window");
        spreadBuilder.add((Object)"-no-boot-anim");
        spreadBuilder.add((Object)"-no-audio");
        spreadBuilder.add((Object)"-delay-adb");
        String string2 = string = "-verbose";
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        boolean bl = false;
        boolean bl2 = this.showFullEmulatorKernelLogging;
        spreadBuilder2.add((Object)(bl2 ? string : null));
        spreadBuilder.add((Object)"-show-kernel");
        spreadBuilder.add((Object)"-gpu");
        spreadBuilder.add((Object)this.emulatorGpuFlag);
        Collection $this$toTypedArray$iv = additionalParams;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        return CollectionsKt.listOfNotNull((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    public final boolean checkSnapshotLoadable(@NotNull String avdName, @NotNull File avdLocation, @NotNull ILogger logger, @NotNull String snapshotName) {
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)avdLocation, (String)"avdLocation");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)snapshotName, (String)"snapshotName");
        logger.info("Checking " + snapshotName + " on device " + avdName + " is loadable.", new Object[0]);
        Object object = new String[]{"-read-only", "-no-snapshot-save", "-check-snapshot-loadable", snapshotName};
        ProcessBuilder processBuilder2 = (ProcessBuilder)this.processFactory.invoke(this.getEmulatorCommand(avdName, CollectionsKt.listOf((Object[])object)));
        Map<String, String> map = processBuilder2.environment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
        object = map;
        String string = "ANDROID_AVD_HOME";
        String string2 = avdLocation.getAbsolutePath();
        object.put(string, string2);
        Process process2 = processBuilder2.start();
        Ref.ObjectRef success2 = new Ref.ObjectRef();
        success2.element = new AtomicBoolean(false);
        Ref.BooleanRef timeout = new Ref.BooleanRef();
        Ref.ObjectRef outputProcessed = new Ref.ObjectRef();
        outputProcessed.element = new CountDownLatch(1);
        try {
            GrabProcessOutput.grabProcessOutput((Process)process2, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput((Ref.ObjectRef<CountDownLatch>)outputProcessed, logger, (Ref.ObjectRef<AtomicBoolean>)success2){
                final /* synthetic */ Ref.ObjectRef<CountDownLatch> $outputProcessed;
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ Ref.ObjectRef<AtomicBoolean> $success;
                {
                    this.$outputProcessed = $outputProcessed;
                    this.$logger = $logger;
                    this.$success = $success;
                }

                public void out(String line) {
                    if (line == null) {
                        ((CountDownLatch)this.$outputProcessed.element).countDown();
                        return;
                    }
                    this.$logger.verbose(line, new Object[0]);
                    if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Loadable", (boolean)false, (int)2, null)) {
                        ((AtomicBoolean)this.$success.element).set(true);
                        ((CountDownLatch)this.$outputProcessed.element).countDown();
                    } else if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Not loadable", (boolean)false, (int)2, null)) {
                        ((CountDownLatch)this.$outputProcessed.element).countDown();
                    }
                }

                public void err(String line) {
                }
            }, null, null);
        }
        catch (Exception e) {
            process2.destroy();
            throw new RuntimeException(e);
        }
        Intrinsics.checkNotNull((Object)process2);
        this.waitUntilTimeout(process2, logger, (Function0<Unit>)((Function0)new Function0<Unit>(timeout, logger, snapshotName, avdName){
            final /* synthetic */ Ref.BooleanRef $timeout;
            final /* synthetic */ ILogger $logger;
            final /* synthetic */ String $snapshotName;
            final /* synthetic */ String $avdName;
            {
                this.$timeout = $timeout;
                this.$logger = $logger;
                this.$snapshotName = $snapshotName;
                this.$avdName = $avdName;
                super(0);
            }

            public final void invoke() {
                this.$timeout.element = true;
                this.$logger.warning("Timed out trying to check " + this.$snapshotName + " for " + this.$avdName + " is loadable.", new Object[0]);
            }
        }));
        if (!timeout.element) {
            ((CountDownLatch)outputProcessed.element).await(this.getTimeoutSeconds(), TimeUnit.SECONDS);
        }
        return ((AtomicBoolean)success2.element).get();
    }

    public static /* synthetic */ boolean checkSnapshotLoadable$default(AvdSnapshotHandler avdSnapshotHandler, String string, File file, ILogger iLogger, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "default_boot";
        }
        return avdSnapshotHandler.checkSnapshotLoadable(string, file, iLogger, string2);
    }

    private final void waitUntilTimeout(Process $this$waitUntilTimeout, ILogger logger, Function0<Unit> onTimeout) {
        if (this.getTimeoutSeconds() > 0L) {
            logger.verbose("Waiting for a process to complete (timeout " + this.getTimeoutSeconds() + " seconds)", new Object[0]);
            if (!$this$waitUntilTimeout.waitFor(this.getTimeoutSeconds(), TimeUnit.SECONDS)) {
                onTimeout.invoke();
            }
        } else {
            logger.verbose("Waiting for a process to complete (no timeout)", new Object[0]);
            $this$waitUntilTimeout.waitFor();
        }
    }

    public final void generateSnapshot(@NotNull String avdName, @NotNull File avdLocation, @NotNull AvdManager avdManager2, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)avdLocation, (String)"avdLocation");
        Intrinsics.checkNotNullParameter((Object)avdManager2, (String)"avdManager");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        logger.verbose("Creating snapshot for " + avdName, new Object[0]);
        int maxRetryAttempt = 5;
        EmulatorException lastException = null;
        int n = 0;
        while (n < maxRetryAttempt) {
            int attempt = n++;
            boolean bl = false;
            try {
                logger.verbose("Starting Emulator to create a snapshot for " + avdName + " (Attempt " + (attempt + 1) + "/" + maxRetryAttempt + ")", new Object[0]);
                this.startEmulatorThenStop(true, avdName, avdLocation, logger, generateSnapshot.1.1.INSTANCE);
                if (!AvdSnapshotHandler.checkSnapshotLoadable$default(this, avdName, avdLocation, logger, null, 8, null)) {
                    throw new EmulatorSnapshotCannotCreatedException("Snapshot setup for " + avdName + " ran successfully, but the snapshot failed to be created. This is likely to a lack of disk space for the snapshot. Try the cleanManagedDevices task with the --unused-only flag to remove any unused devices for this project.");
                }
                logger.verbose("Starting Emulator to validate a snapshot for " + avdName + " (Attempt " + (attempt + 1) + "/" + maxRetryAttempt + ")", new Object[0]);
                this.startEmulatorThenStop(false, avdName, avdLocation, logger, generateSnapshot.1.2.INSTANCE);
                logger.info("Successfully created snapshot for: " + avdName, new Object[0]);
                return;
            }
            catch (EmulatorException e) {
                logger.warning("Failed to create Emulator snapshot image (" + (attempt + 1) + "/" + maxRetryAttempt + "). Error: " + e, new Object[0]);
                lastException = e;
            }
        }
        this.deleteSnapshotForDevice(avdName, avdManager2, logger);
        EmulatorException emulatorException = lastException;
        if (emulatorException == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lastException");
            emulatorException = null;
        }
        throw emulatorException;
    }

    private final void deleteSnapshotForDevice(String deviceName, AvdManager avdManager2, ILogger logger) {
        File file;
        Path path;
        AvdInfo avdInfo = avdManager2.getAvd(deviceName, false);
        if (avdInfo == null || (path = avdInfo.getDataFolderPath()) == null || (file = path.toFile()) == null) {
            return;
        }
        File avdDir = file;
        try {
            logger.warning("Deleting unbootable snapshot for device: " + deviceName, new Object[0]);
            this.qemuExecutor.deleteSnapshot(deviceName, avdDir, "default_boot", logger);
        }
        catch (IOException ioException) {
            logger.error((Throwable)ioException, "Could not delete snapshot default_boot for device " + deviceName + ".", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T startEmulatorThenStop(boolean createSnapshot, @NotNull String avdName, @NotNull File avdLocation, @NotNull ILogger logger, @NotNull Function1<? super String, ? extends T> onDeviceReady) {
        Object object;
        String string;
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)avdLocation, (String)"avdLocation");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(onDeviceReady, (String)"onDeviceReady");
        String deviceId = UUID.randomUUID() + "_GradleManagedDevice";
        Object object2 = new String[6];
        String string2 = string = "-no-snapshot-load";
        int n = 0;
        Object[] objectArray = object2;
        String string3 = avdName;
        AvdSnapshotHandler avdSnapshotHandler = this;
        Function1<List<String>, ProcessBuilder> function1 = this.processFactory;
        boolean bl = false;
        boolean bl2 = createSnapshot;
        objectArray[n] = bl2 ? string : null;
        String it = string = "-force-snapshot-load";
        n = 1;
        objectArray = object2;
        boolean bl3 = false;
        bl2 = !createSnapshot && this.getEmulatorMetadata().getCanUseForceSnapshotLoad();
        objectArray[n] = bl2 ? string : null;
        it = string = "-read-only";
        n = 2;
        objectArray = object2;
        boolean bl4 = false;
        bl2 = !createSnapshot;
        objectArray[n] = bl2 ? string : null;
        it = string = "-no-snapshot-save";
        n = 3;
        objectArray = object2;
        boolean bl5 = false;
        bl2 = !createSnapshot;
        objectArray[n] = bl2 ? string : null;
        object2[4] = "-id";
        object2[5] = deviceId;
        ProcessBuilder processBuilder2 = (ProcessBuilder)function1.invoke(avdSnapshotHandler.getEmulatorCommand(string3, CollectionsKt.listOfNotNull((Object[])object2)));
        Map<String, String> map = processBuilder2.environment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
        object2 = map;
        string = "ANDROID_AVD_HOME";
        it = avdLocation.getAbsolutePath();
        object2.put(string, it);
        Map<String, String> map2 = processBuilder2.environment();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"environment(...)");
        object2 = map2;
        string = "ANDROID_EMULATOR_WAIT_TIME_BEFORE_KILL";
        it = String.valueOf(this.getTimeoutSeconds());
        object2.put(string, it);
        Process emulatorProcess = processBuilder2.start();
        CountDownLatch outputProcessed = new CountDownLatch(2);
        List emulatorErrorList = new ArrayList();
        try {
            Object object3;
            Future deviceSerialFuture2 = this.executor.submit(new Callable(emulatorProcess, this, deviceId, logger, avdName){
                final /* synthetic */ Process $emulatorProcess;
                final /* synthetic */ AvdSnapshotHandler this$0;
                final /* synthetic */ String $deviceId;
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ String $avdName;
                {
                    this.$emulatorProcess = $emulatorProcess;
                    this.this$0 = $receiver;
                    this.$deviceId = $deviceId;
                    this.$logger = $logger;
                    this.$avdName = $avdName;
                }

                public final String call() {
                    String emulatorSerial = null;
                    Exception lastException = null;
                    while (this.$emulatorProcess.isAlive()) {
                        try {
                            emulatorSerial = AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).findDeviceSerialWithId(this.$deviceId, this.$logger);
                            break;
                        }
                        catch (Exception e) {
                            lastException = e;
                            this.$logger.verbose("Waiting for " + this.$avdName + " to be attached to adb. Last attempt: " + e, new Object[0]);
                            Thread.sleep(5000L);
                        }
                    }
                    if (emulatorSerial == null) {
                        throw new EmulatorStartFailedException("Unable to find device serial for " + this.$avdName + ".", lastException);
                    }
                    this.$logger.verbose(this.$avdName + " is attached to adb (" + emulatorSerial + ").", new Object[0]);
                    while (this.$emulatorProcess.isAlive() && !AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).isBootCompleted(emulatorSerial, this.$logger)) {
                        this.$logger.verbose("Waiting for " + this.$avdName + " to boot up.", new Object[0]);
                        Thread.sleep(5000L);
                    }
                    this.$logger.verbose("Booting " + this.$avdName + " is completed.", new Object[0]);
                    while (this.$emulatorProcess.isAlive() && !AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).isPackageManagerStarted(emulatorSerial, this.$logger)) {
                        this.$logger.verbose("Waiting for PackageManager to be ready on " + this.$avdName + ".", new Object[0]);
                        Thread.sleep(5000L);
                    }
                    this.$logger.verbose("PackageManager is ready on " + this.$avdName + ".", new Object[0]);
                    if (AvdSnapshotHandler.access$getExtraWaitAfterBootCompleteMs$p(this.this$0) > 0L) {
                        Thread.sleep(AvdSnapshotHandler.access$getExtraWaitAfterBootCompleteMs$p(this.this$0));
                    }
                    if (this.$emulatorProcess.isAlive()) {
                        this.$logger.verbose(this.$avdName + " is ready to take a snapshot.", new Object[0]);
                        return emulatorSerial;
                    }
                    throw new EmulatorStartFailedException("Emulator process exited unexpectedly with the return code " + this.$emulatorProcess.exitValue() + ".", null, 2, null);
                }
            });
            GrabProcessOutput.grabProcessOutput((Process)emulatorProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(outputProcessed, emulatorErrorList, logger){
                final /* synthetic */ CountDownLatch $outputProcessed;
                final /* synthetic */ List<String> $emulatorErrorList;
                final /* synthetic */ ILogger $logger;
                {
                    this.$outputProcessed = $outputProcessed;
                    this.$emulatorErrorList = $emulatorErrorList;
                    this.$logger = $logger;
                }

                public void out(String line) {
                    this.processLine(line);
                }

                public void err(String line) {
                    this.processLine(line);
                }

                public final void processLine(String line) {
                    if (line == null) {
                        this.$outputProcessed.countDown();
                        return;
                    }
                    if (StringsKt.contains$default((CharSequence)line, (CharSequence)"ERROR", (boolean)false, (int)2, null)) {
                        this.$emulatorErrorList.add(line);
                    }
                    this.$logger.verbose(line, new Object[0]);
                }
            }, null, null);
            try {
                object3 = deviceSerialFuture2.get(this.getTimeoutSeconds(), TimeUnit.SECONDS);
                Intrinsics.checkNotNull(object3);
                object3 = (String)object3;
            }
            catch (ExecutionException e) {
                outputProcessed.await(this.getTimeoutSeconds(), TimeUnit.SECONDS);
                throw new EmulatorStartFailedException("Unable to start Android emulator for " + avdName + ". Error message from emulator process = [" + CollectionsKt.joinToString$default((Iterable)emulatorErrorList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "]", e);
            }
            Object deviceSerial = object3;
            Object returnValue = onDeviceReady.invoke(deviceSerial);
            this.adbHelper.killDevice((String)deviceSerial);
            if (createSnapshot) {
                Intrinsics.checkNotNull((Object)emulatorProcess);
                this.waitUntilTimeout(emulatorProcess, logger, (Function0<Unit>)((Function0)new Function0<Unit>(logger, avdName){
                    final /* synthetic */ ILogger $logger;
                    final /* synthetic */ String $avdName;
                    {
                        this.$logger = $logger;
                        this.$avdName = $avdName;
                        super(0);
                    }

                    public final void invoke() {
                        this.$logger.warning("Snapshot creation timed out.", new Object[0]);
                        throw new EmulatorSnapshotCannotCreatedException(StringsKt.trimIndent((String)("\n                        Gradle was not able to complete device setup for: " + this.$avdName + "\n                        This could be due to having insufficient resources to provision the number of\n                        devices requested. Try running the test again and request fewer devices or\n                        fewer shards.\n                        ")));
                    }
                }));
            }
            object = returnValue;
        }
        finally {
            emulatorProcess.destroy();
        }
        return (T)object;
    }

    public static final /* synthetic */ AdbHelper access$getAdbHelper$p(AvdSnapshotHandler $this) {
        return $this.adbHelper;
    }

    public static final /* synthetic */ long access$getExtraWaitAfterBootCompleteMs$p(AvdSnapshotHandler $this) {
        return $this.extraWaitAfterBootCompleteMs;
    }

    public static final /* synthetic */ Provider access$getEmulatorDir$p(AvdSnapshotHandler $this) {
        return $this.emulatorDir;
    }

    public static final /* synthetic */ Function1 access$getMetadataFactory$p(AvdSnapshotHandler $this) {
        return $this.metadataFactory;
    }

    public static final /* synthetic */ EmulatorVersionMetadata access$getEmulatorMetadata(AvdSnapshotHandler $this) {
        return $this.getEmulatorMetadata();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b&\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/AvdSnapshotHandler$EmulatorException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "cause", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "gradle-core"})
    public static abstract class EmulatorException
    extends RuntimeException {
        public EmulatorException(@NotNull String message2, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(message2, cause);
        }

        public /* synthetic */ EmulatorException(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/AvdSnapshotHandler$EmulatorSnapshotCannotCreatedException;", "Lcom/android/build/gradle/internal/AvdSnapshotHandler$EmulatorException;", "message", "", "<init>", "(Ljava/lang/String;)V", "gradle-core"})
    public static final class EmulatorSnapshotCannotCreatedException
    extends EmulatorException {
        public EmulatorSnapshotCannotCreatedException(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(message2, null, 2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/AvdSnapshotHandler$EmulatorStartFailedException;", "Lcom/android/build/gradle/internal/AvdSnapshotHandler$EmulatorException;", "message", "", "cause", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "gradle-core"})
    public static final class EmulatorStartFailedException
    extends EmulatorException {
        public EmulatorStartFailedException(@NotNull String message2, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(message2, cause);
        }

        public /* synthetic */ EmulatorStartFailedException(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }
    }
}

