/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.attribution;

import com.android.buildanalyzer.common.TaskCategoryIssue;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAnalyzerPartialResult;", "", "issues", "", "Lcom/android/buildanalyzer/common/TaskCategoryIssue;", "<init>", "(Ljava/lang/Iterable;)V", "", "getIssues", "()Ljava/util/Set;", "combineWith", "", "partialResult", "saveToDir", "outputDir", "Ljava/io/File;", "Companion", "gradle-core"})
public final class BuildAnalyzerPartialResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<TaskCategoryIssue> issues;
    @NotNull
    private static final String FILE_NAME_PREFIX = "Build-Analyzer-partial-result";

    public BuildAnalyzerPartialResult(@NotNull Iterable<? extends TaskCategoryIssue> issues) {
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        this.issues = new LinkedHashSet();
        CollectionsKt.addAll((Collection)this.issues, issues);
    }

    @NotNull
    public final Set<TaskCategoryIssue> getIssues() {
        return this.issues;
    }

    public final void combineWith(@NotNull BuildAnalyzerPartialResult partialResult) {
        Intrinsics.checkNotNullParameter((Object)partialResult, (String)"partialResult");
        this.issues.addAll((Collection<TaskCategoryIssue>)partialResult.issues);
    }

    public final void saveToDir(@NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        if (!((Collection)this.issues).isEmpty()) {
            outputDir.mkdirs();
            File file = new File(outputDir, BuildAnalyzerPartialResult.Companion.getUniquePartialResultsFileName());
            String string = Companion.DataAdapter.INSTANCE.toJson(this);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0005H\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAnalyzerPartialResult$Companion;", "", "<init>", "()V", "FILE_NAME_PREFIX", "", "isPartialResultsFile", "", "file", "Ljava/io/File;", "getUniquePartialResultsFileName", "getAllPartialResults", "", "Lcom/android/build/gradle/internal/attribution/BuildAnalyzerPartialResult;", "outputDir", "DataAdapter", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nBuildAnalyzerPartialResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAnalyzerPartialResult.kt\ncom/android/build/gradle/internal/attribution/BuildAnalyzerPartialResult$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n3829#2:111\n4344#2,2:112\n1563#3:114\n1634#3,3:115\n*S KotlinDebug\n*F\n+ 1 BuildAnalyzerPartialResult.kt\ncom/android/build/gradle/internal/attribution/BuildAnalyzerPartialResult$Companion\n*L\n63#1:111\n63#1:112,2\n63#1:114\n63#1:115,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isPartialResultsFile(File file) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return StringsKt.startsWith$default((String)string, (String)BuildAnalyzerPartialResult.FILE_NAME_PREFIX, (boolean)false, (int)2, null);
        }

        private final String getUniquePartialResultsFileName() {
            return "Build-Analyzer-partial-result-" + UUID.randomUUID() + ".json";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final List<BuildAnalyzerPartialResult> getAllPartialResults(@NotNull File outputDir) {
            List list;
            Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
            File[] fileArray = outputDir.listFiles();
            if (fileArray != null) {
                void $this$mapTo$iv$iv;
                File it;
                void $this$filterTo$iv$iv;
                File[] $this$filter$iv = fileArray;
                boolean $i$f$filter = false;
                File[] fileArray2 = $this$filter$iv;
                Iterable<void> destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    it = element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!Companion.isPartialResultsFile(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    BuildAnalyzerPartialResult buildAnalyzerPartialResult;
                    void file;
                    it = (File)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)file);
                    Closeable closeable = file;
                    Object object = Charsets.UTF_8;
                    closeable = new InputStreamReader((InputStream)new FileInputStream((File)((Object)closeable)), (Charset)object);
                    object = null;
                    try {
                        InputStreamReader it2 = (InputStreamReader)closeable;
                        boolean bl2 = false;
                        buildAnalyzerPartialResult = (BuildAnalyzerPartialResult)DataAdapter.INSTANCE.fromJson(it2);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                    }
                    collection.add(buildAnalyzerPartialResult);
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/attribution/BuildAnalyzerPartialResult$Companion$DataAdapter;", "Lcom/google/gson/TypeAdapter;", "Lcom/android/build/gradle/internal/attribution/BuildAnalyzerPartialResult;", "<init>", "()V", "write", "", "writer", "Lcom/google/gson/stream/JsonWriter;", "partialResult", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "gradle-core"})
        @SourceDebugExtension(value={"SMAP\nBuildAnalyzerPartialResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAnalyzerPartialResult.kt\ncom/android/build/gradle/internal/attribution/BuildAnalyzerPartialResult$Companion$DataAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1869#2,2:111\n*S KotlinDebug\n*F\n+ 1 BuildAnalyzerPartialResult.kt\ncom/android/build/gradle/internal/attribution/BuildAnalyzerPartialResult$Companion$DataAdapter\n*L\n76#1:111,2\n*E\n"})
        private static final class DataAdapter
        extends TypeAdapter<BuildAnalyzerPartialResult> {
            @NotNull
            public static final DataAdapter INSTANCE = new DataAdapter();

            private DataAdapter() {
            }

            public void write(@NotNull JsonWriter writer, @NotNull BuildAnalyzerPartialResult partialResult) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Intrinsics.checkNotNullParameter((Object)partialResult, (String)"partialResult");
                writer.beginObject();
                writer.name("issues").beginArray();
                Iterable $this$forEach$iv = partialResult.getIssues();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TaskCategoryIssue it = (TaskCategoryIssue)((Object)element$iv);
                    boolean bl = false;
                    writer.value(it.toString());
                }
                writer.endArray();
                writer.endObject();
            }

            @NotNull
            public BuildAnalyzerPartialResult read(@NotNull JsonReader reader) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                List issues = new ArrayList();
                reader.beginObject();
                while (reader.hasNext()) {
                    if (Intrinsics.areEqual((Object)reader.nextName(), (Object)"issues")) {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            String string = reader.nextString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextString(...)");
                            issues.add(TaskCategoryIssue.valueOf(string));
                        }
                        reader.endArray();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                return new BuildAnalyzerPartialResult(issues);
            }
        }
    }
}

