/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.builder.packaging.JarFlinger;
import com.android.builder.symbols.BytecodeRClassWriterKt;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.ide.common.xml.AndroidManifestParser;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Fast transform")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/dependency/AarToClassTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/AarToClassTransform$Params;", "<init>", "()V", "inputAarFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputAarFile", "()Lorg/gradle/api/provider/Provider;", "transform", "", "transformOutputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "Params", "Companion", "gradle-core"})
public abstract class AarToClassTransform
implements TransformAction<Params> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LIBS_FOLDER_SLASH = "libs/";

    @InputArtifact
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract Provider<FileSystemLocation> getInputAarFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformOutputs transformOutputs) {
        Intrinsics.checkNotNullParameter((Object)transformOutputs, (String)"transformOutputs");
        Closeable closeable = new ZipFile(((FileSystemLocation)this.getInputAarFile().get()).getAsFile());
        Throwable throwable = null;
        try {
            ZipFile inputAar = (ZipFile)closeable;
            boolean bl = false;
            String useSuffix = (Boolean)((Params)this.getParameters()).getForCompileUse().get() != false ? "api" : "runtime";
            File file = ((FileSystemLocation)this.getInputAarFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            String outputFileName = FilesKt.getNameWithoutExtension((File)file) + "-" + useSuffix + ".jar";
            Path outputJar = transformOutputs.file((Object)outputFileName).toPath();
            Intrinsics.checkNotNull((Object)outputJar);
            Object object = ((Params)this.getParameters()).getForCompileUse().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            boolean bl2 = (Boolean)object;
            Object object2 = ((Params)this.getParameters()).getGenerateRClassJar().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            Companion.mergeJars$gradle_core(outputJar, inputAar, bl2, (Boolean)object2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\rJ\u0019\u0010\u0010\u001a\u00020\u0005*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u001c\u0010\u0014\u001a\u00020\u0005*\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001d\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/internal/dependency/AarToClassTransform$Companion;", "", "<init>", "()V", "mergeJars", "", "outputJar", "Ljava/nio/file/Path;", "inputAar", "Ljava/util/zip/ZipFile;", "forCompileUse", "", "generateRClassJar", "mergeJars$gradle_core", "LIBS_FOLDER_SLASH", "", "copyAllClassesJarsTo", "outputApiJar", "Lcom/android/builder/packaging/JarFlinger;", "copyAllClassesJarsTo$gradle_core", "copyEntryTo", "entry", "Ljava/util/zip/ZipEntry;", "generateRClassJarFromRTxt", "generateRClassJarFromRTxt$gradle_core", "isClassesJar", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nAarToClassTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AarToClassTransform.kt\ncom/android/build/gradle/internal/dependency/AarToClassTransform$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n1321#2,2:156\n1#3:158\n*S KotlinDebug\n*F\n+ 1 AarToClassTransform.kt\ncom/android/build/gradle/internal/dependency/AarToClassTransform$Companion\n*L\n124#1:156,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public final void mergeJars$gradle_core(@NotNull Path outputJar, @NotNull ZipFile inputAar, boolean forCompileUse, boolean generateRClassJar) {
            Intrinsics.checkNotNullParameter((Object)outputJar, (String)"outputJar");
            Intrinsics.checkNotNullParameter((Object)inputAar, (String)"inputAar");
            Predicate ignoreFilter = forCompileUse ? JarFlinger.allIgnoringDuplicateResources() : JarFlinger.CLASSES_ONLY;
            Closeable closeable = (Closeable)new JarFlinger(outputJar, ignoreFilter);
            Throwable throwable = null;
            try {
                JarFlinger outputApiJar = (JarFlinger)closeable;
                boolean bl = false;
                outputApiJar.setCompressionLevel(0);
                if (forCompileUse) {
                    ZipEntry apiJAr;
                    if (generateRClassJar) {
                        Companion.generateRClassJarFromRTxt$gradle_core(outputApiJar, inputAar);
                    }
                    if ((apiJAr = inputAar.getEntry("api.jar")) != null) {
                        Companion.copyEntryTo(inputAar, apiJAr, outputApiJar);
                        return;
                    }
                }
                Companion.copyAllClassesJarsTo$gradle_core(inputAar, outputApiJar);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public final void copyAllClassesJarsTo$gradle_core(@NotNull ZipFile $this$copyAllClassesJarsTo, @NotNull JarFlinger outputApiJar) {
            Intrinsics.checkNotNullParameter((Object)$this$copyAllClassesJarsTo, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)outputApiJar, (String)"outputApiJar");
            Enumeration<? extends ZipEntry> enumeration = $this$copyAllClassesJarsTo.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)((Function1)new Function1<ZipEntry, Boolean>((Object)this){

                public final Boolean invoke(ZipEntry p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return com.android.build.gradle.internal.dependency.AarToClassTransform$Companion.access$isClassesJar((Companion)this.receiver, p0);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ZipEntry it = (ZipEntry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Companion.copyEntryTo($this$copyAllClassesJarsTo, it, outputApiJar);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void copyEntryTo(ZipFile $this$copyEntryTo, ZipEntry entry2, JarFlinger outputApiJar) {
            Closeable closeable = $this$copyEntryTo.getInputStream(entry2);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                outputApiJar.addJar(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void generateRClassJarFromRTxt$gradle_core(@NotNull JarFlinger outputApiJar, @NotNull ZipFile inputAar) {
            SymbolTable symbolTable;
            Object object;
            Intrinsics.checkNotNullParameter((Object)outputApiJar, (String)"outputApiJar");
            Intrinsics.checkNotNullParameter((Object)inputAar, (String)"inputAar");
            ZipEntry manifest = inputAar.getEntry("AndroidManifest.xml");
            Closeable closeable = inputAar.getInputStream(manifest);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                object = AndroidManifestParser.parse((InputStream)it).getPackage();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String pkg = object;
            ZipEntry zipEntry = inputAar.getEntry("R.txt");
            if (zipEntry == null) {
                return;
            }
            ZipEntry rTxt = zipEntry;
            object = inputAar.getInputStream(rTxt);
            Throwable throwable3 = null;
            try {
                InputStream it = (InputStream)object;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Intrinsics.checkNotNull((Object)pkg);
                symbolTable = SymbolUtils.rTxtToSymbolTable((InputStream)it, (String)pkg);
            }
            catch (Throwable throwable4) {
                throwable3 = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable3);
            }
            SymbolTable symbols = symbolTable;
            BytecodeRClassWriterKt.exportToCompiledJava((Iterable)CollectionsKt.listOf((Object)symbols), (boolean)false, null, (Function2)((Function2)new Function2<String, byte[], Unit>(outputApiJar){
                final /* synthetic */ JarFlinger $outputApiJar;
                {
                    this.$outputApiJar = $outputApiJar;
                    super(2);
                }

                public final void invoke(String entryPath, byte[] content2) {
                    Intrinsics.checkNotNullParameter((Object)entryPath, (String)"entryPath");
                    Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                    this.$outputApiJar.addEntry(entryPath, (InputStream)new ByteArrayInputStream(content2));
                }
            }));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isClassesJar(ZipEntry entry2) {
            String name = entry2.getName();
            if (Intrinsics.areEqual((Object)name, (Object)"classes.jar")) return true;
            Intrinsics.checkNotNull((Object)name);
            if (!StringsKt.startsWith$default((String)name, (String)AarToClassTransform.LIBS_FOLDER_SLASH, (boolean)false, (int)2, null)) return false;
            if (!StringsKt.endsWith$default((String)name, (String)".jar", (boolean)false, (int)2, null)) return false;
            return true;
        }

        public static final /* synthetic */ boolean access$isClassesJar(Companion $this, ZipEntry entry2) {
            return $this.isClassesJar(entry2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/dependency/AarToClassTransform$Params;", "Lorg/gradle/api/artifacts/transform/TransformParameters;", "generateRClassJar", "Lorg/gradle/api/provider/Property;", "", "getGenerateRClassJar", "()Lorg/gradle/api/provider/Property;", "forCompileUse", "getForCompileUse", "gradle-core"})
    public static interface Params
    extends TransformParameters {
        @Input
        @NotNull
        public Property<Boolean> getGenerateRClassJar();

        @Input
        @NotNull
        public Property<Boolean> getForCompileUse();
    }
}

