/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.builder.dexing.DependencyGraphUpdater;
import com.android.builder.dexing.MutableDependencyGraph;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0002J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013J\f\u0010\u0014\u001a\u00020\u0006*\u00020\u0002H\u0002J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/dependency/DesugarGraph;", "Lcom/android/builder/dexing/DependencyGraphUpdater;", "Ljava/io/File;", "rootDir", "relocatableDesugarGraph", "Lcom/android/builder/dexing/MutableDependencyGraph;", "", "filesToIgnore", "", "<init>", "(Ljava/io/File;Lcom/android/builder/dexing/MutableDependencyGraph;Ljava/util/Set;)V", "addEdge", "", "dependent", "dependency", "removeNode", "nodeToRemove", "getAllDependents", "nodes", "", "toUnixStyleRelativePath", "write", "desugarGraphFile", "Companion", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nDexingTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DexingTransform.kt\ncom/android/build/gradle/internal/dependency/DesugarGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,658:1\n1634#2,3:659\n1634#2,3:662\n*S KotlinDebug\n*F\n+ 1 DexingTransform.kt\ncom/android/build/gradle/internal/dependency/DesugarGraph\n*L\n354#1:659,3\n358#1:662,3\n*E\n"})
public final class DesugarGraph
implements DependencyGraphUpdater<File> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File rootDir;
    @NotNull
    private final MutableDependencyGraph<String> relocatableDesugarGraph;
    @NotNull
    private final Set<File> filesToIgnore;

    public DesugarGraph(@NotNull File rootDir, @NotNull MutableDependencyGraph<String> relocatableDesugarGraph, @NotNull Set<? extends File> filesToIgnore) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter(relocatableDesugarGraph, (String)"relocatableDesugarGraph");
        Intrinsics.checkNotNullParameter(filesToIgnore, (String)"filesToIgnore");
        this.rootDir = rootDir;
        this.relocatableDesugarGraph = relocatableDesugarGraph;
        this.filesToIgnore = filesToIgnore;
    }

    public void addEdge(@NotNull File dependent, @NotNull File dependency) {
        Intrinsics.checkNotNullParameter((Object)dependent, (String)"dependent");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        if (this.filesToIgnore.contains(dependent) || this.filesToIgnore.contains(dependency)) {
            return;
        }
        this.relocatableDesugarGraph.addEdge((Object)this.toUnixStyleRelativePath(dependent), (Object)this.toUnixStyleRelativePath(dependency));
    }

    public final void removeNode(@NotNull File nodeToRemove) {
        Intrinsics.checkNotNullParameter((Object)nodeToRemove, (String)"nodeToRemove");
        this.relocatableDesugarGraph.removeNode((Object)this.toUnixStyleRelativePath(nodeToRemove));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<File> getAllDependents(@NotNull Collection<? extends File> nodes) {
        void destination$iv;
        void $this$mapTo$iv;
        void var11_12;
        Iterable destination$iv2;
        void $this$mapTo$iv2;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Iterable iterable = nodes;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv2) {
            void it;
            File file = (File)item$iv;
            var11_12 = destination$iv2;
            boolean bl = false;
            var11_12.add(this.toUnixStyleRelativePath((File)it));
        }
        Set relativePaths = (Set)destination$iv2;
        Set dependents = this.relocatableDesugarGraph.getAllDependents((Collection)relativePaths);
        destination$iv2 = dependents;
        Collection $i$f$mapTo22 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String bl = (String)item$iv;
            var11_12 = destination$iv;
            boolean bl2 = false;
            var11_12.add(FilesKt.resolve((File)this.rootDir, (String)it));
        }
        return (Set)destination$iv;
    }

    private final String toUnixStyleRelativePath(File $this$toUnixStyleRelativePath) {
        String unixStyleRelativePath = FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)$this$toUnixStyleRelativePath, (File)this.rootDir));
        if (!(!StringsKt.startsWith$default((String)unixStyleRelativePath, (String)"..", (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "The given file '" + $this$toUnixStyleRelativePath.getPath() + "' is located outside the root directory '" + this.rootDir.getPath() + "'";
            throw new IllegalStateException(string.toString());
        }
        return unixStyleRelativePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull File desugarGraphFile) {
        Intrinsics.checkNotNullParameter((Object)desugarGraphFile, (String)"desugarGraphFile");
        Closeable closeable = new FileOutputStream(desugarGraphFile);
        int n = 8192;
        closeable = new ObjectOutputStream(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n));
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl = false;
            it.writeObject(this.relocatableDesugarGraph);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/dependency/DesugarGraph$Companion;", "", "<init>", "()V", "read", "Lcom/android/build/gradle/internal/dependency/DesugarGraph;", "desugarGraphFile", "Ljava/io/File;", "rootDir", "filesToIgnore", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final DesugarGraph read(@NotNull File desugarGraphFile, @NotNull File rootDir, @NotNull Set<? extends File> filesToIgnore) {
            MutableDependencyGraph mutableDependencyGraph;
            Intrinsics.checkNotNullParameter((Object)desugarGraphFile, (String)"desugarGraphFile");
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            Intrinsics.checkNotNullParameter(filesToIgnore, (String)"filesToIgnore");
            Closeable closeable = new FileInputStream(desugarGraphFile);
            int n = 8192;
            closeable = new ObjectInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
            File file = rootDir;
            Throwable throwable = null;
            try {
                ObjectInputStream it = (ObjectInputStream)closeable;
                boolean bl = false;
                Object object = it.readObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.builder.dexing.MutableDependencyGraph<kotlin.String>");
                mutableDependencyGraph = (MutableDependencyGraph)object;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Set<? extends File> set = filesToIgnore;
            MutableDependencyGraph mutableDependencyGraph2 = mutableDependencyGraph;
            File file2 = file;
            return new DesugarGraph(file2, (MutableDependencyGraph<String>)mutableDependencyGraph2, set);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

