/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.dependency.JetifyTransform;
import com.android.tools.build.jetifier.processor.FileMapping;
import com.android.tools.build.jetifier.processor.Processor;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/dependency/JetifyTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/dependency/JetifyTransform$Parameters;", "<init>", "()V", "inputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getInputArtifact", "()Lorg/gradle/api/provider/Provider;", "getJetifierIgnoreList", "", "Lkotlin/text/Regex;", "ignoreListOption", "", "transform", "", "transformOutputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "Parameters", "Companion", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nJetifyTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetifyTransform.kt\ncom/android/build/gradle/internal/dependency/JetifyTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1563#2:162\n1634#2,3:163\n1761#2,3:166\n*S KotlinDebug\n*F\n+ 1 JetifyTransform.kt\ncom/android/build/gradle/internal/dependency/JetifyTransform\n*L\n89#1:162\n89#1:163,3\n131#1:166,3\n*E\n"})
public abstract class JetifyTransform
implements TransformAction<Parameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Processor> jetifierProcessor$delegate = LazyKt.lazy((Function0)Companion.jetifierProcessor.2.INSTANCE);

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    /*
     * WARNING - void declaration
     */
    private final List<Regex> getJetifierIgnoreList(String ignoreListOption) {
        void $this$mapTo$iv$iv;
        List ignoreList = new ArrayList();
        if (((CharSequence)ignoreListOption).length() > 0) {
            List list = Splitter.on((String)",").trimResults().splitToList((CharSequence)ignoreListOption);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitToList(...)");
            ignoreList.addAll(list);
        }
        ignoreList.add("jetifier-.*\\.jar");
        Iterable $this$map$iv = ignoreList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Regex((String)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    public void transform(@NotNull TransformOutputs transformOutputs) {
        block15: {
            Intrinsics.checkNotNullParameter((Object)transformOutputs, (String)"transformOutputs");
            inputFile = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
            v0 = inputFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getName(...)");
            if (StringsKt.endsWith((String)v0, (String)".aar", (boolean)true)) ** GOTO lbl-1000
            v1 = inputFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
            if (StringsKt.endsWith((String)v1, (String)".jar", (boolean)true)) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            if (!v2) {
                $i$a$-check-JetifyTransform$transform$1 = false;
                $i$a$-check-JetifyTransform$transform$1 = "Transform's input file is not .aar or .jar: " + inputFile.getPath();
                throw new IllegalStateException($i$a$-check-JetifyTransform$transform$1.toString());
            }
            if (!inputFile.isFile()) {
                $i$a$-check-JetifyTransform$transform$2 = false;
                $i$a$-check-JetifyTransform$transform$2 = "Transform's input file does not exist: " + inputFile.getPath() + ". (See https://issuetracker.google.com/issues/158753935)";
                throw new IllegalStateException($i$a$-check-JetifyTransform$transform$2.toString());
            }
            v3 = com.android.build.gradle.internal.dependency.JetifyTransform$Companion.access$getJetifierProcessor(JetifyTransform.Companion);
            Intrinsics.checkNotNull((Object)inputFile);
            if (v3.isNewDependencyFile(inputFile)) {
                transformOutputs.file((Object)inputFile);
                return;
            }
            if (com.android.build.gradle.internal.dependency.JetifyTransform$Companion.access$getJetifierProcessor(JetifyTransform.Companion).isOldDependencyFile(inputFile)) {
                transformOutputs.file((Object)inputFile);
                return;
            }
            v4 = ((Parameters)this.getParameters()).getIgnoreListOption().get();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"get(...)");
            jetifierIgnoreList = this.getJetifierIgnoreList((String)v4);
            $this$any$iv = jetifierIgnoreList;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v5 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (Regex)element$iv;
                    $i$a$-any-JetifyTransform$transform$3 = false;
                    v6 = inputFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getAbsolutePath(...)");
                    if (!it.containsMatchIn((CharSequence)v6)) continue;
                    v5 = true;
                    break block15;
                }
                v5 = false;
            }
        }
        if (v5) {
            transformOutputs.file((Object)inputFile);
            return;
        }
        outputFile = transformOutputs.file((Object)("jetified-" + inputFile.getName()));
        try {
            v7 = com.android.build.gradle.internal.dependency.JetifyTransform$Companion.access$getJetifierProcessor(JetifyTransform.Companion);
            Intrinsics.checkNotNull((Object)outputFile);
            var6_11 = v7.transform2(SetsKt.setOf((Object)new FileMapping(inputFile, outputFile)), true, true);
        }
        catch (Exception exception) {
            throw new RuntimeException(StringsKt.trimIndent((String)("\n                Jetifier failed to transform: " + inputFile + "\n                The error was: " + exception.getClass().getName() + " - " + exception.getMessage() + "\n                To fix this issue, see https://issuetracker.google.com/issues/184622491\n                ")), exception);
        }
        result = var6_11;
        if (!(result.getLibrariesMap().size() == 1)) {
            throw new IllegalStateException("Check failed.");
        }
        if (!Intrinsics.areEqual(result.getLibrariesMap().get(inputFile), (Object)outputFile)) {
            throw new IllegalStateException("Check failed.");
        }
        if (!outputFile.exists()) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/dependency/JetifyTransform$Companion;", "", "<init>", "()V", "jetifierProcessor", "Lcom/android/tools/build/jetifier/processor/Processor;", "getJetifierProcessor", "()Lcom/android/tools/build/jetifier/processor/Processor;", "jetifierProcessor$delegate", "Lkotlin/Lazy;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Processor getJetifierProcessor() {
            Lazy lazy = jetifierProcessor$delegate;
            return (Processor)lazy.getValue();
        }

        public static final /* synthetic */ Processor access$getJetifierProcessor(Companion $this) {
            return $this.getJetifierProcessor();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/dependency/JetifyTransform$Parameters;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "ignoreListOption", "Lorg/gradle/api/provider/Property;", "", "getIgnoreListOption", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static interface Parameters
    extends GenericTransformParameters {
        @Input
        @NotNull
        public Property<String> getIgnoreListOption();
    }
}

