/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.CompileSdkReleaseSpec;
import com.android.build.api.dsl.CompileSdkSpec;
import com.android.build.api.dsl.CompileSdkVersion;
import com.android.build.gradle.internal.dsl.CompileSdkReleaseSpecImpl;
import com.android.build.gradle.internal.dsl.CompileSdkVersionImpl;
import com.android.build.gradle.internal.services.DslServices;
import com.android.sdklib.SdkVersionInfo;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\u0002\b\u000eH\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000fJ\b\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/dsl/CompileSdkSpecImpl;", "Lcom/android/build/api/dsl/CompileSdkSpec;", "dslService", "Lcom/android/build/gradle/internal/services/DslServices;", "<init>", "(Lcom/android/build/gradle/internal/services/DslServices;)V", "release", "Lcom/android/build/api/dsl/CompileSdkVersion;", "version", "", "action", "Lkotlin/Function1;", "Lcom/android/build/api/dsl/CompileSdkReleaseSpec;", "", "Lkotlin/ExtensionFunctionType;", "Lorg/gradle/api/Action;", "createCompileSdkReleaseSpec", "preview", "codeName", "", "addon", "vendor", "name", "gradle-core"})
public abstract class CompileSdkSpecImpl
implements CompileSdkSpec {
    @NotNull
    private final DslServices dslService;

    @Inject
    public CompileSdkSpecImpl(@NotNull DslServices dslService) {
        Intrinsics.checkNotNullParameter((Object)dslService, (String)"dslService");
        this.dslService = dslService;
    }

    @NotNull
    public CompileSdkVersion release(int version, @NotNull Function1<? super CompileSdkReleaseSpec, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        CompileSdkReleaseSpec compileSdkRelease = this.createCompileSdkReleaseSpec();
        action.invoke((Object)compileSdkRelease);
        return new CompileSdkVersionImpl(version, compileSdkRelease.getMinorApiLevel(), compileSdkRelease.getSdkExtension(), null, null, null, 56, null);
    }

    @NotNull
    public CompileSdkVersion release(int version) {
        return new CompileSdkVersionImpl(version, null, null, null, null, null, 62, null);
    }

    @NotNull
    public final CompileSdkVersion release(int version, @NotNull Action<CompileSdkReleaseSpec> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        CompileSdkReleaseSpec compileSdkRelease = this.createCompileSdkReleaseSpec();
        action.execute((Object)compileSdkRelease);
        return new CompileSdkVersionImpl(version, compileSdkRelease.getMinorApiLevel(), compileSdkRelease.getSdkExtension(), null, null, null, 56, null);
    }

    private final CompileSdkReleaseSpec createCompileSdkReleaseSpec() {
        Object[] objectArray = new Object[]{this.dslService};
        return this.dslService.newDecoratedInstance(CompileSdkReleaseSpecImpl.class, objectArray);
    }

    @NotNull
    public CompileSdkVersion preview(@NotNull String codeName) {
        Intrinsics.checkNotNullParameter((Object)codeName, (String)"codeName");
        int apiLevel = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)true) - 1;
        return new CompileSdkVersionImpl(apiLevel, null, null, codeName, null, null, 54, null);
    }

    @NotNull
    public CompileSdkVersion addon(@NotNull String vendor, @NotNull String name, int version) {
        Intrinsics.checkNotNullParameter((Object)vendor, (String)"vendor");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new CompileSdkVersionImpl(version, null, null, null, name, vendor, 14, null);
    }
}

