/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.cxx.configure.NdkAbiFile;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFileKt;
import com.android.build.gradle.internal.cxx.configure.PlatformConfigurator;
import com.android.build.gradle.internal.ndk.AbiInfo;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.NdkR25Info;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.sdklib.AndroidVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0001\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\fH\u0016J\u0018\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\fH\u0016J\n\u0010,\u001a\u0004\u0018\u00010-H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000eR\u001b\u0010#\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b$\u0010%\u00a8\u0006."}, d2={"Lcom/android/build/gradle/internal/ndk/NdkR25Info;", "Lcom/android/build/gradle/internal/ndk/NdkInfo;", "rootDirectory", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "platformConfigurator", "Lcom/android/build/gradle/internal/cxx/configure/PlatformConfigurator;", "abiInfoList", "", "Lcom/android/build/gradle/internal/ndk/AbiInfo;", "default32BitsAbis", "", "getDefault32BitsAbis", "()Ljava/util/List;", "defaultAbis", "getDefaultAbis", "supported32BitsAbis", "getSupported32BitsAbis", "supportedAbis", "getSupportedAbis", "supportedStls", "Lcom/android/build/gradle/internal/ndk/Stl;", "getSupportedStls", "findSuitablePlatformVersion", "", "abi", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "ignoreMinSdkVersionFromDsl", "", "ignoreMinSdkVersionFromProperty", "getDefaultStl", "buildSystem", "Lcom/android/build/gradle/tasks/NativeBuildSystem;", "hostTag", "getHostTag", "()Ljava/lang/String;", "hostTag$delegate", "Lkotlin/Lazy;", "getStripExecutable", "getObjcopyExecutable", "getStlSharedObjectFile", "stl", "validate", "", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nNdkR25Info.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NdkR25Info.kt\ncom/android/build/gradle/internal/ndk/NdkR25Info\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n774#2:119\n865#2,2:120\n1563#2:122\n1634#2,3:123\n774#2:126\n865#2,2:127\n1563#2:129\n1634#2,3:130\n774#2:133\n865#2,2:134\n1563#2:136\n1634#2,3:137\n1563#2:140\n1634#2,3:141\n626#2,12:144\n*S KotlinDebug\n*F\n+ 1 NdkR25Info.kt\ncom/android/build/gradle/internal/ndk/NdkR25Info\n*L\n49#1:119\n49#1:120,2\n50#1:122\n50#1:123,3\n55#1:126\n55#1:127,2\n56#1:129\n56#1:130,3\n61#1:133\n61#1:134,2\n62#1:136\n62#1:137,3\n67#1:140\n67#1:141,3\n109#1:144,12\n*E\n"})
public final class NdkR25Info
implements NdkInfo {
    @NotNull
    private final File rootDirectory;
    @NotNull
    private final PlatformConfigurator platformConfigurator;
    @NotNull
    private final List<AbiInfo> abiInfoList;
    @NotNull
    private final List<Stl> supportedStls;
    @NotNull
    private final Lazy hostTag$delegate;

    public NdkR25Info(@NotNull File rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        this.rootDirectory = rootDirectory;
        this.platformConfigurator = new PlatformConfigurator(this.rootDirectory);
        this.abiInfoList = new NdkAbiFile(NdkAbiFileKt.ndkMetaAbisFile(this.rootDirectory)).getAbiInfoList();
        Stl[] stlArray = new Stl[]{Stl.LIBCXX_SHARED, Stl.LIBCXX_STATIC, Stl.NONE, Stl.SYSTEM};
        this.supportedStls = CollectionsKt.listOf((Object[])stlArray);
        this.hostTag$delegate = LazyKt.lazy((Function0)hostTag.2.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getDefault32BitsAbis() {
        void $this$mapTo$iv$iv;
        AbiInfo abiInfo;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.abiInfoList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            abiInfo = (AbiInfo)element$iv$iv;
            boolean bl = false;
            if (!(abiInfo.isDefault() && !abiInfo.isDeprecated() && abiInfo.getBitness() == 32)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            abiInfo = (AbiInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getDefaultAbis() {
        void $this$mapTo$iv$iv;
        AbiInfo abiInfo;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.abiInfoList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            abiInfo = (AbiInfo)element$iv$iv;
            boolean bl = false;
            if (!(abiInfo.isDefault() && !abiInfo.isDeprecated())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            abiInfo = (AbiInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getSupported32BitsAbis() {
        void $this$mapTo$iv$iv;
        AbiInfo abiInfo;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.abiInfoList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            abiInfo = (AbiInfo)element$iv$iv;
            boolean bl = false;
            if (!(abiInfo.getBitness() == 32)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            abiInfo = (AbiInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getSupportedAbis() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.abiInfoList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AbiInfo abiInfo = (AbiInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public List<Stl> getSupportedStls() {
        return this.supportedStls;
    }

    @Override
    public int findSuitablePlatformVersion(@NotNull String abi, @Nullable AndroidVersion androidVersion, @Nullable Object ignoreMinSdkVersionFromDsl, @Nullable String ignoreMinSdkVersionFromProperty) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        return this.platformConfigurator.findSuitablePlatformVersion(abi, this.abiInfoList, androidVersion, ignoreMinSdkVersionFromDsl, ignoreMinSdkVersionFromProperty);
    }

    @Override
    @NotNull
    public Stl getDefaultStl(@NotNull NativeBuildSystem buildSystem) {
        Stl stl;
        Intrinsics.checkNotNullParameter((Object)((Object)buildSystem), (String)"buildSystem");
        switch (WhenMappings.$EnumSwitchMapping$0[buildSystem.ordinal()]) {
            case 1: {
                stl = Stl.LIBCXX_STATIC;
                break;
            }
            case 2: {
                stl = Stl.SYSTEM;
                break;
            }
            case 3: {
                stl = Stl.UNKNOWN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stl;
    }

    private final String getHostTag() {
        Lazy lazy = this.hostTag$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public File getStripExecutable(@NotNull String abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        return FilesKt.resolve((File)this.rootDirectory, (String)("toolchains/llvm/prebuilt/" + this.getHostTag() + "/bin/llvm-strip"));
    }

    @Override
    @NotNull
    public File getObjcopyExecutable(@NotNull String abi) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        return FilesKt.resolve((File)this.rootDirectory, (String)("toolchains/llvm/prebuilt/" + this.getHostTag() + "/bin/llvm-objcopy"));
    }

    @Override
    @NotNull
    public File getStlSharedObjectFile(@NotNull Stl stl, @NotNull String abi) {
        Intrinsics.checkNotNullParameter((Object)((Object)stl), (String)"stl");
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        Iterable $this$single$iv = this.abiInfoList;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            AbiInfo it = (AbiInfo)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)abi)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        AbiInfo info2 = single$iv;
        return FilesKt.resolve((File)this.rootDirectory, (String)("toolchains/llvm/prebuilt/" + this.getHostTag() + "/sysroot/usr/lib/" + info2.getTriple() + "/" + stl.getLibraryName()));
    }

    @Nullable
    public Void validate() {
        return null;
    }

    @Override
    @NotNull
    public Map<String, File> getStlSharedObjectFiles(@NotNull Stl stl, @NotNull Collection<String> abis) {
        return NdkInfo.super.getStlSharedObjectFiles(stl, abis);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NativeBuildSystem.values().length];
            try {
                nArray[NativeBuildSystem.CMAKE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NativeBuildSystem.NDK_BUILD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NativeBuildSystem.NINJA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

