/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.build.gradle.internal.services.RunOnceBuildService;
import com.android.build.gradle.internal.services.RunOnceBuildServiceImpl;
import com.android.build.gradle.options.BooleanOption;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/plugins/VersionCheckPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "apply", "", "project", "doApply", "isGradleWrapperTaskRunning", "", "getVersionCheckOverridePropertyValue", "Companion", "gradle-core"})
public final class VersionCheckPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final GradleVersion GRADLE_MIN_VERSION;

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RunOnceBuildService runOnceBuildService = (RunOnceBuildService)new RunOnceBuildServiceImpl.RegistrationAction(project).execute().get();
        String string = VersionCheckPlugin.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        runOnceBuildService.runOnce("apply", string, (Function0<Unit>)((Function0)new Function0<Unit>(this, project){
            final /* synthetic */ VersionCheckPlugin this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                VersionCheckPlugin.access$doApply(this.this$0, this.$project);
            }
        }));
    }

    private final void doApply(Project project) {
        if (this.isGradleWrapperTaskRunning(project)) {
            return;
        }
        GradleVersion currentVersion = GradleVersion.current();
        if (GRADLE_MIN_VERSION.compareTo(currentVersion) > 0) {
            String string = GRADLE_MIN_VERSION.getVersion();
            String string2 = currentVersion.getVersion();
            File file = project.getRootDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getRootDir(...)");
            String errorMessage = StringsKt.trimIndent((String)("\n                Minimum supported Gradle version is " + string + ". Current version is " + string2 + ".\n                Try updating the 'distributionUrl' property in " + FilesKt.resolve((File)file, (String)"gradle/wrapper/gradle-wrapper.properties").getPath() + " to 'gradle-" + GRADLE_MIN_VERSION.getVersion() + "-bin.zip'.\n                "));
            if (this.getVersionCheckOverridePropertyValue(project)) {
                project.getLogger().warn(errorMessage);
                project.getLogger().warn("As " + BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.getPropertyName() + " is set, continuing anyway.");
            } else {
                throw new IllegalStateException(errorMessage.toString());
            }
        }
    }

    private final boolean isGradleWrapperTaskRunning(Project project) {
        List taskRequests = project.getGradle().getStartParameter().getTaskRequests();
        Intrinsics.checkNotNull((Object)taskRequests);
        Object object = (TaskExecutionRequest)CollectionsKt.singleOrNull((List)taskRequests);
        return Intrinsics.areEqual(object != null && (object = object.getArgs()) != null ? (String)CollectionsKt.getOrNull((List)object, (int)0) : null, (Object)"wrapper");
    }

    private final boolean getVersionCheckOverridePropertyValue(Project project) {
        Object value = project.getExtensions().getExtraProperties().getProperties().get(BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.getPropertyName());
        return value == null ? BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.getDefaultValue().booleanValue() : BooleanOption.VERSION_CHECK_OVERRIDE_PROPERTY.parse(value).booleanValue();
    }

    public static final /* synthetic */ void access$doApply(VersionCheckPlugin $this, Project project) {
        $this.doApply(project);
    }

    static {
        GradleVersion gradleVersion = GradleVersion.version((String)"9.0.0");
        Intrinsics.checkNotNull((Object)gradleVersion);
        GRADLE_MIN_VERSION = gradleVersion;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/plugins/VersionCheckPlugin$Companion;", "", "<init>", "()V", "GRADLE_MIN_VERSION", "Lorg/gradle/util/GradleVersion;", "getGRADLE_MIN_VERSION", "()Lorg/gradle/util/GradleVersion;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GradleVersion getGRADLE_MIN_VERSION() {
            return GRADLE_MIN_VERSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

