/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.androidtest.instrument;

import com.android.build.gradle.internal.testing.androidtest.instrument.AmInstrumentationListener;
import com.android.build.gradle.internal.testing.androidtest.instrument.InstrumentationResult;
import com.android.build.gradle.internal.testing.androidtest.instrument.TestIdentifier;
import com.android.build.gradle.internal.testing.androidtest.instrument.TestResult;
import com.android.build.gradle.internal.testing.androidtest.instrument.TestTimeTracker;
import com.google.testing.platform.proto.api.core.TestStatusProto;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 @2\u00020\u0001:\u0002?@B'\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000fJ\u0006\u0010+\u001a\u00020)J\u0018\u0010,\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u0019H\u0002J\u0018\u0010.\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u0019H\u0002J\b\u0010/\u001a\u00020)H\u0002J\u0017\u00100\u001a\u00020)2\b\u00101\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u00102J\u0014\u00103\u001a\u00020)2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u00105\u001a\u00020)2\b\u00106\u001a\u0004\u0018\u00010 H\u0002J\u0010\u00107\u001a\u00020)2\u0006\u00106\u001a\u00020 H\u0002J\u0010\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020)2\u0006\u0010<\u001a\u00020\u000fH\u0002J\u0010\u0010=\u001a\u00020)2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010>\u001a\u00020 H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0018\u00010\u0015j\u0004\u0018\u0001`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0018\u00010\u0015j\u0004\u0018\u0001`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001e\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/android/build/gradle/internal/testing/androidtest/instrument/AmInstrumentationParser;", "", "listeners", "", "Lcom/android/build/gradle/internal/testing/androidtest/instrument/AmInstrumentationListener;", "testTimeTrackerFactory", "Lkotlin/Function0;", "Lcom/android/build/gradle/internal/testing/androidtest/instrument/TestTimeTracker;", "<init>", "(Ljava/util/Set;Lkotlin/jvm/functions/Function0;)V", "value", "Lcom/android/build/gradle/internal/testing/androidtest/instrument/InstrumentationResult;", "result", "getResult", "()Lcom/android/build/gradle/internal/testing/androidtest/instrument/InstrumentationResult;", "", "instrumentationError", "getInstrumentationError", "()Ljava/lang/String;", "currentKey", "currentResultValue", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "currentStatusValue", "code", "", "Ljava/lang/Integer;", "bundle", "", "expectedTestsCount", "completedTestsCount", "currentTestRecord", "Lcom/android/build/gradle/internal/testing/androidtest/instrument/AmInstrumentationParser$TestRecord;", "onErrorMessage", "parsingEnded", "", "instrumentationEnded", "instrumentationStartedReported", "instrumentationEndedReported", "testStartedReported", "parse", "", "line", "done", "parseResultKeyValue", "startIndex", "parseStatusKeyValue", "storeCurrentValue", "handleStatusCode", "statusCode", "(Ljava/lang/Integer;)V", "handleInstrumentationEnded", "errorCause", "reportInstrumentationStarted", "testRecord", "reportTestStarted", "reportTestEnded", "testResult", "Lcom/android/build/gradle/internal/testing/androidtest/instrument/TestResult;", "reportInstrumentationFailed", "message", "reportInstrumentationEnded", "getOrCreateCurrentTestRecord", "TestRecord", "Companion", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAmInstrumentationParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmInstrumentationParser.kt\ncom/android/build/gradle/internal/testing/androidtest/instrument/AmInstrumentationParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,499:1\n1#2:500\n1869#3,2:501\n1869#3,2:503\n1869#3,2:505\n1869#3,2:507\n1869#3,2:509\n1869#3,2:511\n*S KotlinDebug\n*F\n+ 1 AmInstrumentationParser.kt\ncom/android/build/gradle/internal/testing/androidtest/instrument/AmInstrumentationParser\n*L\n311#1:501,2\n320#1:503,2\n326#1:505,2\n332#1:507,2\n336#1:509,2\n340#1:511,2\n*E\n"})
public final class AmInstrumentationParser {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<AmInstrumentationListener> listeners;
    @NotNull
    private final Function0<TestTimeTracker> testTimeTrackerFactory;
    @Nullable
    private InstrumentationResult result;
    @Nullable
    private String instrumentationError;
    @Nullable
    private String currentKey;
    @Nullable
    private StringBuilder currentResultValue;
    @Nullable
    private StringBuilder currentStatusValue;
    @Nullable
    private Integer code;
    @NotNull
    private Map<String, String> bundle;
    @Nullable
    private Integer expectedTestsCount;
    private int completedTestsCount;
    @Nullable
    private TestRecord currentTestRecord;
    @Nullable
    private String onErrorMessage;
    private boolean parsingEnded;
    private boolean instrumentationEnded;
    private boolean instrumentationStartedReported;
    private boolean instrumentationEndedReported;
    private boolean testStartedReported;
    @Deprecated
    @NotNull
    public static final String ABORTED = "INSTRUMENTATION_ABORTED: ";
    @Deprecated
    @NotNull
    public static final String CODE = "INSTRUMENTATION_CODE: ";
    @Deprecated
    @NotNull
    public static final String ON_ERROR = "onError: ";
    @Deprecated
    @NotNull
    public static final String RESULT = "INSTRUMENTATION_RESULT: ";
    @Deprecated
    @NotNull
    public static final String STATUS = "INSTRUMENTATION_STATUS: ";
    @Deprecated
    @NotNull
    public static final String STATUS_CODE = "INSTRUMENTATION_STATUS_CODE: ";
    @Deprecated
    @NotNull
    public static final String STATUS_FAILED = "INSTRUMENTATION_FAILED: ";
    @Deprecated
    @NotNull
    public static final String PREFIX = "INSTRUMENTATION_";
    @Deprecated
    @NotNull
    public static final String STATUS_CLASS = "class";
    @Deprecated
    @NotNull
    public static final String STATUS_CURRENT = "current";
    @Deprecated
    @NotNull
    public static final String STATUS_ERROR = "Error";
    @Deprecated
    @NotNull
    public static final String STATUS_ID = "id";
    @Deprecated
    @NotNull
    public static final String STATUS_NUMTESTS = "numtests";
    @Deprecated
    @NotNull
    public static final String STATUS_SHORTMSG = "shortMsg";
    @Deprecated
    @NotNull
    public static final String STATUS_STACK = "stack";
    @Deprecated
    @NotNull
    public static final String STATUS_STREAM = "stream";
    @Deprecated
    @NotNull
    public static final String STATUS_TEST = "test";
    @NotNull
    private static final Set<String> knownStatus;
    @Deprecated
    public static final int STATUS_CODE_START = 1;
    @Deprecated
    public static final int STATUS_CODE_IN_PROGRESS = 2;
    @Deprecated
    public static final int STATUS_CODE_OK = 0;
    @Deprecated
    public static final int STATUS_CODE_ERROR = -1;
    @Deprecated
    public static final int STATUS_CODE_FAILURE = -2;
    @Deprecated
    public static final int STATUS_CODE_IGNORED = -3;
    @Deprecated
    public static final int STATUS_CODE_ASSUMPTION_FAILURE = -4;
    @Deprecated
    @NotNull
    public static final String ERROR_NO_TEST_RESULTS = "No test results";
    @Deprecated
    @NotNull
    public static final String FATAL_ERROR_MSG = "Fatal exception when running tests";
    @Deprecated
    @NotNull
    public static final String STREAM_INSTRUMENTATION_PROCESS_CRASHED = "Test instrumentation process crashed";
    @NotNull
    private static final Regex STREAM_FAILURES_REGEX;

    public AmInstrumentationParser(@NotNull Set<? extends AmInstrumentationListener> listeners, @NotNull Function0<TestTimeTracker> testTimeTrackerFactory) {
        Intrinsics.checkNotNullParameter(listeners, (String)"listeners");
        Intrinsics.checkNotNullParameter(testTimeTrackerFactory, (String)"testTimeTrackerFactory");
        this.listeners = listeners;
        this.testTimeTrackerFactory = testTimeTrackerFactory;
        this.bundle = new LinkedHashMap();
    }

    public /* synthetic */ AmInstrumentationParser(Set set, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(set, (Function0<TestTimeTracker>)function0);
    }

    @Nullable
    public final InstrumentationResult getResult() {
        return this.result;
    }

    @Nullable
    public final String getInstrumentationError() {
        return this.instrumentationError;
    }

    public final void parse(@NotNull String line) {
        block4: {
            StringBuilder stringBuilder;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block3: {
                                            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                                            if (!(!this.parsingEnded)) {
                                                boolean bl = false;
                                                String string = "Parsing was completed, but parse() was called again!";
                                                throw new IllegalStateException(string.toString());
                                            }
                                            if (StringsKt.startsWith$default((String)line, (String)PREFIX, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)ON_ERROR, (boolean)false, (int)2, null)) {
                                                this.storeCurrentValue();
                                            }
                                            if (!StringsKt.startsWith$default((String)line, (String)STATUS, (boolean)false, (int)2, null)) break block3;
                                            this.parseStatusKeyValue(line, 24);
                                            break block4;
                                        }
                                        if (!StringsKt.startsWith$default((String)line, (String)STATUS_CODE, (boolean)false, (int)2, null)) break block5;
                                        String string = line.substring(29);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                                        Integer statusCode = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)string)).toString());
                                        this.handleStatusCode(statusCode);
                                        break block4;
                                    }
                                    if (!StringsKt.startsWith$default((String)line, (String)STATUS_FAILED, (boolean)false, (int)2, null)) break block6;
                                    AmInstrumentationParser.handleInstrumentationEnded$default(this, null, 1, null);
                                    break block4;
                                }
                                if (!StringsKt.startsWith$default((String)line, (String)ON_ERROR, (boolean)false, (int)2, null)) break block7;
                                this.onErrorMessage = ((Object)StringsKt.trim((CharSequence)line)).toString();
                                break block4;
                            }
                            if (!StringsKt.startsWith$default((String)line, (String)ABORTED, (boolean)false, (int)2, null)) break block8;
                            String string = this.onErrorMessage;
                            if (string == null) {
                                String string2 = line.substring(25);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                            }
                            this.onErrorMessage = string;
                            break block4;
                        }
                        if (!StringsKt.startsWith$default((String)line, (String)CODE, (boolean)false, (int)2, null)) break block9;
                        String string = line.substring(22);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        this.code = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)string)).toString());
                        this.instrumentationEnded = true;
                        AmInstrumentationParser.handleInstrumentationEnded$default(this, null, 1, null);
                        break block4;
                    }
                    if (!StringsKt.startsWith$default((String)line, (String)RESULT, (boolean)false, (int)2, null)) break block10;
                    this.parseResultKeyValue(line, 24);
                    break block4;
                }
                if (this.currentStatusValue == null) break block11;
                StringBuilder stringBuilder2 = this.currentStatusValue;
                if (stringBuilder2 == null || (stringBuilder2 = stringBuilder2.append('\n')) == null) break block4;
                stringBuilder2.append(line);
                break block4;
            }
            if (this.currentResultValue == null || (stringBuilder = this.currentResultValue) == null || (stringBuilder = stringBuilder.append('\n')) == null) break block4;
            stringBuilder.append(line);
        }
    }

    public final void done() {
        if (!(!this.parsingEnded)) {
            boolean bl = false;
            String string = "Parsing was completed, but done() was called again!";
            throw new IllegalStateException(string.toString());
        }
        this.parsingEnded = true;
        this.storeCurrentValue();
        AmInstrumentationParser.handleInstrumentationEnded$default(this, null, 1, null);
    }

    private final void parseResultKeyValue(String line, int startIndex) {
        int idx = StringsKt.indexOf$default((CharSequence)line, (char)'=', (int)startIndex, (boolean)false, (int)4, null);
        if (idx != -1) {
            String string = line.substring(startIndex, idx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.currentKey = ((Object)StringsKt.trim((CharSequence)string)).toString();
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = line.substring(idx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            this.currentResultValue = stringBuilder.append(string2);
        }
    }

    private final void parseStatusKeyValue(String line, int startIndex) {
        int idx = StringsKt.indexOf$default((CharSequence)line, (char)'=', (int)startIndex, (boolean)false, (int)4, null);
        if (idx != -1) {
            String string = line.substring(startIndex, idx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.currentKey = ((Object)StringsKt.trim((CharSequence)string)).toString();
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = line.substring(idx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            this.currentStatusValue = stringBuilder.append(string2);
        }
    }

    private final void storeCurrentValue() {
        String string = this.currentKey;
        if (string == null) {
            return;
        }
        String key = string;
        StringBuilder statusValue = this.currentStatusValue;
        if (statusValue != null) {
            TestRecord testRecord = this.getOrCreateCurrentTestRecord();
            String string2 = statusValue.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            testRecord.storeStatus(key, string2);
            this.currentStatusValue = null;
            return;
        }
        StringBuilder resultValue = this.currentResultValue;
        if (resultValue != null) {
            this.bundle.put(key, resultValue.toString());
            this.currentResultValue = null;
        }
    }

    private final void handleStatusCode(Integer statusCode) {
        TestRecord testRecord;
        TestRecord testRecord2 = testRecord = this.currentTestRecord;
        if (!(testRecord2 != null ? testRecord2.isComplete() : false)) {
            return;
        }
        if (!this.instrumentationStartedReported) {
            this.reportInstrumentationStarted(testRecord);
        }
        Integer n = statusCode;
        int n2 = 2;
        if (n != null && n == n2) {
            return;
        }
        Integer n3 = statusCode;
        n2 = 1;
        if (n3 != null && n3 == n2) {
            this.reportTestStarted(testRecord);
            testRecord.markTestStarted();
            return;
        }
        this.currentTestRecord = null;
        if (this.testStartedReported) {
            this.reportTestEnded(testRecord.toTestResult(statusCode));
        }
        if (testRecord.getError() != null) {
            this.handleInstrumentationEnded(testRecord.getError());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInstrumentationEnded(String errorCause) {
        InstrumentationResult result2;
        Map map;
        Object error;
        if (this.instrumentationEndedReported) {
            return;
        }
        String shortMsg = this.bundle.get(STATUS_SHORTMSG);
        String string = this.bundle.get(STATUS_STREAM);
        if (string == null) {
            string = "";
        }
        String streamMsg = string;
        boolean wasInstrumentationStartedReported = this.instrumentationStartedReported;
        Integer n = this.expectedTestsCount;
        String notEnoughTestsError = (n != null ? n : 0) > this.completedTestsCount ? "Expected " + this.expectedTestsCount + " tests, received " + this.completedTestsCount : null;
        Object object = errorCause;
        if (object == null) {
            String string2 = shortMsg;
            if (string2 != null) {
                object = "Instrumentation run failed due to " + string2;
            } else if (!wasInstrumentationStartedReported && !this.instrumentationEnded) {
                object = ERROR_NO_TEST_RESULTS;
            } else {
                object = notEnoughTestsError;
                if (object == null) {
                    object = StringsKt.contains$default((CharSequence)streamMsg, (CharSequence)FATAL_ERROR_MSG, (boolean)false, (int)2, null) ? streamMsg : null;
                }
            }
        }
        if ((error = object) != null) {
            Object object2 = this.onErrorMessage != null ? (String)error + ". " + this.onErrorMessage : (error = STREAM_FAILURES_REGEX.containsMatchIn((CharSequence)streamMsg) ? (String)error + ". " + streamMsg : error);
        }
        if (error == null && this.expectedTestsCount == null && STREAM_FAILURES_REGEX.containsMatchIn((CharSequence)streamMsg) && StringsKt.contains$default((CharSequence)streamMsg, (CharSequence)STREAM_INSTRUMENTATION_PROCESS_CRASHED, (boolean)false, (int)2, null)) {
            error = ((Object)StringsKt.trim((CharSequence)streamMsg)).toString();
        }
        if (!this.instrumentationStartedReported) {
            this.reportInstrumentationStarted(this.currentTestRecord);
        }
        if (this.testStartedReported) {
            TestRecord testRecord = this.getOrCreateCurrentTestRecord();
            this.currentTestRecord = null;
            this.reportTestEnded(testRecord.toTestResult(-1));
        }
        this.instrumentationError = error;
        if (error != null) {
            this.reportInstrumentationFailed("Test run failed to complete. " + (String)error);
        }
        Map map2 = map = MapsKt.toMutableMap(this.bundle);
        Integer n2 = this.code;
        boolean bl = false;
        Iterable $this$forEach$iv = knownStatus;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void it;
            String p0 = (String)element$iv;
            boolean bl2 = false;
            it.remove(p0);
        }
        Map map3 = map;
        Integer n3 = n2;
        this.result = result2 = new InstrumentationResult(n3, map3);
        this.reportInstrumentationEnded(result2);
    }

    static /* synthetic */ void handleInstrumentationEnded$default(AmInstrumentationParser amInstrumentationParser, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        amInstrumentationParser.handleInstrumentationEnded(string);
    }

    private final void reportInstrumentationStarted(TestRecord testRecord) {
        TestRecord testRecord2 = testRecord;
        this.expectedTestsCount = testRecord2 != null ? testRecord2.getNumTests() : null;
        this.instrumentationStartedReported = true;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmInstrumentationListener it = (AmInstrumentationListener)element$iv;
            boolean bl = false;
            Integer n = this.expectedTestsCount;
            it.instrumentationStarted(n != null ? n : 0);
        }
    }

    private final void reportTestStarted(TestRecord testRecord) {
        TestIdentifier testIdentifier = testRecord.toTestIdentifier();
        this.testStartedReported = true;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmInstrumentationListener it = (AmInstrumentationListener)element$iv;
            boolean bl = false;
            it.testStarted(testIdentifier);
        }
    }

    private final void reportTestEnded(TestResult testResult) {
        ++this.completedTestsCount;
        this.testStartedReported = false;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmInstrumentationListener it = (AmInstrumentationListener)element$iv;
            boolean bl = false;
            it.testEnded(testResult);
        }
    }

    private final void reportInstrumentationFailed(String message2) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmInstrumentationListener it = (AmInstrumentationListener)element$iv;
            boolean bl = false;
            it.instrumentationFailed(message2);
        }
    }

    private final void reportInstrumentationEnded(InstrumentationResult result2) {
        this.instrumentationEndedReported = true;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AmInstrumentationListener it = (AmInstrumentationListener)element$iv;
            boolean bl = false;
            it.instrumentationEnded(result2);
        }
    }

    private final TestRecord getOrCreateCurrentTestRecord() {
        TestRecord testResult = this.currentTestRecord;
        if (testResult == null) {
            this.currentTestRecord = testResult = new TestRecord((TestTimeTracker)this.testTimeTrackerFactory.invoke());
        }
        return testResult;
    }

    public AmInstrumentationParser() {
        this(null, null, 3, null);
    }

    static {
        Object[] objectArray = new String[]{STATUS_CLASS, STATUS_CURRENT, STATUS_ERROR, STATUS_ID, STATUS_NUMTESTS, STATUS_SHORTMSG, STATUS_STACK, STATUS_STREAM, STATUS_TEST};
        knownStatus = SetsKt.setOf((Object[])objectArray);
        STREAM_FAILURES_REGEX = new Regex("There (?:was|were) \\d+ failure");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lcom/android/build/gradle/internal/testing/androidtest/instrument/AmInstrumentationParser$Companion;", "", "<init>", "()V", "ABORTED", "", "CODE", "ON_ERROR", "RESULT", "STATUS", "STATUS_CODE", "STATUS_FAILED", "PREFIX", "STATUS_CLASS", "STATUS_CURRENT", "STATUS_ERROR", "STATUS_ID", "STATUS_NUMTESTS", "STATUS_SHORTMSG", "STATUS_STACK", "STATUS_STREAM", "STATUS_TEST", "knownStatus", "", "getKnownStatus", "()Ljava/util/Set;", "STATUS_CODE_START", "", "STATUS_CODE_IN_PROGRESS", "STATUS_CODE_OK", "STATUS_CODE_ERROR", "STATUS_CODE_FAILURE", "STATUS_CODE_IGNORED", "STATUS_CODE_ASSUMPTION_FAILURE", "ERROR_NO_TEST_RESULTS", "FATAL_ERROR_MSG", "STREAM_INSTRUMENTATION_PROCESS_CRASHED", "STREAM_FAILURES_REGEX", "Lkotlin/text/Regex;", "getSTREAM_FAILURES_REGEX", "()Lkotlin/text/Regex;", "gradle-core"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getKnownStatus() {
            return knownStatus;
        }

        @NotNull
        public final Regex getSTREAM_FAILURES_REGEX() {
            return STREAM_FAILURES_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\fJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0015\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0006\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/build/gradle/internal/testing/androidtest/instrument/AmInstrumentationParser$TestRecord;", "", "testTimeTracker", "Lcom/android/build/gradle/internal/testing/androidtest/instrument/TestTimeTracker;", "<init>", "(Lcom/android/build/gradle/internal/testing/androidtest/instrument/TestTimeTracker;)V", "value", "", "numTests", "getNumTests", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "", "error", "getError", "()Ljava/lang/String;", "testClass", "testMethod", "stackTrace", "statusBundle", "", "startedTestClass", "startedTestMethod", "markTestStarted", "", "isComplete", "", "storeStatus", "key", "toTestIdentifier", "Lcom/android/build/gradle/internal/testing/androidtest/instrument/TestIdentifier;", "toTestResult", "Lcom/android/build/gradle/internal/testing/androidtest/instrument/TestResult;", "statusCode", "(Ljava/lang/Integer;)Lcom/android/build/gradle/internal/testing/androidtest/instrument/TestResult;", "gradle-core"})
    private static final class TestRecord {
        @NotNull
        private final TestTimeTracker testTimeTracker;
        @Nullable
        private Integer numTests;
        @Nullable
        private String error;
        @Nullable
        private String testClass;
        @Nullable
        private String testMethod;
        @Nullable
        private String stackTrace;
        @NotNull
        private final Map<String, String> statusBundle;
        @Nullable
        private String startedTestClass;
        @Nullable
        private String startedTestMethod;

        public TestRecord(@NotNull TestTimeTracker testTimeTracker) {
            Intrinsics.checkNotNullParameter((Object)testTimeTracker, (String)"testTimeTracker");
            this.testTimeTracker = testTimeTracker;
            this.statusBundle = new LinkedHashMap();
            this.testTimeTracker.testStart();
        }

        @Nullable
        public final Integer getNumTests() {
            return this.numTests;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        public final void markTestStarted() {
            this.startedTestClass = this.testClass;
            this.startedTestMethod = this.testMethod;
            this.testClass = null;
            this.testMethod = null;
        }

        public final boolean isComplete() {
            return this.testClass != null && this.testMethod != null || this.error != null;
        }

        public final void storeStatus(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = key;
            if (Intrinsics.areEqual((Object)string, (Object)AmInstrumentationParser.STATUS_CLASS)) {
                this.testClass = ((Object)StringsKt.trim((CharSequence)value)).toString();
            } else if (Intrinsics.areEqual((Object)string, (Object)AmInstrumentationParser.STATUS_TEST)) {
                this.testMethod = ((Object)StringsKt.trim((CharSequence)value)).toString();
            } else if (Intrinsics.areEqual((Object)string, (Object)AmInstrumentationParser.STATUS_STACK)) {
                this.stackTrace = value;
            } else if (Intrinsics.areEqual((Object)string, (Object)AmInstrumentationParser.STATUS_NUMTESTS)) {
                this.numTests = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)value)).toString());
            } else if (Intrinsics.areEqual((Object)string, (Object)AmInstrumentationParser.STATUS_ERROR)) {
                this.error = value;
            } else if (!Companion.getKnownStatus().contains(string)) {
                this.statusBundle.put(key, value);
            }
        }

        @NotNull
        public final TestIdentifier toTestIdentifier() {
            String string = this.testClass;
            if (string == null && (string = this.startedTestClass) == null) {
                string = "";
            }
            String testClass = string;
            String string2 = StringsKt.substringBeforeLast((String)testClass, (char)'.', (String)"");
            String string3 = StringsKt.substringAfterLast((String)testClass, (char)'.', (String)testClass);
            String string4 = this.testMethod;
            if (string4 == null && (string4 = this.startedTestMethod) == null) {
                string4 = "unknown test method";
            }
            return new TestIdentifier(string2, string3, string4);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final TestResult toTestResult(@Nullable Integer statusCode) {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            this.testTimeTracker.testEnd();
                            v0 = this.toTestIdentifier();
                            v1 = var2_2 = statusCode;
                            if (v1 == null || v1 != 0) break block2;
                            v2 = TestStatusProto.TestStatus.PASSED;
                            break block3;
                        }
                        v3 = var2_2;
                        var3_3 = -1;
                        if (v3 == null || v3 != var3_3) break block4;
                        v2 = TestStatusProto.TestStatus.FAILED;
                        break block3;
                    }
                    v4 = var2_2;
                    var3_3 = -2;
                    if (v4 == null || v4 != var3_3) break block5;
                    v2 = TestStatusProto.TestStatus.FAILED;
                    break block3;
                }
                v5 = var2_2;
                var3_3 = -4;
                if (v5 != null && v5 == var3_3) ** GOTO lbl-1000
                v6 = var2_2;
                var3_3 = -3;
                if (v6 != null && v6 == var3_3) lbl-1000:
                // 2 sources

                {
                    v2 = TestStatusProto.TestStatus.IGNORED;
                } else {
                    v2 = TestStatusProto.TestStatus.ERROR;
                }
            }
            v7 = Instant.ofEpochMilli(this.testTimeTracker.getTestTimingData().getStartTime());
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"ofEpochMilli(...)");
            v8 = Instant.ofEpochMilli(this.testTimeTracker.getTestTimingData().getEndTime());
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"ofEpochMilli(...)");
            return new TestResult(v0, v2, v7, v8, this.stackTrace, MapsKt.toMap(this.statusBundle));
        }
    }
}

