/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadata;
import com.android.build.gradle.internal.transforms.ResourceShrinkerParams;
import com.android.build.gradle.internal.transforms.ShrinkAppBundleResourcesAction;
import com.android.build.gradle.internal.transforms.ShrinkAppBundleResourcesTask;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.OPTIMIZATION, secondaryTaskCategories={TaskCategory.ANDROID_RESOURCES})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u0014\u0010\u0011\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkAppBundleResourcesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "<init>", "()V", "shrunkBundle", "Lorg/gradle/api/file/RegularFileProperty;", "getShrunkBundle", "()Lorg/gradle/api/file/RegularFileProperty;", "originalBundle", "getOriginalBundle", "baseNamespace", "Lorg/gradle/api/provider/Property;", "", "getBaseNamespace", "()Lorg/gradle/api/provider/Property;", "featureSetMetadata", "getFeatureSetMetadata", "mappingFileSrc", "getMappingFileSrc", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class ShrinkAppBundleResourcesTask
extends NonIncrementalTask {
    @OutputFile
    @NotNull
    public abstract RegularFileProperty getShrunkBundle();

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getOriginalBundle();

    @Input
    @NotNull
    public abstract Property<String> getBaseNamespace();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getFeatureSetMetadata();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @Optional
    @NotNull
    public abstract RegularFileProperty getMappingFileSrc();

    @Override
    protected void doTaskAction() {
        File file = ((RegularFile)this.getFeatureSetMetadata().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        Map modules = MapsKt.plus(FeatureSetMetadata.Companion.load(file).getFeatureNameToNamespaceMap(), (Pair)TuplesKt.to((Object)"base", (Object)this.getBaseNamespace().get()));
        this.getWorkerExecutor().noIsolation().submit(ShrinkAppBundleResourcesAction.class, new Action(this, modules){
            final /* synthetic */ ShrinkAppBundleResourcesTask this$0;
            final /* synthetic */ Map<String, String> $modules;
            {
                this.this$0 = $receiver;
                this.$modules = $modules;
            }

            public final void execute(ResourceShrinkerParams it) {
                block1: {
                    it.getOriginalBundle().set((Provider)this.this$0.getOriginalBundle());
                    it.getShrunkBundle().set((Provider)this.this$0.getShrunkBundle());
                    it.getModules().set(this.$modules);
                    if (!this.this$0.getMappingFileSrc().isPresent()) break block1;
                    File file = ((RegularFile)this.this$0.getMappingFileSrc().get()).getAsFile().getParentFile();
                    if (file != null) {
                        File logDir = file;
                        boolean bl = false;
                        it.getReport().set(new File(logDir, "resources.txt"));
                    }
                }
            }
        });
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkAppBundleResourcesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/transforms/ShrinkAppBundleResourcesTask;", "Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;", "creationConfig", "<init>", "(Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "handleProvider", "", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "configure", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ShrinkAppBundleResourcesTask, ApplicationCreationConfig> {
        @NotNull
        private final String name;

        public CreationAction(@NotNull ApplicationCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false, 2, null);
            this.name = this.computeTaskName("shrinkBundle", "Resources");
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<ShrinkAppBundleResourcesTask> getType() {
            return ShrinkAppBundleResourcesTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ShrinkAppBundleResourcesTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            ((ApplicationCreationConfig)this.creationConfig).getArtifacts().use((TaskProvider)taskProvider).wiredWithFiles((Function1)handleProvider.1.INSTANCE, (Function1)handleProvider.2.INSTANCE).toTransform((Artifact.Single)InternalArtifactType.INTERMEDIARY_BUNDLE.INSTANCE);
        }

        @Override
        public void configure(@NotNull ShrinkAppBundleResourcesTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.getBaseNamespace().set(((ApplicationCreationConfig)this.creationConfig).getNamespace());
            ((ApplicationCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.FEATURE_SET_METADATA.INSTANCE, (Property)task.getFeatureSetMetadata());
            ((ApplicationCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct((Artifact.Single)SingleArtifact.OBFUSCATION_MAPPING_FILE.INSTANCE, (Property)task.getMappingFileSrc());
        }
    }
}

