/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.transform.pom;

import com.android.tools.build.jetifier.core.pom.PomDependency;
import com.android.tools.build.jetifier.core.pom.PomRewriteRule;
import com.android.tools.build.jetifier.core.utils.Log;
import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import com.android.tools.build.jetifier.processor.transform.TransformationContext;
import com.android.tools.build.jetifier.processor.transform.pom.PomDependencyExtensionsKt;
import com.android.tools.build.jetifier.processor.transform.pom.XmlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\tJ\b\u0010\u001a\u001a\u00020\u0016H\u0002J\u0006\u0010\u001b\u001a\u00020\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001d2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010 \u001a\u00020\u0016J\u0014\u0010!\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001dR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/pom/PomDocument;", "", "file", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "document", "Lorg/jdom2/Document;", "(Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;Lorg/jdom2/Document;)V", "dependencies", "", "Lcom/android/tools/build/jetifier/core/pom/PomDependency;", "getDependencies", "()Ljava/util/Set;", "dependenciesGroup", "Lorg/jdom2/Element;", "getFile", "()Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "hasChanged", "", "properties", "", "", "applyRules", "", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "getAsPomDependency", "initialize", "logDocumentDetails", "mapDependency", "", "dependency", "rewriteOwnArtifactInfo", "saveBackToFileIfNeeded", "validate", "rules", "Lcom/android/tools/build/jetifier/core/pom/PomRewriteRule;", "Companion", "jetifier-processor"})
public final class PomDocument {
    @NotNull
    private final Set<PomDependency> dependencies;
    private final Map<String, String> properties;
    private Element dependenciesGroup;
    private boolean hasChanged;
    @NotNull
    private final ArchiveFile file;
    private final Document document;
    private static final String TAG = "Pom";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Set<PomDependency> getDependencies() {
        return this.dependencies;
    }

    /*
     * WARNING - void declaration
     */
    private final void initialize() {
        Object element$iv$iv;
        Iterable $receiver$iv;
        Element element = this.document.getRootElement();
        Element element2 = this.document.getRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"document.rootElement");
        Element propertiesGroup = element.getChild("properties", element2.getNamespace());
        if (propertiesGroup != null) {
            CharSequence charSequence;
            Object it;
            Iterator $receiver$iv$iv;
            List list = propertiesGroup.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"propertiesGroup.children");
            $receiver$iv = list;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                Element element3 = it = (Element)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"it");
                charSequence = element3.getValue();
                if (charSequence == null || charSequence.length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Element it2 = (Element)element$iv;
                element$iv$iv = this.properties;
                Element element4 = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)element4, (String)"it");
                Intrinsics.checkExpressionValueIsNotNull((Object)element4.getName(), (String)"it.name");
                Intrinsics.checkExpressionValueIsNotNull((Object)it2.getValue(), (String)"it.value");
                element$iv$iv.put((Element)it, (CharSequence)charSequence);
            }
        }
        Element element5 = this.document.getRootElement();
        Element element6 = this.document.getRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element6, (String)"document.rootElement");
        Element element7 = element5.getChild("dependencies", element6.getNamespace());
        if (element7 == null) {
            return;
        }
        Element element8 = this.dependenciesGroup = element7;
        if (element8 == null) {
            Intrinsics.throwNpe();
        }
        List list = element8.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dependenciesGroup!!.children");
        $receiver$iv = list;
        Collection destination$iv = this.dependencies;
        for (Object item$iv : $receiver$iv) {
            void it;
            element$iv$iv = (Element)item$iv;
            Collection collection = destination$iv;
            void v10 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it");
            PomDependency pomDependency = XmlUtils.Companion.createDependencyFrom((Element)v10, this.properties);
            collection.add(pomDependency);
        }
    }

    public final boolean validate(@NotNull Set<PomRewriteRule> rules) {
        boolean bl;
        block8: {
            Intrinsics.checkParameterIsNotNull(rules, (String)"rules");
            if (this.dependenciesGroup == null) {
                return true;
            }
            Iterable $receiver$iv = this.dependencies;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    boolean bl2;
                    block7: {
                        PomDependency dep = (PomDependency)element$iv;
                        Iterable $receiver$iv2 = rules;
                        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv2 : $receiver$iv2) {
                                PomRewriteRule it = (PomRewriteRule)element$iv2;
                                if (PomRewriteRule.validateVersion$default((PomRewriteRule)it, (PomDependency)dep, null, (int)2, null)) continue;
                                bl2 = false;
                                break block7;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final void applyRules(@NotNull TransformationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.getRewritingSupportLib()) {
            this.rewriteOwnArtifactInfo(context);
            this.hasChanged = true;
        }
        if (this.dependenciesGroup == null) {
            return;
        }
        Set newDependencies = new LinkedHashSet();
        for (PomDependency dependency : this.dependencies) {
            newDependencies.addAll((Collection)this.mapDependency(dependency, context));
        }
        if (newDependencies.isEmpty()) {
            return;
        }
        Element element = this.dependenciesGroup;
        if (element == null) {
            Intrinsics.throwNpe();
        }
        element.getChildren().clear();
        Iterable $receiver$iv = newDependencies;
        for (Object element$iv : $receiver$iv) {
            PomDependency it = (PomDependency)element$iv;
            Element element2 = this.dependenciesGroup;
            if (element2 == null) {
                Intrinsics.throwNpe();
            }
            element2.addContent((Content)PomDependencyExtensionsKt.toXmlElement(it, this.document));
        }
        this.hasChanged = true;
    }

    @NotNull
    public final PomDependency getAsPomDependency() {
        Element element = this.document.getRootElement();
        Element element2 = this.document.getRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"document.rootElement");
        Element groupIdNode = element.getChild("groupId", element2.getNamespace());
        Element element3 = this.document.getRootElement();
        Element element4 = this.document.getRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element4, (String)"document.rootElement");
        Element artifactIdNode = element3.getChild("artifactId", element4.getNamespace());
        Element element5 = this.document.getRootElement();
        Element element6 = this.document.getRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element6, (String)"document.rootElement");
        Element version = element5.getChild("version", element6.getNamespace());
        Element element7 = groupIdNode;
        Intrinsics.checkExpressionValueIsNotNull((Object)element7, (String)"groupIdNode");
        String string = element7.getText();
        Element element8 = artifactIdNode;
        Intrinsics.checkExpressionValueIsNotNull((Object)element8, (String)"artifactIdNode");
        String string2 = element8.getText();
        Element element9 = version;
        Intrinsics.checkExpressionValueIsNotNull((Object)element9, (String)"version");
        return new PomDependency(string, string2, element9.getText(), null, null, null, null, null, 248, null);
    }

    private final void rewriteOwnArtifactInfo(TransformationContext context) {
        Element element = this.document.getRootElement();
        Element element2 = this.document.getRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"document.rootElement");
        Element groupIdNode = element.getChild("groupId", element2.getNamespace());
        Element element3 = this.document.getRootElement();
        Element element4 = this.document.getRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element4, (String)"document.rootElement");
        Element artifactIdNode = element3.getChild("artifactId", element4.getNamespace());
        Element element5 = this.document.getRootElement();
        Element element6 = this.document.getRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element6, (String)"document.rootElement");
        Element version = element5.getChild("version", element6.getNamespace());
        if (groupIdNode == null || artifactIdNode == null || version == null) {
            return;
        }
        PomDependency dependency = new PomDependency(groupIdNode.getText(), artifactIdNode.getText(), version.getText(), null, null, null, null, null, 248, null);
        PomDependency newDependency = (PomDependency)CollectionsKt.first((Iterable)this.mapDependency(dependency, context));
        if (Intrinsics.areEqual((Object)newDependency, (Object)dependency) ^ true) {
            groupIdNode.setText(newDependency.getGroupId());
            artifactIdNode.setText(newDependency.getArtifactId());
            version.setText(newDependency.getVersion());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<PomDependency> mapDependency(PomDependency dependency, TransformationContext context) {
        boolean matchesPrefix;
        block12: {
            boolean bl;
            Object v0;
            Iterable $receiver$iv;
            block11: {
                if (dependency.shouldSkipRewrite()) {
                    return SetsKt.emptySet();
                }
                $receiver$iv = context.getConfig().getPomRewriteRules();
                for (Object element$iv : $receiver$iv) {
                    PomRewriteRule it = (PomRewriteRule)element$iv;
                    if (!it.matches(dependency)) continue;
                    v0 = element$iv;
                    break block11;
                }
                v0 = null;
            }
            PomRewriteRule rule = v0;
            if (rule != null) {
                void $receiver$iv$iv;
                $receiver$iv = rule.getTo();
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    PomDependency $i$f$firstOrNull = (PomDependency)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    PomDependency pomDependency = it.rewrite(dependency);
                    collection.add(pomDependency);
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
            Iterable $receiver$iv2 = context.getConfig().getRestrictToPackagePrefixesWithDots();
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv2) {
                    String it = (String)element$iv;
                    String string = dependency.getGroupId();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block12;
                }
                bl = matchesPrefix = false;
            }
        }
        if (matchesPrefix) {
            if (context.getUseFallbackIfTypeIsMissing()) {
                Log.INSTANCE.i(TAG, "No mapping found for '%s' - using identity", new Object[]{dependency.toStringNotation()});
            } else {
                Log.INSTANCE.e(TAG, "No mapping found for '%s'", new Object[]{dependency.toStringNotation()});
                context.reportNoPackageMappingFoundFailure();
            }
        }
        return SetsKt.setOf((Object)dependency);
    }

    public final void saveBackToFileIfNeeded() {
        if (!this.hasChanged) {
            return;
        }
        this.file.setNewData(XmlUtils.Companion.convertDocumentToByteArray(this.document));
    }

    public final void logDocumentDetails() {
        Log.INSTANCE.i(TAG, "POM file at: '%s'", new Object[]{this.file.getRelativePath()});
        for (PomDependency pomDependency : this.dependencies) {
            String groupId = pomDependency.component1();
            String artifactId = pomDependency.component2();
            String version = pomDependency.component3();
            Log.INSTANCE.d(TAG, "- Dep: %s:%s:%s", new Object[]{groupId, artifactId, version});
        }
    }

    @NotNull
    public final ArchiveFile getFile() {
        return this.file;
    }

    public PomDocument(@NotNull ArchiveFile file, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        this.file = file;
        this.document = document;
        PomDocument pomDocument = this;
        Object object = new LinkedHashSet();
        pomDocument.dependencies = object;
        pomDocument = this;
        pomDocument.properties = object = (Map)new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/pom/PomDocument$Companion;", "", "()V", "TAG", "", "loadFrom", "Lcom/android/tools/build/jetifier/processor/transform/pom/PomDocument;", "file", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "jetifier-processor"})
    public static final class Companion {
        @NotNull
        public final PomDocument loadFrom(@NotNull ArchiveFile file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Document document = XmlUtils.Companion.createDocumentFromByteArray(file.getData());
            PomDocument pomDoc = new PomDocument(file, document);
            pomDoc.initialize();
            return pomDoc;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

