/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.transform.proguard;

import com.android.tools.build.jetifier.core.config.Config;
import com.android.tools.build.jetifier.core.proguard.ProGuardType;
import com.android.tools.build.jetifier.core.type.JavaType;
import com.android.tools.build.jetifier.core.utils.Log;
import com.android.tools.build.jetifier.processor.transform.TransformationContext;
import com.android.tools.build.jetifier.processor.transform.proguard.ProGuardTypesMapper;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/proguard/ProGuardTypesMapper;", "", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "(Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;)V", "config", "Lcom/android/tools/build/jetifier/core/config/Config;", "replaceMethodArgs", "", "argsTypes", "replaceType", "typeToReplace", "Companion", "jetifier-processor"})
public final class ProGuardTypesMapper {
    private final Config config;
    private final TransformationContext context;
    @NotNull
    public static final String TAG = "ProGuardTypesMapper";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String replaceType(@NotNull String typeToReplace) {
        Intrinsics.checkParameterIsNotNull((Object)typeToReplace, (String)"typeToReplace");
        ProGuardType type = ProGuardType.Companion.fromDotNotation(typeToReplace);
        if (type.isTrivial()) {
            return typeToReplace;
        }
        JavaType javaType = type.toJavaType();
        if (javaType != null) {
            JavaType result = this.context.getTypeRewriter().rewriteType(javaType);
            if (result != null) {
                return result.toDotNotation();
            }
            this.context.reportNoProGuardMappingFoundFailure();
            Log.INSTANCE.e(TAG, "No mapping for: %s", new Object[]{type});
            return typeToReplace;
        }
        ProGuardType result = (ProGuardType)this.config.getProGuardMap().getRules().get(type);
        if (result != null) {
            Log.INSTANCE.i(TAG, "  map: %s -> %s", new Object[]{type, result});
            return result.toDotNotation();
        }
        if (this.context.getTypeRewriter().isEligibleForRewrite(type)) {
            this.context.reportNoProGuardMappingFoundFailure();
            Log.INSTANCE.e(TAG, "No mapping for: " + type, new Object[0]);
        }
        return typeToReplace;
    }

    @NotNull
    public final String replaceMethodArgs(@NotNull String argsTypes) {
        Intrinsics.checkParameterIsNotNull((Object)argsTypes, (String)"argsTypes");
        CharSequence charSequence = argsTypes;
        if (charSequence.length() == 0 || Intrinsics.areEqual((Object)argsTypes, (Object)"...")) {
            return argsTypes;
        }
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)StringsKt.splitToSequence$default((CharSequence)argsTypes, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)), (Function1)replaceMethodArgs.1.INSTANCE), (Function1)replaceMethodArgs.2.INSTANCE), (Function1)((Function1)new Function1<String, String>(this){
            final /* synthetic */ ProGuardTypesMapper this$0;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.this$0.replaceType(it);
            }
            {
                this.this$0 = proGuardTypesMapper;
                super(1);
            }
        })), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    public ProGuardTypesMapper(@NotNull TransformationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.config = this.context.getConfig();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/proguard/ProGuardTypesMapper$Companion;", "", "()V", "TAG", "", "jetifier-processor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

