/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor.transform.proguard;

import com.android.tools.build.jetifier.core.config.Config;
import com.android.tools.build.jetifier.core.proguard.ProGuardType;
import com.android.tools.build.jetifier.core.type.JavaType;
import com.android.tools.build.jetifier.core.utils.Log;
import com.android.tools.build.jetifier.processor.CollectionExtensionsKt;
import com.android.tools.build.jetifier.processor.transform.TransformationContext;
import com.android.tools.build.jetifier.processor.transform.proguard.ProGuardTypesMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\tJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000f\u001a\u00020\tJ\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/proguard/ProGuardTypesMapper;", "", "context", "Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;", "(Lcom/android/tools/build/jetifier/processor/transform/TransformationContext;)V", "config", "Lcom/android/tools/build/jetifier/core/config/Config;", "generateProguardRulesFromType", "", "", "type", "Lcom/android/tools/build/jetifier/core/type/JavaType;", "replaceMethodArgs", "argsTypes", "replaceType", "typeToReplace", "tryResolveWildcardsAndRemapAndSimplify", "", "Lcom/android/tools/build/jetifier/core/proguard/ProGuardType;", "Companion", "jetifier-processor"})
public final class ProGuardTypesMapper {
    private final Config config;
    private final TransformationContext context;
    @NotNull
    public static final String TAG = "ProGuardTypesMapper";
    @NotNull
    private static final List<String> INNER_SUFFIXES;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> replaceType(@NotNull String typeToReplace) {
        Intrinsics.checkParameterIsNotNull((Object)typeToReplace, (String)"typeToReplace");
        ProGuardType type = ProGuardType.Companion.fromDotNotation(typeToReplace);
        if (type.isTrivial()) {
            return CollectionsKt.listOf((Object)typeToReplace);
        }
        JavaType javaType = type.toJavaType();
        if (javaType != null) {
            JavaType result = this.context.getTypeRewriter().rewriteType(javaType);
            if (result != null) {
                return CollectionsKt.listOf((Object)result.toDotNotation());
            }
            this.context.reportNoProGuardMappingFoundFailure(TAG, javaType.toString());
            return CollectionsKt.listOf((Object)typeToReplace);
        }
        Set mapResult = this.config.getProGuardMap().mapType(type);
        if (mapResult != null) {
            void $this$mapTo$iv$iv;
            Log.INSTANCE.i(TAG, "map: %s -> %s", new Object[]{type, CollectionsKt.joinToString$default((Iterable)mapResult, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)});
            Iterable $this$map$iv = mapResult;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProGuardType proGuardType = (ProGuardType)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.toDotNotation();
                collection.add(string);
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        for (String innerSuffix : INNER_SUFFIXES) {
            JavaType result;
            ProGuardType strippedType;
            JavaType strippedJavaType;
            if (!StringsKt.endsWith$default((String)typeToReplace, (String)innerSuffix, (boolean)false, (int)2, null) || (strippedJavaType = (strippedType = ProGuardType.Companion.fromDotNotation(StringsKt.removeSuffix((String)typeToReplace, (CharSequence)innerSuffix))).toJavaType()) == null || (result = this.context.getTypeRewriter().rewriteType(strippedJavaType)) == null) continue;
            String newType = result.toDotNotation() + innerSuffix;
            Log.INSTANCE.i(TAG, "map: %s -> %s", new Object[]{typeToReplace, newType});
            return CollectionsKt.listOf((Object)newType);
        }
        Set<String> results = this.tryResolveWildcardsAndRemapAndSimplify(type);
        if (results != null) {
            Log.INSTANCE.i(TAG, "guessed: %s -> %s", new Object[]{typeToReplace, CollectionsKt.joinToString$default((Iterable)results, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)});
            return CollectionsKt.toList((Iterable)results);
        }
        if (this.config.isEligibleForRewrite(type)) {
            this.context.reportNoProGuardMappingFoundFailure(TAG, type.toString());
        }
        return CollectionsKt.listOf((Object)typeToReplace);
    }

    private final Set<String> tryResolveWildcardsAndRemapAndSimplify(ProGuardType typeToReplace) {
        Set setToMatch = this.config.getTypesMap().matchOldProguardForNewTypes(typeToReplace);
        if (setToMatch.isEmpty()) {
            return null;
        }
        if (setToMatch.size() == 1) {
            List suffixesToAppend = CollectionsKt.listOf((Object[])new String[]{"*", "**"});
            for (String suffix : suffixesToAppend) {
                if (!StringsKt.endsWith$default((String)typeToReplace.getValue(), (String)suffix, (boolean)false, (int)2, null)) continue;
                return SetsKt.setOf((Object)(((JavaType)CollectionsKt.single((Iterable)setToMatch)).toDotNotation() + suffix));
            }
            return SetsKt.setOf((Object)((JavaType)CollectionsKt.single((Iterable)setToMatch)).toDotNotation());
        }
        boolean suffix = false;
        Set prefixes = new LinkedHashSet();
        boolean bl = false;
        Set newSet = new LinkedHashSet();
        Iterable $this$forEach$iv = setToMatch;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl2;
            ProGuardTypesMapper $this$run;
            JavaType type;
            block10: {
                type = (JavaType)element$iv;
                boolean bl3 = false;
                ProGuardTypesMapper proGuardTypesMapper = this;
                boolean bl4 = false;
                boolean bl5 = false;
                $this$run = proGuardTypesMapper;
                boolean bl6 = false;
                Iterable $this$any$iv = prefixes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String it = (String)element$iv2;
                        boolean bl7 = false;
                        if (!StringsKt.startsWith$default((String)type.getFullName(), (String)it, (boolean)false, (int)2, null)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            if (bl2) continue;
            String candidate = null;
            String candidatePrefix = null;
            List<String> selectors = $this$run.generateProguardRulesFromType(type);
            for (String selector : selectors) {
                String selectorPrefix = StringsKt.replace$default((String)selector, (String)"*", (String)"", (boolean)false, (int)4, null);
                Set foundSet = $this$run.config.getTypesMap().findAllTypesPrefixedWith(selectorPrefix);
                if (setToMatch.size() < foundSet.size() || !setToMatch.containsAll(foundSet)) break;
                candidate = selector;
                candidatePrefix = selectorPrefix;
                if (setToMatch.size() != foundSet.size()) continue;
                break;
            }
            if (candidate != null) {
                String string = candidatePrefix;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                prefixes.add(string);
                newSet.add(StringsKt.replace$default((String)candidate, (char)'/', (char)'.', (boolean)false, (int)4, null));
                continue;
            }
            return null;
        }
        Log.INSTANCE.v(TAG, "Guessed %s to be %s", new Object[]{typeToReplace.getValue(), CollectionsKt.joinToString$default((Iterable)newSet, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)});
        return newSet;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> generateProguardRulesFromType(JavaType type) {
        void $this$filterTo$iv$iv;
        boolean bl = false;
        List result = new ArrayList();
        String lastSegment = "";
        Object $this$forEach$iv = CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)type.getFullName(), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null), (int)1);
        boolean $i$f$forEach22 = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl2 = false;
            lastSegment = lastSegment + it + '/';
            result.add(lastSegment + "**");
        }
        $this$forEach$iv = StringsKt.substringAfterLast$default((String)type.getFullName(), (String)"/", null, (int)2, null);
        String $i$f$forEach22 = "(?=\\p{Upper})";
        int n = 0;
        $i$f$forEach22 = new Regex($i$f$forEach22);
        n = 0;
        boolean element$iv = false;
        Iterable $this$filter$iv = $i$f$forEach22.split((CharSequence)$this$forEach$iv, n);
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv2 = object.next();
            String it = (String)element$iv2;
            boolean bl5 = false;
            lastSegment = lastSegment + it;
            result.add(lastSegment + "*");
        }
        CollectionsKt.reverse((List)result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> replaceMethodArgs(@NotNull String argsTypes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)argsTypes, (String)"argsTypes");
        CharSequence charSequence = argsTypes;
        boolean bl = false;
        if (charSequence.length() == 0 || Intrinsics.areEqual((Object)argsTypes, (Object)"...")) {
            return CollectionsKt.listOf((Object)argsTypes);
        }
        Iterable $this$map$iv = CollectionExtensionsKt.cartesianProduct(SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)StringsKt.splitToSequence$default((CharSequence)argsTypes, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)), (Function1)replaceMethodArgs.1.INSTANCE), (Function1)replaceMethodArgs.2.INSTANCE), (Function1)((Function1)new Function1<String, List<? extends String>>(this){
            final /* synthetic */ ProGuardTypesMapper this$0;

            @NotNull
            public final List<String> invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.this$0.replaceType(it);
            }
            {
                this.this$0 = proGuardTypesMapper;
                super(1);
            }
        }))));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = CollectionsKt.joinToString$default((Iterable)((Iterable)it), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            collection.add(string);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    public ProGuardTypesMapper(@NotNull TransformationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.config = this.context.getConfig();
    }

    static {
        Companion = new Companion(null);
        INNER_SUFFIXES = CollectionsKt.listOf((Object[])new String[]{"$*", "$**"});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/build/jetifier/processor/transform/proguard/ProGuardTypesMapper$Companion;", "", "()V", "INNER_SUFFIXES", "", "", "getINNER_SUFFIXES", "()Ljava/util/List;", "TAG", "jetifier-processor"})
    public static final class Companion {
        @NotNull
        public final List<String> getINNER_SUFFIXES() {
            return INNER_SUFFIXES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

