/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.jetifier.processor;

import com.android.tools.build.jetifier.processor.archive.ArchiveFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"manifestPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "manifestSignatureDataPattern", "signatureFilePattern", "isSignatureFile", "", "file", "Lcom/android/tools/build/jetifier/processor/archive/ArchiveFile;", "jetifier-processor"})
public final class SignatureDetectionKt {
    private static final Pattern signatureFilePattern = Pattern.compile("^(/|\\\\)*meta-inf(/|\\\\)[^/\\\\]*\\.(SF|DSA|RSA|(SIG(-[^.]*)?))$", 2);
    private static final Pattern manifestPattern = Pattern.compile("^(/|\\\\)*meta-inf(/|\\\\)manifest\\.mf$", 2);
    private static final Pattern manifestSignatureDataPattern = Pattern.compile("(SHA1|SHA-1|SHA256|SHA-256)-Digest", 2);

    public static final boolean isSignatureFile(@NotNull ArchiveFile file) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (signatureFilePattern.matcher(((Object)file.getRelativePath()).toString()).matches()) {
            return true;
        }
        if (!manifestPattern.matcher(((Object)file.getRelativePath()).toString()).matches()) {
            return false;
        }
        byte[] byArray = file.getData();
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = string = new String(byArray, charset2);
        String string3 = string2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder(file.data.\u2026arsets.UTF_8)).toString()");
        String content = string3;
        return manifestSignatureDataPattern.matcher(content).find();
    }
}

