/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.AttributeModel;
import com.android.manifmerger.MergeType;
import com.android.manifmerger.OrphanXmlElement;
import com.android.manifmerger.XmlNode;
import com.android.utils.SdkUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ManifestModel {
    private static final NodeKeyResolver DEFAULT_NAME_ATTRIBUTE_RESOLVER = new AttributeBasedNodeKeyResolver("http://schemas.android.com/apk/res/android", "name");
    private static final NoKeyNodeResolver DEFAULT_NO_KEY_NODE_RESOLVER = new NoKeyNodeResolver();
    private static final NodeKeyResolver NAME_AND_GLESVERSION_KEY_RESOLVER = new NodeKeyResolver(){
        private final NodeKeyResolver nameAttrResolver = ManifestModel.access$200();
        private final NodeKeyResolver glEsVersionResolver = new AttributeBasedNodeKeyResolver("http://schemas.android.com/apk/res/android", "glEsVersion");

        @Override
        public String getKey(Element xmlElement) {
            String key = this.nameAttrResolver.getKey(xmlElement);
            return Strings.isNullOrEmpty((String)key) ? this.glEsVersionResolver.getKey(xmlElement) : key;
        }

        @Override
        public ImmutableList<String> getKeyAttributesNames() {
            return ImmutableList.of((Object)"name", (Object)"glEsVersion");
        }
    };
    private static final NodeKeyResolver INTENT_FILTER_KEY_RESOLVER = new NodeKeyResolver(){

        @Override
        public String getKey(Element element) {
            OrphanXmlElement xmlElement = new OrphanXmlElement(element);
            assert (xmlElement.getType() == NodeTypes.INTENT_FILTER);
            ArrayList<String> allSubElementKeys = new ArrayList<String>();
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Attr nameAttribute;
                OrphanXmlElement subElement;
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1 || (subElement = new OrphanXmlElement((Element)child)).getType() != NodeTypes.ACTION && subElement.getType() != NodeTypes.CATEGORY || (nameAttribute = subElement.getXml().getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")) == null) continue;
                allSubElementKeys.add(nameAttribute.getValue());
            }
            Collections.sort(allSubElementKeys);
            return Joiner.on((char)'+').join(allSubElementKeys);
        }

        @Override
        public ImmutableList<String> getKeyAttributesNames() {
            return ImmutableList.of((Object)"action#name", (Object)"category#name");
        }
    };
    private static final AttributeModel.BooleanValidator BOOLEAN_VALIDATOR = new AttributeModel.BooleanValidator();
    private static final boolean MULTIPLE_DECLARATION_FOR_SAME_KEY_ALLOWED = true;

    ManifestModel() {
    }

    static /* synthetic */ NodeKeyResolver access$200() {
        return DEFAULT_NAME_ATTRIBUTE_RESOLVER;
    }

    static /* synthetic */ NoKeyNodeResolver access$300() {
        return DEFAULT_NO_KEY_NODE_RESOLVER;
    }

    static /* synthetic */ NodeKeyResolver access$400() {
        return INTENT_FILTER_KEY_RESOLVER;
    }

    static /* synthetic */ NodeKeyResolver access$600() {
        return NAME_AND_GLESVERSION_KEY_RESOLVER;
    }

    static /* synthetic */ AttributeModel.BooleanValidator access$700() {
        return BOOLEAN_VALIDATOR;
    }

    static enum NodeTypes {
        ACTION(MergeType.MERGE, ManifestModel.access$200(), new AttributeModel.Builder[0]),
        ACTIVITY(MergeType.MERGE, ManifestModel.access$200(), AttributeModel.newModel("parentActivityName").setIsPackageDependent(), AttributeModel.newModel("name").setIsPackageDependent()),
        ACTIVITY_ALIAS(MergeType.MERGE, ManifestModel.access$200(), AttributeModel.newModel("targetActivity").setIsPackageDependent(), AttributeModel.newModel("name").setIsPackageDependent()),
        APPLICATION(MergeType.MERGE, (NodeKeyResolver)ManifestModel.access$300(), AttributeModel.newModel("backupAgent").setIsPackageDependent(), AttributeModel.newModel("name").setIsPackageDependent()),
        CATEGORY(MergeType.MERGE, ManifestModel.access$200(), new AttributeModel.Builder[0]),
        COMPATIBLE_SCREENS(MergeType.MERGE, (NodeKeyResolver)ManifestModel.access$300(), new AttributeModel.Builder[0]),
        DATA(MergeType.MERGE, (NodeKeyResolver)ManifestModel.access$300(), new AttributeModel.Builder[0]),
        GRANT_URI_PERMISSION(MergeType.MERGE, (NodeKeyResolver)ManifestModel.access$300(), new AttributeModel.Builder[0]),
        INSTRUMENTATION(MergeType.MERGE, (NodeKeyResolver)ManifestModel.access$300(), AttributeModel.newModel("name").setMergingPolicy(AttributeModel.NO_MERGING_POLICY), AttributeModel.newModel("targetPackage").setMergingPolicy(AttributeModel.NO_MERGING_POLICY), AttributeModel.newModel("functionalTest").setMergingPolicy(AttributeModel.NO_MERGING_POLICY), AttributeModel.newModel("handleProfiling").setMergingPolicy(AttributeModel.NO_MERGING_POLICY), AttributeModel.newModel("label").setMergingPolicy(AttributeModel.NO_MERGING_POLICY)),
        INTENT_FILTER(MergeType.ALWAYS, ManifestModel.access$400(), true, new AttributeModel.Builder[0]),
        MANIFEST(MergeType.MERGE_CHILDREN_ONLY, (NodeKeyResolver)ManifestModel.access$300(), new AttributeModel.Builder[0]),
        META_DATA(MergeType.MERGE, ManifestModel.access$200(), new AttributeModel.Builder[0]),
        PATH_PERMISSION(MergeType.MERGE, (NodeKeyResolver)ManifestModel.access$300(), new AttributeModel.Builder[0]),
        PERMISSION_GROUP(MergeType.MERGE, ManifestModel.access$200(), AttributeModel.newModel("name")),
        PERMISSION(MergeType.MERGE, ManifestModel.access$200(), AttributeModel.newModel("name"), AttributeModel.newModel("protectionLevel").setDefaultValue("normal").setOnReadValidator(new AttributeModel.MultiValueValidator("normal", "dangerous", "signature", "signatureOrSystem", "privileged", "system", "development", "appop", "pre23", "installer", "verifier", "preinstalled", "setup", "ephemeral"))),
        PERMISSION_TREE(MergeType.MERGE, ManifestModel.access$200(), AttributeModel.newModel("name")),
        PROVIDER(MergeType.MERGE, ManifestModel.access$200(), AttributeModel.newModel("name").setIsPackageDependent()),
        RECEIVER(MergeType.MERGE, ManifestModel.access$200(), AttributeModel.newModel("name").setIsPackageDependent()),
        SCREEN(MergeType.MERGE, (NodeKeyResolver)new TwoAttributesBasedKeyResolver(new AttributeBasedNodeKeyResolver("http://schemas.android.com/apk/res/android", "screenSize"), new AttributeBasedNodeKeyResolver("http://schemas.android.com/apk/res/android", "screenDensity")), new AttributeModel.Builder[0]),
        SERVICE(MergeType.MERGE, ManifestModel.access$200(), AttributeModel.newModel("name").setIsPackageDependent()),
        SUPPORTS_GL_TEXTURE(MergeType.MERGE, ManifestModel.access$200(), new AttributeModel.Builder[0]),
        SUPPORTS_SCREENS(MergeType.MERGE, (NodeKeyResolver)ManifestModel.access$300(), new AttributeModel.Builder[0]),
        USES_CONFIGURATION(MergeType.MERGE, (NodeKeyResolver)ManifestModel.access$300(), new AttributeModel.Builder[0]),
        USES_FEATURE(MergeType.MERGE, ManifestModel.access$600(), AttributeModel.newModel("required").setDefaultValue("true").setOnReadValidator(ManifestModel.access$700()).setMergingPolicy(AttributeModel.OR_MERGING_POLICY), AttributeModel.newModel("glEsVersion").setDefaultValue("0x00010000").setOnReadValidator(new AttributeModel.Hexadecimal32BitsWithMinimumValue(65536))),
        USES_LIBRARY(MergeType.MERGE, ManifestModel.access$200(), AttributeModel.newModel("required").setDefaultValue("true").setOnReadValidator(ManifestModel.access$700()).setMergingPolicy(AttributeModel.OR_MERGING_POLICY)),
        USES_PERMISSION(MergeType.MERGE, ManifestModel.access$200(), new AttributeModel.Builder[0]),
        USES_SDK(MergeType.MERGE, (NodeKeyResolver)ManifestModel.access$300(), AttributeModel.newModel("minSdkVersion").setDefaultValue("1").setMergingPolicy(AttributeModel.NO_MERGING_POLICY), AttributeModel.newModel("maxSdkVersion").setMergingPolicy(AttributeModel.NO_MERGING_POLICY), AttributeModel.newModel("targetSdkVersion").setMergingPolicy(AttributeModel.NO_MERGING_POLICY)),
        CUSTOM(MergeType.MERGE, (NodeKeyResolver)ManifestModel.access$300(), new AttributeModel.Builder[0]);

        private final MergeType mMergeType;
        private final NodeKeyResolver mNodeKeyResolver;
        private final ImmutableList<AttributeModel> mAttributeModels;
        private final boolean mMultipleDeclarationAllowed;

        private NodeTypes(MergeType mergeType, NodeKeyResolver nodeKeyResolver, AttributeModel.Builder ... attributeModelBuilders) {
            this(mergeType, nodeKeyResolver, false, attributeModelBuilders);
        }

        private NodeTypes(MergeType mergeType, NodeKeyResolver nodeKeyResolver, boolean mutipleDeclarationAllowed, AttributeModel.Builder ... attributeModelBuilders) {
            this.mMergeType = (MergeType)((Object)Preconditions.checkNotNull((Object)((Object)mergeType)));
            this.mNodeKeyResolver = (NodeKeyResolver)Preconditions.checkNotNull((Object)nodeKeyResolver);
            ImmutableList.Builder attributeModels = new ImmutableList.Builder();
            if (attributeModelBuilders != null) {
                for (AttributeModel.Builder attributeModelBuilder : attributeModelBuilders) {
                    attributeModels.add((Object)attributeModelBuilder.build());
                }
            }
            this.mAttributeModels = attributeModels.build();
            this.mMultipleDeclarationAllowed = mutipleDeclarationAllowed;
        }

        NodeKeyResolver getNodeKeyResolver() {
            return this.mNodeKeyResolver;
        }

        ImmutableList<AttributeModel> getAttributeModels() {
            return this.mAttributeModels.asList();
        }

        AttributeModel getAttributeModel(XmlNode.NodeName attributeName) {
            for (AttributeModel attributeModel : this.mAttributeModels) {
                if (!attributeModel.getName().equals(attributeName)) continue;
                return attributeModel;
            }
            return null;
        }

        String toXmlName() {
            return SdkUtils.constantNameToXmlName((String)this.name());
        }

        static NodeTypes fromXmlSimpleName(String xmlSimpleName) {
            String constantName = SdkUtils.xmlNameToConstantName((String)xmlSimpleName);
            try {
                return NodeTypes.valueOf(constantName);
            }
            catch (IllegalArgumentException e) {
                return CUSTOM;
            }
        }

        MergeType getMergeType() {
            return this.mMergeType;
        }

        boolean areMultipleDeclarationAllowed() {
            return this.mMultipleDeclarationAllowed;
        }
    }

    private static final class TwoAttributesBasedKeyResolver
    implements NodeKeyResolver {
        private final NodeKeyResolver firstAttributeKeyResolver;
        private final NodeKeyResolver secondAttributeKeyResolver;

        private TwoAttributesBasedKeyResolver(NodeKeyResolver firstAttributeKeyResolver, NodeKeyResolver secondAttributeKeyResolver) {
            this.firstAttributeKeyResolver = firstAttributeKeyResolver;
            this.secondAttributeKeyResolver = secondAttributeKeyResolver;
        }

        @Override
        public String getKey(Element xmlElement) {
            String firstKey = this.firstAttributeKeyResolver.getKey(xmlElement);
            String secondKey = this.secondAttributeKeyResolver.getKey(xmlElement);
            return Strings.isNullOrEmpty((String)firstKey) ? secondKey : (Strings.isNullOrEmpty((String)secondKey) ? firstKey : firstKey + "+" + secondKey);
        }

        @Override
        public ImmutableList<String> getKeyAttributesNames() {
            return ImmutableList.of((Object)this.firstAttributeKeyResolver.getKeyAttributesNames().get(0), (Object)this.secondAttributeKeyResolver.getKeyAttributesNames().get(0));
        }
    }

    private static class AttributeBasedNodeKeyResolver
    implements NodeKeyResolver {
        private final String mNamespaceUri;
        private final String mAttributeName;

        private AttributeBasedNodeKeyResolver(String namespaceUri, String attributeName) {
            this.mNamespaceUri = namespaceUri;
            this.mAttributeName = (String)Preconditions.checkNotNull((Object)attributeName);
        }

        @Override
        public String getKey(Element xmlElement) {
            String pkg;
            Element root;
            Document document;
            String key;
            String string = key = this.mNamespaceUri == null ? xmlElement.getAttribute(this.mAttributeName) : xmlElement.getAttributeNS(this.mNamespaceUri, this.mAttributeName);
            if (Strings.isNullOrEmpty((String)key)) {
                return null;
            }
            if (key.startsWith(".") && "name".equals(this.mAttributeName) && "http://schemas.android.com/apk/res/android".equals(this.mNamespaceUri) && (document = xmlElement.getOwnerDocument()) != null && (root = document.getDocumentElement()) != null && !(pkg = root.getAttribute("package")).isEmpty()) {
                key = pkg + key;
            }
            return key;
        }

        @Override
        public ImmutableList<String> getKeyAttributesNames() {
            return ImmutableList.of((Object)this.mAttributeName);
        }
    }

    private static class NoKeyNodeResolver
    implements NodeKeyResolver {
        private NoKeyNodeResolver() {
        }

        @Override
        public String getKey(Element xmlElement) {
            return null;
        }

        @Override
        public ImmutableList<String> getKeyAttributesNames() {
            return ImmutableList.of();
        }
    }

    static interface NodeKeyResolver {
        public String getKey(Element var1);

        public ImmutableList<String> getKeyAttributesNames();
    }
}

