/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.XmlNode;
import com.android.utils.ILogger;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ToolsInstructionsCleaner {
    private static final String REMOVE_OPERATION_XML_MAME = NodeOperationType.REMOVE.toCamelCaseName();
    private static final String REMOVE_ALL_OPERATION_XML_MAME = NodeOperationType.REMOVE_ALL.toCamelCaseName();

    public static Optional<Document> cleanToolsReferences(ManifestMerger2.MergeType mergeType, Document document, ILogger logger) {
        Preconditions.checkNotNull((Object)document);
        Preconditions.checkNotNull((Object)logger);
        MergingReport.Result result = ToolsInstructionsCleaner.cleanToolsReferences(mergeType, document.getDocumentElement(), logger);
        return result == MergingReport.Result.SUCCESS ? Optional.of((Object)document) : Optional.absent();
    }

    private static MergingReport.Result cleanToolsReferences(ManifestMerger2.MergeType mergeType, Element element, ILogger logger) {
        if ("http://schemas.android.com/tools".equals(element.getNamespaceURI())) {
            element.getParentNode().removeChild(element);
            return MergingReport.Result.SUCCESS;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            ArrayList<Node> attributes = new ArrayList<Node>();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                attributes.add(namedNodeMap.item(i));
            }
            for (Node attribute : attributes) {
                if ("http://schemas.android.com/tools".equals(attribute.getNamespaceURI())) {
                    boolean hasSelector;
                    boolean bl = hasSelector = namedNodeMap.getNamedItemNS("http://schemas.android.com/tools", "selector") != null;
                    if (attribute.getLocalName().equals("node") && (attribute.getNodeValue().equals(REMOVE_ALL_OPERATION_XML_MAME) || attribute.getNodeValue().equals(REMOVE_OPERATION_XML_MAME) && !hasSelector)) {
                        if (element.getParentNode().getNodeType() == 9) {
                            logger.error(null, String.format("tools:node=\"%1$s\" not allowed on top level %2$s element", attribute.getNodeValue(), XmlNode.unwrapName(element)), new Object[0]);
                            return MergingReport.Result.ERROR;
                        }
                        element.getParentNode().removeChild(element);
                    } else if (mergeType != ManifestMerger2.MergeType.LIBRARY) {
                        element.removeAttributeNS(attribute.getNamespaceURI(), attribute.getLocalName());
                    }
                }
                if (!attribute.getNodeName().startsWith("xmlns:") || !"http://schemas.android.com/tools".equals(attribute.getNodeValue()) || mergeType == ManifestMerger2.MergeType.LIBRARY) continue;
                element.removeAttribute(attribute.getNodeName());
            }
        }
        NodeList childNodes = element.getChildNodes();
        ImmutableList.Builder childElements = ImmutableList.builder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            childElements.add((Object)((Element)node));
        }
        for (Element childElement : childElements.build()) {
            if (ToolsInstructionsCleaner.cleanToolsReferences(mergeType, childElement, logger) != MergingReport.Result.ERROR) continue;
            return MergingReport.Result.ERROR;
        }
        return MergingReport.Result.SUCCESS;
    }
}

