/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlNode;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AttributeModel {
    private final XmlNode.NodeName mName;
    private final boolean mIsPackageDependent;
    private final String mDefaultValue;
    private final Validator mOnReadValidator;
    private final Validator mOnWriteValidator;
    private final MergingPolicy mMergingPolicy;
    static final MergingPolicy STRICT_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return false;
        }

        @Override
        public String merge(String higherPriority, String lowerPriority) {
            return higherPriority.equals(lowerPriority) ? higherPriority : null;
        }
    };
    static final MergingPolicy OR_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return true;
        }

        @Override
        public String merge(String higherPriority, String lowerPriority) {
            return Boolean.toString(BooleanValidator.isTrue(higherPriority) || BooleanValidator.isTrue(lowerPriority));
        }
    };
    static final MergingPolicy NO_MERGING_POLICY = new MergingPolicy(){

        @Override
        public boolean shouldMergeDefaultValues() {
            return true;
        }

        @Override
        public String merge(String higherPriority, String lowerPriority) {
            return higherPriority;
        }
    };

    private AttributeModel(XmlNode.NodeName name, boolean isPackageDependent, String defaultValue, Validator onReadValidator, Validator onWriteValidator, MergingPolicy mergingPolicy) {
        this.mName = name;
        this.mIsPackageDependent = isPackageDependent;
        this.mDefaultValue = defaultValue;
        this.mOnReadValidator = onReadValidator;
        this.mOnWriteValidator = onWriteValidator;
        this.mMergingPolicy = mergingPolicy;
    }

    XmlNode.NodeName getName() {
        return this.mName;
    }

    boolean isPackageDependent() {
        return this.mIsPackageDependent;
    }

    String getDefaultValue() {
        return this.mDefaultValue;
    }

    public Validator getOnReadValidator() {
        return this.mOnReadValidator;
    }

    public Validator getOnWriteValidator() {
        return this.mOnWriteValidator;
    }

    public MergingPolicy getMergingPolicy() {
        return this.mMergingPolicy;
    }

    static Builder newModel(String attributeName) {
        return new Builder(attributeName);
    }

    private static int decodeDecOrHexString(String s) {
        long decodedValue;
        long l = decodedValue = s.startsWith("0x") || s.startsWith("0X") ? Long.decode(s) : Long.parseLong(s);
        if (decodedValue < 0xFFFFFFFFL) {
            return (int)decodedValue;
        }
        throw new IllegalArgumentException("Value " + s + " too big for 32 bits.");
    }

    static class Hexadecimal32BitsWithMinimumValue
    extends Hexadecimal32Bits {
        private final int mMinimumValue;

        Hexadecimal32BitsWithMinimumValue(int minimumValue) {
            this.mMinimumValue = minimumValue;
        }

        @Override
        public boolean validates(MergingReport.Builder mergingReport, XmlAttribute attribute, String value) {
            boolean valid = super.validates(mergingReport, attribute, value);
            if (valid) {
                try {
                    Long decodedValue = Long.decode(value);
                    valid = decodedValue >= (long)this.mMinimumValue && decodedValue < 0xFFFFFFFFL;
                }
                catch (NumberFormatException e) {
                    valid = false;
                }
                if (!valid) {
                    attribute.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("Attribute %1$s at %2$s is not a valid hexadecimal value, minimum is 0x%3$08X, maximum is 0x%4$08X, found %5$s", attribute.getId(), attribute.printPosition(), this.mMinimumValue, Integer.MAX_VALUE, value));
                }
                return valid;
            }
            return false;
        }
    }

    static class Hexadecimal32Bits
    implements Validator {
        protected static final Pattern PATTERN = Pattern.compile("0[xX]([0-9a-fA-F]+)");

        Hexadecimal32Bits() {
        }

        @Override
        public boolean validates(MergingReport.Builder mergingReport, XmlAttribute attribute, String value) {
            boolean valid;
            Matcher matcher = PATTERN.matcher(value);
            boolean bl = valid = matcher.matches() && matcher.group(1).length() <= 8;
            if (!valid) {
                attribute.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("Attribute %1$s at %2$s is not a valid hexadecimal 32 bit value, found %3$s", attribute.getId(), attribute.printPosition(), value));
            }
            return valid;
        }
    }

    static class IntegerValueValidator
    implements Validator {
        IntegerValueValidator() {
        }

        @Override
        public boolean validates(MergingReport.Builder mergingReport, XmlAttribute attribute, String value) {
            try {
                return Integer.parseInt(value) > 0;
            }
            catch (NumberFormatException e) {
                attribute.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("Attribute %1$s at %2$s must be an integer, found %3$s", attribute.getId(), attribute.printPosition(), value));
                return false;
            }
        }
    }

    static class SeparatedValuesValidator
    implements Validator {
        private final ImmutableList<String> multiValuesList;
        private final String delimiter;

        SeparatedValuesValidator(String delimiter, String ... multiValues) {
            this.multiValuesList = ImmutableList.copyOf((Object[])multiValues);
            this.delimiter = delimiter;
        }

        @Override
        public boolean validates(MergingReport.Builder mergingReport, XmlAttribute attribute, String value) {
            boolean result = true;
            List<String> delimitedValues = Arrays.asList(value.split(Pattern.quote(this.delimiter)));
            if (delimitedValues.isEmpty()) {
                result = false;
            }
            for (String delimitedValue : delimitedValues) {
                if (this.multiValuesList.contains((Object)delimitedValue)) continue;
                result = false;
                break;
            }
            if (!result) {
                attribute.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("Invalid value for attribute %1$s at %2$s, value=(%3$s), acceptable delimiter-separated values are (%4$s)", attribute.getId(), attribute.printPosition(), value, Joiner.on((String)this.delimiter).join(this.multiValuesList)));
            }
            return result;
        }
    }

    static class MultiValueValidator
    implements Validator {
        private final String[] multiValues;
        private final String allValues;

        MultiValueValidator(String ... multiValues) {
            this.multiValues = multiValues;
            this.allValues = Joiner.on((char)',').join((Object[])multiValues);
        }

        @Override
        public boolean validates(MergingReport.Builder mergingReport, XmlAttribute attribute, String value) {
            for (String multiValue : this.multiValues) {
                if (!multiValue.equals(value)) continue;
                return true;
            }
            attribute.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("Invalid value for attribute %1$s at %2$s, value=(%3$s), acceptable values are (%4$s)", attribute.getId(), attribute.printPosition(), value, this.allValues));
            return false;
        }
    }

    static class BooleanValidator
    implements Validator {
        private static final Pattern TRUE_PATTERN = Pattern.compile("true|True|TRUE");
        private static final Pattern FALSE_PATTERN = Pattern.compile("false|False|FALSE");

        BooleanValidator() {
        }

        private static boolean isTrue(String value) {
            return TRUE_PATTERN.matcher(value).matches();
        }

        @Override
        public boolean validates(MergingReport.Builder mergingReport, XmlAttribute attribute, String value) {
            boolean matches;
            boolean bl = matches = TRUE_PATTERN.matcher(value).matches() || FALSE_PATTERN.matcher(value).matches();
            if (!matches) {
                attribute.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("Attribute %1$s at %2$s has an illegal value=(%3$s), expected 'true' or 'false'", attribute.getId(), attribute.printPosition(), value));
            }
            return matches;
        }
    }

    static interface Validator {
        public boolean validates(MergingReport.Builder var1, XmlAttribute var2, String var3);
    }

    static interface MergingPolicy {
        public boolean shouldMergeDefaultValues();

        public String merge(String var1, String var2);
    }

    static class Builder {
        private final String mName;
        private boolean mIsPackageDependent = false;
        private String mDefaultValue;
        private Validator mOnReadValidator;
        private Validator mOnWriteValidator;
        private MergingPolicy mMergingPolicy = STRICT_MERGING_POLICY;

        Builder(String name) {
            this.mName = name;
        }

        Builder setIsPackageDependent() {
            this.mIsPackageDependent = true;
            return this;
        }

        Builder setDefaultValue(String value) {
            this.mDefaultValue = value;
            return this;
        }

        Builder setOnReadValidator(Validator validator) {
            this.mOnReadValidator = validator;
            return this;
        }

        Builder setOnWriteValidator(Validator validator) {
            this.mOnWriteValidator = validator;
            return this;
        }

        Builder setMergingPolicy(MergingPolicy mergingPolicy) {
            this.mMergingPolicy = mergingPolicy;
            return this;
        }

        AttributeModel build() {
            return new AttributeModel(XmlNode.fromXmlName("android:" + this.mName), this.mIsPackageDependent, this.mDefaultValue, this.mOnReadValidator, this.mOnWriteValidator, this.mMergingPolicy);
        }
    }
}

