/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFilePosition;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/android/manifmerger/DeepLink;", "", "sourceFilePosition", "Lcom/android/ide/common/blame/SourceFilePosition;", "uri", "", "isAutoVerify", "", "(Lcom/android/ide/common/blame/SourceFilePosition;Ljava/lang/String;Z)V", "host", "getHost", "()Ljava/lang/String;", "()Z", "path", "getPath", "port", "", "getPort", "()I", "schemes", "", "getSchemes", "()Ljava/util/List;", "getSourceFilePosition", "()Lcom/android/ide/common/blame/SourceFilePosition;", "DeepLinkException", "DeepLinkUri", "manifest-merger"})
public final class DeepLink {
    @NotNull
    private final List<String> schemes;
    @Nullable
    private final String host;
    private final int port;
    @NotNull
    private final String path;
    @NotNull
    private final SourceFilePosition sourceFilePosition;
    private final boolean isAutoVerify;

    @NotNull
    public final List<String> getSchemes() {
        return this.schemes;
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final SourceFilePosition getSourceFilePosition() {
        return this.sourceFilePosition;
    }

    public final boolean isAutoVerify() {
        return this.isAutoVerify;
    }

    public DeepLink(@NotNull SourceFilePosition sourceFilePosition, @NotNull String uri, boolean isAutoVerify) {
        Intrinsics.checkParameterIsNotNull((Object)sourceFilePosition, (String)"sourceFilePosition");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this.sourceFilePosition = sourceFilePosition;
        this.isAutoVerify = isAutoVerify;
        try {
            DeepLinkUri deepLinkUri = new DeepLinkUri(uri);
            this.schemes = deepLinkUri.getSchemes();
            this.host = deepLinkUri.getHost();
            this.port = deepLinkUri.getPort();
            this.path = deepLinkUri.getPath();
        }
        catch (URISyntaxException e) {
            throw (Throwable)new DeepLinkException(e);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/android/manifmerger/DeepLink$DeepLinkUri;", "", "uri", "", "(Ljava/lang/String;)V", "host", "getHost", "()Ljava/lang/String;", "path", "getPath", "port", "", "getPort", "()I", "schemes", "", "getSchemes", "()Ljava/util/List;", "Companion", "manifest-merger"})
    public static final class DeepLinkUri {
        @NotNull
        private final List<String> schemes;
        @Nullable
        private final String host;
        private final int port;
        @NotNull
        private final String path;
        private static final ImmutableList<String> DEFAULT_SCHEMES;
        private static final String APPLICATION_ID_PLACEHOLDER = "${applicationId}";
        private static final String PATH_WILDCARD = "\\{[^{}]*}";
        private static final String WILDCARD = ".*";
        private static final String HOST_WILDCARD = "*";
        public static final Companion Companion;

        @NotNull
        public final List<String> getSchemes() {
            return this.schemes;
        }

        @Nullable
        public final String getHost() {
            return this.host;
        }

        public final int getPort() {
            return this.port;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public DeepLinkUri(@NotNull String uri) {
            CharSequence charSequence;
            List list;
            URI compliantUri;
            String compliantScheme;
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            String encodedUri = uri;
            String applicationIdEncoder = Companion.chooseEncoder(encodedUri, 'a', 'b');
            String pathWildcardEncoder = Companion.chooseEncoder(encodedUri, 'c', 'd');
            String wildcardEncoder = Companion.chooseEncoder(encodedUri, 'e', 'f');
            encodedUri = StringsKt.replace$default((String)encodedUri, (String)DeepLinkUri.Companion.getAPPLICATION_ID_PLACEHOLDER(), (String)applicationIdEncoder, (boolean)false, (int)4, null);
            CharSequence charSequence2 = encodedUri;
            String string = DeepLinkUri.Companion.getPATH_WILDCARD();
            string = new Regex(string);
            encodedUri = string.replace(charSequence2, pathWildcardEncoder);
            encodedUri = StringsKt.replace$default((String)encodedUri, (String)DeepLinkUri.Companion.getWILDCARD(), (String)wildcardEncoder, (boolean)false, (int)4, null);
            if (!Pattern.compile("^[^/]*:/").matcher(encodedUri).find() && !StringsKt.startsWith$default((String)encodedUri, (String)"/", (boolean)false, (int)2, null)) {
                encodedUri = "//" + encodedUri;
            }
            if ((compliantScheme = (compliantUri = new URI(encodedUri)).getScheme()) == null) {
                ImmutableList immutableList = DeepLinkUri.Companion.getDEFAULT_SCHEMES();
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"DEFAULT_SCHEMES");
                list = (List)immutableList;
            } else {
                if (StringsKt.contains$default((CharSequence)compliantScheme, (CharSequence)applicationIdEncoder, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)compliantScheme, (CharSequence)pathWildcardEncoder, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)compliantScheme, (CharSequence)wildcardEncoder, (boolean)false, (int)2, null)) {
                    throw (Throwable)new DeepLinkException("Improper use of wildcards and/or placeholders in deeplink URI scheme");
                }
                ImmutableList immutableList = ImmutableList.of((Object)compliantScheme);
                Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"if (compliantScheme.cont\u2026iantScheme)\n            }");
                list = (List)immutableList;
            }
            this.schemes = list;
            String compliantHost = compliantUri.getHost();
            if (compliantHost != null) {
                if (StringsKt.startsWith$default((String)(compliantHost = StringsKt.replace$default((String)compliantHost, (String)applicationIdEncoder, (String)DeepLinkUri.Companion.getAPPLICATION_ID_PLACEHOLDER(), (boolean)false, (int)4, null)), (String)wildcardEncoder, (boolean)false, (int)2, null)) {
                    String string2 = compliantHost;
                    int n = wildcardEncoder.length();
                    StringBuilder stringBuilder = new StringBuilder().append(DeepLinkUri.Companion.getHOST_WILDCARD());
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    String string5 = string4;
                    compliantHost = stringBuilder.append(string5).toString();
                }
                if (StringsKt.contains$default((CharSequence)compliantHost, (CharSequence)pathWildcardEncoder, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)compliantHost, (CharSequence)wildcardEncoder, (boolean)false, (int)2, null)) {
                    throw (Throwable)new DeepLinkException("Improper use of wildcards and/or placeholders in deeplink URI host");
                }
            }
            this.host = compliantHost;
            this.port = compliantUri.getPort();
            String compliantPath = compliantUri.getPath();
            if (compliantPath == null || (charSequence = (CharSequence)compliantPath).length() == 0) {
                compliantPath = "/";
            }
            compliantPath = StringsKt.replace$default((String)compliantPath, (String)applicationIdEncoder, (String)DeepLinkUri.Companion.getAPPLICATION_ID_PLACEHOLDER(), (boolean)false, (int)4, null);
            compliantPath = StringsKt.replace$default((String)compliantPath, (String)pathWildcardEncoder, (String)DeepLinkUri.Companion.getWILDCARD(), (boolean)false, (int)4, null);
            this.path = compliantPath = StringsKt.startsWith$default((String)(compliantPath = StringsKt.replace$default((String)compliantPath, (String)wildcardEncoder, (String)DeepLinkUri.Companion.getWILDCARD(), (boolean)false, (int)4, null)), (String)"/", (boolean)false, (int)2, null) ? compliantPath : "/" + compliantPath;
        }

        static {
            Companion = new Companion(null);
            DEFAULT_SCHEMES = ImmutableList.of((Object)"http", (Object)"https");
            APPLICATION_ID_PLACEHOLDER = APPLICATION_ID_PLACEHOLDER;
            PATH_WILDCARD = PATH_WILDCARD;
            WILDCARD = WILDCARD;
            HOST_WILDCARD = HOST_WILDCARD;
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R8\u0010\u0007\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u0004 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006R\u0014\u0010\u0010\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/android/manifmerger/DeepLink$DeepLinkUri$Companion;", "", "()V", "APPLICATION_ID_PLACEHOLDER", "", "getAPPLICATION_ID_PLACEHOLDER", "()Ljava/lang/String;", "DEFAULT_SCHEMES", "Lcom/google/common/collect/ImmutableList;", "kotlin.jvm.PlatformType", "getDEFAULT_SCHEMES", "()Lcom/google/common/collect/ImmutableList;", "HOST_WILDCARD", "getHOST_WILDCARD", "PATH_WILDCARD", "getPATH_WILDCARD", "WILDCARD", "getWILDCARD", "chooseEncoder", "uri", "char1", "", "char2", "manifest-merger"})
        public static final class Companion {
            private final ImmutableList<String> getDEFAULT_SCHEMES() {
                return DEFAULT_SCHEMES;
            }

            private final String getAPPLICATION_ID_PLACEHOLDER() {
                return APPLICATION_ID_PLACEHOLDER;
            }

            private final String getPATH_WILDCARD() {
                return PATH_WILDCARD;
            }

            private final String getWILDCARD() {
                return WILDCARD;
            }

            private final String getHOST_WILDCARD() {
                return HOST_WILDCARD;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String chooseEncoder(@NotNull String uri, char char1, char char2) {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                if (char1 == char2) {
                    throw (Throwable)new IllegalArgumentException("char1 and char2 must be different");
                }
                int longestLength = 0;
                int currentLength = 0;
                String string = uri;
                char[] cArray = string.toCharArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                char[] cArray2 = cArray;
                for (n = 0; n < cArray2.length; ++n) {
                    char c = cArray2[n];
                    currentLength = c == char1 ? currentLength + 1 : 0;
                    longestLength = currentLength > longestLength ? currentLength : longestLength;
                }
                StringBuilder sb = new StringBuilder();
                n = 0;
                int n2 = longestLength + 1;
                while (n < n2) {
                    void i;
                    sb.append(char1);
                    ++i;
                }
                sb.append(char2);
                String string2 = sb.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sb.toString()");
                return string2;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/manifmerger/DeepLink$DeepLinkException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "s", "", "(Ljava/lang/String;)V", "e", "Ljava/lang/Exception;", "(Ljava/lang/Exception;)V", "manifest-merger"})
    public static final class DeepLinkException
    extends RuntimeException {
        public DeepLinkException(@NotNull String s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            super(s);
        }

        public DeepLinkException(@NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            super(e);
        }
    }
}

