/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.ide.common.blame.SourceFilePosition;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.Actions;
import com.android.manifmerger.DeepLink;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NavigationXmlDocument;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@VisibleForTesting
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u000212B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0002J0\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J4\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017J,\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0012\u001a\u00020\u00062\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u0014H\u0007JT\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00062\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060#H\u0002J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010%\u001a\u00020\u001dH\u0002J \u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J \u00100\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002\u00a8\u00063"}, d2={"Lcom/android/manifmerger/NavGraphExpander;", "", "()V", "addAttribute", "", "nsUri", "", "attrName", "attrValue", "element", "Lorg/w3c/dom/Element;", "addChildElement", "childTagName", "parentElement", "addChildElementWithSingleAttribute", "expandNavGraph", "xmlElement", "Lcom/android/manifmerger/XmlElement;", "navigationXmlId", "loadedNavigationMap", "", "Lcom/android/manifmerger/NavigationXmlDocument;", "mergingReportBuilder", "Lcom/android/manifmerger/MergingReport$Builder;", "expandNavGraphs", "Lcom/android/manifmerger/XmlDocument;", "xmlDocument", "findDeepLinks", "", "Lcom/android/manifmerger/DeepLink;", "deepLinkList", "", "deepLinkUriMap", "", "visitedNavigationFiles", "", "getDeepLinkUriBody", "deepLink", "includeQuery", "", "getDeepLinkUris", "recordXmlAttributeAddition", "xmlAttribute", "Lcom/android/manifmerger/XmlAttribute;", "sourceFilePosition", "Lcom/android/ide/common/blame/SourceFilePosition;", "actionRecorder", "Lcom/android/manifmerger/ActionRecorder;", "recordXmlElementAddition", "ChildElementData", "NavGraphException", "manifest-merger"})
public final class NavGraphExpander {
    public static final NavGraphExpander INSTANCE;

    @NotNull
    public final XmlDocument expandNavGraphs(@NotNull XmlDocument xmlDocument, @NotNull Map<String, NavigationXmlDocument> loadedNavigationMap, @NotNull MergingReport.Builder mergingReportBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)xmlDocument, (String)"xmlDocument");
        Intrinsics.checkParameterIsNotNull(loadedNavigationMap, (String)"loadedNavigationMap");
        Intrinsics.checkParameterIsNotNull((Object)mergingReportBuilder, (String)"mergingReportBuilder");
        XmlElement xmlElement = xmlDocument.getRootNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)xmlElement, (String)"xmlDocument.rootNode");
        this.expandNavGraphs(xmlElement, loadedNavigationMap, mergingReportBuilder);
        XmlDocument xmlDocument2 = xmlDocument.reparse();
        Intrinsics.checkExpressionValueIsNotNull((Object)xmlDocument2, (String)"xmlDocument.reparse()");
        return xmlDocument2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void expandNavGraphs(XmlElement xmlElement, Map<String, NavigationXmlDocument> loadedNavigationMap, MergingReport.Builder mergingReportBuilder) {
        XmlElement navGraph;
        UnmodifiableIterator unmodifiableIterator = xmlElement.getMergeableElements().iterator();
        while (unmodifiableIterator.hasNext()) {
            XmlElement childElement;
            XmlElement xmlElement2 = childElement = (XmlElement)unmodifiableIterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlElement2, (String)"childElement");
            this.expandNavGraphs(xmlElement2, loadedNavigationMap, mergingReportBuilder);
        }
        Element element = xmlElement.getXml();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"xmlElement.xml");
        if (Intrinsics.areEqual((Object)element.getTagName(), (Object)"activity") ^ true) {
            return;
        }
        ImmutableList<XmlElement> immutableList = xmlElement.getAllNodesByType(ManifestModel.NodeTypes.NAV_GRAPH);
        Intrinsics.checkExpressionValueIsNotNull(immutableList, (String)"xmlElement.getAllNodesBy\u2026odel.NodeTypes.NAV_GRAPH)");
        ImmutableList<XmlElement> navGraphs = immutableList;
        if (navGraphs.isEmpty()) {
            return;
        }
        UnmodifiableIterator unmodifiableIterator2 = navGraphs.iterator();
        while (unmodifiableIterator2.hasNext()) {
            String navigationXmlId;
            String string;
            String graphValue;
            XmlElement xmlElement3 = navGraph = (XmlElement)unmodifiableIterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlElement3, (String)"navGraph");
            Element element2 = xmlElement3.getXml();
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"navGraph.xml");
            NamedNodeMap namedNodeMap = element2.getAttributes();
            Object object = namedNodeMap;
            String string2 = graphValue = object != null && (object = object.getNamedItemNS("http://schemas.android.com/apk/res/android", "value")) != null ? object.getNodeValue() : null;
            if (string2 != null && StringsKt.startsWith$default((String)string2, (String)"@navigation/", (boolean)false, (int)2, null)) {
                String string3 = graphValue;
                int n = "@navigation/".length();
                String string4 = string3.substring(n);
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = navigationXmlId = null;
            }
            if (navigationXmlId == null) {
                String nsUriPrefix = XmlUtils.lookupNamespacePrefix((Node)navGraph.getXml(), (String)"http://schemas.android.com/apk/res/android", (boolean)false);
                String graphName = nsUriPrefix + ':' + "value";
                XmlDocument xmlDocument = xmlElement.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)xmlDocument, (String)"xmlElement.document");
                mergingReportBuilder.addMessage(new SourceFilePosition(xmlDocument.getSourceFile(), xmlElement.getPosition()), MergingReport.Record.Severity.ERROR, "Missing or malformed attribute in <nav-graph> element. " + "Android manifest <nav-graph> element must contain a " + graphName + ' ' + "attribute with a value beginning " + "with \"@navigation/\".");
                return;
            }
            this.expandNavGraph(xmlElement, navigationXmlId, loadedNavigationMap, mergingReportBuilder);
        }
        unmodifiableIterator2 = navGraphs.iterator();
        while (unmodifiableIterator2.hasNext()) {
            navGraph = (XmlElement)unmodifiableIterator2.next();
            Element element3 = xmlElement.getXml();
            XmlElement xmlElement4 = navGraph;
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlElement4, (String)"navGraph");
            element3.removeChild(xmlElement4.getXml());
            mergingReportBuilder.getActionRecorder().recordNodeAction(navGraph, Actions.ActionType.CONVERTED);
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    private final void expandNavGraph(XmlElement xmlElement, String navigationXmlId, Map<String, NavigationXmlDocument> loadedNavigationMap, MergingReport.Builder mergingReportBuilder) {
        Object $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        List<DeepLink> list;
        try {
            list = this.findDeepLinks(navigationXmlId, loadedNavigationMap);
        }
        catch (NavGraphException e) {
            XmlDocument xmlDocument = xmlElement.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlDocument, (String)"xmlElement.document");
            SourceFilePosition sourceFilePosition = new SourceFilePosition(xmlDocument.getSourceFile(), xmlElement.getPosition());
            String string = e.getMessage();
            if (string == null) {
                string = "Error finding deep links.";
            }
            mergingReportBuilder.addMessage(sourceFilePosition, MergingReport.Record.Severity.ERROR, string);
            return;
        }
        List<DeepLink> deepLinks2 = list;
        ActionRecorder actionRecorder = mergingReportBuilder.getActionRecorder();
        Intrinsics.checkExpressionValueIsNotNull((Object)actionRecorder, (String)"mergingReportBuilder.actionRecorder");
        ActionRecorder actionRecorder2 = actionRecorder;
        Iterable $receiver$iv = deepLinks2;
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Object object;
            DeepLink it = (DeepLink)element$iv$iv;
            boolean bl = false;
            $receiver$iv$iv$iv = destination$iv$iv;
            String key$iv$iv = INSTANCE.getDeepLinkUriBody(it, false);
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map deepLinkGroups = destination$iv$iv;
        for (List deepLinkGroup : deepLinkGroups.values()) {
            String path;
            void $receiver$iv$iv2;
            Object $receiver$iv2;
            DeepLink deepLink = (DeepLink)CollectionsKt.first((List)deepLinkGroup);
            Element element = xmlElement.getXml();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"xmlElement.xml");
            Element intentFilterElement = this.addChildElement("intent-filter", element);
            if (deepLink.isAutoVerify()) {
                this.addAttribute("http://schemas.android.com/apk/res/android", "autoVerify", "true", intentFilterElement);
            }
            List childElementDataList = CollectionsKt.mutableListOf((Object[])new ChildElementData[]{new ChildElementData("action", "name", "android.intent.action.VIEW"), new ChildElementData("category", "name", "android.intent.category.DEFAULT"), new ChildElementData("category", "name", "android.intent.category.BROWSABLE")});
            $receiver$iv$iv$iv = $receiver$iv2 = (Iterable)deepLinkGroup;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                DeepLink it = (DeepLink)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getSchemes();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            for (String scheme : CollectionsKt.toSet((Iterable)((List)destination$iv$iv2))) {
                childElementDataList.add(new ChildElementData("data", "scheme", scheme));
            }
            if (deepLink.getHost() != null) {
                childElementDataList.add(new ChildElementData("data", "host", deepLink.getHost()));
            }
            if (deepLink.getPort() != -1) {
                childElementDataList.add(new ChildElementData("data", "port", String.valueOf(deepLink.getPort())));
            }
            if (StringsKt.substringBefore$default((String)(path = deepLink.getPath()), (String)".*", null, (int)2, null).length() == path.length() - 2) {
                childElementDataList.add(new ChildElementData("data", "pathPrefix", StringsKt.substringBefore$default((String)path, (String)".*", null, (int)2, null)));
            } else if (StringsKt.contains$default((CharSequence)path, (CharSequence)".*", (boolean)false, (int)2, null)) {
                childElementDataList.add(new ChildElementData("data", "pathPattern", path));
            } else {
                childElementDataList.add(new ChildElementData("data", "path", path));
            }
            Iterable $receiver$iv3 = childElementDataList;
            $receiver$iv2 = $receiver$iv3.iterator();
            while ($receiver$iv2.hasNext()) {
                Object element$iv = $receiver$iv2.next();
                ChildElementData it = (ChildElementData)element$iv;
                boolean bl = false;
                INSTANCE.addChildElementWithSingleAttribute(it.getTagName(), intentFilterElement, "http://schemas.android.com/apk/res/android", it.getAttrName(), it.getAttrValue());
            }
            XmlElement intentFilterXmlElement = new XmlElement(intentFilterElement, xmlElement.getDocument());
            for (DeepLink dl : deepLinkGroup) {
                this.recordXmlElementAddition(intentFilterXmlElement, dl.getSourceFilePosition(), actionRecorder2);
            }
        }
    }

    @VisibleForTesting
    @NotNull
    public final List<DeepLink> findDeepLinks(@NotNull String navigationXmlId, @NotNull Map<String, NavigationXmlDocument> loadedNavigationMap) throws NavGraphException {
        List deepLinkList;
        Intrinsics.checkParameterIsNotNull((Object)navigationXmlId, (String)"navigationXmlId");
        Intrinsics.checkParameterIsNotNull(loadedNavigationMap, (String)"loadedNavigationMap");
        List list = deepLinkList = (List)new ArrayList();
        Map<String, NavigationXmlDocument> map = loadedNavigationMap;
        String string = navigationXmlId;
        NavGraphExpander navGraphExpander = this;
        Map map2 = new LinkedHashMap();
        HashSet hashSet = new HashSet();
        navGraphExpander.findDeepLinks(string, map, list, map2, hashSet);
        ImmutableList immutableList = ImmutableList.copyOf((Collection)deepLinkList);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.copyOf(deepLinkList)");
        return (List)immutableList;
    }

    private final void findDeepLinks(String navigationXmlId, Map<String, NavigationXmlDocument> loadedNavigationMap, List<DeepLink> deepLinkList, Map<String, DeepLink> deepLinkUriMap, Set<String> visitedNavigationFiles) throws NavGraphException {
        if (!visitedNavigationFiles.add(navigationXmlId)) {
            throw (Throwable)new NavGraphException("Illegal circular reference among navigation files when traversing navigation" + " file references starting with navigationXmlId: " + navigationXmlId);
        }
        NavigationXmlDocument navigationXmlDocument = loadedNavigationMap.get(navigationXmlId);
        if (navigationXmlDocument == null) {
            throw (Throwable)new NavGraphException("Referenced navigation file with navigationXmlId = " + navigationXmlId + " not found");
        }
        for (DeepLink deepLink : navigationXmlDocument.getDeepLinks()) {
            for (String deepLinkUri : this.getDeepLinkUris(deepLink)) {
                if (deepLinkUriMap.containsKey(deepLinkUri)) {
                    throw (Throwable)new NavGraphException("Multiple destinations found with a deep link to " + deepLinkUri);
                }
                Map<String, DeepLink> map = deepLinkUriMap;
                DeepLink deepLink2 = deepLink;
                map.put(deepLinkUri, deepLink2);
            }
            deepLinkList.add(deepLink);
        }
        for (String otherNavigationXmlId : navigationXmlDocument.getNavigationXmlIds()) {
            this.findDeepLinks(otherNavigationXmlId, loadedNavigationMap, deepLinkList, deepLinkUriMap, visitedNavigationFiles);
        }
    }

    private final String getDeepLinkUriBody(DeepLink deepLink, boolean includeQuery) {
        String hostString = deepLink.getHost() == null ? "//" : "//" + deepLink.getHost();
        String portString = deepLink.getPort() == -1 ? "" : ":" + deepLink.getPort();
        String queryString = deepLink.getQuery() == null || !includeQuery ? "" : '?' + deepLink.getQuery();
        return hostString + portString + deepLink.getPath() + queryString;
    }

    private final List<String> getDeepLinkUris(DeepLink deepLink) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"ImmutableList.builder()");
        ImmutableList.Builder builder2 = builder;
        String body = this.getDeepLinkUriBody(deepLink, true);
        for (String scheme : deepLink.getSchemes()) {
            builder2.add((Object)(scheme + ':' + body));
        }
        ImmutableList immutableList = builder2.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return (List)immutableList;
    }

    private final void addChildElementWithSingleAttribute(String childTagName, Element parentElement, String nsUri, String attrName, String attrValue) {
        Element childElement = this.addChildElement(childTagName, parentElement);
        this.addAttribute(nsUri, attrName, attrValue, childElement);
    }

    private final Element addChildElement(String childTagName, Element parentElement) {
        Document document = parentElement.getOwnerDocument();
        Element childElement = document.createElement(childTagName);
        Node node = parentElement.appendChild(childElement);
        if (!(node instanceof Element)) {
            node = null;
        }
        Element element = (Element)node;
        if (element == null) {
            throw (Throwable)new RuntimeException("Unable to add " + childTagName + " element to " + parentElement.getTagName() + " element.");
        }
        return element;
    }

    private final void addAttribute(String nsUri, String attrName, String attrValue, Element element) {
        String prefix = XmlUtils.lookupNamespacePrefix((Node)element, (String)nsUri, (boolean)true);
        element.setAttributeNS(nsUri, prefix + ':' + attrName, attrValue);
    }

    private final void recordXmlElementAddition(XmlElement xmlElement, SourceFilePosition sourceFilePosition, ActionRecorder actionRecorder) {
        Actions.NodeRecord nodeRecord = new Actions.NodeRecord(Actions.ActionType.ADDED, sourceFilePosition, xmlElement.getId(), null, xmlElement.getOperationType());
        actionRecorder.recordNodeAction(xmlElement, nodeRecord);
        UnmodifiableIterator unmodifiableIterator = xmlElement.getAttributes().iterator();
        while (unmodifiableIterator.hasNext()) {
            XmlAttribute xmlAttribute;
            XmlAttribute xmlAttribute2 = xmlAttribute = unmodifiableIterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlAttribute2, (String)"xmlAttribute");
            this.recordXmlAttributeAddition(xmlAttribute2, sourceFilePosition, actionRecorder);
        }
        unmodifiableIterator = xmlElement.getMergeableElements().iterator();
        while (unmodifiableIterator.hasNext()) {
            XmlElement childXmlElement;
            XmlElement xmlElement2 = childXmlElement = (XmlElement)unmodifiableIterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlElement2, (String)"childXmlElement");
            this.recordXmlElementAddition(xmlElement2, sourceFilePosition, actionRecorder);
        }
    }

    private final void recordXmlAttributeAddition(XmlAttribute xmlAttribute, SourceFilePosition sourceFilePosition, ActionRecorder actionRecorder) {
        Actions.AttributeRecord attributeRecord = new Actions.AttributeRecord(Actions.ActionType.ADDED, sourceFilePosition, xmlAttribute.getId(), null, null);
        actionRecorder.recordAttributeAction(xmlAttribute, attributeRecord);
    }

    private NavGraphExpander() {
    }

    static {
        NavGraphExpander navGraphExpander;
        INSTANCE = navGraphExpander = new NavGraphExpander();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/android/manifmerger/NavGraphExpander$ChildElementData;", "", "tagName", "", "attrName", "attrValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAttrName", "()Ljava/lang/String;", "getAttrValue", "getTagName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "manifest-merger"})
    private static final class ChildElementData {
        @NotNull
        private final String tagName;
        @NotNull
        private final String attrName;
        @NotNull
        private final String attrValue;

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }

        @NotNull
        public final String getAttrName() {
            return this.attrName;
        }

        @NotNull
        public final String getAttrValue() {
            return this.attrValue;
        }

        public ChildElementData(@NotNull String tagName, @NotNull String attrName, @NotNull String attrValue) {
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            Intrinsics.checkParameterIsNotNull((Object)attrName, (String)"attrName");
            Intrinsics.checkParameterIsNotNull((Object)attrValue, (String)"attrValue");
            this.tagName = tagName;
            this.attrName = attrName;
            this.attrValue = attrValue;
        }

        @NotNull
        public final String component1() {
            return this.tagName;
        }

        @NotNull
        public final String component2() {
            return this.attrName;
        }

        @NotNull
        public final String component3() {
            return this.attrValue;
        }

        @NotNull
        public final ChildElementData copy(@NotNull String tagName, @NotNull String attrName, @NotNull String attrValue) {
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            Intrinsics.checkParameterIsNotNull((Object)attrName, (String)"attrName");
            Intrinsics.checkParameterIsNotNull((Object)attrValue, (String)"attrValue");
            return new ChildElementData(tagName, attrName, attrValue);
        }

        @NotNull
        public static /* synthetic */ ChildElementData copy$default(ChildElementData childElementData, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = childElementData.tagName;
            }
            if ((n & 2) != 0) {
                string2 = childElementData.attrName;
            }
            if ((n & 4) != 0) {
                string3 = childElementData.attrValue;
            }
            return childElementData.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ChildElementData(tagName=" + this.tagName + ", attrName=" + this.attrName + ", attrValue=" + this.attrValue + ")";
        }

        public int hashCode() {
            String string = this.tagName;
            String string2 = this.attrName;
            String string3 = this.attrValue;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ChildElementData)) break block3;
                    ChildElementData childElementData = (ChildElementData)object;
                    if (!Intrinsics.areEqual((Object)this.tagName, (Object)childElementData.tagName) || !Intrinsics.areEqual((Object)this.attrName, (Object)childElementData.attrName) || !Intrinsics.areEqual((Object)this.attrValue, (Object)childElementData.attrValue)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/manifmerger/NavGraphExpander$NavGraphException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "s", "", "(Ljava/lang/String;)V", "manifest-merger"})
    public static final class NavGraphException
    extends RuntimeException {
        public NavGraphException(@NotNull String s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            super(s);
        }
    }
}

