/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.NodeKeyResolver;
import com.android.manifmerger.OrphanXmlElement;
import com.android.manifmerger.XmlNode;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R2\u0010\u0005\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u0003 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/android/manifmerger/CompositeNodeKeyResolver;", "Lcom/android/manifmerger/NodeKeyResolver;", "nodeType", "", "(Ljava/lang/String;)V", "dataAttributeNames", "Lcom/google/common/collect/ImmutableList;", "kotlin.jvm.PlatformType", "keyAttributesNames", "getKeyAttributesNames", "()Lcom/google/common/collect/ImmutableList;", "model", "Lcom/android/manifmerger/ManifestModel;", "getNodeType", "()Ljava/lang/String;", "getAttributeInfo", "xmlElement", "Lcom/android/manifmerger/OrphanXmlElement;", "attributeName", "getKey", "element", "Lorg/w3c/dom/Element;", "manifest-merger"})
public class CompositeNodeKeyResolver
implements NodeKeyResolver {
    private final ManifestModel model;
    private final ImmutableList<String> dataAttributeNames;
    @NotNull
    private final String nodeType;

    @Override
    @NotNull
    public ImmutableList<String> getKeyAttributesNames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new String[]{"action#name", "category#name"});
        for (String dataAttributeName : this.dataAttributeNames) {
            builder.add((Object)("data#" + dataAttributeName));
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return immutableList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getKey(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        OrphanXmlElement xmlElement = new OrphanXmlElement(element, this.model);
        XmlNode.NodeName nodeName = xmlElement.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeName, (String)"xmlElement.name");
        boolean bl = Intrinsics.areEqual((Object)nodeName.getLocalName(), (Object)this.nodeType);
        boolean bl2 = false;
        int n = 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList<String> subElementAttributes = new ArrayList<String>();
        NodeList childNodes = element.getChildNodes();
        n = 0;
        NodeList nodeList = childNodes;
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeList, (String)"childNodes");
        int n2 = nodeList.getLength();
        while (n < n2) {
            void i;
            Node child;
            Node node = child = childNodes.item((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"child");
            if (node.getNodeType() == 1) {
                OrphanXmlElement subElement = new OrphanXmlElement((Element)child, this.model);
                if (subElement.getType() == ManifestModel.NodeTypes.ACTION || subElement.getType() == ManifestModel.NodeTypes.CATEGORY) {
                    String attributeInfo = this.getAttributeInfo(subElement, "name");
                    if (attributeInfo != null) {
                        subElementAttributes.add(attributeInfo);
                    }
                } else if (subElement.getType() == ManifestModel.NodeTypes.DATA) {
                    UnmodifiableIterator unmodifiableIterator = this.dataAttributeNames.iterator();
                    while (unmodifiableIterator.hasNext()) {
                        String dataAttributeName;
                        String string = dataAttributeName = (String)unmodifiableIterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dataAttributeName");
                        String attributeInfo = this.getAttributeInfo(subElement, string);
                        if (attributeInfo == null) continue;
                        subElementAttributes.add(attributeInfo);
                    }
                }
            }
            ++i;
        }
        CollectionsKt.sort((List)subElementAttributes);
        return Joiner.on((char)'+').join((Iterable)subElementAttributes);
    }

    private final String getAttributeInfo(OrphanXmlElement xmlElement, String attributeName) {
        Element element = xmlElement.getXml();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"xmlElement.xml");
        Element element2 = element;
        Attr attr = element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
        return attr == null ? null : element2.getTagName() + ":" + attributeName + ":" + attr.getValue();
    }

    @NotNull
    public final String getNodeType() {
        return this.nodeType;
    }

    public CompositeNodeKeyResolver(@NotNull String nodeType) {
        Intrinsics.checkParameterIsNotNull((Object)nodeType, (String)"nodeType");
        this.nodeType = nodeType;
        this.model = new ManifestModel();
        this.dataAttributeNames = ImmutableList.of((Object)"scheme", (Object)"host", (Object)"mimeType", (Object)"port", (Object)"path", (Object)"pathPattern", (Object)"pathPrefix");
    }
}

