/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlElement;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class Selector {
    public static final String SELECTOR_LOCAL_NAME = "selector";
    private final String mPackageName;
    private final List<String> mPackages = new LinkedList<String>();

    public Selector(String packageName) {
        this.mPackageName = (String)Preconditions.checkNotNull((Object)packageName);
        this.mPackages.addAll(Arrays.asList(this.mPackageName.split(",")));
    }

    boolean appliesTo(XmlElement element) {
        Optional<XmlAttribute> packageName = element.getDocument().getPackage();
        return packageName.isPresent() && this.mPackageName.contains(packageName.get().getValue());
    }

    boolean isResolvable(KeyResolver<String> resolver) {
        for (String p : this.mPackages) {
            if (resolver.resolve(p) != null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.mPackageName;
    }
}

