/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.AttributeModel;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeKeyResolver;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlNode;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;

public class PreValidator {
    private PreValidator() {
    }

    @NotNull
    public static MergingReport.Result validate(@NotNull MergingReport.Builder mergingReport, @NotNull XmlDocument xmlDocument, boolean validateExtractNativeLibsFromSources, boolean validateExtractNativeLibsFromDependencies) {
        PreValidator.validatePackageAttribute(mergingReport, xmlDocument.getRootNode(), xmlDocument.getFileType());
        if (validateExtractNativeLibsFromSources) {
            PreValidator.validateExtractNativeLibsFromSources(mergingReport, xmlDocument);
        }
        if (validateExtractNativeLibsFromDependencies) {
            PreValidator.validateExtractNativeLibsFromDependencies(mergingReport, xmlDocument);
        }
        return PreValidator.validate(mergingReport, xmlDocument.getRootNode());
    }

    @NotNull
    private static MergingReport.Result validate(@NotNull MergingReport.Builder mergingReport, @NotNull XmlElement xmlElement) {
        PreValidator.validateAttributeInstructions(mergingReport, xmlElement);
        PreValidator.validateAndroidAttributes(mergingReport, xmlElement);
        PreValidator.checkSelectorPresence(mergingReport, xmlElement);
        HashMap<XmlNode.NodeKey, XmlElement> childrenKeys = new HashMap<XmlNode.NodeKey, XmlElement>();
        for (XmlElement childElement : xmlElement.getMergeableElements()) {
            if (childElement.getOperationType() == NodeOperationType.REMOVE_ALL) {
                PreValidator.validateRemoveAllOperation(mergingReport, childElement);
                continue;
            }
            if (PreValidator.checkKeyPresence(mergingReport, childElement)) {
                XmlElement twin = (XmlElement)childrenKeys.get(childElement.getId());
                if (twin != null && !childElement.getType().areMultipleDeclarationAllowed()) {
                    String message = String.format("Element %1$s at %2$s duplicated with element declared at %3$s", childElement.getId(), childElement.printPosition(), ((XmlElement)childrenKeys.get(childElement.getId())).printPosition());
                    if (twin.compareTo(childElement).isPresent()) {
                        mergingReport.addMessage(childElement, MergingReport.Record.Severity.ERROR, message);
                    } else {
                        mergingReport.addMessage(childElement, MergingReport.Record.Severity.WARNING, message);
                    }
                }
                childrenKeys.put(childElement.getId(), childElement);
            }
            PreValidator.validate(mergingReport, childElement);
        }
        return mergingReport.hasErrors() ? MergingReport.Result.ERROR : MergingReport.Result.SUCCESS;
    }

    private static void validateRemoveAllOperation(@NotNull MergingReport.Builder mergingReport, @NotNull XmlElement element) {
        if (element.getAttributeCount() > 1) {
            ImmutableList<String> extraAttributeNames = element.getAttributeNames(item -> !"http://schemas.android.com/tools".equals(item.getNamespaceURI()) || !"node".equals(item.getLocalName()));
            String message = String.format("Element %1$s at %2$s annotated with 'tools:node=\"removeAll\"' cannot have other attributes : %3$s", element.getId(), element.printPosition(), Joiner.on((char)',').join(extraAttributeNames));
            mergingReport.addMessage(element, MergingReport.Record.Severity.ERROR, message);
        }
    }

    private static void checkSelectorPresence(@NotNull MergingReport.Builder mergingReport, @NotNull XmlElement element) {
        Attr selectorAttribute = element.getAttributeNodeNS("http://schemas.android.com/tools", "selector");
        if (selectorAttribute != null && !element.supportsSelector()) {
            String message = String.format("Unsupported tools:selector=\"%1$s\" found on node %2$s at %3$s", selectorAttribute.getValue(), element.getId(), element.printPosition());
            mergingReport.addMessage(element, MergingReport.Record.Severity.ERROR, message);
        }
    }

    private static void validatePackageAttribute(@NotNull MergingReport.Builder mergingReport, @NotNull XmlElement manifest, XmlDocument.Type fileType) {
        Attr attributeNode = manifest.getAttributeNode("package");
        if ((attributeNode == null || attributeNode.getValue().isEmpty()) && fileType == XmlDocument.Type.LIBRARY && !PreValidator.isSubManifest(manifest)) {
            mergingReport.addMessage(manifest, MergingReport.Record.Severity.ERROR, String.format("Missing 'package' declaration in manifest at %1$s", manifest.printPosition()));
        }
    }

    private static void validateExtractNativeLibsFromSources(@NotNull MergingReport.Builder mergingReport, @NotNull XmlDocument xmlDocument) {
        if (xmlDocument.getFileType() == XmlDocument.Type.LIBRARY) {
            return;
        }
        Boolean extractNativeLibsValue = PreValidator.getExtractNativeLibsValue(xmlDocument);
        if (extractNativeLibsValue != null) {
            String warning = String.format("android:%1$s should not be specified in this source AndroidManifest.xml file. See %2$s for more information.\nThe AGP Upgrade Assistant can remove the attribute from the AndroidManifest.xml file and update the build file accordingly. See %3$s for more information.", "extractNativeLibs", "https://d.android.com/guide/topics/manifest/application-element#extractNativeLibs", "https://d.android.com/studio/build/agp-upgrade-assistant");
            PreValidator.getExtractNativeLibsAttribute(xmlDocument).ifPresent(it -> mergingReport.addMessage((XmlAttribute)it, MergingReport.Record.Severity.WARNING, warning));
        }
    }

    private static void validateExtractNativeLibsFromDependencies(@NotNull MergingReport.Builder mergingReport, @NotNull XmlDocument xmlDocument) {
        if (xmlDocument.getFileType() != XmlDocument.Type.LIBRARY) {
            return;
        }
        Boolean extractNativeLibsValue = PreValidator.getExtractNativeLibsValue(xmlDocument);
        if (Boolean.TRUE.equals(extractNativeLibsValue)) {
            String warning = String.format("android:%1$s is set to true in a dependency's AndroidManifest.xml, but not in the app's merged manifest. If the dependency truly requires its native libraries to be extracted, the app can be configured to do so by setting the jniLibs.useLegacyPackaging DSL to true.\nOtherwise, you can silence this type of warning by adding %2$s=true to your gradle.properties file.", "extractNativeLibs", "android.experimental.suppressExtractNativeLibsWarnings");
            PreValidator.getExtractNativeLibsAttribute(xmlDocument).ifPresent(it -> mergingReport.addMessage((XmlAttribute)it, MergingReport.Record.Severity.WARNING, warning));
        }
    }

    @Nullable
    static Boolean getExtractNativeLibsValue(XmlDocument xmlDocument) {
        XmlAttribute extractNativeLibsAttribute = PreValidator.getExtractNativeLibsAttribute(xmlDocument).orElse(null);
        if (extractNativeLibsAttribute == null) {
            return null;
        }
        return Boolean.valueOf(extractNativeLibsAttribute.getValue());
    }

    private static Optional<XmlAttribute> getExtractNativeLibsAttribute(XmlDocument xmlDocument) {
        if (xmlDocument == null) {
            return Optional.empty();
        }
        XmlElement applicationElement = xmlDocument.getByTypeAndKey(ManifestModel.NodeTypes.APPLICATION, null).orElse(null);
        if (applicationElement == null) {
            return Optional.empty();
        }
        return applicationElement.getAttribute(XmlNode.fromNSName("http://schemas.android.com/apk/res/android", "android", "extractNativeLibs"));
    }

    private static boolean isSubManifest(@NotNull XmlElement manifest) {
        String description = manifest.getSourceFile().getDescription();
        if (description == null) {
            return false;
        }
        return description.equals("Wear App sub-manifest") || description.equals("Compatible-Screens sub-manifest") || description.endsWith("-privacy-sandbox-sdk-dependency-manifest-snippet.xml");
    }

    private static boolean checkKeyPresence(@NotNull MergingReport.Builder mergingReport, @NotNull XmlElement xmlElement) {
        NodeKeyResolver nodeKeyResolver = xmlElement.getType().getNodeKeyResolver();
        ImmutableList<String> keyAttributesNames = nodeKeyResolver.getKeyAttributesNames();
        if (keyAttributesNames.isEmpty()) {
            return false;
        }
        if (Strings.isNullOrEmpty((String)xmlElement.getKey())) {
            String message = keyAttributesNames.size() > 1 ? String.format("Missing one of the key attributes '%1$s' on element %2$s at %3$s", Joiner.on((char)',').join(keyAttributesNames), xmlElement.getId(), xmlElement.printPosition()) : String.format("Missing '%1$s' key attribute on element %2$s at %3$s", keyAttributesNames.get(0), xmlElement.getId(), xmlElement.printPosition());
            mergingReport.addMessage(xmlElement, MergingReport.Record.Severity.ERROR, message);
            return false;
        }
        return true;
    }

    private static void validateAndroidAttributes(@NotNull MergingReport.Builder mergingReport, @NotNull XmlElement xmlElement) {
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            AttributeModel model = xmlAttribute.getModel();
            if (model == null || model.getOnReadValidator() == null) continue;
            model.getOnReadValidator().validates(mergingReport, xmlAttribute, xmlAttribute.getValue());
        }
    }

    private static void validateAttributeInstructions(@NotNull MergingReport.Builder mergingReport, @NotNull XmlElement xmlElement) {
        block5: for (Map.Entry<XmlNode.NodeName, AttributeOperationType> attributeOperationTypeEntry : xmlElement.getAttributeOperations()) {
            Optional<XmlAttribute> attribute = xmlElement.getAttribute(attributeOperationTypeEntry.getKey());
            switch (attributeOperationTypeEntry.getValue()) {
                case STRICT: 
                case IGNORE_WARNING: {
                    continue block5;
                }
                case REMOVE: {
                    if (!attribute.isPresent()) continue block5;
                    mergingReport.addMessage(xmlElement, MergingReport.Record.Severity.ERROR, String.format("tools:remove specified at line:%d for attribute %s, but attribute also declared at line:%d, do you want to use tools:replace instead ?", xmlElement.getPosition().getStartLine() + 1, attributeOperationTypeEntry.getKey(), attribute.get().getPosition().getStartLine() + 1));
                    continue block5;
                }
                case REPLACE: {
                    if (attribute.isPresent()) continue block5;
                    mergingReport.addMessage(xmlElement, MergingReport.Record.Severity.ERROR, String.format("tools:replace specified at line:%d for attribute %s, but no new value specified", xmlElement.getPosition().getStartLine() + 1, attributeOperationTypeEntry.getKey()));
                    continue block5;
                }
            }
            mergingReport.addMessage(xmlElement, MergingReport.Record.Severity.ERROR, "Unhandled AttributeOperationType " + (Object)((Object)attributeOperationTypeEntry.getValue()));
        }
    }
}

