/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlElement;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class Selector {
    public static final String SELECTOR_LOCAL_NAME = "selector";
    @NotNull
    private final String commaSeparatedPackageNames;
    @NotNull
    private final List<String> packages = new LinkedList<String>();

    public Selector(@NotNull String commaSeparatedPackageNames) {
        this.commaSeparatedPackageNames = (String)Preconditions.checkNotNull((Object)commaSeparatedPackageNames);
        this.packages.addAll(Arrays.asList(commaSeparatedPackageNames.split(",")));
    }

    boolean appliesTo(@NotNull XmlElement element) {
        Optional<XmlAttribute> packageName = element.getDocument().getPackage();
        return packageName.isPresent() && this.packages.contains(packageName.get().getValue());
    }

    boolean isResolvable(@NotNull KeyResolver<String> resolver) {
        for (String p : this.packages) {
            if (resolver.resolve(p) != null) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        return this.commaSeparatedPackageNames;
    }
}

