/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.manifmerger.AttributeModel;
import com.android.manifmerger.DocumentModel;
import com.android.manifmerger.IntentFilterNodeKeyResolver;
import com.android.manifmerger.IntentNodeKeyResolver;
import com.android.manifmerger.MergeType;
import com.android.manifmerger.NodeKeyResolver;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlNode;
import com.android.utils.SdkUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ManifestModel
implements DocumentModel<NodeTypes> {
    private final boolean autoReject;
    private static final NodeKeyResolver DEFAULT_NAME_ATTRIBUTE_RESOLVER = new AttributeBasedNodeKeyResolver("http://schemas.android.com/apk/res/android", "name");
    private static final NoKeyNodeResolver DEFAULT_NO_KEY_NODE_RESOLVER = new NoKeyNodeResolver();
    private static final NodeKeyResolver PROVIDER_KEY_RESOLVER = new NodeKeyResolver(){

        @Override
        public ImmutableList<String> getKeyAttributesNames() {
            return ImmutableList.of();
        }

        @Override
        public String getKey(Element element) {
            if (element.getParentNode().getNodeName().equals(NodeTypes.QUERIES.name())) {
                return null;
            }
            return DEFAULT_NAME_ATTRIBUTE_RESOLVER.getKey(element);
        }
    };
    private static final NodeKeyResolver NAME_AND_GLESVERSION_KEY_RESOLVER = new NodeKeyResolver(){
        private final NodeKeyResolver nameAttrResolver = DEFAULT_NAME_ATTRIBUTE_RESOLVER;
        private final NodeKeyResolver glEsVersionResolver = new AttributeBasedNodeKeyResolver("http://schemas.android.com/apk/res/android", "glEsVersion");

        @Override
        public String getKey(Element element) {
            String key = this.nameAttrResolver.getKey(element);
            return Strings.isNullOrEmpty((String)key) ? this.glEsVersionResolver.getKey(element) : key;
        }

        @Override
        public ImmutableList<String> getKeyAttributesNames() {
            return ImmutableList.of((Object)"name", (Object)"glEsVersion");
        }
    };
    private static final AttributeModel.BooleanValidator BOOLEAN_VALIDATOR = new AttributeModel.BooleanValidator();
    private static final boolean MULTIPLE_DECLARATION_FOR_SAME_KEY_ALLOWED = true;

    public ManifestModel() {
        this(false);
    }

    public ManifestModel(boolean autoReject) {
        this.autoReject = autoReject;
    }

    @Override
    public String toXmlName(NodeTypes type) {
        return SdkUtils.constantNameToXmlName((String)type.name());
    }

    @Override
    public NodeTypes fromXmlSimpleName(String xmlSimpleName) {
        String constantName = SdkUtils.xmlNameToConstantName((String)xmlSimpleName);
        try {
            return NodeTypes.valueOf(constantName);
        }
        catch (IllegalArgumentException e) {
            return NodeTypes.CUSTOM;
        }
    }

    @Override
    public boolean autoRejectConflicts() {
        return this.autoReject;
    }

    static enum NodeTypes {
        ACTION(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, new AttributeModel.Builder[0]),
        ACTIVITY(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, AttributeModel.newModel("parentActivityName").setIsPackageDependent(), AttributeModel.newModel("name").setIsPackageDependent()),
        ACTIVITY_ALIAS(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, AttributeModel.newModel("targetActivity").setIsPackageDependent(), AttributeModel.newModel("name").setIsPackageDependent()),
        APPLICATION(MergeType.MERGE, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, AttributeModel.newModel("backupAgent").setIsPackageDependent(), AttributeModel.newModel("name").setIsPackageDependent(), AttributeModel.newModel("hasCode").setMergingPolicy(new AttributeModel.MergingPolicy(){

            @Override
            public boolean shouldMergeDefaultValues() {
                return false;
            }

            @Override
            public boolean canMergeWithLowerPriority(XmlDocument document) {
                return EnumSet.of(XmlDocument.Type.MAIN, XmlDocument.Type.OVERLAY).contains((Object)document.getFileType());
            }

            @Override
            public String merge(String higherPriority, String lowerPriority) {
                return AttributeModel.OR_MERGING_POLICY.merge(higherPriority, lowerPriority);
            }
        }), AttributeModel.newModel("localeConfig").setMergingPolicy(AttributeModel.STRICT_MAIN_OR_OVERLAY_MERGING_POLICY), AttributeModel.newModel("useEmbeddedDex").setMergingPolicy(AttributeModel.STRICT_MAIN_OR_OVERLAY_MERGING_POLICY), AttributeModel.newModel("extractNativeLibs").setMergingPolicy(AttributeModel.STRICT_MAIN_OR_OVERLAY_MERGING_POLICY)),
        CATEGORY(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, new AttributeModel.Builder[0]),
        COMPATIBLE_SCREENS(MergeType.MERGE, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, new AttributeModel.Builder[0]),
        DATA(MergeType.MERGE, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, new AttributeModel.Builder[0]),
        GRANT_URI_PERMISSION(MergeType.MERGE, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, new AttributeModel.Builder[0]),
        INSTRUMENTATION(MergeType.MERGE, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, AttributeModel.newModel("name").setMergingPolicy(AttributeModel.NO_MERGING_POLICY), AttributeModel.newModel("targetPackage").setMergingPolicy(AttributeModel.NO_MERGING_POLICY), AttributeModel.newModel("functionalTest").setMergingPolicy(AttributeModel.NO_MERGING_POLICY), AttributeModel.newModel("handleProfiling").setMergingPolicy(AttributeModel.NO_MERGING_POLICY), AttributeModel.newModel("label").setMergingPolicy(AttributeModel.NO_MERGING_POLICY)),
        INTENT(MergeType.ALWAYS, (NodeKeyResolver)IntentNodeKeyResolver.INSTANCE, true, new AttributeModel.Builder[0]),
        INTENT_FILTER(MergeType.ALWAYS, (NodeKeyResolver)IntentFilterNodeKeyResolver.INSTANCE, true, new AttributeModel.Builder[0]),
        MANIFEST(MergeType.MERGE_CHILDREN_ONLY, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, new AttributeModel.Builder[0]),
        META_DATA(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, new AttributeModel.Builder[0]),
        MODULE(MergeType.MERGE, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, EnumSet.of(XmlDocument.Type.MAIN, XmlDocument.Type.OVERLAY), new AttributeModel.Builder[0]),
        NAV_GRAPH(MergeType.MERGE, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, new AttributeModel.Builder[0]),
        PACKAGE(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, new AttributeModel.Builder[0]),
        PATH_PERMISSION(MergeType.MERGE, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, new AttributeModel.Builder[0]),
        PERMISSION_GROUP(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, AttributeModel.newModel("name")),
        PERMISSION(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, AttributeModel.newModel("name"), AttributeModel.newModel("protectionLevel").setDefaultValue("normal").setOnReadValidator(new AttributeModel.SeparatedValuesValidator("|", "normal", "dangerous", "signature", "signatureOrSystem", "internal", "privileged", "system", "development", "appop", "pre23", "installer", "verifier", "preinstalled", "setup", "ephemeral", "instant", "runtime", "oem", "vendorPrivileged", "textClassifier", "wellbeing", "documenter", "configurator", "incidentReportApprover", "appPredictor", "companion", "retailDemo", "recents", "role", "knownSigner"))),
        PERMISSION_TREE(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, AttributeModel.newModel("name")),
        PROFILEABLE(MergeType.MERGE, PROVIDER_KEY_RESOLVER, AttributeModel.newModel("shell").setDefaultValue("true").setMergingPolicy(AttributeModel.NO_MERGING_POLICY), AttributeModel.newModel("enabled").setDefaultValue("true").setMergingPolicy(AttributeModel.NO_MERGING_POLICY)),
        PROPERTY(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, AttributeModel.newModel("name").setIsPackageDependent()),
        PROVIDER(MergeType.MERGE, PROVIDER_KEY_RESOLVER, AttributeModel.newModel("name").setIsPackageDependent()),
        QUERIES(MergeType.MERGE, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, new AttributeModel.Builder[0]),
        RECEIVER(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, AttributeModel.newModel("name").setIsPackageDependent()),
        SCREEN(MergeType.MERGE, (NodeKeyResolver)new TwoAttributesBasedKeyResolver(new AttributeBasedNodeKeyResolver("http://schemas.android.com/apk/res/android", "screenSize"), new AttributeBasedNodeKeyResolver("http://schemas.android.com/apk/res/android", "screenDensity")), new AttributeModel.Builder[0]),
        SDK_LIBRARY(MergeType.MERGE, (NodeKeyResolver)new TwoAttributesBasedKeyResolver(new AttributeBasedNodeKeyResolver("http://schemas.android.com/apk/res/android", "name"), new AttributeBasedNodeKeyResolver("http://schemas.android.com/apk/res/android", "versionMajor")), AttributeModel.newModel("name").setIsPackageDependent()),
        SERVICE(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, AttributeModel.newModel("name").setIsPackageDependent()),
        SUPPORTS_GL_TEXTURE(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, new AttributeModel.Builder[0]),
        SUPPORTS_SCREENS(MergeType.MERGE, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, new AttributeModel.Builder[0]),
        USES_CONFIGURATION(MergeType.MERGE, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, new AttributeModel.Builder[0]),
        USES_FEATURE(MergeType.MERGE, NAME_AND_GLESVERSION_KEY_RESOLVER, AttributeModel.newModel("required").setDefaultValue("true").setOnReadValidator(BOOLEAN_VALIDATOR).setMergingPolicy(AttributeModel.OR_MERGING_POLICY), AttributeModel.newModel("glEsVersion").setDefaultValue("0x00010000").setOnReadValidator(new AttributeModel.Hexadecimal32BitsWithMinimumValue(65536))),
        USES_LIBRARY(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, AttributeModel.newModel("required").setDefaultValue("true").setOnReadValidator(BOOLEAN_VALIDATOR).setMergingPolicy(AttributeModel.OR_MERGING_POLICY)),
        USES_PERMISSION(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, new AttributeModel.Builder(XmlNode.fromNSName("http://schemas.android.com/tools", "tools", "requiredByPrivacySandboxSdk")).setDefaultValue("false").setOnReadValidator(BOOLEAN_VALIDATOR).setMergingPolicy(AttributeModel.AND_MERGING_POLICY)),
        USES_PERMISSION_SDK_23(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, new AttributeModel.Builder(XmlNode.fromNSName("http://schemas.android.com/tools", "tools", "requiredByPrivacySandboxSdk")).setDefaultValue("false").setOnReadValidator(BOOLEAN_VALIDATOR).setMergingPolicy(AttributeModel.AND_MERGING_POLICY)),
        USES_SDK(MergeType.MERGE, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, AttributeModel.newModel("minSdkVersion").setDefaultValue("1").setMergingPolicy(AttributeModel.NO_MERGING_POLICY), AttributeModel.newModel("maxSdkVersion").setMergingPolicy(AttributeModel.NO_MERGING_POLICY), AttributeModel.newModel("targetSdkVersion").setMergingPolicy(AttributeModel.NO_MERGING_POLICY)),
        USES_SDK_LIBRARY(MergeType.MERGE, DEFAULT_NAME_ATTRIBUTE_RESOLVER, AttributeModel.newModel("name").setIsPackageDependent()),
        ATTRIBUTION(MergeType.MERGE, (NodeKeyResolver)new AttributeBasedNodeKeyResolver("http://schemas.android.com/apk/res/android", "tag"), new AttributeModel.Builder[0]),
        CUSTOM(MergeType.MERGE, (NodeKeyResolver)DEFAULT_NO_KEY_NODE_RESOLVER, new AttributeModel.Builder[0]);

        private final MergeType mMergeType;
        private final NodeKeyResolver mNodeKeyResolver;
        private final ImmutableList<AttributeModel> mAttributeModels;
        private final boolean mMultipleDeclarationAllowed;
        private final EnumSet<XmlDocument.Type> mMergeableLowerPriorityTypes;

        private NodeTypes(MergeType mergeType, NodeKeyResolver nodeKeyResolver, AttributeModel.Builder ... attributeModelBuilders) {
            this(mergeType, nodeKeyResolver, false, EnumSet.allOf(XmlDocument.Type.class), attributeModelBuilders);
        }

        private NodeTypes(MergeType mergeType, NodeKeyResolver nodeKeyResolver, boolean multipleDeclarationAllowed, AttributeModel.Builder ... attributeModelBuilders) {
            this(mergeType, nodeKeyResolver, multipleDeclarationAllowed, EnumSet.allOf(XmlDocument.Type.class), attributeModelBuilders);
        }

        private NodeTypes(MergeType mergeType, NodeKeyResolver nodeKeyResolver, EnumSet<XmlDocument.Type> mergeableLowerPriorityTypes, AttributeModel.Builder ... attributeModelBuilders) {
            this(mergeType, nodeKeyResolver, false, mergeableLowerPriorityTypes, attributeModelBuilders);
        }

        private NodeTypes(MergeType mergeType, NodeKeyResolver nodeKeyResolver, boolean mutipleDeclarationAllowed, EnumSet<XmlDocument.Type> mergeableLowerPriorityTypes, AttributeModel.Builder ... attributeModelBuilders) {
            this.mMergeType = (MergeType)((Object)Preconditions.checkNotNull((Object)((Object)mergeType)));
            this.mNodeKeyResolver = (NodeKeyResolver)Preconditions.checkNotNull((Object)nodeKeyResolver);
            ImmutableList.Builder attributeModels = new ImmutableList.Builder();
            if (attributeModelBuilders != null) {
                for (AttributeModel.Builder attributeModelBuilder : attributeModelBuilders) {
                    attributeModels.add((Object)attributeModelBuilder.build());
                }
            }
            this.mAttributeModels = attributeModels.build();
            this.mMultipleDeclarationAllowed = mutipleDeclarationAllowed;
            this.mMergeableLowerPriorityTypes = mergeableLowerPriorityTypes;
        }

        NodeKeyResolver getNodeKeyResolver() {
            return this.mNodeKeyResolver;
        }

        ImmutableList<AttributeModel> getAttributeModels() {
            return this.mAttributeModels.asList();
        }

        AttributeModel getAttributeModel(XmlNode.NodeName attributeName) {
            for (AttributeModel attributeModel : this.mAttributeModels) {
                if (!attributeModel.getName().equals(attributeName)) continue;
                return attributeModel;
            }
            return null;
        }

        MergeType getMergeType() {
            return this.mMergeType;
        }

        boolean areMultipleDeclarationAllowed() {
            return this.mMultipleDeclarationAllowed;
        }

        boolean canMergeWithLowerPriority(XmlElement xmlElement) {
            return this.mMergeableLowerPriorityTypes.contains((Object)xmlElement.getDocument().getFileType());
        }
    }

    private static class AttributeBasedNodeKeyResolver
    implements NodeKeyResolver {
        private final String mNamespaceUri;
        private final String mAttributeName;

        private AttributeBasedNodeKeyResolver(String namespaceUri, String attributeName) {
            this.mNamespaceUri = namespaceUri;
            this.mAttributeName = (String)Preconditions.checkNotNull((Object)attributeName);
        }

        @Override
        public String getKey(Element element) {
            String pkg;
            Element root;
            Document document;
            Object key;
            Object object = key = this.mNamespaceUri == null ? element.getAttribute(this.mAttributeName) : element.getAttributeNS(this.mNamespaceUri, this.mAttributeName);
            if (Strings.isNullOrEmpty((String)key)) {
                return null;
            }
            if (((String)key).startsWith(".") && "name".equals(this.mAttributeName) && "http://schemas.android.com/apk/res/android".equals(this.mNamespaceUri) && (document = element.getOwnerDocument()) != null && (root = document.getDocumentElement()) != null && !(pkg = root.getAttribute("package")).isEmpty()) {
                key = pkg + (String)key;
            }
            return key;
        }

        @Override
        public ImmutableList<String> getKeyAttributesNames() {
            return ImmutableList.of((Object)this.mAttributeName);
        }
    }

    private static class NoKeyNodeResolver
    implements NodeKeyResolver {
        private NoKeyNodeResolver() {
        }

        @Override
        public String getKey(Element element) {
            return null;
        }

        @Override
        public ImmutableList<String> getKeyAttributesNames() {
            return ImmutableList.of();
        }
    }

    private static final class TwoAttributesBasedKeyResolver
    implements NodeKeyResolver {
        private final NodeKeyResolver firstAttributeKeyResolver;
        private final NodeKeyResolver secondAttributeKeyResolver;

        private TwoAttributesBasedKeyResolver(NodeKeyResolver firstAttributeKeyResolver, NodeKeyResolver secondAttributeKeyResolver) {
            this.firstAttributeKeyResolver = firstAttributeKeyResolver;
            this.secondAttributeKeyResolver = secondAttributeKeyResolver;
        }

        @Override
        public String getKey(Element element) {
            String firstKey = this.firstAttributeKeyResolver.getKey(element);
            String secondKey = this.secondAttributeKeyResolver.getKey(element);
            return Strings.isNullOrEmpty((String)firstKey) ? secondKey : (Strings.isNullOrEmpty((String)secondKey) ? firstKey : firstKey + "+" + secondKey);
        }

        @Override
        public ImmutableList<String> getKeyAttributesNames() {
            return ImmutableList.of((Object)((String)this.firstAttributeKeyResolver.getKeyAttributesNames().get(0)), (Object)((String)this.secondAttributeKeyResolver.getKeyAttributesNames().get(0)));
        }
    }
}

