/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.concurrency;

import com.android.utils.JvmWideVariable;
import com.android.utils.concurrency.ReadWriteThreadLock;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class ReadWriteProcessLock {
    private static final ConcurrentMap<Path, FileChannel> fileChannelMap = new JvmWideVariable<ConcurrentMap>(ReadWriteProcessLock.class, "fileChannelMap", new TypeToken<ConcurrentMap<Path, FileChannel>>(){}, ConcurrentHashMap::new).get();
    private static final ConcurrentMap<Path, FileLock> fileLockMap = new JvmWideVariable<ConcurrentMap>(ReadWriteProcessLock.class, "fileLockMap", new TypeToken<ConcurrentMap<Path, FileLock>>(){}, ConcurrentHashMap::new).get();
    private static final ConcurrentMap<Path, AtomicInteger> numOfReadingActionsMap = new JvmWideVariable<ConcurrentMap>(ReadWriteProcessLock.class, "numOfReadingActionsMap", new TypeToken<ConcurrentMap<Path, AtomicInteger>>(){}, ConcurrentHashMap::new).get();
    private final Lock readLock = new ReadLock();
    private final Lock writeLock = new WriteLock();
    private final Path lockFile;
    private final ReadWriteThreadLock readWriteThreadLock;
    private final AtomicInteger numOfReadingActions;

    public ReadWriteProcessLock(Path lockFile) {
        try {
            lockFile = ReadWriteProcessLock.createAndNormalizeLockFile(lockFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.lockFile = lockFile;
        this.readWriteThreadLock = new ReadWriteThreadLock(lockFile);
        this.numOfReadingActions = numOfReadingActionsMap.computeIfAbsent(lockFile, any -> new AtomicInteger(0));
    }

    static Path createAndNormalizeLockFile(Path lockFilePath) throws IOException {
        if (!Files.exists(lockFilePath, new LinkOption[0])) {
            lockFilePath = lockFilePath.normalize();
            Preconditions.checkArgument((boolean)Files.exists((Path)Verify.verifyNotNull((Object)lockFilePath.getParent()), new LinkOption[0]), (Object)("Parent directory of " + lockFilePath.toAbsolutePath() + " does not exist"));
            try {
                Files.createFile(lockFilePath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        Preconditions.checkArgument((!Files.isDirectory(lockFilePath = lockFilePath.toRealPath(new LinkOption[0]), new LinkOption[0]) ? 1 : 0) != 0, (Object)(lockFilePath.toAbsolutePath() + " is a directory."));
        long lockFileSize = Files.size(lockFilePath);
        Preconditions.checkArgument((lockFileSize == 0L ? 1 : 0) != 0, (Object)String.format("File '%1$s' with size=%2$d cannot be used as a lock file.", lockFilePath.toAbsolutePath(), lockFileSize));
        return lockFilePath;
    }

    public Lock readLock() {
        return this.readLock;
    }

    public Lock writeLock() {
        return this.writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireReadLock() throws IOException {
        this.readWriteThreadLock.readLock().lock();
        try {
            AtomicInteger atomicInteger = this.numOfReadingActions;
            synchronized (atomicInteger) {
                if (this.numOfReadingActions.get() == 0) {
                    this.acquireFileLock(true);
                }
                this.numOfReadingActions.getAndIncrement();
            }
        }
        catch (Throwable throwable) {
            this.readWriteThreadLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReadLock() throws IOException {
        try {
            AtomicInteger atomicInteger = this.numOfReadingActions;
            synchronized (atomicInteger) {
                if (this.numOfReadingActions.decrementAndGet() == 0) {
                    this.releaseFileLock();
                }
            }
        }
        finally {
            this.readWriteThreadLock.readLock().unlock();
        }
    }

    private void acquireWriteLock() throws IOException {
        this.readWriteThreadLock.writeLock().lock();
        try {
            this.acquireFileLock(false);
        }
        catch (Throwable throwable) {
            this.readWriteThreadLock.writeLock().unlock();
            throw throwable;
        }
    }

    private void releaseWriteLock() throws IOException {
        try {
            this.releaseFileLock();
        }
        finally {
            this.readWriteThreadLock.writeLock().unlock();
        }
    }

    private void acquireFileLock(boolean shared) throws IOException {
        FileLock fileLock;
        Preconditions.checkState((!fileChannelMap.containsKey(this.lockFile) && !fileLockMap.containsKey(this.lockFile) ? 1 : 0) != 0, (Object)"acquireFileLock() must not be called twice (ReadWriteProcessLock is not reentrant)");
        FileChannel fileChannel = FileChannel.open(this.lockFile, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        try {
            fileLock = fileChannel.lock(0L, Long.MAX_VALUE, shared);
        }
        catch (OverlappingFileLockException e) {
            throw new RuntimeException("Unable to acquire a file lock for " + this.lockFile.toAbsolutePath(), e);
        }
        fileChannelMap.put(this.lockFile, fileChannel);
        fileLockMap.put(this.lockFile, fileLock);
    }

    private void releaseFileLock() throws IOException {
        FileChannel fileChannel = (FileChannel)fileChannelMap.get(this.lockFile);
        FileLock fileLock = (FileLock)fileLockMap.get(this.lockFile);
        Preconditions.checkNotNull((Object)fileChannel);
        Preconditions.checkNotNull((Object)fileLock);
        fileLock.release();
        fileChannel.close();
        fileChannelMap.remove(this.lockFile);
        fileLockMap.remove(this.lockFile);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("lockFile", (Object)this.lockFile).toString();
    }

    private final class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() throws IOException {
            ReadWriteProcessLock.this.acquireWriteLock();
        }

        @Override
        public void unlock() throws IOException {
            ReadWriteProcessLock.this.releaseWriteLock();
        }
    }

    private final class ReadLock
    implements Lock {
        private ReadLock() {
        }

        @Override
        public void lock() throws IOException {
            ReadWriteProcessLock.this.acquireReadLock();
        }

        @Override
        public void unlock() throws IOException {
            ReadWriteProcessLock.this.releaseReadLock();
        }
    }

    public static interface Lock {
        public void lock() throws IOException;

        public void unlock() throws IOException;
    }
}

