/*
 * Decompiled with CFR 0.152.
 */
package com.android.support;

import com.android.support.AndroidxMigrationParserKt;
import com.android.support.AndroidxName;
import com.android.support.MigrationParserVisitor;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AndroidxNameUtils {
    private static final Logger LOG = Logger.getLogger(AndroidxName.class.getName());
    static final String ANDROID_SUPPORT_PKG = "android.support.";
    static final ImmutableMap<String, String> ANDROIDX_PKG_MAPPING;
    static final ImmutableMap<String, String> ANDROIDX_FULL_CLASS_MAPPING;
    private static final ImmutableBiMap<String, String> ANDROIDX_COORDINATES_MAPPING;
    static final ImmutableList<String> ANDROIDX_OLD_PKGS;

    static String getPackageMapping(String oldPkgName, boolean strictChecking) {
        int n = ANDROIDX_OLD_PKGS.size();
        for (int i = 0; i < n; ++i) {
            String prefix = (String)ANDROIDX_OLD_PKGS.get(i);
            if (!oldPkgName.startsWith(prefix)) continue;
            return (String)ANDROIDX_PKG_MAPPING.get((Object)prefix) + oldPkgName.substring(prefix.length());
        }
        if (strictChecking && LOG.isLoggable(Level.FINE)) {
            LOG.fine("support library package not found: " + oldPkgName);
        }
        return oldPkgName;
    }

    public static Collection<String> getAllAndroidxCoordinates() {
        return ANDROIDX_COORDINATES_MAPPING.values();
    }

    public static String getCoordinateMapping(String coordinate) {
        return (String)ANDROIDX_COORDINATES_MAPPING.getOrDefault((Object)coordinate, (Object)coordinate);
    }

    public static String getCoordinateReverseMapping(String coordinate) {
        return (String)ANDROIDX_COORDINATES_MAPPING.inverse().getOrDefault((Object)coordinate, (Object)coordinate);
    }

    public static String getNewName(String oldName) {
        String newName = (String)ANDROIDX_FULL_CLASS_MAPPING.get((Object)oldName);
        if (newName != null) {
            return newName;
        }
        int lastDot = oldName.lastIndexOf(46);
        return AndroidxNameUtils.getPackageMapping(oldName.substring(0, lastDot + 1), false) + oldName.substring(lastDot + 1);
    }

    static {
        final ImmutableMap.Builder classTransformMap = ImmutableMap.builder();
        final ImmutableMap.Builder packageTransformMap = ImmutableMap.builder();
        final ImmutableBiMap.Builder coordinatesTransformMap = ImmutableBiMap.builder();
        try {
            AndroidxMigrationParserKt.parseMigrationFile(new MigrationParserVisitor(){

                @Override
                public void visitGradleCoordinate(String oldGroupName, String oldArtifactName, String newGroupName, String newArtifactName, String newBaseVersion) {
                    coordinatesTransformMap.put((Object)(oldGroupName + ":" + oldArtifactName), (Object)(newGroupName + ":" + newArtifactName));
                }

                @Override
                public void visitClass(String old, String newName) {
                    classTransformMap.put((Object)old, (Object)newName);
                }

                @Override
                public void visitPackage(String old, String newName) {
                    packageTransformMap.put((Object)old, (Object)newName);
                }
            });
        }
        catch (Throwable e) {
            LOG.severe("Error loading androidx migration mapping: " + e.getLocalizedMessage());
        }
        ANDROIDX_FULL_CLASS_MAPPING = classTransformMap.build();
        ANDROIDX_PKG_MAPPING = packageTransformMap.build();
        ANDROIDX_OLD_PKGS = Ordering.from((left, right) -> Ints.compare((int)right.length(), (int)left.length())).immutableSortedCopy((Iterable)ANDROIDX_PKG_MAPPING.keySet());
        ANDROIDX_COORDINATES_MAPPING = coordinatesTransformMap.build();
    }
}

