/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class SdkUtils {
    public static final String FILENAME_PREFIX = "From: ";
    public static final List<String> IMAGE_EXTENSIONS = ImmutableList.of((Object)".png", (Object)".9.png", (Object)".gif", (Object)".jpeg", (Object)".jpg", (Object)".bmp", (Object)".webp", (Object)".avif");

    public static boolean endsWithIgnoreCase(String string, String suffix) {
        return string.regionMatches(true, string.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean endsWith(CharSequence sequence, CharSequence suffix) {
        return SdkUtils.endsWith(sequence, sequence.length(), suffix);
    }

    public static boolean endsWith(CharSequence sequence, int endOffset, CharSequence suffix) {
        if (endOffset < suffix.length()) {
            return false;
        }
        int i = endOffset - 1;
        for (int j = suffix.length() - 1; j >= 0; --j) {
            if (sequence.charAt(i) != suffix.charAt(j)) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static String wrap(String text, int lineWidth, String hangingIndent) {
        return SdkUtils.wrap(text, lineWidth, lineWidth, hangingIndent);
    }

    public static String wrap(String text, int firstLineWidth, int nextLineWidth, String hangingIndent) {
        return SdkUtils.wrap(text, firstLineWidth, nextLineWidth, hangingIndent, true);
    }

    public static String wrap(String text, int firstLineWidth, int nextLineWidth, String hangingIndent, boolean forceBreak) {
        if (hangingIndent == null) {
            hangingIndent = "";
        }
        int lineWidth = firstLineWidth;
        int explanationLength = text.length();
        StringBuilder sb = new StringBuilder(explanationLength * 2);
        int index = 0;
        while (index < explanationLength) {
            int next;
            int lineEnd = text.indexOf(10, index);
            if (lineEnd != -1 && lineEnd - index < lineWidth) {
                next = lineEnd + 1;
            } else {
                lineEnd = Math.min(index + lineWidth, explanationLength);
                if (lineEnd - index < lineWidth) {
                    next = explanationLength;
                } else {
                    int lastSpace = text.lastIndexOf(32, lineEnd);
                    if (lastSpace > index) {
                        lineEnd = lastSpace;
                        next = lastSpace + 1;
                    } else if (!forceBreak) {
                        char c;
                        for (next = lineEnd; next < explanationLength && !Character.isWhitespace(c = text.charAt(next)); ++next) {
                            ++lineEnd;
                        }
                    }
                }
            }
            if (sb.length() > 0) {
                sb.append(hangingIndent);
            } else {
                lineWidth = nextLineWidth - hangingIndent.length();
            }
            sb.append(text, index, lineEnd);
            sb.append('\n');
            index = next;
        }
        return sb.toString();
    }

    public static File urlToFile(String url) throws MalformedURLException {
        return SdkUtils.urlToFile(new URL(url));
    }

    public static File urlToFile(URL url) throws MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (IllegalArgumentException e) {
            MalformedURLException ex = new MalformedURLException(e.getLocalizedMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    public static String fileToUrlString(File file2) throws MalformedURLException {
        String url = SdkUtils.fileToUrl(file2).toExternalForm();
        if (!url.startsWith("file:///")) {
            url = url.replaceFirst("file:/", "file:///");
        }
        return url;
    }

    public static URL fileToUrl(File file2) throws MalformedURLException {
        return file2.toURI().toURL();
    }

    public static String createPathComment(File file2, boolean includePadding) throws MalformedURLException {
        String url = SdkUtils.fileToUrlString(file2);
        int dashes = url.indexOf("--");
        if (dashes != -1) {
            url = url.replace("--", "%2D%2D");
        }
        if (includePadding) {
            return " From: " + url + " ";
        }
        return FILENAME_PREFIX + url;
    }

    public static String xmlNameToConstantName(String xmlName) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, xmlName);
    }

    public static String camelCaseToConstantName(String camelCaseName) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, camelCaseName);
    }

    public static String constantNameToCamelCase(String constantName) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, constantName);
    }

    public static String constantNameToXmlName(String constantName) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, constantName);
    }

    public static String fileNameToResourceName(String fileName) {
        int lastExtension = fileName.lastIndexOf(46);
        if (lastExtension <= 0) {
            return fileName;
        }
        if (fileName.endsWith(".9.png")) {
            if (fileName.length() > ".9.png".length()) {
                return fileName.substring(0, fileName.length() - ".9.png".length());
            }
            return fileName;
        }
        return fileName.substring(0, lastExtension);
    }

    public static String getLayoutName(File layoutFile) {
        String name = layoutFile.getName();
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }

    public static boolean hasImageExtension(String path) {
        for (String ext : IMAGE_EXTENSIONS) {
            if (!SdkUtils.endsWithIgnoreCase(path, ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBitmapFile(File file2) {
        return SdkUtils.hasImageExtension(file2.getPath());
    }

    public static String escapePropertyValue(String value) {
        Properties properties = new Properties();
        properties.setProperty("k", value);
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, null);
            String s = writer.toString();
            int end = s.length();
            String lineSeparator = System.lineSeparator();
            if (s.endsWith(lineSeparator)) {
                end -= lineSeparator.length();
            }
            int start = s.indexOf(61);
            assert (start != -1) : s;
            return s.substring(start + 1, end);
        }
        catch (IOException e) {
            return value;
        }
    }

    public static String globToRegexp(String glob) {
        StringBuilder sb = new StringBuilder(glob.length() * 2);
        int begin = 0;
        sb.append('^');
        int n = glob.length();
        for (int i = 0; i < n; ++i) {
            char c = glob.charAt(i);
            if (c == '*') {
                begin = SdkUtils.appendQuoted(sb, glob, begin, i) + 1;
                if (i < n - 1 && glob.charAt(i + 1) == '*') {
                    ++i;
                    ++begin;
                }
                sb.append(".*?");
                continue;
            }
            if (c != '?') continue;
            begin = SdkUtils.appendQuoted(sb, glob, begin, i) + 1;
            sb.append(".?");
        }
        SdkUtils.appendQuoted(sb, glob, begin, glob.length());
        sb.append('$');
        return sb.toString();
    }

    private static int appendQuoted(StringBuilder sb, String s, int from, int to) {
        if (to > from) {
            int i;
            boolean isSimple = true;
            for (i = from; i < to; ++i) {
                char c = s.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '/' || c == ' ') continue;
                isSimple = false;
                break;
            }
            if (isSimple) {
                for (i = from; i < to; ++i) {
                    sb.append(s.charAt(i));
                }
                return to;
            }
            sb.append(Pattern.quote(s.substring(from, to)));
        }
        return to;
    }

    public static boolean isServiceKey(String name) {
        switch (name) {
            case "gcm_defaultSenderId": 
            case "google_app_id": 
            case "google_api_key": 
            case "google_storage_bucket": 
            case "ga_trackingID": 
            case "default_web_client_id": 
            case "firebase_database_url": 
            case "google_crash_reporting_api_key": {
                return true;
            }
        }
        return false;
    }
}

