/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.cxx;

import com.android.utils.cxx.Sections;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u001cH\u0002J\u0018\u0010)\u001a\n \u000f*\u0004\u0018\u00010\u00150\u00152\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\n \u000f*\u0004\u0018\u00010\u00150\u00152\u0006\u0010-\u001a\u00020\u0006H\u0002J\u0010\u0010.\u001a\n \u000f*\u0004\u0018\u00010\u00150\u0015H\u0002J\u0010\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u0006H\u0002J\b\u00101\u001a\u00020&H\u0002J\u0012\u00102\u001a\u00020\u00062\b\u0010(\u001a\u0004\u0018\u00010\u001cH\u0002J\u0016\u00102\u001a\u00020\u00062\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0002J\u0010\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u000206H\u0002J<\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u00042\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u001cJ\b\u0010>\u001a\u00020&H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u000f*\u0004\u0018\u00010\u00150\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00060\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001d\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001e\u0012\u0004\u0012\u00020\u00060\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/android/utils/cxx/CompileCommandsEncoder;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "file", "Ljava/io/File;", "initialBufferSize", "", "<init>", "(Ljava/io/File;I)V", "getFile", "()Ljava/io/File;", "ras", "Ljava/io/RandomAccessFile;", "channel", "Ljava/nio/channels/FileChannel;", "kotlin.jvm.PlatformType", "lock", "Ljava/nio/channels/FileLock;", "bufferStartPosition", "", "map", "Ljava/nio/ByteBuffer;", "stringTableIndexEntry", "stringListsIndexEntry", "compileCommandsIndexEntry", "countOfSourceMessagesOffset", "stringTable", "", "", "stringListTable", "", "countOfSourceMessages", "lastCompilerWritten", "lastFlagsWritten", "lastTargetWritten", "lastWorkingDirectoryWritten", "countOfSourceFiles", "encodeMagic", "", "encodeUTF8", "string", "encodeByte", "byte", "", "encodeInt", "int", "encodeLongZero", "ensureAtLeast", "bytes", "flushBuffer", "intern", "strings", "writeSectionIndexEntry", "section", "Lcom/android/utils/cxx/Sections;", "writeCompileCommand", "sourceFile", "compiler", "flags", "workingDirectory", "outputFile", "target", "close", "common"})
@SourceDebugExtension(value={"SMAP\nCompileCommandsCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompileCommandsCodec.kt\ncom/android/utils/cxx/CompileCommandsEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,770:1\n1563#2:771\n1634#2,3:772\n1056#2:775\n1869#2,2:776\n1056#2:778\n1869#2:779\n1869#2,2:780\n1870#2:782\n*S KotlinDebug\n*F\n+ 1 CompileCommandsCodec.kt\ncom/android/utils/cxx/CompileCommandsEncoder\n*L\n267#1:771\n267#1:772,3\n309#1:775\n310#1:776,2\n316#1:778\n317#1:779\n319#1:780,2\n317#1:782\n*E\n"})
public final class CompileCommandsEncoder
implements AutoCloseable {
    @NotNull
    private final File file;
    @NotNull
    private final RandomAccessFile ras;
    private final FileChannel channel;
    private final FileLock lock;
    private long bufferStartPosition;
    private ByteBuffer map;
    private final long stringTableIndexEntry;
    private final long stringListsIndexEntry;
    private final long compileCommandsIndexEntry;
    private final long countOfSourceMessagesOffset;
    @NotNull
    private final Map<String, Integer> stringTable;
    @NotNull
    private final Map<List<Integer>, Integer> stringListTable;
    private int countOfSourceMessages;
    private int lastCompilerWritten;
    private int lastFlagsWritten;
    private int lastTargetWritten;
    private int lastWorkingDirectoryWritten;
    private int countOfSourceFiles;

    public CompileCommandsEncoder(@NotNull File file2, int initialBufferSize) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.file = file2;
        this.ras = new RandomAccessFile(this.file, "rw");
        this.channel = this.ras.getChannel();
        this.lock = this.channel.lock();
        this.map = ByteBuffer.allocate(initialBufferSize);
        this.stringTable = new LinkedHashMap();
        this.stringListTable = new LinkedHashMap();
        this.lastCompilerWritten = -1;
        this.lastFlagsWritten = -1;
        this.lastTargetWritten = -1;
        this.lastWorkingDirectoryWritten = -1;
        this.encodeMagic();
        this.encodeInt(3);
        this.encodeInt(3);
        this.compileCommandsIndexEntry = this.writeSectionIndexEntry(Sections.CompileCommands);
        this.stringTableIndexEntry = this.writeSectionIndexEntry(Sections.StringTable);
        this.stringListsIndexEntry = this.writeSectionIndexEntry(Sections.StringLists);
        this.countOfSourceMessagesOffset = this.ras.getFilePointer() + (long)this.map.position();
        this.encodeInt(0);
        this.encodeInt(0);
    }

    public /* synthetic */ CompileCommandsEncoder(File file2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 32768;
        }
        this(file2, n);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    private final void encodeMagic() {
        byte[] byArray = "C/C++ Build Metadata\u001a".getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        ByteBuffer map = this.ensureAtLeast(bytes.length);
        map.put(bytes);
    }

    private final void encodeUTF8(String string) {
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        ByteBuffer map = this.ensureAtLeast(4 + bytes.length);
        map.putInt(bytes.length);
        map.put(bytes);
    }

    private final ByteBuffer encodeByte(byte by) {
        return this.ensureAtLeast(1).put(by);
    }

    private final ByteBuffer encodeInt(int n) {
        return this.ensureAtLeast(4).putInt(n);
    }

    private final ByteBuffer encodeLongZero() {
        return this.ensureAtLeast(8).putLong(0L);
    }

    private final ByteBuffer ensureAtLeast(int bytes) {
        if (this.map.capacity() < this.map.position() + bytes) {
            this.flushBuffer();
            if (this.map.capacity() < bytes) {
                this.map = ByteBuffer.allocate(bytes);
            }
        }
        ByteBuffer byteBuffer = this.map;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"map");
        return byteBuffer;
    }

    private final void flushBuffer() {
        if (this.map.position() == 0) {
            return;
        }
        this.ras.seek(this.bufferStartPosition);
        this.ras.write(this.map.array(), 0, this.map.position());
        this.bufferStartPosition += (long)this.map.position();
        ByteBuffer byteBuffer = this.map;
        Intrinsics.checkNotNull((Object)byteBuffer, (String)"null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)byteBuffer).clear();
    }

    private final int intern(String string) {
        Integer n = string == null ? Integer.valueOf(0) : this.stringTable.computeIfAbsent(string, new Function(this){
            final /* synthetic */ CompileCommandsEncoder this$0;
            {
                this.this$0 = $receiver;
            }

            public final Integer apply(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CompileCommandsEncoder.access$getStringTable$p(this.this$0).size() + 1;
            }
        });
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    private final int intern(List<Integer> strings) {
        Integer n = this.stringListTable.computeIfAbsent(strings, new Function(this){
            final /* synthetic */ CompileCommandsEncoder this$0;
            {
                this.this$0 = $receiver;
            }

            public final Integer apply(List<Integer> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return CompileCommandsEncoder.access$getStringListTable$p(this.this$0).size();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"computeIfAbsent(...)");
        return ((Number)n).intValue();
    }

    private final long writeSectionIndexEntry(Sections section) {
        long result = this.ras.getFilePointer() + (long)this.map.position();
        this.encodeInt(section.ordinal());
        this.encodeLongZero();
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeCompileCommand(@NotNull File sourceFile, @NotNull File compiler, @NotNull List<String> flags, @NotNull File workingDirectory, @NotNull File outputFile, @NotNull String target) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter(flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int compilerIndex = this.intern(compiler.getPath());
        Iterable iterable = flags;
        CompileCommandsEncoder compileCommandsEncoder = this;
        boolean $i$f$map = false;
        void var11_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.intern((String)it));
        }
        int flagsIndex = compileCommandsEncoder.intern((List)destination$iv$iv);
        int workingDirectoryIndex = this.intern(workingDirectory.getPath());
        int targetIndex = this.intern(target);
        if (compilerIndex != this.lastCompilerWritten || flagsIndex != this.lastFlagsWritten || workingDirectoryIndex != this.lastWorkingDirectoryWritten || targetIndex != this.lastTargetWritten) {
            this.encodeByte((byte)0);
            this.encodeInt(compilerIndex);
            this.encodeInt(flagsIndex);
            this.encodeInt(workingDirectoryIndex);
            this.encodeInt(targetIndex);
            this.lastCompilerWritten = compilerIndex;
            this.lastFlagsWritten = flagsIndex;
            this.lastWorkingDirectoryWritten = workingDirectoryIndex;
            this.lastTargetWritten = targetIndex;
            ++this.countOfSourceMessages;
        }
        this.encodeByte((byte)1);
        this.encodeInt(this.intern(sourceFile.getPath()));
        this.encodeInt(this.intern(outputFile.getPath()));
        ++this.countOfSourceMessages;
        ++this.countOfSourceFiles;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void $this$forEach$iv;
        Iterable $this$sortedBy$iv;
        long offsetOfStringTable = this.bufferStartPosition + (long)this.map.position();
        this.encodeInt(this.stringTable.size());
        Iterable $this$sortedBy$iv2 = MapsKt.toList(this.stringTable);
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                boolean bl = false;
                int index = ((Number)pair.component2()).intValue();
                pair = (Pair)b;
                Comparable comparable = Integer.valueOf(index);
                bl = false;
                index = ((Number)pair.component2()).intValue();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(index));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String string = (String)pair.component1();
            this.encodeUTF8(string);
        }
        long offsetOfStringListsTable = this.bufferStartPosition + (long)this.map.position();
        this.encodeInt(this.stringListTable.size());
        Iterable iterable = MapsKt.toList(this.stringListTable);
        boolean $i$f$sortedBy2 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                boolean bl = false;
                int index = ((Number)pair.component2()).intValue();
                pair = (Pair)b;
                Comparable comparable = Integer.valueOf(index);
                bl = false;
                index = ((Number)pair.component2()).intValue();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(index));
            }
        });
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            List strings = (List)pair.component1();
            this.encodeInt(strings.size());
            Iterable $this$forEach$iv3 = strings;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                int id = ((Number)element$iv2).intValue();
                boolean bl2 = false;
                this.encodeInt(id);
            }
        }
        this.flushBuffer();
        this.map = null;
        this.ras.seek(this.countOfSourceMessagesOffset);
        this.ras.writeInt(this.countOfSourceMessages);
        this.ras.writeInt(this.countOfSourceFiles);
        this.ras.seek(this.compileCommandsIndexEntry + (long)4);
        this.ras.writeLong(this.countOfSourceMessagesOffset);
        this.ras.seek(this.stringTableIndexEntry + (long)4);
        this.ras.writeLong(offsetOfStringTable);
        this.ras.seek(this.stringListsIndexEntry + (long)4);
        this.ras.writeLong(offsetOfStringListsTable);
        this.ras.getFD().sync();
        this.lock.close();
        this.channel.close();
        this.ras.close();
    }

    public static final /* synthetic */ Map access$getStringTable$p(CompileCommandsEncoder $this) {
        return $this.stringTable;
    }

    public static final /* synthetic */ Map access$getStringListTable$p(CompileCommandsEncoder $this) {
        return $this.stringListTable;
    }
}

