/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.IShellOutputReceiver;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class CollectingOutputReceiver
implements IShellOutputReceiver {
    private final CountDownLatch mCompletionLatch;
    private final StringBuffer mOutputBuffer = new StringBuffer();
    private final AtomicBoolean mIsCanceled = new AtomicBoolean(false);

    public CollectingOutputReceiver() {
        this.mCompletionLatch = new CountDownLatch(1);
    }

    public CollectingOutputReceiver(CountDownLatch commandCompleteLatch) {
        this.mCompletionLatch = commandCompleteLatch;
    }

    public String getOutput() {
        return this.mOutputBuffer.toString();
    }

    @Override
    public boolean isCancelled() {
        return this.mIsCanceled.get();
    }

    public void cancel() {
        this.mIsCanceled.set(true);
    }

    @Override
    public void addOutput(byte[] data, int offset, int length) {
        if (!this.isCancelled()) {
            String s = new String(data, offset, length, StandardCharsets.UTF_8);
            this.mOutputBuffer.append(s);
        }
    }

    @Override
    public void flush() {
        this.mCompletionLatch.countDown();
    }

    public boolean isComplete() {
        return this.mCompletionLatch.getCount() == 0L;
    }

    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return this.mCompletionLatch.await(timeout, unit);
    }
}

