/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.clientmanager;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.clientmanager.DeviceClientManager;
import com.android.ddmlib.clientmanager.DeviceClientManagerListener;
import org.jetbrains.annotations.NotNull;

public class DeviceClientManagerUtils {
    public static DeviceClientManager createDeviceClientManager(AndroidDebugBridge bridge, IDevice device) {
        if (bridge.getClientManager() == null) {
            throw new IllegalStateException("AndroidDebugBridge does not have a ClientManager configured");
        }
        DeviceClientManagerListener listener = new DeviceClientManagerListener(){

            @Override
            public void processListUpdated(@NotNull AndroidDebugBridge bridge, @NotNull DeviceClientManager deviceClientManager) {
                if (bridge == AndroidDebugBridge.getBridge()) {
                    AndroidDebugBridge.deviceChanged(deviceClientManager.getDevice(), 2);
                }
            }

            @Override
            public void processNameUpdated(@NotNull AndroidDebugBridge bridge, @NotNull DeviceClientManager deviceClientManager, @NotNull Client client) {
                if (bridge == AndroidDebugBridge.getBridge()) {
                    AndroidDebugBridge.clientChanged(client, 1);
                }
            }

            @Override
            public void processDebuggerStatusUpdated(@NotNull AndroidDebugBridge bridge, @NotNull DeviceClientManager deviceClientManager, @NotNull Client client) {
                if (bridge == AndroidDebugBridge.getBridge()) {
                    AndroidDebugBridge.clientChanged(client, 2);
                }
            }
        };
        return bridge.getClientManager().createDeviceClientManager(bridge, device, listener);
    }
}

