/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatHeaderParser;
import com.android.ddmlib.logcat.LogCatMessage;
import com.google.common.annotations.VisibleForTesting;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public class LogCatMessageParser {
    LogCatHeader mPrevHeader;
    private final LogCatHeaderParser mHeaderParser;

    public LogCatMessageParser() {
        this(ZonedDateTime.now().getYear(), ZoneId.systemDefault());
    }

    @VisibleForTesting
    LogCatMessageParser(int year, ZoneId zoneId) {
        this.mHeaderParser = new LogCatHeaderParser(year, zoneId);
    }

    private LogCatHeader processLogHeader(String line, IDevice device) {
        LogCatHeader header = this.mHeaderParser.parseHeader(line, device);
        if (header == null) {
            return null;
        }
        this.mPrevHeader = header;
        return header;
    }

    public List<LogCatMessage> processLogLines(String[] lines, IDevice device) {
        ArrayList<LogCatMessage> messages = new ArrayList<LogCatMessage>(lines.length);
        for (String line : lines) {
            if (line.isEmpty() || this.processLogHeader(line, device) != null || this.mPrevHeader == null) continue;
            messages.add(new LogCatMessage(this.mPrevHeader, line));
        }
        return messages;
    }
}

