/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.Serializable;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;

abstract class ChronoLocalDateImpl<D extends ChronoLocalDate>
implements ChronoLocalDate,
Temporal,
TemporalAdjuster,
Serializable {
    private static final long serialVersionUID = 6282433883239719096L;

    static <D extends ChronoLocalDate> D ensureValid(Chronology chrono, Temporal temporal) {
        ChronoLocalDate other = (ChronoLocalDate)temporal;
        if (!chrono.equals(other.getChronology())) {
            throw new ClassCastException("Chronology mismatch, expected: " + chrono.getId() + ", actual: " + other.getChronology().getId());
        }
        return (D)other;
    }

    ChronoLocalDateImpl() {
    }

    public D with(TemporalAdjuster adjuster) {
        return (D)ChronoLocalDate.super.with(adjuster);
    }

    public D with(TemporalField field, long value) {
        return (D)ChronoLocalDate.super.with(field, value);
    }

    public D plus(TemporalAmount amount) {
        return (D)ChronoLocalDate.super.plus(amount);
    }

    public D plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            ChronoUnit f = (ChronoUnit)unit;
            switch (f) {
                case DAYS: {
                    return this.plusDays(amountToAdd);
                }
                case WEEKS: {
                    return this.plusDays(Math8.multiplyExact(amountToAdd, 7L));
                }
                case MONTHS: {
                    return this.plusMonths(amountToAdd);
                }
                case YEARS: {
                    return this.plusYears(amountToAdd);
                }
                case DECADES: {
                    return this.plusYears(Math8.multiplyExact(amountToAdd, 10L));
                }
                case CENTURIES: {
                    return this.plusYears(Math8.multiplyExact(amountToAdd, 100L));
                }
                case MILLENNIA: {
                    return this.plusYears(Math8.multiplyExact(amountToAdd, 1000L));
                }
                case ERAS: {
                    return (D)this.with(ChronoField.ERA, Math8.addExact(this.getLong(ChronoField.ERA), amountToAdd));
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
        }
        return (D)ChronoLocalDate.super.plus(amountToAdd, unit);
    }

    public D minus(TemporalAmount amount) {
        return (D)ChronoLocalDate.super.minus(amount);
    }

    public D minus(long amountToSubtract, TemporalUnit unit) {
        return (D)ChronoLocalDate.super.minus(amountToSubtract, unit);
    }

    abstract D plusYears(long var1);

    abstract D plusMonths(long var1);

    D plusWeeks(long weeksToAdd) {
        return this.plusDays(Math8.multiplyExact(weeksToAdd, 7L));
    }

    abstract D plusDays(long var1);

    D minusYears(long yearsToSubtract) {
        return yearsToSubtract == Long.MIN_VALUE ? ((ChronoLocalDateImpl)this.plusYears(Long.MAX_VALUE)).plusYears(1L) : this.plusYears(-yearsToSubtract);
    }

    D minusMonths(long monthsToSubtract) {
        return monthsToSubtract == Long.MIN_VALUE ? ((ChronoLocalDateImpl)this.plusMonths(Long.MAX_VALUE)).plusMonths(1L) : this.plusMonths(-monthsToSubtract);
    }

    D minusWeeks(long weeksToSubtract) {
        return weeksToSubtract == Long.MIN_VALUE ? ((ChronoLocalDateImpl)this.plusWeeks(Long.MAX_VALUE)).plusWeeks(1L) : this.plusWeeks(-weeksToSubtract);
    }

    D minusDays(long daysToSubtract) {
        return daysToSubtract == Long.MIN_VALUE ? ((ChronoLocalDateImpl)this.plusDays(Long.MAX_VALUE)).plusDays(1L) : this.plusDays(-daysToSubtract);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        Objects.requireNonNull(endExclusive, "endExclusive");
        ChronoLocalDate end = this.getChronology().date(endExclusive);
        if (unit instanceof ChronoUnit) {
            switch ((ChronoUnit)unit) {
                case DAYS: {
                    return this.daysUntil(end);
                }
                case WEEKS: {
                    return this.daysUntil(end) / 7L;
                }
                case MONTHS: {
                    return this.monthsUntil(end);
                }
                case YEARS: {
                    return this.monthsUntil(end) / 12L;
                }
                case DECADES: {
                    return this.monthsUntil(end) / 120L;
                }
                case CENTURIES: {
                    return this.monthsUntil(end) / 1200L;
                }
                case MILLENNIA: {
                    return this.monthsUntil(end) / 12000L;
                }
                case ERAS: {
                    return end.getLong(ChronoField.ERA) - this.getLong(ChronoField.ERA);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
        }
        Objects.requireNonNull(unit, "unit");
        return unit.between(this, end);
    }

    private long daysUntil(ChronoLocalDate end) {
        return end.toEpochDay() - this.toEpochDay();
    }

    private long monthsUntil(ChronoLocalDate end) {
        ValueRange range = this.getChronology().range(ChronoField.MONTH_OF_YEAR);
        if (range.getMaximum() != 12L) {
            throw new IllegalStateException("ChronoLocalDateImpl only supports Chronologies with 12 months per year");
        }
        long packed1 = this.getLong(ChronoField.PROLEPTIC_MONTH) * 32L + (long)this.get(ChronoField.DAY_OF_MONTH);
        long packed2 = end.getLong(ChronoField.PROLEPTIC_MONTH) * 32L + (long)end.get(ChronoField.DAY_OF_MONTH);
        return (packed2 - packed1) / 32L;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChronoLocalDate) {
            return this.compareTo((ChronoLocalDate)obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long epDay = this.toEpochDay();
        return this.getChronology().hashCode() ^ (int)(epDay ^ epDay >>> 32);
    }

    @Override
    public String toString() {
        long yoe = this.getLong(ChronoField.YEAR_OF_ERA);
        long moy = this.getLong(ChronoField.MONTH_OF_YEAR);
        long dom = this.getLong(ChronoField.DAY_OF_MONTH);
        StringBuilder buf = new StringBuilder(30);
        buf.append(this.getChronology().toString()).append(" ").append(this.getEra()).append(" ").append(yoe).append(moy < 10L ? "-0" : "-").append(moy).append(dom < 10L ? "-0" : "-").append(dom);
        return buf.toString();
    }
}

