/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class WeekFields
implements Serializable {
    private static final ConcurrentMap<String, WeekFields> CACHE = new ConcurrentHashMap<String, WeekFields>(4, 0.75f, 2);
    public static final WeekFields ISO = new WeekFields(DayOfWeek.MONDAY, 4);
    public static final WeekFields SUNDAY_START = WeekFields.of(DayOfWeek.SUNDAY, 1);
    public static final TemporalUnit WEEK_BASED_YEARS = IsoFields.WEEK_BASED_YEARS;
    private static final long serialVersionUID = -1177360819670808121L;
    private final DayOfWeek firstDayOfWeek;
    private final int minimalDays;
    private final transient TemporalField dayOfWeek = ComputedDayOfField.ofDayOfWeekField(this);
    private final transient TemporalField weekOfMonth = ComputedDayOfField.ofWeekOfMonthField(this);
    private final transient TemporalField weekOfYear = ComputedDayOfField.ofWeekOfYearField(this);
    private final transient TemporalField weekOfWeekBasedYear = ComputedDayOfField.ofWeekOfWeekBasedYearField(this);
    private final transient TemporalField weekBasedYear = ComputedDayOfField.ofWeekBasedYearField(this);

    public static WeekFields of(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        locale = new Locale(locale.getLanguage(), locale.getCountry());
        Calendar cal = Calendar.getInstance(locale);
        int calDow = cal.getFirstDayOfWeek();
        DayOfWeek dow = DayOfWeek.SUNDAY.plus(calDow - 1);
        int minDays = cal.getMinimalDaysInFirstWeek();
        return WeekFields.of(dow, minDays);
    }

    public static WeekFields of(DayOfWeek firstDayOfWeek, int minimalDaysInFirstWeek) {
        String key = firstDayOfWeek.toString() + minimalDaysInFirstWeek;
        WeekFields rules = (WeekFields)CACHE.get(key);
        if (rules == null) {
            rules = new WeekFields(firstDayOfWeek, minimalDaysInFirstWeek);
            CACHE.putIfAbsent(key, rules);
            rules = (WeekFields)CACHE.get(key);
        }
        return rules;
    }

    private WeekFields(DayOfWeek firstDayOfWeek, int minimalDaysInFirstWeek) {
        Objects.requireNonNull(firstDayOfWeek, "firstDayOfWeek");
        if (minimalDaysInFirstWeek < 1 || minimalDaysInFirstWeek > 7) {
            throw new IllegalArgumentException("Minimal number of days is invalid");
        }
        this.firstDayOfWeek = firstDayOfWeek;
        this.minimalDays = minimalDaysInFirstWeek;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException, InvalidObjectException {
        s.defaultReadObject();
        if (this.firstDayOfWeek == null) {
            throw new InvalidObjectException("firstDayOfWeek is null");
        }
        if (this.minimalDays < 1 || this.minimalDays > 7) {
            throw new InvalidObjectException("Minimal number of days is invalid");
        }
    }

    private Object readResolve() throws InvalidObjectException {
        try {
            return WeekFields.of(this.firstDayOfWeek, this.minimalDays);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidObjectException("Invalid serialized WeekFields: " + iae.getMessage());
        }
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDays;
    }

    public TemporalField dayOfWeek() {
        return this.dayOfWeek;
    }

    public TemporalField weekOfMonth() {
        return this.weekOfMonth;
    }

    public TemporalField weekOfYear() {
        return this.weekOfYear;
    }

    public TemporalField weekOfWeekBasedYear() {
        return this.weekOfWeekBasedYear;
    }

    public TemporalField weekBasedYear() {
        return this.weekBasedYear;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WeekFields) {
            return this.hashCode() == object.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.firstDayOfWeek.ordinal() * 7 + this.minimalDays;
    }

    public String toString() {
        return "WeekFields[" + this.firstDayOfWeek + ',' + this.minimalDays + ']';
    }

    static class ComputedDayOfField
    implements TemporalField {
        private final String name;
        private final WeekFields weekDef;
        private final TemporalUnit baseUnit;
        private final TemporalUnit rangeUnit;
        private final ValueRange range;
        private static final ValueRange DAY_OF_WEEK_RANGE = ValueRange.of(1L, 7L);
        private static final ValueRange WEEK_OF_MONTH_RANGE = ValueRange.of(0L, 1L, 4L, 6L);
        private static final ValueRange WEEK_OF_YEAR_RANGE = ValueRange.of(0L, 1L, 52L, 54L);
        private static final ValueRange WEEK_OF_WEEK_BASED_YEAR_RANGE = ValueRange.of(1L, 52L, 53L);

        static ComputedDayOfField ofDayOfWeekField(WeekFields weekDef) {
            return new ComputedDayOfField("DayOfWeek", weekDef, ChronoUnit.DAYS, ChronoUnit.WEEKS, DAY_OF_WEEK_RANGE);
        }

        static ComputedDayOfField ofWeekOfMonthField(WeekFields weekDef) {
            return new ComputedDayOfField("WeekOfMonth", weekDef, ChronoUnit.WEEKS, ChronoUnit.MONTHS, WEEK_OF_MONTH_RANGE);
        }

        static ComputedDayOfField ofWeekOfYearField(WeekFields weekDef) {
            return new ComputedDayOfField("WeekOfYear", weekDef, ChronoUnit.WEEKS, ChronoUnit.YEARS, WEEK_OF_YEAR_RANGE);
        }

        static ComputedDayOfField ofWeekOfWeekBasedYearField(WeekFields weekDef) {
            return new ComputedDayOfField("WeekOfWeekBasedYear", weekDef, ChronoUnit.WEEKS, IsoFields.WEEK_BASED_YEARS, WEEK_OF_WEEK_BASED_YEAR_RANGE);
        }

        static ComputedDayOfField ofWeekBasedYearField(WeekFields weekDef) {
            return new ComputedDayOfField("WeekBasedYear", weekDef, IsoFields.WEEK_BASED_YEARS, ChronoUnit.FOREVER, ChronoField.YEAR.range());
        }

        private ChronoLocalDate ofWeekBasedYear(Chronology chrono, int yowby, int wowby, int dow) {
            ChronoLocalDate date = chrono.date(yowby, 1, 1);
            int ldow = this.localizedDayOfWeek(date);
            int offset = this.startOfWeekOffset(1, ldow);
            int yearLen = date.lengthOfYear();
            int newYearWeek = this.computeWeek(offset, yearLen + this.weekDef.getMinimalDaysInFirstWeek());
            wowby = Math.min(wowby, newYearWeek - 1);
            int days = -offset + (dow - 1) + (wowby - 1) * 7;
            return date.plus(days, ChronoUnit.DAYS);
        }

        private ComputedDayOfField(String name, WeekFields weekDef, TemporalUnit baseUnit, TemporalUnit rangeUnit, ValueRange range) {
            this.name = name;
            this.weekDef = weekDef;
            this.baseUnit = baseUnit;
            this.rangeUnit = rangeUnit;
            this.range = range;
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            if (this.rangeUnit == ChronoUnit.WEEKS) {
                return this.localizedDayOfWeek(temporal);
            }
            if (this.rangeUnit == ChronoUnit.MONTHS) {
                return this.localizedWeekOfMonth(temporal);
            }
            if (this.rangeUnit == ChronoUnit.YEARS) {
                return this.localizedWeekOfYear(temporal);
            }
            if (this.rangeUnit == WEEK_BASED_YEARS) {
                return this.localizedWeekOfWeekBasedYear(temporal);
            }
            if (this.rangeUnit == ChronoUnit.FOREVER) {
                return this.localizedWeekBasedYear(temporal);
            }
            throw new IllegalStateException("unreachable, rangeUnit: " + this.rangeUnit + ", this: " + this);
        }

        private int localizedDayOfWeek(TemporalAccessor temporal) {
            int sow = this.weekDef.getFirstDayOfWeek().getValue();
            int isoDow = temporal.get(ChronoField.DAY_OF_WEEK);
            return Math8.floorMod(isoDow - sow, 7) + 1;
        }

        private int localizedDayOfWeek(int isoDow) {
            int sow = this.weekDef.getFirstDayOfWeek().getValue();
            return Math8.floorMod(isoDow - sow, 7) + 1;
        }

        private long localizedWeekOfMonth(TemporalAccessor temporal) {
            int dow = this.localizedDayOfWeek(temporal);
            int dom = temporal.get(ChronoField.DAY_OF_MONTH);
            int offset = this.startOfWeekOffset(dom, dow);
            return this.computeWeek(offset, dom);
        }

        private long localizedWeekOfYear(TemporalAccessor temporal) {
            int dow = this.localizedDayOfWeek(temporal);
            int doy = temporal.get(ChronoField.DAY_OF_YEAR);
            int offset = this.startOfWeekOffset(doy, dow);
            return this.computeWeek(offset, doy);
        }

        private int localizedWeekBasedYear(TemporalAccessor temporal) {
            int dow = this.localizedDayOfWeek(temporal);
            int year = temporal.get(ChronoField.YEAR);
            int doy = temporal.get(ChronoField.DAY_OF_YEAR);
            int offset = this.startOfWeekOffset(doy, dow);
            int week = this.computeWeek(offset, doy);
            if (week == 0) {
                return year - 1;
            }
            ValueRange dayRange = temporal.range(ChronoField.DAY_OF_YEAR);
            int yearLen = (int)dayRange.getMaximum();
            int newYearWeek = this.computeWeek(offset, yearLen + this.weekDef.getMinimalDaysInFirstWeek());
            if (week >= newYearWeek) {
                return year + 1;
            }
            return year;
        }

        private int localizedWeekOfWeekBasedYear(TemporalAccessor temporal) {
            ValueRange dayRange;
            int yearLen;
            int newYearWeek;
            int dow = this.localizedDayOfWeek(temporal);
            int doy = temporal.get(ChronoField.DAY_OF_YEAR);
            int offset = this.startOfWeekOffset(doy, dow);
            int week = this.computeWeek(offset, doy);
            if (week == 0) {
                ChronoLocalDate date = Chronology.from(temporal).date(temporal);
                date = date.minus(doy, ChronoUnit.DAYS);
                return this.localizedWeekOfWeekBasedYear(date);
            }
            if (week > 50 && week >= (newYearWeek = this.computeWeek(offset, (yearLen = (int)(dayRange = temporal.range(ChronoField.DAY_OF_YEAR)).getMaximum()) + this.weekDef.getMinimalDaysInFirstWeek()))) {
                week = week - newYearWeek + 1;
            }
            return week;
        }

        private int startOfWeekOffset(int day, int dow) {
            int weekStart = Math8.floorMod(day - dow, 7);
            int offset = -weekStart;
            if (weekStart + 1 > this.weekDef.getMinimalDaysInFirstWeek()) {
                offset = 7 - weekStart;
            }
            return offset;
        }

        private int computeWeek(int offset, int day) {
            return (7 + offset + (day - 1)) / 7;
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long newValue) {
            int currentVal;
            int newVal = this.range.checkValidIntValue(newValue, this);
            if (newVal == (currentVal = temporal.get(this))) {
                return temporal;
            }
            if (this.rangeUnit == ChronoUnit.FOREVER) {
                int idow = temporal.get(this.weekDef.dayOfWeek);
                int wowby = temporal.get(this.weekDef.weekOfWeekBasedYear);
                return (R)this.ofWeekBasedYear(Chronology.from(temporal), (int)newValue, wowby, idow);
            }
            return (R)temporal.plus(newVal - currentVal, this.baseUnit);
        }

        @Override
        public ChronoLocalDate resolve(Map<TemporalField, Long> fieldValues, TemporalAccessor partialTemporal, ResolverStyle resolverStyle) {
            long value = fieldValues.get(this);
            int newValue = Math8.toIntExact(value);
            if (this.rangeUnit == ChronoUnit.WEEKS) {
                int checkedValue = this.range.checkValidIntValue(value, this);
                int startDow = this.weekDef.getFirstDayOfWeek().getValue();
                long isoDow = Math8.floorMod(startDow - 1 + (checkedValue - 1), 7) + 1;
                fieldValues.remove(this);
                fieldValues.put(ChronoField.DAY_OF_WEEK, isoDow);
                return null;
            }
            if (!fieldValues.containsKey(ChronoField.DAY_OF_WEEK)) {
                return null;
            }
            int isoDow = ChronoField.DAY_OF_WEEK.checkValidIntValue(fieldValues.get(ChronoField.DAY_OF_WEEK));
            int dow = this.localizedDayOfWeek(isoDow);
            Chronology chrono = Chronology.from(partialTemporal);
            if (fieldValues.containsKey(ChronoField.YEAR)) {
                int year = ChronoField.YEAR.checkValidIntValue(fieldValues.get(ChronoField.YEAR));
                if (this.rangeUnit == ChronoUnit.MONTHS && fieldValues.containsKey(ChronoField.MONTH_OF_YEAR)) {
                    long month = fieldValues.get(ChronoField.MONTH_OF_YEAR);
                    return this.resolveWoM(fieldValues, chrono, year, month, newValue, dow, resolverStyle);
                }
                if (this.rangeUnit == ChronoUnit.YEARS) {
                    return this.resolveWoY(fieldValues, chrono, year, newValue, dow, resolverStyle);
                }
            } else if ((this.rangeUnit == WEEK_BASED_YEARS || this.rangeUnit == ChronoUnit.FOREVER) && fieldValues.containsKey(this.weekDef.weekBasedYear) && fieldValues.containsKey(this.weekDef.weekOfWeekBasedYear)) {
                return this.resolveWBY(fieldValues, chrono, dow, resolverStyle);
            }
            return null;
        }

        private ChronoLocalDate resolveWoM(Map<TemporalField, Long> fieldValues, Chronology chrono, int year, long month, long wom, int localDow, ResolverStyle resolverStyle) {
            ChronoLocalDate date;
            if (resolverStyle == ResolverStyle.LENIENT) {
                date = chrono.date(year, 1, 1).plus(Math8.subtractExact(month, 1L), ChronoUnit.MONTHS);
                long weeks = Math8.subtractExact(wom, this.localizedWeekOfMonth(date));
                int days = localDow - this.localizedDayOfWeek(date);
                date = date.plus(Math8.addExact(Math8.multiplyExact(weeks, 7L), (long)days), ChronoUnit.DAYS);
            } else {
                int monthValid = ChronoField.MONTH_OF_YEAR.checkValidIntValue(month);
                date = chrono.date(year, monthValid, 1);
                int womInt = this.range.checkValidIntValue(wom, this);
                int weeks = (int)((long)womInt - this.localizedWeekOfMonth(date));
                int days = localDow - this.localizedDayOfWeek(date);
                date = date.plus(weeks * 7 + days, ChronoUnit.DAYS);
                if (resolverStyle == ResolverStyle.STRICT && date.getLong(ChronoField.MONTH_OF_YEAR) != month) {
                    throw new DateTimeException("Strict mode rejected resolved date as it is in a different month");
                }
            }
            fieldValues.remove(this);
            fieldValues.remove(ChronoField.YEAR);
            fieldValues.remove(ChronoField.MONTH_OF_YEAR);
            fieldValues.remove(ChronoField.DAY_OF_WEEK);
            return date;
        }

        private ChronoLocalDate resolveWoY(Map<TemporalField, Long> fieldValues, Chronology chrono, int year, long woy, int localDow, ResolverStyle resolverStyle) {
            ChronoLocalDate date = chrono.date(year, 1, 1);
            if (resolverStyle == ResolverStyle.LENIENT) {
                long weeks = Math8.subtractExact(woy, this.localizedWeekOfYear(date));
                int days = localDow - this.localizedDayOfWeek(date);
                date = date.plus(Math8.addExact(Math8.multiplyExact(weeks, 7L), (long)days), ChronoUnit.DAYS);
            } else {
                int womInt = this.range.checkValidIntValue(woy, this);
                int weeks = (int)((long)womInt - this.localizedWeekOfYear(date));
                int days = localDow - this.localizedDayOfWeek(date);
                date = date.plus(weeks * 7 + days, ChronoUnit.DAYS);
                if (resolverStyle == ResolverStyle.STRICT && date.getLong(ChronoField.YEAR) != (long)year) {
                    throw new DateTimeException("Strict mode rejected resolved date as it is in a different year");
                }
            }
            fieldValues.remove(this);
            fieldValues.remove(ChronoField.YEAR);
            fieldValues.remove(ChronoField.DAY_OF_WEEK);
            return date;
        }

        private ChronoLocalDate resolveWBY(Map<TemporalField, Long> fieldValues, Chronology chrono, int localDow, ResolverStyle resolverStyle) {
            ChronoLocalDate date;
            int yowby = this.weekDef.weekBasedYear.range().checkValidIntValue(fieldValues.get(this.weekDef.weekBasedYear), this.weekDef.weekBasedYear);
            if (resolverStyle == ResolverStyle.LENIENT) {
                date = this.ofWeekBasedYear(chrono, yowby, 1, localDow);
                long wowby = fieldValues.get(this.weekDef.weekOfWeekBasedYear);
                long weeks = Math8.subtractExact(wowby, 1L);
                date = date.plus(weeks, ChronoUnit.WEEKS);
            } else {
                int wowby = this.weekDef.weekOfWeekBasedYear.range().checkValidIntValue(fieldValues.get(this.weekDef.weekOfWeekBasedYear), this.weekDef.weekOfWeekBasedYear);
                date = this.ofWeekBasedYear(chrono, yowby, wowby, localDow);
                if (resolverStyle == ResolverStyle.STRICT && this.localizedWeekBasedYear(date) != yowby) {
                    throw new DateTimeException("Strict mode rejected resolved date as it is in a different week-based-year");
                }
            }
            fieldValues.remove(this);
            fieldValues.remove(this.weekDef.weekBasedYear);
            fieldValues.remove(this.weekDef.weekOfWeekBasedYear);
            fieldValues.remove(ChronoField.DAY_OF_WEEK);
            return date;
        }

        @Override
        public String getDisplayName(Locale locale) {
            Objects.requireNonNull(locale, "locale");
            if (this.rangeUnit == ChronoUnit.YEARS) {
                return "Week";
            }
            return this.name;
        }

        @Override
        public TemporalUnit getBaseUnit() {
            return this.baseUnit;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return this.rangeUnit;
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public ValueRange range() {
            return this.range;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            if (temporal.isSupported(ChronoField.DAY_OF_WEEK)) {
                if (this.rangeUnit == ChronoUnit.WEEKS) {
                    return true;
                }
                if (this.rangeUnit == ChronoUnit.MONTHS) {
                    return temporal.isSupported(ChronoField.DAY_OF_MONTH);
                }
                if (this.rangeUnit == ChronoUnit.YEARS) {
                    return temporal.isSupported(ChronoField.DAY_OF_YEAR);
                }
                if (this.rangeUnit == WEEK_BASED_YEARS) {
                    return temporal.isSupported(ChronoField.DAY_OF_YEAR);
                }
                if (this.rangeUnit == ChronoUnit.FOREVER) {
                    return temporal.isSupported(ChronoField.YEAR);
                }
            }
            return false;
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            if (this.rangeUnit == ChronoUnit.WEEKS) {
                return this.range;
            }
            if (this.rangeUnit == ChronoUnit.MONTHS) {
                return this.rangeByWeek(temporal, ChronoField.DAY_OF_MONTH);
            }
            if (this.rangeUnit == ChronoUnit.YEARS) {
                return this.rangeByWeek(temporal, ChronoField.DAY_OF_YEAR);
            }
            if (this.rangeUnit == WEEK_BASED_YEARS) {
                return this.rangeWeekOfWeekBasedYear(temporal);
            }
            if (this.rangeUnit == ChronoUnit.FOREVER) {
                return ChronoField.YEAR.range();
            }
            throw new IllegalStateException("unreachable, rangeUnit: " + this.rangeUnit + ", this: " + this);
        }

        private ValueRange rangeByWeek(TemporalAccessor temporal, TemporalField field) {
            int dow = this.localizedDayOfWeek(temporal);
            int offset = this.startOfWeekOffset(temporal.get(field), dow);
            ValueRange fieldRange = temporal.range(field);
            return ValueRange.of(this.computeWeek(offset, (int)fieldRange.getMinimum()), this.computeWeek(offset, (int)fieldRange.getMaximum()));
        }

        private ValueRange rangeWeekOfWeekBasedYear(TemporalAccessor temporal) {
            if (!temporal.isSupported(ChronoField.DAY_OF_YEAR)) {
                return WEEK_OF_YEAR_RANGE;
            }
            int dow = this.localizedDayOfWeek(temporal);
            int doy = temporal.get(ChronoField.DAY_OF_YEAR);
            int offset = this.startOfWeekOffset(doy, dow);
            int week = this.computeWeek(offset, doy);
            if (week == 0) {
                ChronoLocalDate date = Chronology.from(temporal).date(temporal);
                date = date.minus(doy + 7, ChronoUnit.DAYS);
                return this.rangeWeekOfWeekBasedYear(date);
            }
            ValueRange dayRange = temporal.range(ChronoField.DAY_OF_YEAR);
            int yearLen = (int)dayRange.getMaximum();
            int newYearWeek = this.computeWeek(offset, yearLen + this.weekDef.getMinimalDaysInFirstWeek());
            if (week >= newYearWeek) {
                ChronoLocalDate date = Chronology.from(temporal).date(temporal);
                date = date.plus(yearLen - doy + 1 + 7, ChronoUnit.DAYS);
                return this.rangeWeekOfWeekBasedYear(date);
            }
            return ValueRange.of(1L, newYearWeek - 1);
        }

        @Override
        public String toString() {
            return this.name + "[" + this.weekDef.toString() + "]";
        }
    }
}

