/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class DesugarString {
    private DesugarString() {
    }

    public static String join(CharSequence delimiter, CharSequence ... elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StringJoiner joiner = new StringJoiner(delimiter);
        for (CharSequence cs : elements) {
            joiner.add(cs);
        }
        return joiner.toString();
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StringJoiner joiner = new StringJoiner(delimiter);
        for (CharSequence charSequence : elements) {
            joiner.add(charSequence);
        }
        return joiner.toString();
    }

    public static String strip(String this_) {
        if (this_.isEmpty()) {
            return this_;
        }
        if (!Character.isWhitespace(this_.charAt(0)) && !Character.isWhitespace(this_.length() - 1)) {
            return this_;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (Character.isWhitespace(this_.charAt(i))) {
            ++i;
        }
        int j = this_.length() - 1;
        while (Character.isWhitespace(this_.charAt(j))) {
            --j;
        }
        return this_.substring(i, j + 1);
    }

    public static String stripLeading(String this_) {
        if (this_.isEmpty()) {
            return this_;
        }
        if (!Character.isWhitespace(this_.charAt(0))) {
            return this_;
        }
        int i = 0;
        while (Character.isWhitespace(this_.charAt(i))) {
            ++i;
        }
        return this_.substring(i);
    }

    public static String stripTrailing(String this_) {
        if (this_.isEmpty()) {
            return this_;
        }
        if (!Character.isWhitespace(this_.length() - 1)) {
            return this_;
        }
        int j = this_.length() - 1;
        while (Character.isWhitespace(this_.charAt(j))) {
            --j;
        }
        return this_.substring(0, j + 1);
    }

    public static boolean isBlank(String this_) {
        for (char c : this_.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static Stream lines(String this_) {
        return Arrays.stream(this_.split("\n"));
    }

    public static IntStream chars(String this_) {
        IntStream.Builder builder = IntStream.builder();
        for (char c : this_.toCharArray()) {
            builder.add(c);
        }
        return builder.build();
    }

    static void checkOffset(int offset, int length) {
        if (offset < 0 || offset > length) {
            throw new StringIndexOutOfBoundsException("offset " + offset + ",length " + length);
        }
    }

    static void checkBoundsBeginEnd(int begin, int end, int length) {
        if (begin < 0 || begin > end || end > length) {
            throw new StringIndexOutOfBoundsException("begin " + begin + ", end " + end + ", length " + length);
        }
    }
}

