/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Objects;

public final class DesugarOffsetTime {
    private DesugarOffsetTime() {
    }

    public static long toEpochSecond(OffsetTime receiver, LocalDate date) {
        Objects.requireNonNull(date, "date");
        long epochDay = date.toEpochDay();
        LocalTime time = receiver.toLocalTime();
        long secs = epochDay * 86400L + (long)time.toSecondOfDay();
        ZoneOffset offset = receiver.getOffset();
        return secs -= (long)offset.getTotalSeconds();
    }
}

