/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class DesugarCollections {
    private DesugarCollections() {
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> c) {
        return new UnmodifiableCollection<T>(c);
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> s) {
        return new UnmodifiableSet<T>(s);
    }

    public static <T> SortedSet<T> unmodifiableSortedSet(SortedSet<T> s) {
        return new UnmodifiableSortedSet<T>(s);
    }

    public static <T> List<T> unmodifiableList(List<? extends T> list) {
        return list instanceof RandomAccess ? new UnmodifiableRandomAccessList<T>(list) : new UnmodifiableList<T>(list);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> m) {
        return new UnmodifiableMap<K, V>(m);
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> m) {
        return new UnmodifiableSortedMap<K, V>(m);
    }

    public static <T> Collection<T> bridge_synchronizedCollection(Collection<T> c, Object mutex) {
        return DesugarCollections.synchronizedCollection(c, mutex);
    }

    public static <T> Set<T> bridge_synchronizedSet(Set<T> s, Object mutex) {
        return DesugarCollections.synchronizedSet(s, mutex);
    }

    public static <T> List<T> bridge_synchronizedList(List<T> l, Object mutex) {
        return DesugarCollections.synchronizedList(l, mutex);
    }

    public static <T> Collection<T> synchronizedCollection(Collection<T> c) {
        return new SynchronizedCollection<T>(c);
    }

    static <T> Collection<T> synchronizedCollection(Collection<T> c, Object mutex) {
        return new SynchronizedCollection<T>(c, mutex);
    }

    public static <T> Set<T> synchronizedSet(Set<T> s) {
        return new SynchronizedSet<T>(s);
    }

    static <T> Set<T> synchronizedSet(Set<T> s, Object mutex) {
        return new SynchronizedSet<T>(s, mutex);
    }

    public static <T> SortedSet<T> synchronizedSortedSet(SortedSet<T> s) {
        return new SynchronizedSortedSet<T>(s);
    }

    public static <T> List<T> synchronizedList(List<T> list) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList<T>(list) : new SynchronizedList<T>(list);
    }

    static <T> List<T> synchronizedList(List<T> list, Object mutex) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList<T>(list, mutex) : new SynchronizedList<T>(list, mutex);
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> m) {
        return new SynchronizedMap<K, V>(m);
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> m) {
        return new SynchronizedSortedMap<K, V>(m);
    }

    public static <E> Collection<E> checkedCollection(Collection<E> c, Class<E> type) {
        return new CheckedCollection<E>(c, type);
    }

    static <T> T[] zeroLengthArray(Class<T> type) {
        return (Object[])Array.newInstance(type, 0);
    }

    public static <E> Set<E> checkedSet(Set<E> s, Class<E> type) {
        return new CheckedSet<E>(s, type);
    }

    public static <E> SortedSet<E> checkedSortedSet(SortedSet<E> s, Class<E> type) {
        return new CheckedSortedSet<E>(s, type);
    }

    public static <E> List<E> checkedList(List<E> list, Class<E> type) {
        return list instanceof RandomAccess ? new CheckedRandomAccessList<E>(list, type) : new CheckedList<E>(list, type);
    }

    public static <K, V> Map<K, V> checkedMap(Map<K, V> m, Class<K> keyType, Class<V> valueType) {
        return new CheckedMap<K, V>(m, keyType, valueType);
    }

    public static <K, V> SortedMap<K, V> checkedSortedMap(SortedMap<K, V> m, Class<K> keyType, Class<V> valueType) {
        return new CheckedSortedMap<K, V>(m, keyType, valueType);
    }

    static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static class CheckedSortedMap<K, V>
    extends CheckedMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 1599671320688067438L;
        private final SortedMap<K, V> sm;

        CheckedSortedMap(SortedMap<K, V> m, Class<K> keyType, Class<V> valueType) {
            super(m, keyType, valueType);
            this.sm = m;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return DesugarCollections.checkedSortedMap(this.sm.subMap(fromKey, toKey), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return DesugarCollections.checkedSortedMap(this.sm.headMap(toKey), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return DesugarCollections.checkedSortedMap(this.sm.tailMap(fromKey), this.keyType, this.valueType);
        }
    }

    private static class CheckedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 5742860141034234728L;
        private final Map<K, V> m;
        final Class<K> keyType;
        final Class<V> valueType;
        private transient Set<Map.Entry<K, V>> entrySet;

        private void typeCheck(Object key, Object value) {
            if (key != null && !this.keyType.isInstance(key)) {
                throw new ClassCastException(this.badKeyMsg(key));
            }
            if (value != null && !this.valueType.isInstance(value)) {
                throw new ClassCastException(this.badValueMsg(value));
            }
        }

        private BiFunction<? super K, ? super V, ? extends V> typeCheck(BiFunction<? super K, ? super V, ? extends V> func) {
            Objects.requireNonNull(func);
            return (k, v) -> {
                Object newValue = func.apply((K)k, (V)v);
                this.typeCheck(k, newValue);
                return newValue;
            };
        }

        private String badKeyMsg(Object key) {
            return "Attempt to insert " + key.getClass() + " key into map with key type " + this.keyType;
        }

        private String badValueMsg(Object value) {
            return "Attempt to insert " + value.getClass() + " value into map with value type " + this.valueType;
        }

        CheckedMap(Map<K, V> m, Class<K> keyType, Class<V> valueType) {
            this.m = Objects.requireNonNull(m);
            this.keyType = Objects.requireNonNull(keyType);
            this.valueType = Objects.requireNonNull(valueType);
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        @Override
        public boolean containsValue(Object v) {
            return this.m.containsValue(v);
        }

        @Override
        public V get(Object key) {
            return this.m.get(key);
        }

        @Override
        public V remove(Object key) {
            return this.m.remove(key);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.m.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.m.values();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.m.equals(o);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public V put(K key, V value) {
            this.typeCheck(key, value);
            return this.m.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
            Object[] entries = t.entrySet().toArray();
            ArrayList checked = new ArrayList(entries.length);
            for (Object o : entries) {
                Map.Entry e = (Map.Entry)o;
                Object k = e.getKey();
                Object v = e.getValue();
                this.typeCheck(k, v);
                checked.add(new AbstractMap.SimpleImmutableEntry(k, v));
            }
            for (Map.Entry entry : checked) {
                this.m.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new CheckedEntrySet<K, V>(this.m.entrySet(), this.valueType);
            }
            return this.entrySet;
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            this.m.forEach(action);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            this.m.replaceAll(this.typeCheck(function));
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.typeCheck(key, value);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.m.remove(key, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.typeCheck(key, newValue);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.typeCheck(key, value);
            return this.m.replace(key, value);
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            Objects.requireNonNull(mappingFunction);
            return (V)this.m.computeIfAbsent(key, k -> {
                Object value = mappingFunction.apply((K)k);
                this.typeCheck(k, value);
                return value;
            });
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            return this.m.computeIfPresent((K)key, this.typeCheck(remappingFunction));
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            return this.m.compute((K)key, this.typeCheck(remappingFunction));
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            Objects.requireNonNull(remappingFunction);
            return (V)this.m.merge(key, value, (v1, v2) -> {
                Object newValue = remappingFunction.apply((V)v1, (V)v2);
                this.typeCheck(null, newValue);
                return newValue;
            });
        }

        static class CheckedEntrySet<K, V>
        implements Set<Map.Entry<K, V>> {
            private final Set<Map.Entry<K, V>> s;
            private final Class<V> valueType;

            CheckedEntrySet(Set<Map.Entry<K, V>> s, Class<V> valueType) {
                this.s = s;
                this.valueType = valueType;
            }

            @Override
            public int size() {
                return this.s.size();
            }

            @Override
            public boolean isEmpty() {
                return this.s.isEmpty();
            }

            public String toString() {
                return this.s.toString();
            }

            @Override
            public int hashCode() {
                return this.s.hashCode();
            }

            @Override
            public void clear() {
                this.s.clear();
            }

            @Override
            public boolean add(Map.Entry<K, V> e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> coll) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator<Map.Entry<K, V>> i = this.s.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return CheckedEntrySet.checkedEntry((Map.Entry)i.next(), valueType);
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                        i.forEachRemaining((? super E e) -> action.accept(CheckedEntrySet.checkedEntry(e, valueType)));
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] source = this.s.toArray();
                Object[] dest = source.getClass() == Object[].class ? source : new Object[source.length];
                for (int i = 0; i < source.length; ++i) {
                    dest[i] = CheckedEntrySet.checkedEntry((Map.Entry)source[i], this.valueType);
                }
                return dest;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                T[] arr = this.s.toArray(a.length == 0 ? a : Arrays.copyOf(a, 0));
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = CheckedEntrySet.checkedEntry((Map.Entry)arr[i], this.valueType);
                }
                if (arr.length > a.length) {
                    return arr;
                }
                System.arraycopy(arr, 0, a, 0, arr.length);
                if (a.length > arr.length) {
                    a[arr.length] = null;
                }
                return a;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                CheckedEntry<K, V, V> e = (CheckedEntry<K, V, V>)o;
                return this.s.contains(e instanceof CheckedEntry ? e : CheckedEntrySet.checkedEntry(e, this.valueType));
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object o : c) {
                    if (this.contains(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return this.s.remove(new AbstractMap.SimpleImmutableEntry((Map.Entry)o));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return this.batchRemove(c, false);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return this.batchRemove(c, true);
            }

            private boolean batchRemove(Collection<?> c, boolean complement) {
                Objects.requireNonNull(c);
                boolean modified = false;
                Iterator<Map.Entry<K, V>> it = this.iterator();
                while (it.hasNext()) {
                    if (c.contains(it.next()) == complement) continue;
                    it.remove();
                    modified = true;
                }
                return modified;
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Set)) {
                    return false;
                }
                Set that = (Set)o;
                return that.size() == this.s.size() && this.containsAll(that);
            }

            static <K, V, T> CheckedEntry<K, V, T> checkedEntry(Map.Entry<K, V> e, Class<T> valueType) {
                return new CheckedEntry<K, V, T>(e, valueType);
            }

            private static class CheckedEntry<K, V, T>
            implements Map.Entry<K, V> {
                private final Map.Entry<K, V> e;
                private final Class<T> valueType;

                CheckedEntry(Map.Entry<K, V> e, Class<T> valueType) {
                    this.e = Objects.requireNonNull(e);
                    this.valueType = Objects.requireNonNull(valueType);
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                public String toString() {
                    return this.e.toString();
                }

                @Override
                public V setValue(V value) {
                    if (value != null && !this.valueType.isInstance(value)) {
                        throw new ClassCastException(this.badValueMsg(value));
                    }
                    return this.e.setValue(value);
                }

                private String badValueMsg(Object value) {
                    return "Attempt to insert " + value.getClass() + " value into map with value type " + this.valueType;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    return this.e.equals(new AbstractMap.SimpleImmutableEntry((Map.Entry)o));
                }
            }
        }
    }

    static class CheckedRandomAccessList<E>
    extends CheckedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1638200125423088369L;

        CheckedRandomAccessList(List<E> list, Class<E> type) {
            super(list, type);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new CheckedRandomAccessList(this.list.subList(fromIndex, toIndex), this.type);
        }
    }

    static class CheckedList<E>
    extends CheckedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 65247728283967356L;
        final List<E> list;

        CheckedList(List<E> list, Class<E> type) {
            super(list, type);
            this.list = list;
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.list.equals(o);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public E get(int index) {
            return this.list.get(index);
        }

        @Override
        public E remove(int index) {
            return this.list.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public E set(int index, E element) {
            return this.list.set(index, this.typeCheck(element));
        }

        @Override
        public void add(int index, E element) {
            this.list.add(index, this.typeCheck(element));
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            return this.list.addAll(index, this.checkedCopyOf(c));
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            final ListIterator<E> i = this.list.listIterator(index);
            return new ListIterator<E>(){

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public E next() {
                    return i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return i.hasPrevious();
                }

                @Override
                public E previous() {
                    return i.previous();
                }

                @Override
                public int nextIndex() {
                    return i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return i.previousIndex();
                }

                @Override
                public void remove() {
                    i.remove();
                }

                @Override
                public void set(E e) {
                    i.set(this.typeCheck(e));
                }

                @Override
                public void add(E e) {
                    i.add(this.typeCheck(e));
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    i.forEachRemaining(action);
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new CheckedList<E>(this.list.subList(fromIndex, toIndex), this.type);
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            Objects.requireNonNull(operator);
            this.list.replaceAll(e -> this.typeCheck(operator.apply(e)));
        }

        @Override
        public void sort(Comparator<? super E> c) {
            this.list.sort(c);
        }
    }

    static class CheckedSortedSet<E>
    extends CheckedSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = 1599911165492914959L;
        private final SortedSet<E> ss;

        CheckedSortedSet(SortedSet<E> s, Class<E> type) {
            super(s, type);
            this.ss = s;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public E last() {
            return this.ss.last();
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return DesugarCollections.checkedSortedSet(this.ss.subSet(fromElement, toElement), this.type);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return DesugarCollections.checkedSortedSet(this.ss.headSet(toElement), this.type);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return DesugarCollections.checkedSortedSet(this.ss.tailSet(fromElement), this.type);
        }
    }

    static class CheckedSet<E>
    extends CheckedCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = 4694047833775013803L;

        CheckedSet(Set<E> s, Class<E> elementType) {
            super(s, elementType);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.c.equals(o);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class CheckedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1578914078182001775L;
        final Collection<E> c;
        final Class<E> type;
        private E[] zeroLengthElementArray;

        E typeCheck(Object o) {
            if (o != null && !this.type.isInstance(o)) {
                throw new ClassCastException(this.badElementMsg(o));
            }
            return (E)o;
        }

        private String badElementMsg(Object o) {
            return "Attempt to insert " + o.getClass() + " element into collection with element type " + this.type;
        }

        CheckedCollection(Collection<E> c, Class<E> type) {
            this.c = Objects.requireNonNull(c, "c");
            this.type = Objects.requireNonNull(type, "type");
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.c.toArray(a);
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.c.remove(o);
        }

        @Override
        public void clear() {
            this.c.clear();
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.c.containsAll(coll);
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            return this.c.removeAll(coll);
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            return this.c.retainAll(coll);
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator<E> it = this.c.iterator();
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public E next() {
                    return it.next();
                }

                @Override
                public void remove() {
                    it.remove();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    it.forEachRemaining(action);
                }
            };
        }

        @Override
        public boolean add(E e) {
            return this.c.add(this.typeCheck(e));
        }

        private E[] zeroLengthElementArray() {
            return this.zeroLengthElementArray != null ? this.zeroLengthElementArray : (this.zeroLengthElementArray = DesugarCollections.zeroLengthArray(this.type));
        }

        Collection<E> checkedCopyOf(Collection<? extends E> coll) {
            Object[] a;
            block3: {
                try {
                    E[] z = this.zeroLengthElementArray();
                    a = coll.toArray(z);
                    if (a.getClass() == z.getClass()) break block3;
                    a = Arrays.copyOf(a, a.length, z.getClass());
                }
                catch (ArrayStoreException ignore) {
                    a = (Object[])coll.toArray().clone();
                    for (E o : a) {
                        this.typeCheck(o);
                    }
                }
            }
            return Arrays.asList(a);
        }

        @Override
        public boolean addAll(Collection<? extends E> coll) {
            return this.c.addAll(this.checkedCopyOf(coll));
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.c.forEach(action);
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            return this.c.removeIf(filter);
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.c.parallelStream();
        }
    }

    static class SynchronizedSortedMap<K, V>
    extends SynchronizedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap<K, V> sm;

        SynchronizedSortedMap(SortedMap<K, V> m) {
            super(m);
            this.sm = m;
        }

        SynchronizedSortedMap(SortedMap<K, V> m, Object mutex) {
            super(m, mutex);
            this.sm = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.subMap(fromKey, toKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> headMap(K toKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.headMap(toKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.tailMap(fromKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }
    }

    private static class SynchronizedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map<K, V> m;
        final Object mutex;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        SynchronizedMap(Map<K, V> m) {
            this.m = Objects.requireNonNull(m);
            this.mutex = this;
        }

        SynchronizedMap(Map<K, V> m, Object mutex) {
            this.m = m;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = new SynchronizedSet<K>(this.m.keySet(), this.mutex);
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = new SynchronizedSet<Map.Entry<K, V>>(this.m.entrySet(), this.mutex);
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.values == null) {
                    this.values = new SynchronizedCollection<V>(this.m.values(), this.mutex);
                }
                return this.values;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                return this.m.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getOrDefault(Object k, V defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.getOrDefault(k, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.forEach(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.replaceAll(function);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putIfAbsent(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.putIfAbsent(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.remove(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.replace(key, oldValue, newValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V replace(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.replace(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.computeIfAbsent((K)key, mappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                s.defaultWriteObject();
            }
        }
    }

    static class SynchronizedRandomAccessList<E>
    extends SynchronizedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List<E> list) {
            super(list);
        }

        SynchronizedRandomAccessList(List<E> list, Object mutex) {
            super(list, mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.list.subList(fromIndex, toIndex), this.mutex);
            }
        }

        private Object writeReplace() {
            return new SynchronizedList(this.list);
        }
    }

    static class SynchronizedList<E>
    extends SynchronizedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -7754090372962971524L;
        final List<E> list;

        SynchronizedList(List<E> list) {
            super(list);
            this.list = list;
        }

        SynchronizedList(List<E> list, Object mutex) {
            super(list, mutex);
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                return this.list.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int index, E element) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.set(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, E element) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.add(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.lastIndexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.list.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return this.list.listIterator(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList<E>(this.list.subList(fromIndex, toIndex), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.replaceAll(operator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator<? super E> c) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.sort(c);
            }
        }

        private Object readResolve() {
            return this.list instanceof RandomAccess ? new SynchronizedRandomAccessList<E>(this.list) : this;
        }
    }

    static class SynchronizedSortedSet<E>
    extends SynchronizedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet<E> ss;

        SynchronizedSortedSet(SortedSet<E> s) {
            super(s);
            this.ss = s;
        }

        SynchronizedSortedSet(SortedSet<E> s, Object mutex) {
            super(s, mutex);
            this.ss = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super E> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.subSet(fromElement, toElement), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> headSet(E toElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.headSet(toElement), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> tailSet(E fromElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.tailSet(fromElement), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }
    }

    static class SynchronizedSet<E>
    extends SynchronizedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set<E> s) {
            super(s);
        }

        SynchronizedSet(Set<E> s, Object mutex) {
            super(s, mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                return this.c.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.hashCode();
            }
        }
    }

    static class SynchronizedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection<E> c;
        final Object mutex;

        SynchronizedCollection(Collection<E> c) {
            this.c = Objects.requireNonNull(c);
            this.mutex = this;
        }

        SynchronizedCollection(Collection<E> c, Object mutex) {
            this.c = Objects.requireNonNull(c);
            this.mutex = Objects.requireNonNull(mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(a);
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(Consumer<? super E> consumer) {
            Object object = this.mutex;
            synchronized (object) {
                this.c.forEach(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeIf(filter);
            }
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.c.parallelStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                s.defaultWriteObject();
            }
        }
    }

    static class UnmodifiableSortedMap<K, V>
    extends UnmodifiableMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap<K, ? extends V> sm;

        UnmodifiableSortedMap(SortedMap<K, ? extends V> m) {
            super(m);
            this.sm = m;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return new UnmodifiableSortedMap<K, V>(this.sm.subMap(fromKey, toKey));
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return new UnmodifiableSortedMap<K, V>(this.sm.headMap(toKey));
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return new UnmodifiableSortedMap<K, V>(this.sm.tailMap(fromKey));
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }
    }

    private static class UnmodifiableMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map<? extends K, ? extends V> m;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        UnmodifiableMap(Map<? extends K, ? extends V> m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.m = m;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        @Override
        public boolean containsValue(Object val) {
            return this.m.containsValue(val);
        }

        @Override
        public V get(Object key) {
            return this.m.get(key);
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = DesugarCollections.unmodifiableSet(this.m.keySet());
            }
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new UnmodifiableEntrySet<K, V>(this.m.entrySet());
            }
            return this.entrySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = DesugarCollections.unmodifiableCollection(this.m.values());
            }
            return this.values;
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.m.equals(o);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public V getOrDefault(Object k, V defaultValue) {
            return this.m.getOrDefault(k, defaultValue);
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            this.m.forEach(action);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        static class UnmodifiableEntrySet<K, V>
        extends UnmodifiableSet<Map.Entry<K, V>> {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set<? extends Map.Entry<? extends K, ? extends V>> s) {
                super(s);
            }

            static <K, V> Consumer<Map.Entry<? extends K, ? extends V>> entryConsumer(Consumer<? super Map.Entry<K, V>> action) {
                return e -> action.accept(new UnmodifiableEntry(e));
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<K, V>> action) {
                Objects.requireNonNull(action);
                this.c.forEach(UnmodifiableEntrySet.entryConsumer(action));
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return new UnmodifiableEntrySetSpliterator(this.c.spliterator());
            }

            @Override
            public Stream<Map.Entry<K, V>> stream() {
                return StreamSupport.stream(this.spliterator(), false);
            }

            @Override
            public Stream<Map.Entry<K, V>> parallelStream() {
                return StreamSupport.stream(this.spliterator(), true);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<? extends Map.Entry<? extends K, ? extends V>> i;
                    {
                        this.i = c.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new UnmodifiableEntry(this.i.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                        this.i.forEachRemaining(UnmodifiableEntrySet.entryConsumer(action));
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] a = this.c.toArray();
                for (int i = 0; i < a.length; ++i) {
                    a[i] = new UnmodifiableEntry((Map.Entry)a[i]);
                }
                return a;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                T[] arr = this.c.toArray(a.length == 0 ? a : Arrays.copyOf(a, 0));
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = new UnmodifiableEntry((Map.Entry)arr[i]);
                }
                if (arr.length > a.length) {
                    return arr;
                }
                System.arraycopy(arr, 0, a, 0, arr.length);
                if (a.length > arr.length) {
                    a[arr.length] = null;
                }
                return a;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return this.c.contains(new UnmodifiableEntry((Map.Entry)o));
            }

            @Override
            public boolean containsAll(Collection<?> coll) {
                for (Object e : coll) {
                    if (this.contains(e)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Set)) {
                    return false;
                }
                Set s = (Set)o;
                if (s.size() != this.c.size()) {
                    return false;
                }
                return this.containsAll(s);
            }

            private static class UnmodifiableEntry<K, V>
            implements Map.Entry<K, V> {
                private Map.Entry<? extends K, ? extends V> e;

                UnmodifiableEntry(Map.Entry<? extends K, ? extends V> e) {
                    this.e = Objects.requireNonNull(e);
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                @Override
                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry t = (Map.Entry)o;
                    return DesugarCollections.eq(this.e.getKey(), t.getKey()) && DesugarCollections.eq(this.e.getValue(), t.getValue());
                }

                public String toString() {
                    return this.e.toString();
                }
            }

            static final class UnmodifiableEntrySetSpliterator<K, V>
            implements Spliterator<Map.Entry<K, V>> {
                final Spliterator<Map.Entry<K, V>> s;

                UnmodifiableEntrySetSpliterator(Spliterator<Map.Entry<K, V>> s) {
                    this.s = s;
                }

                @Override
                public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
                    Objects.requireNonNull(action);
                    return this.s.tryAdvance(UnmodifiableEntrySet.entryConsumer(action));
                }

                @Override
                public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                    Objects.requireNonNull(action);
                    this.s.forEachRemaining(UnmodifiableEntrySet.entryConsumer(action));
                }

                @Override
                public Spliterator<Map.Entry<K, V>> trySplit() {
                    Spliterator<Map.Entry<K, V>> split = this.s.trySplit();
                    return split == null ? null : new UnmodifiableEntrySetSpliterator<K, V>(split);
                }

                @Override
                public long estimateSize() {
                    return this.s.estimateSize();
                }

                @Override
                public long getExactSizeIfKnown() {
                    return this.s.getExactSizeIfKnown();
                }

                @Override
                public int characteristics() {
                    return this.s.characteristics();
                }

                @Override
                public boolean hasCharacteristics(int characteristics) {
                    return this.s.hasCharacteristics(characteristics);
                }

                @Override
                public Comparator<? super Map.Entry<K, V>> getComparator() {
                    return this.s.getComparator();
                }
            }
        }
    }

    static class UnmodifiableRandomAccessList<E>
    extends UnmodifiableList<E>
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List<? extends E> list) {
            super(list);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new UnmodifiableRandomAccessList(this.list.subList(fromIndex, toIndex));
        }

        private Object writeReplace() {
            return new UnmodifiableList(this.list);
        }
    }

    static class UnmodifiableList<E>
    extends UnmodifiableCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -283967356065247728L;
        final List<? extends E> list;

        UnmodifiableList(List<? extends E> list) {
            super(list);
            this.list = list;
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.list.equals(o);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public E get(int index) {
            return this.list.get(index);
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            return new ListIterator<E>(){
                private final ListIterator<? extends E> i;
                {
                    this.i = list.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                @Override
                public E previous() {
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.i.forEachRemaining(action);
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new UnmodifiableList<E>(this.list.subList(fromIndex, toIndex));
        }

        private Object readResolve() {
            return this.list instanceof RandomAccess ? new UnmodifiableRandomAccessList<E>(this.list) : this;
        }
    }

    static class UnmodifiableSortedSet<E>
    extends UnmodifiableSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = -4929149591599911165L;
        private final SortedSet<E> ss;

        UnmodifiableSortedSet(SortedSet<E> s) {
            super(s);
            this.ss = s;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return new UnmodifiableSortedSet<E>(this.ss.subSet(fromElement, toElement));
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return new UnmodifiableSortedSet<E>(this.ss.headSet(toElement));
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return new UnmodifiableSortedSet<E>(this.ss.tailSet(fromElement));
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public E last() {
            return this.ss.last();
        }
    }

    static class UnmodifiableSet<E>
    extends UnmodifiableCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set<? extends E> s) {
            super(s);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.c.equals(o);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class UnmodifiableCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection<? extends E> c;

        UnmodifiableCollection(Collection<? extends E> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.c = c;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.c.toArray(a);
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> i;
                {
                    this.i = c.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.i.forEachRemaining(action);
                }
            };
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.c.containsAll(coll);
        }

        @Override
        public boolean addAll(Collection<? extends E> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.c.forEach(action);
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.c.parallelStream();
        }
    }
}

