/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.SimpleDeclarationChecker;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DataClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/SimpleDeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
public final class DataClassDeclarationChecker
implements SimpleDeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration instanceof KtClassOrObject)) {
            return;
        }
        if (((ClassDescriptor)descriptor2).isData()) {
            Object parameters2;
            KtPrimaryConstructor primaryConstructor2;
            Object object;
            if (((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor() == null) {
                PsiElement psiElement = ((ClassDescriptor)descriptor2).getConstructors();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, (String)"descriptor.constructors");
                PsiElement psiElement2 = psiElement;
                if (!psiElement2.isEmpty()) {
                    PsiElement psiElement3 = ((KtClassOrObject)declaration).getNameIdentifier();
                    if (psiElement3 != null) {
                        PsiElement it = psiElement2 = psiElement3;
                        diagnosticHolder.report(Errors.PRIMARY_CONSTRUCTOR_REQUIRED_FOR_DATA_CLASS.on(it));
                    }
                }
            }
            if ((object = (primaryConstructor2 = ((KtClassOrObject)declaration).getPrimaryConstructor())) == null || (object = ((KtConstructor)object).getValueParameters()) == null) {
                object = parameters2 = CollectionsKt.emptyList();
            }
            if (parameters2.isEmpty()) {
                KtElementImplStub ktElementImplStub = primaryConstructor2;
                PsiElement psiElement = ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.getValueParameterList()) != null ? (PsiElement)ktElementImplStub : ((KtClassOrObject)declaration).getNameIdentifier();
                if (psiElement != null) {
                    PsiElement $i$a$1$let;
                    PsiElement it = $i$a$1$let = psiElement;
                    diagnosticHolder.report(Errors.DATA_CLASS_WITHOUT_PARAMETERS.on(it));
                }
            }
            Iterator iterator2 = parameters2.iterator();
            while (iterator2.hasNext()) {
                KtParameter parameter;
                KtParameter ktParameter = parameter = (KtParameter)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
                if (ktParameter.isVarArg()) {
                    diagnosticHolder.report(Errors.DATA_CLASS_VARARG_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                }
                if (parameter.hasValOrVar()) continue;
                diagnosticHolder.report(Errors.DATA_CLASS_NOT_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ExpectActualTracker expectActualTracker) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)expectActualTracker, (String)"expectActualTracker");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration, descriptor2, diagnosticHolder, bindingContext, languageVersionSettings, expectActualTracker);
    }
}

