/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class AnalyzingUtils {
    private static final boolean WRITE_DEBUG_TRACE_NAMES = false;

    public static void checkForSyntacticErrors(@NotNull PsiElement root2) {
        root2.acceptChildren((PsiElementVisitor)new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(@NotNull PsiErrorElement element) {
                throw new IllegalArgumentException(element.getErrorDescription() + "; looking at " + element.getNode().getElementType() + " '" + element.getText() + PsiDiagnosticUtils.atLocation((PsiElement)element));
            }
        });
    }

    public static List<PsiErrorElement> getSyntaxErrorRanges(@NotNull PsiElement root2) {
        final ArrayList<PsiErrorElement> r = new ArrayList<PsiErrorElement>();
        root2.acceptChildren((PsiElementVisitor)new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(@NotNull PsiErrorElement element) {
                r.add(element);
            }
        });
        return r;
    }

    public static void throwExceptionOnErrors(BindingContext bindingContext) {
        AnalyzingUtils.throwExceptionOnErrors(bindingContext.getDiagnostics());
    }

    public static void throwExceptionOnErrors(Diagnostics diagnostics2) {
        for (Diagnostic diagnostic : diagnostics2) {
            DiagnosticSink.THROW_EXCEPTION.report(diagnostic);
        }
    }

    public static String formDebugNameForBindingTrace(@NotNull String debugName, @Nullable Object resolutionSubjectForMessage) {
        return "";
    }

    public static abstract class PsiErrorElementVisitor
    extends KtTreeVisitorVoid {
        public abstract void visitErrorElement(@NotNull PsiErrorElement var1);
    }
}

