/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FakeDescriptorsForReferencesKt;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtils2Kt;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializerExtension;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ClosureCodegen
extends MemberCodegen<KtElement> {
    protected final FunctionDescriptor funDescriptor;
    private final ClassDescriptor classDescriptor;
    private final SamType samType;
    private final KotlinType superClassType;
    private final List<KotlinType> superInterfaceTypes;
    private final FunctionDescriptor functionReferenceTarget;
    private final FunctionGenerationStrategy strategy;
    protected final CalculatedClosure closure;
    protected final Type asmType;
    protected final int visibilityFlag;
    private final boolean shouldHaveBoundReferenceReceiver;
    private Method constructor;
    protected Type superClassAsmType;

    public ClosureCodegen(@NotNull GenerationState state2, @NotNull KtElement element, @Nullable SamType samType, @NotNull ClosureContext context, @Nullable FunctionDescriptor functionReferenceTarget, @NotNull FunctionGenerationStrategy strategy, @NotNull MemberCodegen<?> parentCodegen, @NotNull ClassBuilder classBuilder2) {
        super(state2, parentCodegen, context, element, classBuilder2);
        this.funDescriptor = context.getFunctionDescriptor();
        this.classDescriptor = (ClassDescriptor)context.getContextDescriptor();
        this.samType = samType;
        this.functionReferenceTarget = functionReferenceTarget;
        this.strategy = strategy;
        if (samType == null) {
            this.superInterfaceTypes = new ArrayList<KotlinType>();
            KotlinType superClassType = null;
            for (KotlinType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                ClassifierDescriptor classifier2 = supertype.getConstructor().getDeclarationDescriptor();
                if (DescriptorUtils.isInterface(classifier2)) {
                    this.superInterfaceTypes.add(supertype);
                    continue;
                }
                assert (superClassType == null) : "Closure class can't have more than one superclass: " + this.funDescriptor;
                superClassType = supertype;
            }
            assert (superClassType != null) : "Closure class should have a superclass: " + this.funDescriptor;
            this.superClassType = superClassType;
        } else {
            this.superInterfaceTypes = Collections.singletonList(samType.getType());
            this.superClassType = DescriptorUtilsKt.getBuiltIns(this.funDescriptor).getAnyType();
        }
        this.closure = this.bindingContext.get(CodegenBinding.CLOSURE, this.classDescriptor);
        assert (this.closure != null) : "Closure must be calculated for class: " + this.classDescriptor;
        this.shouldHaveBoundReferenceReceiver = CallableReferenceUtilKt.isForBoundCallableReference(this.closure);
        this.asmType = this.typeMapper.mapClass(this.classDescriptor);
        this.visibilityFlag = AsmUtil.getVisibilityAccessFlagForClass(this.classDescriptor);
    }

    @Override
    protected void generateDeclaration() {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS);
        if (this.samType != null) {
            this.typeMapper.writeFormalTypeParameters(this.samType.getType().getConstructor().getParameters(), sw);
        }
        ((JvmSignatureWriter)sw).writeSuperclass();
        this.superClassAsmType = this.typeMapper.mapSupertype(this.superClassType, sw);
        ((JvmSignatureWriter)sw).writeSuperclassEnd();
        String[] superInterfaceAsmTypes = new String[this.superInterfaceTypes.size()];
        for (int i = 0; i < this.superInterfaceTypes.size(); ++i) {
            KotlinType superInterfaceType = this.superInterfaceTypes.get(i);
            ((JvmSignatureWriter)sw).writeInterface();
            superInterfaceAsmTypes[i] = this.typeMapper.mapSupertype(superInterfaceType, sw).getInternalName();
            ((JvmSignatureWriter)sw).writeInterfaceEnd();
        }
        this.v.defineClass((PsiElement)this.element, this.state.getClassFileVersion(), 0x30 | this.visibilityFlag, this.asmType.getInternalName(), ((JvmSignatureWriter)sw).makeJavaGenericSignature(), this.superClassAsmType.getInternalName(), superInterfaceAsmTypes);
        InlineCodegenUtils2Kt.initDefaultSourceMappingIfNeeded(this.context, this, this.state);
        this.v.visitSource(((KtElement)this.element).getContainingFile().getName(), null);
    }

    @Override
    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return JvmCodegenUtil.isArgumentWhichWillBeInlined(this.bindingContext, this.funDescriptor) ? null : this.classDescriptor;
    }

    @Override
    protected void generateBody() {
        this.generateBridges();
        this.generateClosureBody();
        this.constructor = this.generateConstructor();
        if (JvmCodegenUtil.isConst(this.closure)) {
            this.generateConstInstance(this.asmType, this.asmType);
        }
        AsmUtil.genClosureFields(this.closure, this.v, this.typeMapper);
    }

    protected void generateClosureBody() {
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin((PsiElement)this.element, this.funDescriptor), this.funDescriptor, this.strategy);
        if (this.functionReferenceTarget != null) {
            this.generateFunctionReferenceMethods(this.functionReferenceTarget);
        }
        this.functionCodegen.generateDefaultIfNeeded(this.context.intoFunction(this.funDescriptor), this.funDescriptor, this.context.getContextKind(), DefaultParameterValueLoader.DEFAULT, null);
    }

    protected void generateBridges() {
        FunctionDescriptor erasedInterfaceFunction = this.samType == null ? ClosureCodegen.getErasedInvokeFunction(this.funDescriptor) : this.samType.getOriginalAbstractMethod();
        this.generateBridge(this.typeMapper.mapAsmMethod(erasedInterfaceFunction), erasedInterfaceFunction.getReturnType(), this.typeMapper.mapAsmMethod(this.funDescriptor), this.funDescriptor.getReturnType());
        if (this.samType != null) {
            SimpleFunctionDescriptorImpl descriptorForBridges = SimpleFunctionDescriptorImpl.create(this.funDescriptor.getContainingDeclaration(), this.funDescriptor.getAnnotations(), erasedInterfaceFunction.getName(), CallableMemberDescriptor.Kind.DECLARATION, this.funDescriptor.getSource());
            descriptorForBridges.initialize((KotlinType)null, erasedInterfaceFunction.getDispatchReceiverParameter(), erasedInterfaceFunction.getTypeParameters(), (List)erasedInterfaceFunction.getValueParameters(), erasedInterfaceFunction.getReturnType(), Modality.OPEN, erasedInterfaceFunction.getVisibility());
            DescriptorUtilsKt.setSingleOverridden(descriptorForBridges, erasedInterfaceFunction);
            this.functionCodegen.generateBridges(descriptorForBridges);
        }
    }

    @Override
    protected void generateKotlinMetadataAnnotation() {
        FunctionDescriptor frontendFunDescriptor = CodegenUtilKt.unwrapFrontendVersion(this.funDescriptor);
        Method method = this.v.getSerializationBindings().get(JvmSerializationBindings.METHOD_FOR_FUNCTION, frontendFunDescriptor);
        assert (method != null) : "No method for " + frontendFunDescriptor;
        FunctionDescriptor freeLambdaDescriptor = FakeDescriptorsForReferencesKt.createFreeFakeLambdaDescriptor(frontendFunDescriptor);
        this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, freeLambdaDescriptor, method);
        DescriptorSerializer serializer = DescriptorSerializer.createForLambda(new JvmSerializerExtension(this.v.getSerializationBindings(), this.state));
        ProtoBuf.Function functionProto = serializer.functionProto(freeLambdaDescriptor).build();
        WriteAnnotationUtilKt.writeKotlinMetadata(this.v, this.state, KotlinClassHeader.Kind.SYNTHETIC_CLASS, 0, (Function1<? super AnnotationVisitor, Unit>)((Function1)av -> {
            AsmUtil.writeAnnotationData(av, serializer, functionProto);
            return Unit.INSTANCE;
        }));
    }

    @Override
    protected void done() {
        this.writeOuterClassAndEnclosingMethod();
        super.done();
    }

    @NotNull
    public StackValue putInstanceOnStack(@NotNull ExpressionCodegen codegen, @Nullable StackValue functionReferenceReceiver) {
        return StackValue.operation(this.functionReferenceTarget != null ? AsmTypes.K_FUNCTION : this.asmType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            if (JvmCodegenUtil.isConst(this.closure)) {
                v.getstatic(this.asmType.getInternalName(), "INSTANCE", this.asmType.getDescriptor());
            } else {
                v.anew(this.asmType);
                v.dup();
                codegen.pushClosureOnStack(this.classDescriptor, true, codegen.defaultCallGenerator, functionReferenceReceiver);
                v.invokespecial(this.asmType.getInternalName(), "<init>", this.constructor.getDescriptor(), false);
            }
            return Unit.INSTANCE;
        }));
    }

    protected void generateBridge(@NotNull Method bridge, @Nullable KotlinType bridgeReturnType, @NotNull Method delegate2, @Nullable KotlinType delegateReturnType) {
        if (bridge.equals((Object)delegate2)) {
            return;
        }
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin((PsiElement)this.element, this.funDescriptor), 4161, bridge.getName(), bridge.getDescriptor(), null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        mv.visitCode();
        InstructionAdapter iv = new InstructionAdapter(mv);
        MemberCodegen.markLineNumberForDescriptor(DescriptorUtils.getParentOfType(this.funDescriptor, ClassDescriptor.class), iv);
        iv.load(0, this.asmType);
        Type[] myParameterTypes = bridge.getArgumentTypes();
        List calleeParameters = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)this.funDescriptor.getExtensionReceiverParameter()), this.funDescriptor.getValueParameters());
        int slot = 1;
        for (int i = 0; i < calleeParameters.size(); ++i) {
            Type type2 = myParameterTypes[i];
            ParameterDescriptor calleeParameter = (ParameterDescriptor)calleeParameters.get(i);
            KotlinType parameterType = calleeParameter.getType();
            StackValue.local(slot, type2, parameterType).put(this.typeMapper.mapType(calleeParameter), parameterType, iv);
            slot += type2.getSize();
        }
        iv.invokevirtual(this.asmType.getInternalName(), delegate2.getName(), delegate2.getDescriptor(), false);
        StackValue.onStack(delegate2.getReturnType(), delegateReturnType).put(bridge.getReturnType(), bridgeReturnType, iv);
        iv.areturn(bridge.getReturnType());
        FunctionCodegen.endVisit(mv, "bridge", (KtElement)this.element);
    }

    private void generateFunctionReferenceMethods(@NotNull FunctionDescriptor descriptor2) {
        InstructionAdapter iv;
        int flags = 17;
        boolean generateBody2 = this.state.getClassBuilderMode().generateBodies;
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, flags, "getOwner", Type.getMethodDescriptor((Type)AsmTypes.K_DECLARATION_CONTAINER_TYPE, (Type[])new Type[0]), null, null);
        if (generateBody2) {
            mv.visitCode();
            iv = new InstructionAdapter(mv);
            ClosureCodegen.generateCallableReferenceDeclarationContainer(iv, descriptor2, this.state);
            iv.areturn(AsmTypes.K_DECLARATION_CONTAINER_TYPE);
            FunctionCodegen.endVisit((MethodVisitor)iv, "function reference getOwner", (KtElement)this.element);
        }
        mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, flags, "getName", Type.getMethodDescriptor((Type)AsmTypes.JAVA_STRING_TYPE, (Type[])new Type[0]), null, null);
        if (generateBody2) {
            mv.visitCode();
            iv = new InstructionAdapter(mv);
            iv.aconst((Object)descriptor2.getName().asString());
            iv.areturn(AsmTypes.JAVA_STRING_TYPE);
            FunctionCodegen.endVisit((MethodVisitor)iv, "function reference getName", (KtElement)this.element);
        }
        mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, flags, "getSignature", Type.getMethodDescriptor((Type)AsmTypes.JAVA_STRING_TYPE, (Type[])new Type[0]), null, null);
        if (generateBody2) {
            mv.visitCode();
            iv = new InstructionAdapter(mv);
            PropertyReferenceCodegen.generateCallableReferenceSignature(iv, descriptor2, this.state);
            iv.areturn(AsmTypes.JAVA_STRING_TYPE);
            FunctionCodegen.endVisit((MethodVisitor)iv, "function reference getSignature", (KtElement)this.element);
        }
    }

    public static void generateCallableReferenceDeclarationContainer(@NotNull InstructionAdapter iv, @NotNull CallableDescriptor descriptor2, @NotNull GenerationState state2) {
        boolean isContainerPackage;
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (container2 instanceof ClassDescriptor) {
            AsmUtil.putJavaLangClassInstance(iv, state2.getTypeMapper().mapType(((ClassDescriptor)container2).getDefaultType()));
        } else if (container2 instanceof PackageFragmentDescriptor) {
            iv.aconst((Object)state2.getTypeMapper().mapOwner(descriptor2));
        } else if (descriptor2 instanceof VariableDescriptorWithAccessors) {
            iv.aconst((Object)state2.getBindingContext().get(CodegenBinding.DELEGATED_PROPERTY_METADATA_OWNER, (VariableDescriptorWithAccessors)descriptor2));
        } else {
            iv.aconst(null);
            return;
        }
        boolean bl = descriptor2 instanceof LocalVariableDescriptor ? DescriptorUtils.getParentOfType(descriptor2, ClassDescriptor.class) == null : (isContainerPackage = container2 instanceof PackageFragmentDescriptor);
        if (isContainerPackage) {
            iv.aconst((Object)state2.getModuleName());
            iv.invokestatic("kotlin/jvm/internal/Reflection", "getOrCreateKotlinPackage", Type.getMethodDescriptor((Type)AsmTypes.K_DECLARATION_CONTAINER_TYPE, (Type[])new Type[]{AsmTypes.getType(Class.class), AsmTypes.getType(String.class)}), false);
        } else {
            AsmUtil.wrapJavaClassIntoKClass(iv);
        }
    }

    @NotNull
    protected Method generateConstructor() {
        List<FieldInfo> args = ClosureCodegen.calculateConstructorParameters(this.typeMapper, this.closure, this.asmType);
        Type[] argTypes = ClosureCodegen.fieldListToTypeArray(args);
        Method constructor = new Method("<init>", Type.VOID_TYPE, argTypes);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin((PsiElement)this.element, this.funDescriptor), this.visibilityFlag, "<init>", constructor.getDescriptor(), null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (this.state.getClassBuilderMode().generateBodies) {
            String superClassConstructorDescriptor;
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            Pair<Integer, Type> receiverIndexAndType = CallableReferenceUtilKt.generateClosureFieldsInitializationFromParameters(iv, this.closure, args);
            if (this.shouldHaveBoundReferenceReceiver && receiverIndexAndType == null) {
                throw new AssertionError((Object)("No bound reference receiver in constructor parameters: " + args));
            }
            int boundReferenceReceiverParameterIndex = this.shouldHaveBoundReferenceReceiver ? (Integer)receiverIndexAndType.getFirst() : -1;
            Type boundReferenceReceiverType = this.shouldHaveBoundReferenceReceiver ? (Type)receiverIndexAndType.getSecond() : null;
            iv.load(0, this.superClassAsmType);
            if (this.superClassAsmType.equals((Object)AsmTypes.LAMBDA) || this.superClassAsmType.equals((Object)AsmTypes.FUNCTION_REFERENCE) || this.superClassAsmType.equals((Object)CoroutineCodegenUtilKt.coroutineImplAsmType(this.state.getLanguageVersionSettings()))) {
                int arity = this.calculateArity();
                iv.iconst(arity);
                if (this.shouldHaveBoundReferenceReceiver) {
                    CallableReferenceUtilKt.loadBoundReferenceReceiverParameter(iv, boundReferenceReceiverParameterIndex, boundReferenceReceiverType);
                    superClassConstructorDescriptor = "(ILjava/lang/Object;)V";
                } else {
                    superClassConstructorDescriptor = "(I)V";
                }
            } else {
                assert (!this.shouldHaveBoundReferenceReceiver) : "Unexpected bound reference with supertype " + this.superClassAsmType;
                superClassConstructorDescriptor = "()V";
            }
            iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", superClassConstructorDescriptor, false);
            iv.visitInsn(177);
            FunctionCodegen.endVisit((MethodVisitor)iv, "constructor", (KtElement)this.element);
        }
        return constructor;
    }

    protected int calculateArity() {
        int arity = this.funDescriptor.getValueParameters().size();
        if (this.funDescriptor.getExtensionReceiverParameter() != null) {
            ++arity;
        }
        if (this.funDescriptor.getDispatchReceiverParameter() != null) {
            ++arity;
        }
        return arity;
    }

    @NotNull
    public static List<FieldInfo> calculateConstructorParameters(@NotNull KotlinTypeMapper typeMapper, @NotNull CalculatedClosure closure, @NotNull Type ownerType) {
        KotlinType captureReceiverType;
        ArrayList args = Lists.newArrayList();
        ClassDescriptor captureThis = closure.getCaptureThis();
        if (captureThis != null) {
            Type type2 = typeMapper.mapType(captureThis);
            args.add(FieldInfo.createForHiddenField(ownerType, type2, "this$0"));
        }
        if ((captureReceiverType = closure.getCaptureReceiverType()) != null) {
            args.add(FieldInfo.createForHiddenField(ownerType, typeMapper.mapType(captureReceiverType), "receiver$0"));
        }
        for (EnclosedValueDescriptor enclosedValueDescriptor : closure.getCaptureVariables().values()) {
            DeclarationDescriptor descriptor2 = enclosedValueDescriptor.getDescriptor();
            if (descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof PropertyDescriptor) || ExpressionTypingUtils.isLocalFunction(descriptor2)) {
                args.add(FieldInfo.createForHiddenField(ownerType, enclosedValueDescriptor.getType(), enclosedValueDescriptor.getFieldName()));
                continue;
            }
            if (descriptor2 instanceof FunctionDescriptor) assert (captureReceiverType != null);
        }
        return args;
    }

    private static Type[] fieldListToTypeArray(List<FieldInfo> args) {
        Type[] argTypes = new Type[args.size()];
        for (int i = 0; i != argTypes.length; ++i) {
            argTypes[i] = args.get(i).getFieldType();
        }
        return argTypes;
    }

    @NotNull
    public static FunctionDescriptor getErasedInvokeFunction(@NotNull FunctionDescriptor function2) {
        ClassDescriptor functionClass = DescriptorUtilsKt.getBuiltIns(function2).getFunction(function2.getValueParameters().size() + (function2.getExtensionReceiverParameter() != null ? 1 : 0));
        MemberScope scope = functionClass.getDefaultType().getMemberScope();
        return scope.getContributedFunctions(OperatorNameConventions.INVOKE, NoLookupLocation.FROM_BACKEND).iterator().next();
    }
}

