/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationContainerLoweringPass;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.BlockDecomposerLowering;
import org.jetbrains.kotlin.ir.backend.js.symbols.JsSymbolBuilder;
import org.jetbrains.kotlin.ir.backend.js.symbols.SymbolBuilderKt;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBranchImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCatchImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrContainerExpressionBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrDoWhileLoopImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrElseBranchImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetVariableImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSpreadElementImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrThrowImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTryImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhenImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhileLoopImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\t56789:;<=B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001dJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000eJ\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)JV\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0018\u00010/j\u0002`02\n\u0010\u000b\u001a\u000601R\u00020\u00002\n\u0010\u0011\u001a\u000601R\u00020\u00002\u001e\u00102\u001a\u001a\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020+\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u001e03H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationContainerLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "constFalse", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "constTrue", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "expressionVisitor", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$ExpressionVisitor;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "nothingType", "Lorg/jetbrains/kotlin/types/SimpleType;", "statementVisitor", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$StatementVisitor;", "tmpVarCounter", "", "unitType", "unitValue", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "unreachableFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "lower", "", "irDeclarationContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "irField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "container", "irFunction", "makeLoopLabel", "", "makeTempVar", "Lorg/jetbrains/kotlin/ir/symbols/impl/IrVariableSymbolImpl;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "processWhen", "Lorg/jetbrains/kotlin/ir/IrStatement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "data", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/VisitData;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$DecomposerVisitor;", "bodyBuilder", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$VisitResult;", "ChangedResult", "DecomposedResult", "DecomposerVisitor", "ExpressionVisitor", "KeptResult", "StatementVisitor", "TerminatedResult", "VisitResult", "VisitStatus", "backend.js"})
public final class BlockDecomposerLowering
implements DeclarationContainerLoweringPass {
    private IrFunction function;
    private int tmpVarCounter;
    private final StatementVisitor statementVisitor;
    private final ExpressionVisitor expressionVisitor;
    private final IrConstImpl<Boolean> constTrue;
    private final IrConstImpl<Boolean> constFalse;
    private final SimpleType nothingType;
    private final SimpleType unitType;
    private final IrGetObjectValueImpl unitValue;
    private final IrSimpleFunctionSymbol unreachableFunction;
    @NotNull
    private final JsIrBackendContext context;

    @Override
    public void lower(@NotNull IrDeclarationContainer irDeclarationContainer) {
        Intrinsics.checkParameterIsNotNull((Object)irDeclarationContainer, (String)"irDeclarationContainer");
        List<IrDeclaration> $receiver$iv = irDeclarationContainer.getDeclarations();
        int i$iv = 0;
        while (i$iv < $receiver$iv.size()) {
            List<IrDeclaration> transformed$iv;
            List<IrDeclaration> list2;
            IrDeclaration item$iv = $receiver$iv.get(i$iv);
            IrDeclaration declaration = item$iv;
            IrDeclaration irDeclaration = declaration;
            if (irDeclaration instanceof IrFunction) {
                this.lower((IrFunction)declaration);
                list2 = CollectionsKt.listOf((Object)declaration);
            } else {
                list2 = transformed$iv = irDeclaration instanceof IrField ? this.lower((IrField)declaration, irDeclarationContainer) : CollectionsKt.listOf((Object)declaration);
            }
            if (transformed$iv == null) {
                ++i$iv;
                continue;
            }
            $receiver$iv.addAll(i$iv, (Collection<IrDeclaration>)transformed$iv);
            $receiver$iv.remove(i$iv += transformed$iv.size());
        }
    }

    public final void lower(@NotNull IrFunction irFunction) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)irFunction, (String)"irFunction");
            this.function = irFunction;
            this.tmpVarCounter = 0;
            IrBody irBody = irFunction.getBody();
            if (irBody == null) break block0;
            VisitResult cfr_ignored_0 = (VisitResult)irBody.accept(this.statementVisitor, null);
        }
    }

    @NotNull
    public final List<IrDeclaration> lower(@NotNull IrField irField, @NotNull IrDeclarationContainer container2) {
        Intrinsics.checkParameterIsNotNull((Object)irField, (String)"irField");
        Intrinsics.checkParameterIsNotNull((Object)container2, (String)"container");
        IrExpressionBody irExpressionBody = irField.getInitializer();
        if (irExpressionBody != null) {
            IrFunctionImpl irFunctionImpl;
            IrBlockBodyImpl irBlockBodyImpl;
            IrExpressionBody irExpressionBody2;
            IrExpressionBody $receiver = irExpressionBody2 = irExpressionBody;
            IrSimpleFunctionSymbol initFnSymbol = SymbolBuilderKt.initialize$default(JsSymbolBuilder.buildSimpleFunction$default(JsSymbolBuilder.INSTANCE, ((IrSymbolOwner)((Object)container2)).getSymbol().getDescriptor(), irField.getName().asString() + "$init$", null, null, null, 28, null), null, null, null, null, $receiver.getExpression().getType(), null, null, 111, null);
            IrBlockBodyImpl $receiver2 = irBlockBodyImpl = new IrBlockBodyImpl($receiver.getExpression().getStartOffset(), $receiver.getExpression().getEndOffset());
            Collection collection = $receiver2.getStatements();
            IrReturnImpl irReturnImpl = JsIrBuilder.INSTANCE.buildReturn(initFnSymbol, $receiver.getExpression());
            collection.add(irReturnImpl);
            IrBlockBodyImpl newBody = irBlockBodyImpl;
            IrFunctionImpl $receiver3 = irFunctionImpl = JsIrBuilder.INSTANCE.buildFunction(initFnSymbol);
            $receiver3.setBody(newBody);
            IrFunctionImpl initFn = irFunctionImpl;
            this.lower(initFn);
            if (newBody.getStatements().size() > 1) {
                $receiver.setExpression(JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, initFnSymbol, null, null, 6, null));
                return CollectionsKt.listOf((Object[])new IrSymbolDeclaration[]{initFn, irField});
            }
        }
        return CollectionsKt.listOf((Object)irField);
    }

    @NotNull
    public final IrVariableSymbolImpl makeTempVar(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        IrFunction irFunction = this.function;
        if (irFunction == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"function");
        }
        int n = this.tmpVarCounter;
        this.tmpVarCounter = n + 1;
        return JsSymbolBuilder.INSTANCE.buildTempVar(irFunction.getSymbol(), type2, "tmp$dcms$" + n, true);
    }

    @NotNull
    public final String makeLoopLabel() {
        int n = this.tmpVarCounter;
        this.tmpVarCounter = n + 1;
        return "$l$" + n;
    }

    /*
     * WARNING - void declaration
     */
    private final IrStatement processWhen(IrWhen expression2, Void data, DecomposerVisitor expressionVisitor2, DecomposerVisitor statementVisitor, Function2<? super VisitResult, ? super IrStatement, ? extends List<? extends IrStatement>> bodyBuilder) {
        Iterable $receiver$iv;
        Object bodyResult;
        VisitResult conditionResult;
        void needNewBodies;
        void needNewConds;
        void $receiver$iv$iv;
        Iterable $receiver$iv2;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
        booleanRef2.element = false;
        Iterable iterable = $receiver$iv2 = (Iterable)expression2.getBranches();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            IrBranch irBranch = (IrBranch)item$iv$iv;
            Collection collection = destination$iv$iv;
            conditionResult = ((VisitResult)it.getCondition().accept(expressionVisitor2, data)).applyIfChanged((Function1<? super VisitResult, Unit>)((Function1)new Function1<VisitResult, Unit>(expressionVisitor2, data, (Ref.BooleanRef)needNewConds, statementVisitor, (Ref.BooleanRef)needNewBodies){
                final /* synthetic */ DecomposerVisitor $expressionVisitor$inlined;
                final /* synthetic */ Void $data$inlined;
                final /* synthetic */ Ref.BooleanRef $needNewConds$inlined;
                final /* synthetic */ DecomposerVisitor $statementVisitor$inlined;
                final /* synthetic */ Ref.BooleanRef $needNewBodies$inlined;
                {
                    this.$expressionVisitor$inlined = decomposerVisitor;
                    this.$data$inlined = void_;
                    this.$needNewConds$inlined = booleanRef;
                    this.$statementVisitor$inlined = decomposerVisitor2;
                    this.$needNewBodies$inlined = booleanRef2;
                    super(1);
                }

                public final void invoke(@NotNull VisitResult $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    this.$needNewConds$inlined.element = true;
                }
            }));
            bodyResult = ((VisitResult)it.getResult().accept(statementVisitor, data)).applyIfChanged((Function1<? super VisitResult, Unit>)((Function1)new Function1<VisitResult, Unit>(expressionVisitor2, data, (Ref.BooleanRef)needNewConds, statementVisitor, (Ref.BooleanRef)needNewBodies){
                final /* synthetic */ DecomposerVisitor $expressionVisitor$inlined;
                final /* synthetic */ Void $data$inlined;
                final /* synthetic */ Ref.BooleanRef $needNewConds$inlined;
                final /* synthetic */ DecomposerVisitor $statementVisitor$inlined;
                final /* synthetic */ Ref.BooleanRef $needNewBodies$inlined;
                {
                    this.$expressionVisitor$inlined = decomposerVisitor;
                    this.$data$inlined = void_;
                    this.$needNewConds$inlined = booleanRef;
                    this.$statementVisitor$inlined = decomposerVisitor2;
                    this.$needNewBodies$inlined = booleanRef2;
                    super(1);
                }

                public final void invoke(@NotNull VisitResult $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    this.$needNewBodies$inlined.element = true;
                }
            }));
            Pair pair = new Pair((Object)conditionResult, bodyResult);
            collection.add(pair);
        }
        List branches = (List)destination$iv$iv;
        if (!needNewConds.element && !needNewBodies.element) {
            return expression2;
        }
        if (needNewConds.element) {
            int n = expression2.getStartOffset();
            int n2 = expression2.getEndOffset();
            SimpleType simpleType2 = this.unitType;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"unitType");
            IrBlockImpl block = new IrBlockImpl(n, n2, simpleType2, expression2.getOrigin());
            $receiver$iv = branches;
            int index$iv = 0;
            IrBlockImpl accumulator$iv = block;
            for (Object element$iv : $receiver$iv) {
                IrBlockImpl irBlockImpl;
                void appendBlock;
                void $condResult_bodyResult;
                int n3 = index$iv++;
                conditionResult = (Pair)element$iv;
                bodyResult = accumulator$iv;
                int i = n3;
                VisitResult condResult = (VisitResult)$condResult_bodyResult.component1();
                VisitResult bodyResult2 = (VisitResult)$condResult_bodyResult.component2();
                IrBranch originalBranch = expression2.getBranches().get(i);
                IrExpression originalCondition = originalBranch.getCondition();
                IrExpression originalResult = originalBranch.getResult();
                IrExpression irCondition2 = condResult.runIfChangedOrDefault(originalCondition, (Function2)new Function2<VisitResult, IrExpression, IrExpression>((IrBlockImpl)appendBlock){
                    final /* synthetic */ IrBlockImpl $appendBlock;

                    @NotNull
                    public final IrExpression invoke(@NotNull VisitResult $receiver, @NotNull IrExpression it) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Collection collection = this.$appendBlock.getStatements();
                        Iterable iterable = $receiver.getStatements();
                        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                        return $receiver.getResultValue();
                    }
                    {
                        this.$appendBlock = irBlockImpl;
                        super(2);
                    }
                });
                int n4 = originalResult.getStartOffset();
                int n5 = originalResult.getEndOffset();
                SimpleType simpleType3 = this.unitType;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"unitType");
                IrBlockImpl $receiver = irBlockImpl = new IrBlockImpl(n4, n5, simpleType3, null, 8, null);
                Collection collection = $receiver.getStatements();
                Iterable iterable2 = (Iterable)bodyBuilder.invoke((Object)bodyResult2, (Object)originalResult);
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
                IrBlockImpl thenBlock = irBlockImpl;
                SimpleType simpleType4 = this.unitType;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"unitType");
                IrBlockImpl it = irBlockImpl = JsIrBuilder.INSTANCE.buildBlock(simpleType4);
                IrBlockImpl elseBlock = originalBranch instanceof IrElseBranch ? null : it;
                int n6 = originalBranch.getStartOffset();
                int n7 = originalBranch.getEndOffset();
                SimpleType simpleType5 = this.unitType;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType5, (String)"unitType");
                IrIfThenElseImpl ifElseNode = new IrIfThenElseImpl(n6, n7, simpleType5, irCondition2, thenBlock, elseBlock, expression2.getOrigin());
                Collection collection2 = appendBlock.getStatements();
                collection2.add(ifElseNode);
                accumulator$iv = irBlockImpl;
            }
            return block;
        }
        int n = expression2.getStartOffset();
        int n8 = expression2.getEndOffset();
        SimpleType simpleType6 = this.unitType;
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType6, (String)"unitType");
        IrWhenImpl newWhen2 = new IrWhenImpl(n, n8, simpleType6, expression2.getOrigin());
        $receiver$iv = branches;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void $$_$_bodyResult;
            Object element$iv;
            int n9 = index$iv++;
            element$iv = (Pair)item$iv;
            int i = n9;
            bodyResult = (VisitResult)$$_$_bodyResult.component2();
            IrBranch originalBranch = expression2.getBranches().get(i);
            IrExpression condition = originalBranch.getCondition();
            IrExpression originalResult = originalBranch.getResult();
            int n10 = originalResult.getStartOffset();
            int n11 = originalResult.getEndOffset();
            SimpleType simpleType7 = this.unitType;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType7, (String)"unitType");
            Object object = new IrBlockImpl(n10, n11, simpleType7, null, 8, null);
            IrBlockImpl $receiver = object;
            Collection collection = $receiver.getStatements();
            Iterable iterable3 = (Iterable)bodyBuilder.invoke(bodyResult, (Object)originalResult);
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable3);
            IrBlockImpl body = object;
            object = newWhen2.getBranches();
            IrBranch irBranch = originalBranch;
            irBranch = irBranch instanceof IrElseBranch ? (IrBranchImpl)new IrElseBranchImpl(originalBranch.getStartOffset(), originalBranch.getEndOffset(), condition, body) : new IrBranchImpl(originalBranch.getStartOffset(), originalBranch.getEndOffset(), condition, body);
            object.add(irBranch);
        }
        return newWhen2;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    public BlockDecomposerLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.statementVisitor = new StatementVisitor();
        this.expressionVisitor = new ExpressionVisitor();
        SimpleType simpleType2 = this.context.getBuiltIns().getBooleanType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.booleanType");
        this.constTrue = JsIrBuilder.INSTANCE.buildBoolean(simpleType2, true);
        SimpleType simpleType3 = this.context.getBuiltIns().getBooleanType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"context.builtIns.booleanType");
        this.constFalse = JsIrBuilder.INSTANCE.buildBoolean(simpleType3, false);
        this.nothingType = this.context.getBuiltIns().getNullableNothingType();
        SimpleType simpleType4 = this.unitType = this.context.getBuiltIns().getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"unitType");
        KotlinType kotlinType = simpleType4;
        SymbolTable symbolTable = this.context.getSymbolTable();
        ClassDescriptor classDescriptor = this.context.getBuiltIns().getUnit();
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"context.builtIns.unit");
        this.unitValue = JsIrBuilder.INSTANCE.buildGetObjectValue(kotlinType, symbolTable.referenceClass(classDescriptor));
        this.unreachableFunction = SymbolBuilderKt.initialize$default(JsSymbolBuilder.buildSimpleFunction$default(JsSymbolBuilder.INSTANCE, this.context.getModule(), Namer.INSTANCE.getUNREACHABLE_NAME(), null, null, null, 28, null), null, null, null, null, this.nothingType, null, null, 111, null);
    }

    @NotNull
    public static final /* synthetic */ IrConstImpl access$getConstTrue$p(BlockDecomposerLowering $this) {
        return $this.constTrue;
    }

    @NotNull
    public static final /* synthetic */ IrConstImpl access$getConstFalse$p(BlockDecomposerLowering $this) {
        return $this.constFalse;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$VisitStatus;", "", "(Ljava/lang/String;I)V", "DECOMPOSED", "TERMINATED", "KEPT", "backend.js"})
    public static final class VisitStatus
    extends Enum<VisitStatus> {
        public static final /* enum */ VisitStatus DECOMPOSED;
        public static final /* enum */ VisitStatus TERMINATED;
        public static final /* enum */ VisitStatus KEPT;
        private static final /* synthetic */ VisitStatus[] $VALUES;

        static {
            VisitStatus[] visitStatusArray = new VisitStatus[3];
            VisitStatus[] visitStatusArray2 = visitStatusArray;
            visitStatusArray[0] = DECOMPOSED = new VisitStatus();
            visitStatusArray[1] = TERMINATED = new VisitStatus();
            visitStatusArray[2] = KEPT = new VisitStatus();
            $VALUES = visitStatusArray;
        }

        public static VisitStatus[] values() {
            return (VisitStatus[])$VALUES.clone();
        }

        public static VisitStatus valueOf(String string) {
            return Enum.valueOf(VisitStatus.class, string);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0010\u001a\u00020\u00002\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\b\u0014H&J!\u0010\u0015\u001a\u00020\u00002\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u0012\u00a2\u0006\u0002\b\u0014H&JI\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u0002H\u00172,\u0010\u0011\u001a(\u0012\u0004\u0012\u00020\u0000\u0012\u0013\u0012\u0011H\u0017\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u0002H\u00170\u0019\u00a2\u0006\u0002\b\u0014H&\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$VisitResult;", "", "status", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$VisitStatus;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$VisitStatus;)V", "resultValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getResultValue", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "statements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "getStatements", "()Ljava/util/List;", "getStatus", "()Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$VisitStatus;", "applyIfChanged", "action", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "runIfChanged", "runIfChangedOrDefault", "T", "default", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "d", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "backend.js"})
    public static abstract class VisitResult {
        @NotNull
        private final VisitStatus status;

        @NotNull
        public List<IrStatement> getStatements() {
            String string = "No statement is possible here";
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @NotNull
        public IrExpression getResultValue() {
            String string = "This result has no value";
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @NotNull
        public abstract VisitResult runIfChanged(@NotNull Function1<? super VisitResult, ? extends VisitResult> var1);

        public abstract <T> T runIfChangedOrDefault(T var1, @NotNull Function2<? super VisitResult, ? super T, ? extends T> var2);

        @NotNull
        public abstract VisitResult applyIfChanged(@NotNull Function1<? super VisitResult, Unit> var1);

        @NotNull
        public final VisitStatus getStatus() {
            return this.status;
        }

        public VisitResult(@NotNull VisitStatus status2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)status2), (String)"status");
            this.status = status2;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00002\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\b\u0007H\u0016J!\u0010\b\u001a\u00020\u00002\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\b\u0007H\u0016JI\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u0002H\n2,\u0010\u0004\u001a(\u0012\u0004\u0012\u00020\u0001\u0012\u0013\u0012\u0011H\n\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u0002H\n0\f\u00a2\u0006\u0002\b\u0007H\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$KeptResult;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$VisitResult;", "()V", "applyIfChanged", "action", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "runIfChanged", "runIfChangedOrDefault", "T", "default", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "d", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "backend.js"})
    public static final class KeptResult
    extends VisitResult {
        public static final KeptResult INSTANCE;

        @Override
        @NotNull
        public KeptResult runIfChanged(@NotNull Function1<? super VisitResult, ? extends VisitResult> action2) {
            Intrinsics.checkParameterIsNotNull(action2, (String)"action");
            return this;
        }

        @Override
        public <T> T runIfChangedOrDefault(T t, @NotNull Function2<? super VisitResult, ? super T, ? extends T> action2) {
            Intrinsics.checkParameterIsNotNull(action2, (String)"action");
            return t;
        }

        @Override
        @NotNull
        public KeptResult applyIfChanged(@NotNull Function1<? super VisitResult, Unit> action2) {
            Intrinsics.checkParameterIsNotNull(action2, (String)"action");
            return this;
        }

        private KeptResult() {
            super(VisitStatus.KEPT);
        }

        static {
            KeptResult keptResult;
            INSTANCE = keptResult = new KeptResult();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ!\u0010\u000e\u001a\u00020\u00002\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\b\u0012H\u0016J!\u0010\u0013\u001a\u00020\u00012\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0010\u00a2\u0006\u0002\b\u0012H\u0016JI\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0016\u001a\u0002H\u00152,\u0010\u000f\u001a(\u0012\u0004\u0012\u00020\u0001\u0012\u0013\u0012\u0011H\u0015\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u0002H\u00150\u0017\u00a2\u0006\u0002\b\u0012H\u0016\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$ChangedResult;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$VisitResult;", "statements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "resultValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "status", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$VisitStatus;", "(Ljava/util/List;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$VisitStatus;)V", "getResultValue", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getStatements", "()Ljava/util/List;", "applyIfChanged", "action", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "runIfChanged", "runIfChangedOrDefault", "T", "default", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "d", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "backend.js"})
    public static abstract class ChangedResult
    extends VisitResult {
        @NotNull
        private final List<IrStatement> statements;
        @NotNull
        private final IrExpression resultValue;

        @Override
        @NotNull
        public VisitResult runIfChanged(@NotNull Function1<? super VisitResult, ? extends VisitResult> action2) {
            ChangedResult changedResult;
            Intrinsics.checkParameterIsNotNull(action2, (String)"action");
            ChangedResult $receiver = changedResult = this;
            return (VisitResult)action2.invoke((Object)$receiver);
        }

        @Override
        public <T> T runIfChangedOrDefault(T t, @NotNull Function2<? super VisitResult, ? super T, ? extends T> action2) {
            ChangedResult changedResult;
            Intrinsics.checkParameterIsNotNull(action2, (String)"action");
            ChangedResult $receiver = changedResult = this;
            return (T)action2.invoke((Object)$receiver, t);
        }

        @Override
        @NotNull
        public ChangedResult applyIfChanged(@NotNull Function1<? super VisitResult, Unit> action2) {
            ChangedResult changedResult;
            Intrinsics.checkParameterIsNotNull(action2, (String)"action");
            ChangedResult $receiver = changedResult = this;
            action2.invoke((Object)$receiver);
            return changedResult;
        }

        @Override
        @NotNull
        public List<IrStatement> getStatements() {
            return this.statements;
        }

        @Override
        @NotNull
        public IrExpression getResultValue() {
            return this.resultValue;
        }

        public ChangedResult(@NotNull List<IrStatement> statements, @NotNull IrExpression resultValue, @NotNull VisitStatus status2) {
            Intrinsics.checkParameterIsNotNull(statements, (String)"statements");
            Intrinsics.checkParameterIsNotNull((Object)resultValue, (String)"resultValue");
            Intrinsics.checkParameterIsNotNull((Object)((Object)status2), (String)"status");
            super(status2);
            this.statements = statements;
            this.resultValue = resultValue;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$DecomposedResult;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$ChangedResult;", "statement", "Lorg/jetbrains/kotlin/ir/IrStatement;", "resultValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "(Lorg/jetbrains/kotlin/ir/IrStatement;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "statements", "", "(Ljava/util/List;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "backend.js"})
    public static final class DecomposedResult
    extends ChangedResult {
        public DecomposedResult(@NotNull List<IrStatement> statements, @NotNull IrExpression resultValue) {
            Intrinsics.checkParameterIsNotNull(statements, (String)"statements");
            Intrinsics.checkParameterIsNotNull((Object)resultValue, (String)"resultValue");
            super(statements, resultValue, VisitStatus.DECOMPOSED);
        }

        public DecomposedResult(@NotNull IrStatement statement2, @NotNull IrExpression resultValue) {
            Intrinsics.checkParameterIsNotNull((Object)statement2, (String)"statement");
            Intrinsics.checkParameterIsNotNull((Object)resultValue, (String)"resultValue");
            this(CollectionsKt.mutableListOf((Object[])new IrStatement[]{statement2}), resultValue);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$TerminatedResult;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$ChangedResult;", "statements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "resultValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "(Ljava/util/List;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "backend.js"})
    public static final class TerminatedResult
    extends ChangedResult {
        public TerminatedResult(@NotNull List<IrStatement> statements, @NotNull IrExpression resultValue) {
            Intrinsics.checkParameterIsNotNull(statements, (String)"statements");
            Intrinsics.checkParameterIsNotNull((Object)resultValue, (String)"resultValue");
            super(statements, resultValue, VisitStatus.TERMINATED);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a6\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0018\u00010\u0003j\u0002`\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0018\u00010\u0003j\u0002`\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$DecomposerVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$VisitResult;", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/VisitData;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering;)V", "visitElement", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$KeptResult;", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "data", "backend.js"})
    public abstract class DecomposerVisitor
    implements IrElementVisitor {
        @NotNull
        public KeptResult visitElement(@NotNull IrElement element, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            return KeptResult.INSTANCE;
        }

        @NotNull
        public VisitResult visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
        }

        @NotNull
        public VisitResult visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data);
        }

        @NotNull
        public VisitResult visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitBlockBody(this, body, data);
        }

        @NotNull
        public VisitResult visitBody(@NotNull IrBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitBody(this, body, data);
        }

        @NotNull
        public VisitResult visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitBranch(this, branch, data);
        }

        @NotNull
        public VisitResult visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitBreak(this, jump, data);
        }

        @NotNull
        public VisitResult visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @NotNull
        public VisitResult visitCall(@NotNull IrCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitCall(this, expression2, data);
        }

        @NotNull
        public VisitResult visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @NotNull
        public VisitResult visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @NotNull
        public VisitResult visitClass(@NotNull IrClass declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitClass(this, declaration, data);
        }

        @NotNull
        public VisitResult visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @NotNull
        public VisitResult visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data);
        }

        @NotNull
        public <T> VisitResult visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitConst(this, expression2, data);
        }

        @NotNull
        public VisitResult visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitConstructor(this, declaration, data);
        }

        @NotNull
        public VisitResult visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @NotNull
        public VisitResult visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitContinue(this, jump, data);
        }

        @NotNull
        public VisitResult visitDeclaration(@NotNull IrDeclaration declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration, data);
        }

        @NotNull
        public VisitResult visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @NotNull
        public VisitResult visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @NotNull
        public VisitResult visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @NotNull
        public VisitResult visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @NotNull
        public VisitResult visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @NotNull
        public VisitResult visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration, data);
        }

        @NotNull
        public VisitResult visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @NotNull
        public VisitResult visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration, data);
        }

        @NotNull
        public VisitResult visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @NotNull
        public VisitResult visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data);
        }

        @NotNull
        public VisitResult visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitExpressionBody(this, body, data);
        }

        @NotNull
        public VisitResult visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
        }

        @NotNull
        public VisitResult visitField(@NotNull IrField declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitField(this, declaration, data);
        }

        @NotNull
        public VisitResult visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @NotNull
        public VisitResult visitFile(@NotNull IrFile declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitFile(this, declaration, data);
        }

        @NotNull
        public VisitResult visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitFunction(this, declaration, data);
        }

        @NotNull
        public VisitResult visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @NotNull
        public VisitResult visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @NotNull
        public VisitResult visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @NotNull
        public VisitResult visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @NotNull
        public VisitResult visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data);
        }

        @NotNull
        public VisitResult visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @NotNull
        public VisitResult visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @NotNull
        public VisitResult visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @NotNull
        public VisitResult visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
        }

        @NotNull
        public VisitResult visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @NotNull
        public VisitResult visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitLoop(this, loop2, data);
        }

        @NotNull
        public VisitResult visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @NotNull
        public VisitResult visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration, data);
        }

        @NotNull
        public VisitResult visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration, data);
        }

        @NotNull
        public VisitResult visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitProperty(this, declaration, data);
        }

        @NotNull
        public VisitResult visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @NotNull
        public VisitResult visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data);
        }

        @NotNull
        public VisitResult visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data);
        }

        @NotNull
        public VisitResult visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitSetVariable(this, expression2, data);
        }

        @NotNull
        public VisitResult visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration, data);
        }

        @NotNull
        public VisitResult visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @NotNull
        public VisitResult visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @NotNull
        public VisitResult visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @NotNull
        public VisitResult visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @NotNull
        public VisitResult visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @NotNull
        public VisitResult visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body, data);
        }

        @NotNull
        public VisitResult visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data);
        }

        @NotNull
        public VisitResult visitTry(@NotNull IrTry aTry, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitTry(this, aTry, data);
        }

        @NotNull
        public VisitResult visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration, data);
        }

        @NotNull
        public VisitResult visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @NotNull
        public VisitResult visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration, data);
        }

        @NotNull
        public VisitResult visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @NotNull
        public VisitResult visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration, data);
        }

        @NotNull
        public VisitResult visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data);
        }

        @NotNull
        public VisitResult visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitVariable(this, declaration, data);
        }

        @NotNull
        public VisitResult visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data);
        }

        @NotNull
        public VisitResult visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            return (VisitResult)IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016J\u001e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016J\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016J\u001e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016J\u001e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00192\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016J\u001e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016J\u001e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u001e2\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016J\u001e\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020 2\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016J\u001e\u0010!\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\"2\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016J\u001e\u0010#\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020$2\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016J\u001e\u0010%\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020&2\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016J\u001e\u0010'\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020(2\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016J\u001e\u0010)\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020*2\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016J\u001e\u0010+\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020,2\f\u0010\b\u001a\b\u0018\u00010\tj\u0002`\nH\u0016\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$StatementVisitor;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$DecomposerVisitor;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering;)V", "processStatement", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "statement", "data", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/VisitData;", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$VisitResult;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitBreakContinue", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreakContinue;", "visitContainerExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitField", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetVariable", "Lorg/jetbrains/kotlin/ir/expressions/IrSetVariable;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "BreakContinueUpdater", "backend.js"})
    public final class StatementVisitor
    extends DecomposerVisitor {
        @Override
        @NotNull
        public VisitResult visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            List<IrStatement> $receiver$iv = body.getStatements();
            int i$iv = 0;
            while (i$iv < $receiver$iv.size()) {
                IrStatement item$iv = $receiver$iv.get(i$iv);
                IrStatement it = item$iv;
                List<IrStatement> transformed$iv = this.processStatement(it, data);
                if (transformed$iv == null) {
                    ++i$iv;
                    continue;
                }
                $receiver$iv.addAll(i$iv, (Collection<IrStatement>)transformed$iv);
                $receiver$iv.remove(i$iv += transformed$iv.size());
            }
            return KeptResult.INSTANCE;
        }

        @Override
        @NotNull
        public VisitResult visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            List<IrStatement> $receiver$iv = expression2.getStatements();
            int i$iv = 0;
            while (i$iv < $receiver$iv.size()) {
                IrStatement item$iv = $receiver$iv.get(i$iv);
                IrStatement it = item$iv;
                List<IrStatement> transformed$iv = this.processStatement(it, data);
                if (transformed$iv == null) {
                    ++i$iv;
                    continue;
                }
                $receiver$iv.addAll(i$iv, (Collection<IrStatement>)transformed$iv);
                $receiver$iv.remove(i$iv += transformed$iv.size());
            }
            return KeptResult.INSTANCE;
        }

        private final List<IrStatement> processStatement(IrStatement statement2, Void data) {
            VisitResult result2 = (VisitResult)statement2.accept(this, data);
            if (Intrinsics.areEqual((Object)result2, (Object)KeptResult.INSTANCE)) {
                return statement2 instanceof IrComposite ? ((IrComposite)statement2).getStatements() : null;
            }
            return result2.getStatements();
        }

        @Override
        @NotNull
        public VisitResult visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return (VisitResult)expression2.accept(BlockDecomposerLowering.this.expressionVisitor, data);
        }

        @Override
        @NotNull
        public VisitResult visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            VisitResult expressionResult = (VisitResult)expression2.getValue().accept(BlockDecomposerLowering.this.expressionVisitor, data);
            return expressionResult.runIfChanged((Function1<? super VisitResult, ? extends VisitResult>)((Function1)new Function1<VisitResult, VisitResult>(this, expressionResult, expression2){
                final /* synthetic */ StatementVisitor this$0;
                final /* synthetic */ VisitResult $expressionResult;
                final /* synthetic */ IrReturn $expression;

                @NotNull
                public final VisitResult invoke(@NotNull VisitResult $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    IrExpression returnValue2 = this.$expressionResult.getResultValue();
                    Collection collection = this.$expressionResult.getStatements();
                    IrReturnImpl irReturnImpl = new IrReturnImpl(this.$expression.getStartOffset(), this.$expression.getEndOffset(), this.$expression.getType(), this.$expression.getReturnTargetSymbol(), returnValue2);
                    collection.add(irReturnImpl);
                    return new DecomposedResult(this.$expressionResult.getStatements(), (IrExpression)BlockDecomposerLowering.access$getUnitValue$p(this.this$0.BlockDecomposerLowering.this));
                }
                {
                    this.this$0 = statementVisitor;
                    this.$expressionResult = visitResult;
                    this.$expression = irReturn;
                    super(1);
                }
            }));
        }

        @Override
        @NotNull
        public VisitResult visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            KeptResult keptResult = KeptResult.INSTANCE;
            if (keptResult == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.backend.js.lower.BlockDecomposerLowering.VisitResult");
            }
            return keptResult;
        }

        @Override
        @NotNull
        public VisitResult visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            VisitResult expressionResult = (VisitResult)expression2.getValue().accept(BlockDecomposerLowering.this.expressionVisitor, data);
            return expressionResult.runIfChanged((Function1<? super VisitResult, ? extends VisitResult>)((Function1)new Function1<VisitResult, VisitResult>(this, expressionResult, expression2){
                final /* synthetic */ StatementVisitor this$0;
                final /* synthetic */ VisitResult $expressionResult;
                final /* synthetic */ IrThrow $expression;

                @NotNull
                public final VisitResult invoke(@NotNull VisitResult $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    IrExpression returnValue2 = this.$expressionResult.getResultValue();
                    Collection collection = this.$expressionResult.getStatements();
                    IrThrowImpl irThrowImpl = new IrThrowImpl(this.$expression.getStartOffset(), this.$expression.getEndOffset(), this.$expression.getType(), returnValue2);
                    collection.add(irThrowImpl);
                    return new DecomposedResult(this.$expressionResult.getStatements(), (IrExpression)BlockDecomposerLowering.access$getUnitValue$p(this.this$0.BlockDecomposerLowering.this));
                }
                {
                    this.this$0 = statementVisitor;
                    this.$expressionResult = visitResult;
                    this.$expression = irThrow;
                    super(1);
                }
            }));
        }

        @Override
        @NotNull
        public VisitResult visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrExpression irExpression = declaration.getInitializer();
            if (irExpression != null) {
                IrExpression irExpression2;
                IrExpression it = irExpression2 = irExpression;
                VisitResult initResult = (VisitResult)it.accept(BlockDecomposerLowering.this.expressionVisitor, data);
                return initResult.runIfChanged((Function1<? super VisitResult, ? extends VisitResult>)((Function1)new Function1<VisitResult, VisitResult>(this, data, declaration){
                    final /* synthetic */ StatementVisitor this$0;
                    final /* synthetic */ Void $data$inlined;
                    final /* synthetic */ IrVariable $declaration$inlined;
                    {
                        this.this$0 = statementVisitor;
                        this.$data$inlined = void_;
                        this.$declaration$inlined = irVariable;
                        super(1);
                    }

                    @NotNull
                    public final VisitResult invoke(@NotNull VisitResult $receiver) {
                        IrVariable irVariable;
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        Collection collection = $receiver.getStatements();
                        IrVariable $receiver2 = irVariable = this.$declaration$inlined;
                        $receiver2.setInitializer($receiver.getResultValue());
                        collection.add(irVariable);
                        return new DecomposedResult($receiver.getStatements(), (IrExpression)BlockDecomposerLowering.access$getUnitValue$p(this.this$0.BlockDecomposerLowering.this));
                    }
                }));
            }
            return KeptResult.INSTANCE;
        }

        @Override
        @NotNull
        public VisitResult visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrStatement newWhen2 = BlockDecomposerLowering.this.processWhen(expression2, data, BlockDecomposerLowering.this.expressionVisitor, this, (Function2<? super VisitResult, ? super IrStatement, ? extends List<? extends IrStatement>>)visitWhen.newWhen.1.INSTANCE);
            if (Intrinsics.areEqual((Object)newWhen2, (Object)expression2) ^ true) {
                return new DecomposedResult(newWhen2, (IrExpression)BlockDecomposerLowering.this.unitValue);
            }
            return KeptResult.INSTANCE;
        }

        @Override
        @NotNull
        public VisitResult visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            VisitResult conditionResult = (VisitResult)loop2.getCondition().accept(BlockDecomposerLowering.this.expressionVisitor, data);
            IrExpression irExpression = loop2.getBody();
            VisitResult bodyResult = irExpression != null ? (VisitResult)irExpression.accept(this, data) : null;
            return conditionResult.runIfChanged((Function1<? super VisitResult, ? extends VisitResult>)((Function1)new Function1<VisitResult, VisitResult>(this, bodyResult, conditionResult, loop2){
                final /* synthetic */ StatementVisitor this$0;
                final /* synthetic */ VisitResult $bodyResult;
                final /* synthetic */ VisitResult $conditionResult;
                final /* synthetic */ IrWhileLoop $loop;

                @NotNull
                public final VisitResult invoke(@NotNull VisitResult $receiver) {
                    IrWhileLoopImpl newLoop;
                    block3: {
                        IrWhileLoopImpl irWhileLoopImpl;
                        IrCallImpl irCallImpl;
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        VisitResult visitResult = this.$bodyResult;
                        if (visitResult != null) {
                            boolean bl;
                            VisitResult visitResult2 = visitResult;
                            VisitResult $receiver2 = visitResult2;
                            boolean bl2 = bl = $receiver2.getStatus() == VisitStatus.KEPT;
                            if (_Assertions.ENABLED && !bl) {
                                String string = "Assertion failed";
                                throw (Throwable)((Object)new AssertionError((Object)string));
                            }
                        }
                        IrExpression condVariable = this.$conditionResult.getResultValue();
                        SimpleType simpleType2 = BlockDecomposerLowering.access$getUnitType$p(this.this$0.BlockDecomposerLowering.this);
                        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"unitType");
                        KotlinType kotlinType = simpleType2;
                        SimpleType simpleType3 = BlockDecomposerLowering.access$getUnitType$p(this.this$0.BlockDecomposerLowering.this);
                        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"unitType");
                        IrBlockImpl thenBlock = JsIrBuilder.INSTANCE.buildBlock(kotlinType, CollectionsKt.listOf((Object)JsIrBuilder.INSTANCE.buildBreak(simpleType3, this.$loop)));
                        IrCallImpl $receiver3 = irCallImpl = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.BlockDecomposerLowering.this.getContext().getIrBuiltIns().getBooleanNotSymbol(), null, null, 6, null);
                        $receiver3.putValueArgument(0, condVariable);
                        IrCallImpl breakCond = irCallImpl;
                        List<IrStatement> list2 = $receiver.getStatements();
                        SimpleType simpleType4 = BlockDecomposerLowering.access$getUnitType$p(this.this$0.BlockDecomposerLowering.this);
                        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"unitType");
                        list2.add(JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, simpleType4, breakCond, thenBlock, null, 8, null));
                        IrExpression irExpression = this.$loop.getBody();
                        if (irExpression == null) {
                            Intrinsics.throwNpe();
                        }
                        IrExpression oldBody = irExpression;
                        List newBody = CollectionsKt.plus((Collection)$receiver.getStatements(), (Object)oldBody);
                        IrWhileLoopImpl $receiver4 = irWhileLoopImpl = new IrWhileLoopImpl(this.$loop.getStartOffset(), this.$loop.getEndOffset(), this.$loop.getType(), this.$loop.getOrigin());
                        $receiver4.setLabel(this.$loop.getLabel());
                        $receiver4.setCondition(BlockDecomposerLowering.access$getConstTrue$p(this.this$0.BlockDecomposerLowering.this));
                        IrExpression irExpression2 = oldBody;
                        IrWhileLoopImpl irWhileLoopImpl2 = $receiver4;
                        IrExpression $receiver5 = irExpression2;
                        IrBlockImpl irBlockImpl = new IrBlockImpl($receiver5.getStartOffset(), $receiver5.getEndOffset(), $receiver5.getType(), $receiver4.getOrigin(), newBody);
                        irWhileLoopImpl2.setBody(irBlockImpl);
                        newLoop = irWhileLoopImpl;
                        IrExpression irExpression3 = newLoop.getBody();
                        if (irExpression3 == null) break block3;
                        irExpression3.transform(this.this$0.new BreakContinueUpdater(newLoop, newLoop), this.$loop);
                    }
                    return new DecomposedResult(newLoop, (IrExpression)BlockDecomposerLowering.access$getUnitValue$p(this.this$0.BlockDecomposerLowering.this));
                }
                {
                    this.this$0 = statementVisitor;
                    this.$bodyResult = visitResult;
                    this.$conditionResult = visitResult2;
                    this.$loop = irWhileLoop;
                    super(1);
                }
            }));
        }

        @Override
        @NotNull
        public VisitResult visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrExpression irExpression = loop2.getBody();
            VisitResult bodyResult = irExpression != null ? (VisitResult)irExpression.accept(this, data) : null;
            VisitResult conditionResult = (VisitResult)loop2.getCondition().accept(BlockDecomposerLowering.this.expressionVisitor, data);
            return conditionResult.runIfChanged((Function1<? super VisitResult, ? extends VisitResult>)((Function1)new Function1<VisitResult, VisitResult>(this, bodyResult, loop2, conditionResult){
                final /* synthetic */ StatementVisitor this$0;
                final /* synthetic */ VisitResult $bodyResult;
                final /* synthetic */ IrDoWhileLoop $loop;
                final /* synthetic */ VisitResult $conditionResult;

                @NotNull
                public final VisitResult invoke(@NotNull VisitResult $receiver) {
                    IrDoWhileLoopImpl irDoWhileLoopImpl;
                    IrDoWhileLoopImpl irDoWhileLoopImpl2;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    VisitResult visitResult = this.$bodyResult;
                    if (visitResult != null) {
                        boolean bl;
                        VisitResult visitResult2 = visitResult;
                        VisitResult $receiver2 = visitResult2;
                        boolean bl2 = bl = $receiver2.getStatus() == VisitStatus.KEPT;
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                    }
                    IrExpression irExpression = this.$loop.getBody();
                    if (irExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    IrExpression body = irExpression;
                    int n = this.$loop.getStartOffset();
                    int n2 = this.$loop.getEndOffset();
                    SimpleType simpleType2 = BlockDecomposerLowering.access$getUnitType$p(this.this$0.BlockDecomposerLowering.this);
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"unitType");
                    IrDoWhileLoopImpl $receiver3 = irDoWhileLoopImpl2 = new IrDoWhileLoopImpl(n, n2, simpleType2, this.$loop.getOrigin(), body, BlockDecomposerLowering.access$getConstFalse$p(this.this$0.BlockDecomposerLowering.this));
                    $receiver3.setLabel(this.this$0.BlockDecomposerLowering.this.makeLoopLabel());
                    IrDoWhileLoopImpl innerLoop = irDoWhileLoopImpl2;
                    IrExpression condVariable = this.$conditionResult.getResultValue();
                    IrBlockImpl newBody = JsIrBuilder.INSTANCE.buildBlock(body.getType(), CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)innerLoop), (Iterable)$receiver.getStatements()));
                    int n3 = this.$loop.getStartOffset();
                    int n4 = this.$loop.getEndOffset();
                    SimpleType simpleType3 = BlockDecomposerLowering.access$getUnitType$p(this.this$0.BlockDecomposerLowering.this);
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"unitType");
                    IrDoWhileLoopImpl $receiver4 = irDoWhileLoopImpl = new IrDoWhileLoopImpl(n3, n4, simpleType3, this.$loop.getOrigin(), newBody, condVariable);
                    String string = this.$loop.getLabel();
                    if (string == null) {
                        string = this.this$0.BlockDecomposerLowering.this.makeLoopLabel();
                    }
                    $receiver4.setLabel(string);
                    IrDoWhileLoopImpl newLoop = irDoWhileLoopImpl;
                    body.transform(this.this$0.new BreakContinueUpdater(newLoop, innerLoop), this.$loop);
                    return new DecomposedResult(newLoop, (IrExpression)BlockDecomposerLowering.access$getUnitValue$p(this.this$0.BlockDecomposerLowering.this));
                }
                {
                    this.this$0 = statementVisitor;
                    this.$bodyResult = visitResult;
                    this.$loop = irDoWhileLoop;
                    this.$conditionResult = visitResult2;
                    super(1);
                }
            }));
        }

        @Override
        @NotNull
        public VisitResult visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            VisitResult argumentResult = (VisitResult)expression2.getArgument().accept(BlockDecomposerLowering.this.expressionVisitor, data);
            return argumentResult.runIfChanged((Function1<? super VisitResult, ? extends VisitResult>)((Function1)new Function1<VisitResult, VisitResult>(this, expression2){
                final /* synthetic */ StatementVisitor this$0;
                final /* synthetic */ IrTypeOperatorCall $expression;

                @NotNull
                public final VisitResult invoke(@NotNull VisitResult $receiver) {
                    IrExpression resValue;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    IrTypeOperatorCallImpl newOperator = new IrTypeOperatorCallImpl(this.$expression.getStartOffset(), this.$expression.getEndOffset(), this.$expression.getType(), this.$expression.getOperator(), this.$expression.getTypeOperand(), $receiver.getResultValue(), this.$expression.getTypeOperandClassifier());
                    if (!KotlinBuiltIns.isUnit(this.$expression.getType())) {
                        IrVariableSymbolImpl resVar = this.this$0.BlockDecomposerLowering.this.makeTempVar(this.$expression.getType());
                        Collection collection = $receiver.getStatements();
                        IrVariableImpl irVariableImpl = JsIrBuilder.INSTANCE.buildVar(resVar, newOperator);
                        collection.add(irVariableImpl);
                        resValue = JsIrBuilder.INSTANCE.buildGetValue(resVar);
                    } else {
                        Collection collection = $receiver.getStatements();
                        collection.add(newOperator);
                        resValue = BlockDecomposerLowering.access$getUnitValue$p(this.this$0.BlockDecomposerLowering.this);
                    }
                    return new DecomposedResult($receiver.getStatements(), resValue);
                }
                {
                    this.this$0 = statementVisitor;
                    this.$expression = irTypeOperatorCall;
                    super(1);
                }
            }));
        }

        @Override
        @NotNull
        public VisitResult visitField(@NotNull IrField declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            if (declaration.getInitializer() == null) {
                return KeptResult.INSTANCE;
            }
            IrExpressionBody irExpressionBody = declaration.getInitializer();
            if (irExpressionBody == null) {
                Intrinsics.throwNpe();
            }
            VisitResult result2 = (VisitResult)irExpressionBody.accept(BlockDecomposerLowering.this.expressionVisitor, data);
            return result2.runIfChanged((Function1<? super VisitResult, ? extends VisitResult>)((Function1)visitField.1.INSTANCE));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public VisitResult visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
            void needNew;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            IrExpression irExpression = expression2.getReceiver();
            VisitResult receiverResult = irExpression != null ? (VisitResult)irExpression.accept(BlockDecomposerLowering.this.expressionVisitor, data) : null;
            VisitResult valueResult = (VisitResult)expression2.getValue().accept(BlockDecomposerLowering.this.expressionVisitor, data);
            List newStatements = new ArrayList();
            VisitResult visitResult = receiverResult;
            IrExpression newReceiver2 = visitResult != null ? visitResult.runIfChangedOrDefault(expression2.getReceiver(), (Function2)new Function2<VisitResult, IrExpression, IrExpression>(newStatements, (Ref.BooleanRef)needNew){
                final /* synthetic */ List $newStatements;
                final /* synthetic */ Ref.BooleanRef $needNew;

                @Nullable
                public final IrExpression invoke(@NotNull VisitResult $receiver, @Nullable IrExpression it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Collection collection = this.$newStatements;
                    Iterable iterable = $receiver.getStatements();
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                    this.$needNew.element = true;
                    return $receiver.getResultValue();
                }
                {
                    this.$newStatements = list2;
                    this.$needNew = booleanRef;
                    super(2);
                }
            }) : null;
            IrExpression newValue2 = valueResult.runIfChangedOrDefault(expression2.getValue(), (Function2)new Function2<VisitResult, IrExpression, IrExpression>(newStatements, (Ref.BooleanRef)needNew){
                final /* synthetic */ List $newStatements;
                final /* synthetic */ Ref.BooleanRef $needNew;

                @NotNull
                public final IrExpression invoke(@NotNull VisitResult $receiver, @NotNull IrExpression it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Collection collection = this.$newStatements;
                    Iterable iterable = $receiver.getStatements();
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                    this.$needNew.element = true;
                    return $receiver.getResultValue();
                }
                {
                    this.$newStatements = list2;
                    this.$needNew = booleanRef;
                    super(2);
                }
            });
            if (needNew.element) {
                Collection collection = newStatements;
                IrSetFieldImpl irSetFieldImpl = JsIrBuilder.INSTANCE.buildSetField(expression2.getSymbol(), newReceiver2, newValue2, expression2.getSuperQualifierSymbol());
                collection.add(irSetFieldImpl);
                return new DecomposedResult(newStatements, (IrExpression)BlockDecomposerLowering.this.unitValue);
            }
            return KeptResult.INSTANCE;
        }

        @Override
        @NotNull
        public VisitResult visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            VisitResult valueResult = (VisitResult)expression2.getValue().accept(BlockDecomposerLowering.this.expressionVisitor, data);
            return valueResult.runIfChanged((Function1<? super VisitResult, ? extends VisitResult>)((Function1)new Function1<VisitResult, VisitResult>(this, expression2){
                final /* synthetic */ StatementVisitor this$0;
                final /* synthetic */ IrSetVariable $expression;

                @NotNull
                public final VisitResult invoke(@NotNull VisitResult $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Collection collection = $receiver.getStatements();
                    IrSetVariableImpl irSetVariableImpl = JsIrBuilder.INSTANCE.buildSetVariable(this.$expression.getSymbol(), $receiver.getResultValue());
                    collection.add(irSetVariableImpl);
                    return new DecomposedResult($receiver.getStatements(), (IrExpression)BlockDecomposerLowering.access$getUnitValue$p(this.this$0.BlockDecomposerLowering.this));
                }
                {
                    this.this$0 = statementVisitor;
                    this.$expression = irSetVariable;
                    super(1);
                }
            }));
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$StatementVisitor$BreakContinueUpdater;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "breakLoop", "continueLoop", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$StatementVisitor;Lorg/jetbrains/kotlin/ir/expressions/IrLoop;Lorg/jetbrains/kotlin/ir/expressions/IrLoop;)V", "getBreakLoop", "()Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getContinueLoop", "visitBreak", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "jump", "data", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "backend.js"})
        private final class BreakContinueUpdater
        implements IrElementTransformer<IrLoop> {
            @NotNull
            private final IrLoop breakLoop;
            @NotNull
            private final IrLoop continueLoop;

            @Override
            @NotNull
            public IrBreak visitBreak(@NotNull IrBreak jump, @NotNull IrLoop data) {
                IrBreak irBreak;
                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                IrBreak $receiver = irBreak = jump;
                if (Intrinsics.areEqual((Object)$receiver.getLoop(), (Object)data)) {
                    $receiver.setLoop(this.breakLoop);
                }
                return irBreak;
            }

            @Override
            @NotNull
            public IrContinue visitContinue(@NotNull IrContinue jump, @NotNull IrLoop data) {
                IrContinue irContinue;
                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                IrContinue $receiver = irContinue = jump;
                if (Intrinsics.areEqual((Object)$receiver.getLoop(), (Object)data)) {
                    $receiver.setLoop(this.continueLoop);
                }
                return irContinue;
            }

            @NotNull
            public final IrLoop getBreakLoop() {
                return this.breakLoop;
            }

            @NotNull
            public final IrLoop getContinueLoop() {
                return this.continueLoop;
            }

            public BreakContinueUpdater(@NotNull IrLoop breakLoop, IrLoop continueLoop) {
                Intrinsics.checkParameterIsNotNull((Object)breakLoop, (String)"breakLoop");
                Intrinsics.checkParameterIsNotNull((Object)continueLoop, (String)"continueLoop");
                this.breakLoop = breakLoop;
                this.continueLoop = continueLoop;
            }

            @Override
            @NotNull
            public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
            }

            @Override
            @NotNull
            public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data);
            }

            @Override
            @NotNull
            public IrBody visitBlockBody(@NotNull IrBlockBody body, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitBlockBody(this, body, data);
            }

            @Override
            @NotNull
            public IrBody visitBody(@NotNull IrBody body, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitBody(this, body, data);
            }

            @Override
            @NotNull
            public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
            }

            @Override
            @NotNull
            public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            @Override
            @NotNull
            public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitCall(this, expression2, data);
            }

            @Override
            @NotNull
            public IrElement visitCallableReference(@NotNull IrCallableReference expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            @Override
            @NotNull
            public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
            }

            @Override
            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitClass(this, declaration, data);
            }

            @Override
            @NotNull
            public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
            }

            @Override
            @NotNull
            public <T> IrExpression visitConst(@NotNull IrConst<T> expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
            }

            @Override
            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration, data);
            }

            @Override
            @NotNull
            public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            @Override
            @NotNull
            public IrStatement visitDeclaration(@NotNull IrDeclaration declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, data);
            }

            @Override
            @NotNull
            public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            @Override
            @NotNull
            public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
            }

            @Override
            @NotNull
            public IrElement visitElement(@NotNull IrElement element, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
            }

            @Override
            @NotNull
            public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
            }

            @Override
            @NotNull
            public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            @Override
            @NotNull
            public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data);
            }

            @Override
            @NotNull
            public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            @Override
            @NotNull
            public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data);
            }

            @Override
            @NotNull
            public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
            }

            @Override
            @NotNull
            public IrBody visitExpressionBody(@NotNull IrExpressionBody body, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body, data);
            }

            @Override
            @NotNull
            public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
            }

            @Override
            @NotNull
            public IrStatement visitField(@NotNull IrField declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitField(this, declaration, data);
            }

            @Override
            @NotNull
            public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            @Override
            @NotNull
            public IrFile visitFile(@NotNull IrFile declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data);
            }

            @Override
            @NotNull
            public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, data);
            }

            @Override
            @NotNull
            public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            @Override
            @NotNull
            public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            @Override
            @NotNull
            public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
            }

            @Override
            @NotNull
            public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitLoop(@NotNull IrLoop loop2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data);
            }

            @Override
            @NotNull
            public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            @Override
            @NotNull
            public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data);
            }

            @Override
            @NotNull
            public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data);
            }

            @Override
            @NotNull
            public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data);
            }

            @Override
            @NotNull
            public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitSetVariable(@NotNull IrSetVariable expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSetVariable(this, expression2, data);
            }

            @Override
            @NotNull
            public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data);
            }

            @Override
            @NotNull
            public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            @Override
            @NotNull
            public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            @Override
            @NotNull
            public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            @Override
            @NotNull
            public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body, data);
            }

            @Override
            @NotNull
            public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitTry(@NotNull IrTry aTry, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
            }

            @Override
            @NotNull
            public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data);
            }

            @Override
            @NotNull
            public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
            }

            @Override
            @NotNull
            public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data);
            }

            @Override
            @NotNull
            public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            @Override
            @NotNull
            public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data);
            }

            @Override
            @NotNull
            public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
            }

            @Override
            @NotNull
            public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data);
            }

            @Override
            @NotNull
            public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data);
            }

            @Override
            @NotNull
            public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull IrLoop data) {
                Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003JD\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u001c\u0010\u0007\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u00052\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J&\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002JK\u0010\u0014\u001a\u00020\u0015\"\b\b\u0000\u0010\u0016*\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00062!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u0002H\u00160\u00192\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0002J\u001e\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020\u00062\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u0010'\u001a\u00020\t2\u0006\u0010#\u001a\u00020(2\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u0010)\u001a\u00020\t2\u0006\u0010#\u001a\u00020*2\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u0010+\u001a\u00020\t2\u0006\u0010#\u001a\u00020,2\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020/2\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u00100\u001a\u00020\u00152\u0006\u0010#\u001a\u0002012\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u00102\u001a\u00020\t2\u0006\u0010#\u001a\u0002032\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u00104\u001a\u00020\t2\u0006\u0010#\u001a\u0002052\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u00106\u001a\u00020\t2\u0006\u0010#\u001a\u0002072\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u00108\u001a\u00020\u00152\u0006\u0010#\u001a\u0002092\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020<2\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u0010=\u001a\u00020\t2\u0006\u0010#\u001a\u00020>2\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016J\u001e\u0010?\u001a\u00020\t2\u0006\u0010#\u001a\u00020@2\f\u0010\u001c\u001a\b\u0018\u00010\u001dj\u0002`\u001eH\u0016\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$ExpressionVisitor;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$DecomposerVisitor;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering;)V", "mapArguments", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "argResults", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$VisitResult;", "toDecompose", "", "newStatements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "prepareArgument", "arg", "needWrap", "", "statements", "transformTermination", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$TerminatedResult;", "T", "value", "instantiater", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "data", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/VisitData;", "visitBreakContinue", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreakContinue;", "visitContainerExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitExpression", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BlockDecomposerLowering$KeptResult;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "visitGetClass", "Lorg/jetbrains/kotlin/ir/expressions/IrGetClass;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetVariable", "Lorg/jetbrains/kotlin/ir/expressions/IrSetVariable;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "backend.js"})
    public final class ExpressionVisitor
    extends DecomposerVisitor {
        @Override
        @NotNull
        public KeptResult visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return KeptResult.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public VisitResult visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
            DecomposedResult decomposedResult;
            IrStatement statement2;
            IrContainerExpressionBase irContainerExpressionBase;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrVariableSymbolImpl variable2 = BlockDecomposerLowering.this.makeTempVar(expression2.getType());
            IrVariableImpl varDeclaration = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, variable2, null, 2, null);
            List<IrStatement> blockStatements = expression2.getStatements();
            IrStatement lastStatement = (IrStatement)CollectionsKt.lastOrNull(blockStatements);
            IrContainerExpression irContainerExpression = expression2;
            if (irContainerExpression instanceof IrBlock) {
                int n = expression2.getStartOffset();
                int n2 = expression2.getEndOffset();
                SimpleType simpleType2 = BlockDecomposerLowering.this.unitType;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"unitType");
                irContainerExpressionBase = new IrBlockImpl(n, n2, simpleType2, expression2.getOrigin());
            } else if (irContainerExpression instanceof IrComposite) {
                int n = expression2.getStartOffset();
                int n3 = expression2.getEndOffset();
                SimpleType simpleType3 = BlockDecomposerLowering.this.unitType;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"unitType");
                irContainerExpressionBase = new IrCompositeImpl(n, n3, simpleType3, expression2.getOrigin());
            } else {
                String string = "Unsupported block type";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            IrContainerExpressionBase body = irContainerExpressionBase;
            List<IrStatement> collectingList = body.getStatements();
            int n = 0;
            int n4 = blockStatements.size() - 1;
            while (n < n4) {
                void i;
                statement2 = blockStatements.get((int)i);
                VisitResult tempResult = (VisitResult)statement2.accept(BlockDecomposerLowering.this.statementVisitor, data);
                Collection collection = collectingList;
                Iterable iterable = tempResult.runIfChangedOrDefault(CollectionsKt.listOf((Object)statement2), visitContainerExpression.1.INSTANCE);
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                ++i;
            }
            if (lastStatement != null) {
                IrExpression result2 = ((VisitResult)lastStatement.accept(BlockDecomposerLowering.this.expressionVisitor, data)).runIfChangedOrDefault((IrExpression)lastStatement, (Function2)new Function2<VisitResult, IrExpression, IrExpression>(collectingList){
                    final /* synthetic */ List $collectingList;

                    @NotNull
                    public final IrExpression invoke(@NotNull VisitResult $receiver, @NotNull IrExpression it) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Collection collection = this.$collectingList;
                        Iterable iterable = $receiver.getStatements();
                        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                        return $receiver.getResultValue();
                    }
                    {
                        this.$collectingList = list2;
                        super(2);
                    }
                });
                Collection collection = collectingList;
                statement2 = JsIrBuilder.INSTANCE.buildSetVariable(variable2, result2);
                collection.add(statement2);
                if (body instanceof IrComposite) {
                    void $receiver$iv;
                    SpreadBuilder spreadBuilder = new SpreadBuilder(2);
                    spreadBuilder.add((Object)varDeclaration);
                    collection = collectingList;
                    SpreadBuilder spreadBuilder2 = spreadBuilder;
                    SpreadBuilder spreadBuilder3 = spreadBuilder;
                    void v8 = $receiver$iv;
                    if (v8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    void thisCollection$iv = v8;
                    IrStatement[] irStatementArray = thisCollection$iv.toArray(new IrStatement[0]);
                    if (irStatementArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    IrStatement[] irStatementArray2 = irStatementArray;
                    SpreadBuilder spreadBuilder4 = spreadBuilder3;
                    spreadBuilder2.addSpread((Object)irStatementArray2);
                    IrExpression irExpression = JsIrBuilder.INSTANCE.buildGetValue(variable2);
                    List list2 = CollectionsKt.mutableListOf((Object[])((IrStatement[])spreadBuilder4.toArray((Object[])new IrStatement[spreadBuilder4.size()])));
                    decomposedResult = new DecomposedResult(list2, irExpression);
                } else {
                    decomposedResult = new DecomposedResult(CollectionsKt.mutableListOf((Object[])new IrStatement[]{varDeclaration, body}), (IrExpression)JsIrBuilder.INSTANCE.buildGetValue(variable2));
                }
            } else {
                List list3 = new ArrayList();
                IrExpression irExpression = BlockDecomposerLowering.this.unitValue;
                List list4 = list3;
                decomposedResult = new DecomposedResult(list4, irExpression);
            }
            return decomposedResult;
        }

        @Override
        @NotNull
        public VisitResult visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            VisitResult res2 = super.visitGetClass(expression2, data);
            return res2.runIfChanged((Function1<? super VisitResult, ? extends VisitResult>)((Function1)new Function1<VisitResult, VisitResult>(expression2){
                final /* synthetic */ IrGetClass $expression;

                @NotNull
                public final VisitResult invoke(@NotNull VisitResult $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    return new DecomposedResult($receiver.getStatements(), (IrExpression)JsIrBuilder.INSTANCE.buildGetClass($receiver.getResultValue(), this.$expression.getType()));
                }
                {
                    this.$expression = irGetClass;
                    super(1);
                }
            }));
        }

        @Override
        @NotNull
        public VisitResult visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            VisitResult res2 = super.visitGetField(expression2, data);
            return res2.runIfChanged((Function1<? super VisitResult, ? extends VisitResult>)((Function1)new Function1<VisitResult, VisitResult>(expression2){
                final /* synthetic */ IrGetField $expression;

                @NotNull
                public final VisitResult invoke(@NotNull VisitResult $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    return new DecomposedResult($receiver.getStatements(), (IrExpression)JsIrBuilder.INSTANCE.buildGetField(this.$expression.getSymbol(), $receiver.getResultValue(), this.$expression.getSuperQualifierSymbol()));
                }
                {
                    this.$expression = irGetField;
                    super(1);
                }
            }));
        }

        private final IrExpression prepareArgument(IrExpression arg, boolean needWrap, List<IrStatement> statements) {
            IrExpression irExpression;
            if (needWrap) {
                IrVariableSymbolImpl wrapVar = BlockDecomposerLowering.this.makeTempVar(arg.getType());
                Collection collection = statements;
                IrVariableImpl irVariableImpl = JsIrBuilder.INSTANCE.buildVar(wrapVar, arg);
                collection.add(irVariableImpl);
                irExpression = JsIrBuilder.INSTANCE.buildGetValue(wrapVar);
            } else {
                irExpression = arg;
            }
            return irExpression;
        }

        /*
         * WARNING - void declaration
         */
        private final List<IrExpression> mapArguments(List<? extends Pair<? extends IrExpression, ? extends VisitResult>> argResults, int toDecompose, List<IrStatement> newStatements) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            Iterable iterable = $receiver$iv = (Iterable)argResults;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                IrExpression irExpression;
                void decomposed;
                boolean needWrap;
                void $original_result;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                IrExpression original = (IrExpression)$original_result.component1();
                VisitResult result2 = (VisitResult)$original_result.component2();
                boolean bl = needWrap = decomposed.element < toDecompose;
                if (original != null) {
                    IrExpression irExpression2;
                    IrExpression it = irExpression2;
                    VisitResult visitResult = result2;
                    if (visitResult == null) {
                        Intrinsics.throwNpe();
                    }
                    IrExpression evaluated = visitResult.runIfChangedOrDefault(it, (Function2)new Function2<VisitResult, IrExpression, IrExpression>(result2, needWrap, this, (Ref.IntRef)decomposed, toDecompose, newStatements){
                        final /* synthetic */ VisitResult $result$inlined;
                        final /* synthetic */ boolean $needWrap$inlined;
                        final /* synthetic */ ExpressionVisitor this$0;
                        final /* synthetic */ Ref.IntRef $decomposed$inlined;
                        final /* synthetic */ int $toDecompose$inlined;
                        final /* synthetic */ List $newStatements$inlined;
                        {
                            this.$result$inlined = visitResult;
                            this.$needWrap$inlined = bl;
                            this.this$0 = expressionVisitor2;
                            this.$decomposed$inlined = intRef;
                            this.$toDecompose$inlined = n;
                            this.$newStatements$inlined = list2;
                            super(2);
                        }

                        @NotNull
                        public final IrExpression invoke(@NotNull VisitResult $receiver, @NotNull IrExpression it) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            Collection collection = this.$newStatements$inlined;
                            Iterable iterable = $receiver.getStatements();
                            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                            int n = this.$decomposed$inlined.element;
                            this.$decomposed$inlined.element = n + 1;
                            return $receiver.getResultValue();
                        }
                    });
                    irExpression = this.prepareArgument(evaluated, needWrap, newStatements);
                } else {
                    irExpression = null;
                }
                IrExpression irExpression3 = irExpression;
                collection.add(irExpression3);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public VisitResult visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
            IrExpression irExpression;
            IrExpression newExtensionReceiverValue2;
            IrExpression irExpression2;
            IrExpression newDispatchReceiverValue2;
            Pair pair;
            IrExpression arg;
            List list2;
            void argsCounter;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            Object object = expression2.getDispatchReceiver();
            VisitResult dispatchResult2 = object != null && (object = (VisitResult)object.accept(this, data)) != null ? ((VisitResult)object).applyIfChanged((Function1<? super VisitResult, Unit>)((Function1)new Function1<VisitResult, Unit>((Ref.IntRef)argsCounter){
                final /* synthetic */ Ref.IntRef $argsCounter;

                public final void invoke(@NotNull VisitResult $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    int n = this.$argsCounter.element;
                    this.$argsCounter.element = n + 1;
                }
                {
                    this.$argsCounter = intRef;
                    super(1);
                }
            })) : null;
            Object object2 = expression2.getExtensionReceiver();
            VisitResult extensionResult2 = object2 != null && (object2 = (VisitResult)object2.accept(this, data)) != null ? ((VisitResult)object2).applyIfChanged((Function1<? super VisitResult, Unit>)((Function1)new Function1<VisitResult, Unit>((Ref.IntRef)argsCounter){
                final /* synthetic */ Ref.IntRef $argsCounter;

                public final void invoke(@NotNull VisitResult $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    int n = this.$argsCounter.element;
                    this.$argsCounter.element = n + 1;
                }
                {
                    this.$argsCounter = intRef;
                    super(1);
                }
            })) : null;
            List it = list2 = (List)new ArrayList();
            int n = 0;
            int n2 = expression2.getValueArgumentsCount();
            while (n < n2) {
                void i;
                arg = expression2.getValueArgument((int)i);
                Object object3 = arg;
                VisitResult result2 = object3 != null && (object3 = (VisitResult)object3.accept(this, data)) != null ? ((VisitResult)object3).applyIfChanged((Function1<? super VisitResult, Unit>)((Function1)new Function1<VisitResult, Unit>(this, expression2, data, (Ref.IntRef)argsCounter){
                    final /* synthetic */ ExpressionVisitor this$0;
                    final /* synthetic */ IrFunctionAccessExpression $expression$inlined;
                    final /* synthetic */ Void $data$inlined;
                    final /* synthetic */ Ref.IntRef $argsCounter$inlined;
                    {
                        this.this$0 = expressionVisitor2;
                        this.$expression$inlined = irFunctionAccessExpression;
                        this.$data$inlined = void_;
                        this.$argsCounter$inlined = intRef;
                        super(1);
                    }

                    public final void invoke(@NotNull VisitResult $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        int n = this.$argsCounter$inlined.element;
                        this.$argsCounter$inlined.element = n + 1;
                    }
                })) : null;
                Collection collection = it;
                pair = new Pair((Object)arg, result2);
                collection.add(pair);
                ++i;
            }
            List argumentResults = list2;
            if (argsCounter.element == 0) {
                return KeptResult.INSTANCE;
            }
            List newStatements = new ArrayList();
            boolean needWrapDR = argsCounter.element != 0;
            VisitResult visitResult = dispatchResult2;
            IrExpression irExpression3 = newDispatchReceiverValue2 = visitResult != null ? visitResult.runIfChangedOrDefault(expression2.getDispatchReceiver(), (Function2)new Function2<VisitResult, IrExpression, IrExpression>(newStatements, (Ref.IntRef)argsCounter){
                final /* synthetic */ List $newStatements;
                final /* synthetic */ Ref.IntRef $argsCounter;

                @Nullable
                public final IrExpression invoke(@NotNull VisitResult $receiver, @Nullable IrExpression it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Collection collection = this.$newStatements;
                    Iterable iterable = $receiver.getStatements();
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                    int n = this.$argsCounter.element;
                    this.$argsCounter.element = n + -1;
                    return $receiver.getResultValue();
                }
                {
                    this.$newStatements = list2;
                    this.$argsCounter = intRef;
                    super(2);
                }
            }) : null;
            if (irExpression3 != null) {
                IrExpression it2 = arg = irExpression3;
                irExpression2 = this.prepareArgument(it2, needWrapDR, newStatements);
            } else {
                irExpression2 = null;
            }
            IrExpression newDispatchReceiver = irExpression2;
            boolean needWrapER = argsCounter.element != 0;
            VisitResult visitResult2 = extensionResult2;
            IrExpression irExpression4 = newExtensionReceiverValue2 = visitResult2 != null ? visitResult2.runIfChangedOrDefault(expression2.getExtensionReceiver(), (Function2)new Function2<VisitResult, IrExpression, IrExpression>(newStatements, (Ref.IntRef)argsCounter){
                final /* synthetic */ List $newStatements;
                final /* synthetic */ Ref.IntRef $argsCounter;

                @Nullable
                public final IrExpression invoke(@NotNull VisitResult $receiver, @Nullable IrExpression it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Collection collection = this.$newStatements;
                    Iterable iterable = $receiver.getStatements();
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                    int n = this.$argsCounter.element;
                    this.$argsCounter.element = n + -1;
                    return $receiver.getResultValue();
                }
                {
                    this.$newStatements = list2;
                    this.$argsCounter = intRef;
                    super(2);
                }
            }) : null;
            if (irExpression4 != null) {
                Pair it3 = pair = irExpression4;
                irExpression = this.prepareArgument((IrExpression)it3, needWrapER, newStatements);
            } else {
                irExpression = null;
            }
            IrExpression newExtensionReceiver = irExpression;
            List<IrExpression> newArguments = this.mapArguments(argumentResults, argsCounter.element, newStatements);
            expression2.setDispatchReceiver(newDispatchReceiver);
            expression2.setExtensionReceiver(newExtensionReceiver);
            Iterable $receiver$iv = newArguments;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void v;
                int n3 = index$iv++;
                IrExpression irExpression5 = (IrExpression)item$iv;
                int i = n3;
                expression2.putValueArgument(i, (IrExpression)v);
            }
            IrVariableSymbolImpl resultVar = BlockDecomposerLowering.this.makeTempVar(expression2.getType());
            Collection collection = newStatements;
            IrVariableImpl irVariableImpl = JsIrBuilder.INSTANCE.buildVar(resultVar, expression2);
            collection.add(irVariableImpl);
            return new DecomposedResult(newStatements, (IrExpression)JsIrBuilder.INSTANCE.buildGetValue(resultVar));
        }

        @Override
        @NotNull
        public VisitResult visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrVariableSymbolImpl collectiveVar = BlockDecomposerLowering.this.makeTempVar(expression2.getType());
            IrVariableImpl varDeclaration = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, collectiveVar, null, 2, null);
            IrStatement newWhen2 = BlockDecomposerLowering.this.processWhen(expression2, data, this, this, (Function2<? super VisitResult, ? super IrStatement, ? extends List<? extends IrStatement>>)((Function2)new Function2<VisitResult, IrStatement, List<? extends IrStatement>>(collectiveVar){
                final /* synthetic */ IrVariableSymbolImpl $collectiveVar;

                @NotNull
                public final List<IrStatement> invoke(@NotNull VisitResult visitResult, @NotNull IrStatement original) {
                    List list2;
                    Intrinsics.checkParameterIsNotNull((Object)visitResult, (String)"visitResult");
                    Intrinsics.checkParameterIsNotNull((Object)original, (String)"original");
                    List resultList = new ArrayList<E>();
                    IrExpression newResult2 = visitResult.runIfChangedOrDefault((IrExpression)original, (Function2)new Function2<VisitResult, IrExpression, IrExpression>(resultList){
                        final /* synthetic */ List $resultList;

                        @NotNull
                        public final IrExpression invoke(@NotNull VisitResult $receiver, @NotNull IrExpression it) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            Collection collection = this.$resultList;
                            Iterable iterable = $receiver.getStatements();
                            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                            return $receiver.getResultValue();
                        }
                        {
                            this.$resultList = list2;
                            super(2);
                        }
                    });
                    List $receiver = list2 = resultList;
                    $receiver.add(JsIrBuilder.INSTANCE.buildSetVariable(this.$collectiveVar, newResult2));
                    return list2;
                }
                {
                    this.$collectiveVar = irVariableSymbolImpl;
                    super(2);
                }
            }));
            if (Intrinsics.areEqual((Object)newWhen2, (Object)expression2) ^ true) {
                return new DecomposedResult(CollectionsKt.mutableListOf((Object[])new IrStatement[]{varDeclaration, newWhen2}), (IrExpression)JsIrBuilder.INSTANCE.buildGetValue(collectiveVar));
            }
            return KeptResult.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public VisitResult visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
            void $receiver$iv$iv;
            Object object;
            void decomposed;
            Collection collection;
            void $receiver$iv$iv2;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            Iterable iterable = $receiver$iv = (Iterable)expression2.getElements();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                IrVarargElement irVarargElement;
                void it;
                IrVarargElement irVarargElement2 = (IrVarargElement)item$iv$iv;
                collection = destination$iv$iv;
                Object v0 = it;
                if (!(v0 instanceof IrSpreadElement)) {
                    v0 = null;
                }
                if ((irVarargElement = (IrSpreadElement)v0) == null || (irVarargElement = irVarargElement.getExpression()) == null) {
                    void v2 = it;
                    if (v2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                    }
                    irVarargElement = (IrExpression)v2;
                }
                IrVarargElement expr = irVarargElement;
                object = new Pair((Object)it, (Object)((VisitResult)expr.accept(this, data)).applyIfChanged((Function1<? super VisitResult, Unit>)((Function1)new Function1<VisitResult, Unit>(this, data, (Ref.IntRef)decomposed){
                    final /* synthetic */ ExpressionVisitor this$0;
                    final /* synthetic */ Void $data$inlined;
                    final /* synthetic */ Ref.IntRef $decomposed$inlined;
                    {
                        this.this$0 = expressionVisitor2;
                        this.$data$inlined = void_;
                        this.$decomposed$inlined = intRef;
                        super(1);
                    }

                    public final void invoke(@NotNull VisitResult $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        int n = this.$decomposed$inlined.element;
                        this.$decomposed$inlined.element = n + 1;
                    }
                })));
                collection.add(object);
            }
            List arguments2 = (List)destination$iv$iv;
            if (decomposed.element == 0) {
                return KeptResult.INSTANCE;
            }
            List newStatements = new ArrayList();
            Iterable $receiver$iv2 = arguments2;
            Iterable iterable2 = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                IrVarargElement irVarargElement;
                void $original_result;
                Pair $i$a$1$map = (Pair)item$iv$iv;
                collection = destination$iv$iv2;
                IrVarargElement original = (IrVarargElement)$original_result.component1();
                VisitResult result2 = (VisitResult)$original_result.component2();
                if (decomposed.element == 0) {
                    irVarargElement = original;
                } else {
                    IrVariableImpl irVariableImpl;
                    IrVarargElement irVarargElement3;
                    IrVarargElement irVarargElement4 = original;
                    if (!(irVarargElement4 instanceof IrSpreadElement)) {
                        irVarargElement4 = null;
                    }
                    if ((irVarargElement3 = (IrSpreadElement)irVarargElement4) == null || (irVarargElement3 = irVarargElement3.getExpression()) == null) {
                        IrVarargElement irVarargElement5 = original;
                        if (irVarargElement5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                        }
                        irVarargElement3 = (IrExpression)irVarargElement5;
                    }
                    IrVarargElement originalExpression = irVarargElement3;
                    IrExpression newExpression = (IrExpression)((Object)result2.runIfChangedOrDefault(originalExpression, (Function2)new Function2<VisitResult, IrExpression, IrExpression>(this, (Ref.IntRef)decomposed, newStatements, expression2){
                        final /* synthetic */ ExpressionVisitor this$0;
                        final /* synthetic */ Ref.IntRef $decomposed$inlined;
                        final /* synthetic */ List $newStatements$inlined;
                        final /* synthetic */ IrVararg $expression$inlined;
                        {
                            this.this$0 = expressionVisitor2;
                            this.$decomposed$inlined = intRef;
                            this.$newStatements$inlined = list2;
                            this.$expression$inlined = irVararg;
                            super(2);
                        }

                        @NotNull
                        public final IrExpression invoke(@NotNull VisitResult $receiver, @NotNull IrExpression it) {
                            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            Collection collection = this.$newStatements$inlined;
                            Iterable iterable = $receiver.getStatements();
                            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                            int n = this.$decomposed$inlined.element;
                            this.$decomposed$inlined.element = n + -1;
                            return $receiver.getResultValue();
                        }
                    }));
                    IrVariableSymbolImpl wrapVar = BlockDecomposerLowering.this.makeTempVar(expression2.getVarargElementType());
                    Collection collection2 = newStatements;
                    IrVariableImpl $receiver = irVariableImpl = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, wrapVar, null, 2, null);
                    $receiver.setInitializer(newExpression);
                    collection2.add(irVariableImpl);
                    IrGetValueImpl newValue2 = JsIrBuilder.INSTANCE.buildGetValue(wrapVar);
                    irVarargElement = (IrVarargElement)(original instanceof IrSpreadElement ? (IrElement)new IrSpreadElementImpl(original.getStartOffset(), original.getEndOffset(), newValue2) : (IrElement)newValue2);
                }
                object = irVarargElement;
                collection.add(object);
            }
            List newArguments = (List)destination$iv$iv2;
            IrVarargImpl newExpression = new IrVarargImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), expression2.getVarargElementType(), newArguments);
            return new DecomposedResult(newStatements, (IrExpression)newExpression);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public VisitResult visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
            Collection<void> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            void decomposed;
            Object item$iv$iv2;
            void $receiver$iv$iv2;
            Iterable $receiver$iv2;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            Iterable iterable = $receiver$iv2 = (Iterable)expression2.getArguments();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                void it;
                IrExpression irExpression = (IrExpression)item$iv$iv2;
                Collection collection2 = destination$iv$iv;
                Pair pair = new Pair((Object)it, (Object)((VisitResult)it.accept(this, data)).applyIfChanged((Function1<? super VisitResult, Unit>)((Function1)new Function1<VisitResult, Unit>(this, data, (Ref.IntRef)decomposed){
                    final /* synthetic */ ExpressionVisitor this$0;
                    final /* synthetic */ Void $data$inlined;
                    final /* synthetic */ Ref.IntRef $decomposed$inlined;
                    {
                        this.this$0 = expressionVisitor2;
                        this.$data$inlined = void_;
                        this.$decomposed$inlined = intRef;
                        super(1);
                    }

                    public final void invoke(@NotNull VisitResult $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        int n = this.$decomposed$inlined.element;
                        this.$decomposed$inlined.element = n + 1;
                    }
                })));
                collection2.add(pair);
            }
            List arguments2 = (List)destination$iv$iv;
            if (decomposed.element == 0) {
                return KeptResult.INSTANCE;
            }
            List newStatements = new ArrayList();
            List<IrExpression> newArguments = this.mapArguments(arguments2, decomposed.element, newStatements);
            Iterable iterable2 = newArguments;
            KotlinType kotlinType = expression2.getType();
            int n = expression2.getEndOffset();
            int n2 = expression2.getStartOffset();
            item$iv$iv2 = $receiver$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv3 : $receiver$iv$iv) {
                void var23_20;
                void it;
                IrExpression $i$f$map = (IrExpression)item$iv$iv3;
                collection = destination$iv$iv2;
                if (it == null) {
                    Intrinsics.throwNpe();
                }
                collection.add(var23_20);
            }
            collection = (List)destination$iv$iv2;
            Collection collection3 = collection;
            KotlinType kotlinType2 = kotlinType;
            int n3 = n;
            int n4 = n2;
            IrStringConcatenationImpl newExpression = new IrStringConcatenationImpl(n4, n3, kotlinType2, collection3);
            return new DecomposedResult(newStatements, (IrExpression)newExpression);
        }

        private final <T extends IrStatement> TerminatedResult transformTermination(IrExpression value, Function1<? super IrExpression, ? extends T> instantiater, Void data) {
            VisitResult valueResult = (VisitResult)value.accept(this, data);
            List newStatements = new ArrayList();
            IrExpression returnValue2 = valueResult.runIfChangedOrDefault(value, (Function2)new Function2<VisitResult, IrExpression, IrExpression>(newStatements){
                final /* synthetic */ List $newStatements;

                @NotNull
                public final IrExpression invoke(@NotNull VisitResult $receiver, @NotNull IrExpression it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Collection collection = this.$newStatements;
                    Iterable iterable = $receiver.getStatements();
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                    return $receiver.getResultValue();
                }
                {
                    this.$newStatements = list2;
                    super(2);
                }
            });
            Collection collection = newStatements;
            Object object = instantiater.invoke((Object)returnValue2);
            collection.add(object);
            return new TerminatedResult(newStatements, JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, BlockDecomposerLowering.this.unreachableFunction, null, null, 6, null));
        }

        @Override
        @NotNull
        public TerminatedResult visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return this.transformTermination(expression2.getValue(), (Function1)new Function1<IrExpression, IrReturnImpl>(expression2){
                final /* synthetic */ IrReturn $expression;

                @NotNull
                public final IrReturnImpl invoke(@NotNull IrExpression v) {
                    Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
                    return new IrReturnImpl(this.$expression.getStartOffset(), this.$expression.getEndOffset(), this.$expression.getType(), this.$expression.getReturnTargetSymbol(), v);
                }
                {
                    this.$expression = irReturn;
                    super(1);
                }
            }, data);
        }

        @Override
        @NotNull
        public TerminatedResult visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            return this.transformTermination(expression2.getValue(), (Function1)new Function1<IrExpression, IrThrowImpl>(expression2){
                final /* synthetic */ IrThrow $expression;

                @NotNull
                public final IrThrowImpl invoke(@NotNull IrExpression v) {
                    Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
                    return new IrThrowImpl(this.$expression.getStartOffset(), this.$expression.getEndOffset(), this.$expression.getType(), v);
                }
                {
                    this.$expression = irThrow;
                    super(1);
                }
            }, data);
        }

        @Override
        @NotNull
        public VisitResult visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            return new DecomposedResult(jump, (IrExpression)JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, BlockDecomposerLowering.this.unreachableFunction, null, null, 6, null));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public VisitResult visitTry(@NotNull IrTry aTry, @Nullable Void data) {
            IrTry irTry;
            void $receiver$iv$iv;
            IrBlockImpl $i$a$1$map;
            VisitResult finallyResult;
            Object object;
            Collection collection;
            Object item$iv$iv;
            VisitResult $receiver$iv$iv2;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            VisitResult tryResult = (VisitResult)aTry.getTryResult().accept(BlockDecomposerLowering.this.expressionVisitor, data);
            Iterable iterable = $receiver$iv = (Iterable)aTry.getCatches();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator2 = $receiver$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                void it;
                item$iv$iv = iterator2.next();
                IrCatch irCatch = (IrCatch)item$iv$iv;
                collection = destination$iv$iv;
                object = new Pair((Object)it, it.getResult().accept(BlockDecomposerLowering.this.expressionVisitor, data));
                collection.add(object);
            }
            List catchResults = (List)destination$iv$iv;
            IrExpression irExpression = aTry.getFinallyExpression();
            VisitResult visitResult = finallyResult = irExpression != null ? (VisitResult)irExpression.accept(BlockDecomposerLowering.this.statementVisitor, data) : null;
            if (visitResult != null) {
                boolean bl;
                $receiver$iv$iv2 = visitResult;
                VisitResult $receiver = $receiver$iv$iv2;
                boolean bl2 = bl = $receiver.getStatus() == VisitStatus.KEPT;
                if (_Assertions.ENABLED && !bl) {
                    item$iv$iv = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError(item$iv$iv));
                }
            }
            IrVariableSymbolImpl resultSymbol = BlockDecomposerLowering.this.makeTempVar(aTry.getType());
            IrVariableImpl resultDeclaration = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, resultSymbol, null, 2, null);
            IrExpression newTryValue2 = tryResult.runIfChangedOrDefault(aTry.getTryResult(), visitTry.newTryValue.1.INSTANCE);
            IrSetVariableImpl irSetVariableImpl = JsIrBuilder.INSTANCE.buildSetVariable(resultSymbol, newTryValue2);
            if (irSetVariableImpl == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
            }
            IrStatement trySetResult = irSetVariableImpl;
            int n = aTry.getTryResult().getStartOffset();
            int n2 = aTry.getTryResult().getEndOffset();
            SimpleType simpleType2 = BlockDecomposerLowering.this.unitType;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"unitType");
            IrBlockImpl $receiver = $i$a$1$map = new IrBlockImpl(n, n2, simpleType2, null, 8, null);
            Iterable $i$f$map = $receiver.getStatements();
            Iterable iterable2 = tryResult.runIfChangedOrDefault(CollectionsKt.listOf((Object)trySetResult), (Function2)new Function2<VisitResult, List<? extends IrStatement>, List<? extends IrStatement>>(tryResult, trySetResult){
                final /* synthetic */ VisitResult $tryResult$inlined;
                final /* synthetic */ IrStatement $trySetResult$inlined;
                {
                    this.$tryResult$inlined = visitResult;
                    this.$trySetResult$inlined = irStatement;
                    super(2);
                }

                @NotNull
                public final List<IrStatement> invoke(@NotNull VisitResult $receiver, @NotNull List<? extends IrStatement> it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    return CollectionsKt.plus((Collection)$receiver.getStatements(), (Object)this.$trySetResult$inlined);
                }
            });
            CollectionsKt.addAll((Collection)$i$f$map, (Iterable)iterable2);
            IrBlockImpl tryBlock = $i$a$1$map;
            Iterable $receiver$iv2 = catchResults;
            $i$f$map = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                void $original_result;
                Pair pair = (Pair)item$iv$iv2;
                collection = destination$iv$iv2;
                IrCatch original = (IrCatch)$original_result.component1();
                VisitResult result2 = (VisitResult)$original_result.component2();
                IrExpression newCatchResult2 = result2.runIfChangedOrDefault(original.getResult(), visitTry.catchBlocks.1.newCatchResult.1.INSTANCE);
                IrSetVariableImpl irSetVariableImpl2 = JsIrBuilder.INSTANCE.buildSetVariable(resultSymbol, newCatchResult2);
                if (irSetVariableImpl2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
                }
                IrStatement catchSetResult = irSetVariableImpl2;
                int n3 = original.getResult().getStartOffset();
                int n4 = original.getResult().getEndOffset();
                SimpleType simpleType3 = BlockDecomposerLowering.this.unitType;
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"unitType");
                IrBlockImpl catchBlock = new IrBlockImpl(n3, n4, simpleType3, null, 8, null);
                Collection collection2 = catchBlock.getStatements();
                Iterable iterable3 = result2.runIfChangedOrDefault(CollectionsKt.listOf((Object)catchSetResult), (Function2)new Function2<VisitResult, List<? extends IrStatement>, List<? extends IrStatement>>(catchSetResult){
                    final /* synthetic */ IrStatement $catchSetResult;

                    @NotNull
                    public final List<IrStatement> invoke(@NotNull VisitResult $receiver, @NotNull List<? extends IrStatement> it) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        return CollectionsKt.plus((Collection)$receiver.getStatements(), (Object)this.$catchSetResult);
                    }
                    {
                        this.$catchSetResult = irStatement;
                        super(2);
                    }
                });
                CollectionsKt.addAll((Collection)collection2, (Iterable)iterable3);
                object = new IrCatchImpl(original.getStartOffset(), original.getEndOffset(), original.getCatchParameter(), catchBlock);
                collection.add(object);
            }
            List catchBlocks2 = (List)destination$iv$iv2;
            IrTry $receiver2 = irTry = aTry;
            int n5 = $receiver2.getStartOffset();
            int n6 = $receiver2.getEndOffset();
            SimpleType simpleType4 = BlockDecomposerLowering.this.unitType;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"unitType");
            IrTryImpl newTry = new IrTryImpl(n5, n6, simpleType4, tryBlock, catchBlocks2, $receiver2.getFinallyExpression());
            return new DecomposedResult(CollectionsKt.mutableListOf((Object[])new IrStatement[]{resultDeclaration, newTry}), (IrExpression)JsIrBuilder.INSTANCE.buildGetValue(resultSymbol));
        }

        @Override
        @NotNull
        public VisitResult visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            VisitResult result2 = (VisitResult)expression2.accept(BlockDecomposerLowering.this.statementVisitor, data);
            return result2.getStatus() == VisitStatus.KEPT ? (VisitResult)new DecomposedResult(expression2, (IrExpression)BlockDecomposerLowering.this.unitValue) : result2;
        }

        @Override
        @NotNull
        public VisitResult visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            VisitResult result2 = (VisitResult)loop2.accept(BlockDecomposerLowering.this.statementVisitor, data);
            return result2.getStatus() == VisitStatus.KEPT ? (VisitResult)new DecomposedResult(loop2, (IrExpression)BlockDecomposerLowering.this.unitValue) : result2;
        }

        @Override
        @NotNull
        public VisitResult visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            VisitResult result2 = (VisitResult)expression2.accept(BlockDecomposerLowering.this.statementVisitor, data);
            return result2.getStatus() == VisitStatus.KEPT ? (VisitResult)new DecomposedResult(expression2, (IrExpression)BlockDecomposerLowering.this.unitValue) : result2;
        }
    }
}

