/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.context;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.ScriptContextKt;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.lazy.descriptors.script.ScriptEnvironmentDescriptor;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010#\u001a\u00020$J\u0018\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010*\u001a\u00020\tJ\u000e\u0010+\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010,\u001a\u00020\"H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/codegen/context/ScriptContext;", "Lorg/jetbrains/kotlin/codegen/context/ClassContext;", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "earlierScripts", "", "contextDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "parentContext", "Lorg/jetbrains/kotlin/codegen/context/CodegenContext;", "(Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/codegen/context/CodegenContext;)V", "getEarlierScripts", "()Ljava/util/List;", "lastStatement", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getLastStatement", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "receiverDescriptors", "getReceiverDescriptors", "resultFieldInfo", "Lorg/jetbrains/kotlin/codegen/FieldInfo;", "getResultFieldInfo", "()Lorg/jetbrains/kotlin/codegen/FieldInfo;", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "getScript", "()Lorg/jetbrains/kotlin/psi/KtScript;", "getScriptDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "getTypeMapper", "()Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "getImplicitReceiverName", "", "index", "", "getImplicitReceiverType", "Lorg/jetbrains/org/objectweb/asm/Type;", "getOuterReceiverExpression", "Lorg/jetbrains/kotlin/codegen/StackValue;", "prefix", "thisOrOuterClass", "getScriptFieldName", "toString", "backend"})
public final class ScriptContext
extends ClassContext {
    @Nullable
    private final KtExpression lastStatement;
    @NotNull
    private final KtScript script;
    @NotNull
    private final KotlinTypeMapper typeMapper;
    @NotNull
    private final ScriptDescriptor scriptDescriptor;
    @NotNull
    private final List<ScriptDescriptor> earlierScripts;

    @Nullable
    public final KtExpression getLastStatement() {
        return this.lastStatement;
    }

    @NotNull
    public final FieldInfo getResultFieldInfo() {
        boolean bl = this.getState().getReplSpecific().getShouldGenerateScriptResultValue();
        if (_Assertions.ENABLED && !bl) {
            String string = "Should not be called unless 'scriptResultFieldName' is set";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String string = this.getState().getReplSpecific().getScriptResultFieldName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String scriptResultFieldName = string;
        FieldInfo fieldInfo = FieldInfo.createForHiddenField(this.getState().getTypeMapper().mapClass(this.scriptDescriptor), AsmTypes.OBJECT_TYPE, scriptResultFieldName);
        Intrinsics.checkExpressionValueIsNotNull((Object)fieldInfo, (String)"FieldInfo.createForHidde\u2026E, scriptResultFieldName)");
        return fieldInfo;
    }

    @NotNull
    public final KtScript getScript() {
        return this.script;
    }

    @NotNull
    public final String getImplicitReceiverName(int index2) {
        return "$$implicitReceiver" + index2;
    }

    @Nullable
    public final Type getImplicitReceiverType(int index2) {
        Type type2;
        KClass kClass2;
        Object object;
        List<KType> receivers = ((KotlinScriptDefinition)((Object)this.script.kotlinScriptDefinition.getValue())).getImplicitReceivers();
        KType kType = (KType)CollectionsKt.getOrNull(receivers, (int)index2);
        Object object2 = kType != null ? kType.getClassifier() : null;
        if (!(object2 instanceof KClass)) {
            object2 = null;
        }
        if ((object = (kClass2 = (KClass)object2)) != null && (object = JvmClassMappingKt.getJavaClass((KClass)object)) != null && (object = ScriptContextKt.access$getClassId$p((Class)object)) != null) {
            Object object3;
            Object p1 = object3 = object;
            type2 = AsmUtil.asmTypeByClassId((ClassId)p1);
        } else {
            type2 = null;
        }
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StackValue getOuterReceiverExpression(@Nullable StackValue prefix, @NotNull ClassDescriptor thisOrOuterClass) {
        Intrinsics.checkParameterIsNotNull((Object)thisOrOuterClass, (String)"thisOrOuterClass");
        if (thisOrOuterClass instanceof ScriptEnvironmentDescriptor) {
            StackValue stackValue = prefix;
            if (stackValue == null) {
                StackValue.Local local = StackValue.LOCAL_0;
                Intrinsics.checkExpressionValueIsNotNull((Object)local, (String)"StackValue.LOCAL_0");
                stackValue = local;
            }
            return stackValue;
        }
        Iterable $receiver$iv = this.getReceiverDescriptors();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            Object object;
            block8: {
                Object object2;
                block7: {
                    void outerReceiver;
                    int n = index$iv++;
                    ClassDescriptor classDescriptor = (ClassDescriptor)item$iv;
                    int index2 = n;
                    if (!Intrinsics.areEqual((Object)outerReceiver, (Object)thisOrOuterClass)) continue;
                    object = this.getImplicitReceiverType(index2);
                    if (object == null) break block7;
                    object2 = object;
                    Type type2 = object2;
                    Type owner = this.typeMapper.mapType(this.scriptDescriptor);
                    String string = this.getImplicitReceiverName(index2);
                    StackValue stackValue = prefix;
                    if (stackValue == null) {
                        stackValue = StackValue.LOCAL_0;
                    }
                    StackValue.Field field = StackValue.field(type2, owner, string, false, stackValue);
                    object = field;
                    if (field != null) break block8;
                }
                object2 = "Invalid script receiver: " + DescriptorUtilsKt.getFqNameSafe(thisOrOuterClass);
                throw (Throwable)new IllegalStateException(object2.toString());
            }
            return (StackValue)object;
        }
        String string = "Script receiver not found: " + DescriptorUtilsKt.getFqNameSafe(thisOrOuterClass);
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public final List<ClassDescriptor> getReceiverDescriptors() {
        List<ClassDescriptor> list2 = this.scriptDescriptor.getImplicitReceivers();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"scriptDescriptor.implicitReceivers");
        return list2;
    }

    @NotNull
    public final String getScriptFieldName(@NotNull ScriptDescriptor scriptDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)scriptDescriptor, (String)"scriptDescriptor");
        int index2 = this.earlierScripts.indexOf(scriptDescriptor);
        if (index2 < 0) {
            throw (Throwable)new IllegalStateException("Unregistered script: " + scriptDescriptor);
        }
        return "script$" + (index2 + 1);
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Script: ");
        ClassDescriptor classDescriptor = (ClassDescriptor)this.getContextDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"contextDescriptor");
        return stringBuilder.append(classDescriptor.getName().asString()).toString();
    }

    @NotNull
    public final KotlinTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    @NotNull
    public final ScriptDescriptor getScriptDescriptor() {
        return this.scriptDescriptor;
    }

    @NotNull
    public final List<ScriptDescriptor> getEarlierScripts() {
        return this.earlierScripts;
    }

    public ScriptContext(@NotNull KotlinTypeMapper typeMapper, @NotNull ScriptDescriptor scriptDescriptor, @NotNull List<? extends ScriptDescriptor> earlierScripts, @NotNull ClassDescriptor contextDescriptor, @Nullable CodegenContext<?> parentContext) {
        Intrinsics.checkParameterIsNotNull((Object)typeMapper, (String)"typeMapper");
        Intrinsics.checkParameterIsNotNull((Object)scriptDescriptor, (String)"scriptDescriptor");
        Intrinsics.checkParameterIsNotNull(earlierScripts, (String)"earlierScripts");
        Intrinsics.checkParameterIsNotNull((Object)contextDescriptor, (String)"contextDescriptor");
        super(typeMapper, contextDescriptor, OwnerKind.IMPLEMENTATION, parentContext, null);
        this.typeMapper = typeMapper;
        this.scriptDescriptor = scriptDescriptor;
        this.earlierScripts = earlierScripts;
        KtScript ktScript = (KtScript)DescriptorToSourceUtils.getSourceFromDescriptor(this.scriptDescriptor);
        if (ktScript == null) {
            String string = "Declaration should be present for script: " + this.scriptDescriptor;
            ScriptContext scriptContext = this;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.script = ktScript;
        List<KtDeclaration> list2 = this.script.getDeclarations();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"script.declarations");
        KtDeclaration lastDeclaration = (KtDeclaration)CollectionsKt.lastOrNull(list2);
        this.lastStatement = lastDeclaration instanceof KtAnonymousInitializer ? ((KtAnonymousInitializer)lastDeclaration).getBody() : (KtExpression)null;
    }
}

