/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.when;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.when.WhenByEnumsMapping;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class MappingClassesForWhenByEnumCodegen {
    public static final String MAPPINGS_FIELD_DESCRIPTOR = Type.getDescriptor(int[].class);
    private final GenerationState state;

    public MappingClassesForWhenByEnumCodegen(@NotNull GenerationState state2) {
        this.state = state2;
    }

    public void generate(@NotNull List<WhenByEnumsMapping> mappings, @NotNull Type mappingsClass, @NotNull KtFile srcFile) {
        ClassBuilder cb = this.state.getFactory().newVisitor(JvmDeclarationOrigin.NO_ORIGIN, mappingsClass, (PsiFile)srcFile);
        cb.defineClass((PsiElement)srcFile, this.state.getClassFileVersion(), 4145, mappingsClass.getInternalName(), null, AsmTypes.OBJECT_TYPE.getInternalName(), ArrayUtil.EMPTY_STRING_ARRAY);
        MappingClassesForWhenByEnumCodegen.generateFields(cb, mappings);
        this.generateInitialization(cb, mappings);
        WriteAnnotationUtilKt.writeSyntheticClassMetadata(cb, this.state);
        cb.done();
    }

    private static void generateFields(@NotNull ClassBuilder cb, @NotNull List<WhenByEnumsMapping> mappings) {
        for (WhenByEnumsMapping mapping2 : mappings) {
            cb.newField(JvmDeclarationOrigin.NO_ORIGIN, 4121, mapping2.getFieldName(), MAPPINGS_FIELD_DESCRIPTOR, null, null);
        }
    }

    private void generateInitialization(@NotNull ClassBuilder cb, @NotNull List<WhenByEnumsMapping> mappings) {
        MethodVisitor mv = cb.newMethod(JvmDeclarationOrigin.NO_ORIGIN, 4104, "<clinit>", "()V", null, ArrayUtil.EMPTY_STRING_ARRAY);
        mv.visitCode();
        InstructionAdapter v2 = new InstructionAdapter(mv);
        for (WhenByEnumsMapping mapping2 : mappings) {
            this.generateInitializationForMapping(cb, v2, mapping2);
        }
        v2.areturn(Type.VOID_TYPE);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void generateInitializationForMapping(@NotNull ClassBuilder cb, @NotNull InstructionAdapter v2, @NotNull WhenByEnumsMapping mapping2) {
        Type enumType = this.state.getTypeMapper().mapClass(mapping2.getEnumClassDescriptor());
        v2.invokestatic(enumType.getInternalName(), "values", Type.getMethodDescriptor((Type)Type.getType((String)("[" + enumType.getDescriptor())), (Type[])new Type[0]), false);
        v2.arraylength();
        v2.newarray(Type.INT_TYPE);
        v2.putstatic(cb.getThisName(), mapping2.getFieldName(), MAPPINGS_FIELD_DESCRIPTOR);
        for (Map.Entry<EnumValue, Integer> item : mapping2.enumValuesToIntMapping()) {
            EnumValue enumValue = item.getKey();
            int mappedValue = item.getValue();
            v2.getstatic(cb.getThisName(), mapping2.getFieldName(), MAPPINGS_FIELD_DESCRIPTOR);
            v2.getstatic(enumType.getInternalName(), enumValue.getEnumEntryName().asString(), enumType.getDescriptor());
            v2.invokevirtual(enumType.getInternalName(), "ordinal", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), false);
            v2.iconst(mappedValue);
            v2.astore(Type.INT_TYPE);
        }
    }
}

