/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.artifact;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.artifact.DirectoryArtifactType;
import org.jetbrains.jps.model.artifact.JarArtifactType;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactService;
import org.jetbrains.jps.model.artifact.JpsArtifactType;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsExtractedDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsFileCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsLibraryFilesPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElementFactory;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.artifact.ArtifactPropertiesState;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactDummyPropertiesSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactExtensionSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactPropertiesSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsPackagingElementSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;

public class JpsArtifactSerializer {
    private static final JpsPackagingElementSerializer<?>[] STANDARD_SERIALIZERS = new JpsPackagingElementSerializer[]{new ArtifactRootElementSerializer(), new DirectoryElementSerializer(), new ArchiveElementSerializer(), new FileCopyElementSerializer(), new DirectoryCopyElementSerializer(), new ExtractedDirectoryElementSerializer(), new LibraryFilesElementSerializer(), new ArtifactOutputElementSerializer()};
    private static final JpsArtifactPropertiesSerializer<?>[] STANDARD_TYPE_SERIALIZERS = new JpsArtifactPropertiesSerializer[]{new JpsArtifactDummyPropertiesSerializer("plain", DirectoryArtifactType.INSTANCE), new JpsArtifactDummyPropertiesSerializer("jar", JarArtifactType.INSTANCE)};
    private static final String ELEMENT_TAG = "element";
    private static final String ID_ATTRIBUTE = "id";
    private static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();

    public static void loadArtifacts(@NotNull JpsProject project, @Nullable Element componentElement) {
        if (project == null) {
            JpsArtifactSerializer.$$$reportNull$$$0(0);
        }
        JpsArtifactService service = JpsArtifactService.getInstance();
        for (Element artifactElement : JDOMUtil.getChildren((Element)componentElement, (String)"artifact")) {
            ArtifactState state2 = (ArtifactState)XmlSerializer.deserialize((Element)artifactElement, ArtifactState.class);
            JpsArtifactPropertiesSerializer<?> serializer = JpsArtifactSerializer.getTypePropertiesSerializer(state2.getArtifactType());
            JpsArtifactSerializer.loadArtifact(project, service, state2, serializer);
        }
    }

    private static <P extends JpsElement> void loadArtifact(JpsProject project, JpsArtifactService service, ArtifactState state2, JpsArtifactPropertiesSerializer<P> serializer) {
        JpsPackagingElement rootElement = JpsArtifactSerializer.loadPackagingElement(state2.getRootElement());
        if (rootElement != null) {
            List<ArtifactPropertiesState> propertiesList = state2.getPropertiesList();
            JpsArtifact artifact = service.addArtifact(project, state2.getName(), (JpsCompositePackagingElement)rootElement, (JpsArtifactType)serializer.getType(), serializer.loadProperties(propertiesList));
            artifact.setBuildOnMake(state2.isBuildOnMake());
            artifact.setOutputPath(state2.getOutputPath());
            for (ArtifactPropertiesState propertiesState : propertiesList) {
                JpsArtifactExtensionSerializer<?> extensionSerializer = JpsArtifactSerializer.getExtensionSerializer(propertiesState.getId());
                if (extensionSerializer == null) continue;
                JpsArtifactSerializer.loadExtension(extensionSerializer, artifact, propertiesState.getOptions());
            }
        }
    }

    public static void saveArtifact(@NotNull JpsArtifact artifact, Element componentElement) {
        if (artifact == null) {
            JpsArtifactSerializer.$$$reportNull$$$0(1);
        }
        ArtifactState state2 = new ArtifactState();
        state2.setName(artifact.getName());
        state2.setBuildOnMake(artifact.isBuildOnMake());
        state2.setOutputPath(artifact.getOutputPath());
        JpsArtifactPropertiesSerializer<?> serializer = JpsArtifactSerializer.getTypePropertiesSerializer(artifact.getArtifactType());
        JpsArtifactSerializer.doSaveArtifact(artifact, componentElement, state2, serializer);
    }

    private static <P extends JpsElement> void doSaveArtifact(JpsArtifact artifact, Element componentElement, ArtifactState state2, JpsArtifactPropertiesSerializer<P> serializer) {
        state2.setArtifactType(serializer.getTypeId());
        state2.setRootElement(JpsArtifactSerializer.savePackagingElement(artifact.getRootElement()));
        List<ArtifactPropertiesState> propertiesList = state2.getPropertiesList();
        serializer.saveProperties(artifact.getProperties(), propertiesList);
        for (JpsModelSerializerExtension serializerExtension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsArtifactExtensionSerializer<?> extensionSerializer : serializerExtension.getArtifactExtensionSerializers()) {
                Object extension = artifact.getContainer().getChild(extensionSerializer.getRole());
                if (extension == null) continue;
                ArtifactPropertiesState propertiesState = new ArtifactPropertiesState();
                propertiesState.setId(extensionSerializer.getId());
                propertiesState.setOptions(JpsArtifactSerializer.saveExtension(extensionSerializer, extension));
                propertiesList.add(propertiesState);
            }
        }
        componentElement.addContent(XmlSerializer.serialize((Object)state2, (SerializationFilter)SERIALIZATION_FILTERS));
    }

    private static <E extends JpsElement> void loadExtension(JpsArtifactExtensionSerializer<E> serializer, JpsArtifact artifact, Element options) {
        E e = serializer.loadExtension(options);
        artifact.getContainer().setChild(serializer.getRole(), e);
    }

    private static <E extends JpsElement> Element saveExtension(JpsArtifactExtensionSerializer<?> serializer, E extension) {
        Element optionsTag = new Element("options");
        serializer.saveExtension(extension, optionsTag);
        return optionsTag;
    }

    private static <P extends JpsPackagingElement> Element savePackagingElement(P element) {
        JpsPackagingElementSerializer<?> serializer = JpsArtifactSerializer.findElementSerializer(element.getClass());
        Element tag = new Element(ELEMENT_TAG).setAttribute(ID_ATTRIBUTE, serializer.getTypeId());
        serializer.save(element, tag);
        if (element instanceof JpsCompositePackagingElement) {
            for (JpsPackagingElement child : ((JpsCompositePackagingElement)element).getChildren()) {
                tag.addContent(JpsArtifactSerializer.savePackagingElement(child));
            }
        }
        return tag;
    }

    @Nullable
    private static JpsPackagingElement loadPackagingElement(Element element) {
        JpsPackagingElement packagingElement = JpsArtifactSerializer.createPackagingElement(element);
        if (packagingElement instanceof JpsCompositePackagingElement) {
            for (Element childElement : JDOMUtil.getChildren((Element)element, (String)ELEMENT_TAG)) {
                JpsPackagingElement child = JpsArtifactSerializer.loadPackagingElement(childElement);
                if (child == null) continue;
                ((JpsCompositePackagingElement)packagingElement).addChild(child);
            }
        }
        return packagingElement;
    }

    @Nullable
    private static JpsPackagingElement createPackagingElement(Element element) {
        String typeId = element.getAttributeValue(ID_ATTRIBUTE);
        JpsPackagingElementSerializer<?> serializer = JpsArtifactSerializer.findElementSerializer(typeId);
        if (serializer != null) {
            return serializer.load(element);
        }
        return null;
    }

    @Nullable
    private static JpsPackagingElementSerializer<?> findElementSerializer(@NotNull String typeId) {
        if (typeId == null) {
            JpsArtifactSerializer.$$$reportNull$$$0(2);
        }
        for (JpsPackagingElementSerializer<?> serializer : STANDARD_SERIALIZERS) {
            if (!serializer.getTypeId().equals(typeId)) continue;
            return serializer;
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsPackagingElementSerializer<?> serializer : extension.getPackagingElementSerializers()) {
                if (!serializer.getTypeId().equals(typeId)) continue;
                return serializer;
            }
        }
        return null;
    }

    @NotNull
    private static <E extends JpsPackagingElement> JpsPackagingElementSerializer<E> findElementSerializer(@NotNull Class<E> elementClass) {
        if (elementClass == null) {
            JpsArtifactSerializer.$$$reportNull$$$0(3);
        }
        for (JpsPackagingElementSerializer<?> serializer : STANDARD_SERIALIZERS) {
            if (!serializer.getElementClass().isAssignableFrom(elementClass)) continue;
            JpsPackagingElementSerializer<?> jpsPackagingElementSerializer = serializer;
            if (jpsPackagingElementSerializer == null) {
                JpsArtifactSerializer.$$$reportNull$$$0(4);
            }
            return jpsPackagingElementSerializer;
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsPackagingElementSerializer<?> serializer : extension.getPackagingElementSerializers()) {
                if (!serializer.getElementClass().isAssignableFrom(elementClass)) continue;
                JpsPackagingElementSerializer<?> jpsPackagingElementSerializer = serializer;
                if (jpsPackagingElementSerializer == null) {
                    JpsArtifactSerializer.$$$reportNull$$$0(5);
                }
                return jpsPackagingElementSerializer;
            }
        }
        throw new IllegalArgumentException("Serializer not found for " + elementClass);
    }

    @Nullable
    private static JpsArtifactExtensionSerializer<?> getExtensionSerializer(String id) {
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsArtifactExtensionSerializer<?> serializer : extension.getArtifactExtensionSerializers()) {
                if (!serializer.getId().equals(id)) continue;
                return serializer;
            }
        }
        return null;
    }

    private static JpsArtifactPropertiesSerializer<?> getTypePropertiesSerializer(String typeId) {
        for (JpsArtifactPropertiesSerializer<?> serializer : STANDARD_TYPE_SERIALIZERS) {
            if (!serializer.getTypeId().equals(typeId)) continue;
            return serializer;
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsArtifactPropertiesSerializer<?> serializer : extension.getArtifactTypePropertiesSerializers()) {
                if (!serializer.getTypeId().equals(typeId)) continue;
                return serializer;
            }
        }
        return STANDARD_TYPE_SERIALIZERS[0];
    }

    private static JpsArtifactPropertiesSerializer<?> getTypePropertiesSerializer(JpsArtifactType type2) {
        for (JpsArtifactPropertiesSerializer<?> serializer : STANDARD_TYPE_SERIALIZERS) {
            if (!serializer.getType().equals(type2)) continue;
            return serializer;
        }
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsArtifactPropertiesSerializer<?> serializer : extension.getArtifactTypePropertiesSerializers()) {
                if (!serializer.getType().equals(type2)) continue;
                return serializer;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/artifact/JpsArtifactSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/artifact/JpsArtifactSerializer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadArtifacts";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveArtifact";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElementSerializer";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArtifactOutputElementSerializer
    extends JpsPackagingElementSerializer<JpsArtifactOutputPackagingElement> {
        ArtifactOutputElementSerializer() {
            super("artifact", JpsArtifactOutputPackagingElement.class);
        }

        @Override
        public JpsArtifactOutputPackagingElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createArtifactOutput(JpsArtifactService.getInstance().createReference(element.getAttributeValue("artifact-name")));
        }

        @Override
        public void save(JpsArtifactOutputPackagingElement element, Element tag) {
            tag.setAttribute("artifact-name", element.getArtifactReference().getArtifactName());
        }
    }

    private static class LibraryFilesElementSerializer
    extends JpsPackagingElementSerializer<JpsLibraryFilesPackagingElement> {
        LibraryFilesElementSerializer() {
            super("library", JpsLibraryFilesPackagingElement.class);
        }

        @Override
        public JpsLibraryFilesPackagingElement load(Element element) {
            String level = element.getAttributeValue("level");
            String libraryName = element.getAttributeValue("name");
            String moduleName = element.getAttributeValue("module-name");
            JpsModuleReference parentReference = moduleName != null ? JpsElementFactory.getInstance().createModuleReference(moduleName) : JpsLibraryTableSerializer.createLibraryTableReference(level);
            return JpsPackagingElementFactory.getInstance().createLibraryElement(JpsElementFactory.getInstance().createLibraryReference(libraryName, parentReference));
        }

        @Override
        public void save(JpsLibraryFilesPackagingElement element, Element tag) {
            JpsLibraryReference reference = element.getLibraryReference();
            JpsElementReference<? extends JpsCompositeElement> parentReference = reference.getParentReference();
            tag.setAttribute("level", JpsLibraryTableSerializer.getLevelId(parentReference));
            tag.setAttribute("name", reference.getLibraryName());
            if (parentReference instanceof JpsModuleReference) {
                tag.setAttribute("module-name", ((JpsModuleReference)parentReference).getModuleName());
            }
        }
    }

    private static class ExtractedDirectoryElementSerializer
    extends JpsPackagingElementSerializer<JpsExtractedDirectoryPackagingElement> {
        ExtractedDirectoryElementSerializer() {
            super("extracted-dir", JpsExtractedDirectoryPackagingElement.class);
        }

        @Override
        public JpsExtractedDirectoryPackagingElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createExtractedDirectory(element.getAttributeValue("path"), element.getAttributeValue("path-in-jar"));
        }

        @Override
        public void save(JpsExtractedDirectoryPackagingElement element, Element tag) {
            tag.setAttribute("path", element.getFilePath());
            tag.setAttribute("path-in-jar", element.getPathInJar());
        }
    }

    private static class DirectoryCopyElementSerializer
    extends JpsPackagingElementSerializer<JpsDirectoryCopyPackagingElement> {
        DirectoryCopyElementSerializer() {
            super("dir-copy", JpsDirectoryCopyPackagingElement.class);
        }

        @Override
        public JpsDirectoryCopyPackagingElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createDirectoryCopy(element.getAttributeValue("path"));
        }

        @Override
        public void save(JpsDirectoryCopyPackagingElement element, Element tag) {
            tag.setAttribute("path", element.getDirectoryPath());
        }
    }

    private static class FileCopyElementSerializer
    extends JpsPackagingElementSerializer<JpsFileCopyPackagingElement> {
        FileCopyElementSerializer() {
            super("file-copy", JpsFileCopyPackagingElement.class);
        }

        @Override
        public JpsFileCopyPackagingElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createFileCopy(element.getAttributeValue("path"), element.getAttributeValue("output-file-name"));
        }

        @Override
        public void save(JpsFileCopyPackagingElement element, Element tag) {
            tag.setAttribute("path", element.getFilePath());
            String outputFileName = element.getRenamedOutputFileName();
            if (outputFileName != null) {
                tag.setAttribute("output-path-name", outputFileName);
            }
        }
    }

    private static class ArchiveElementSerializer
    extends JpsPackagingElementSerializer<JpsArchivePackagingElement> {
        ArchiveElementSerializer() {
            super("archive", JpsArchivePackagingElement.class);
        }

        @Override
        public JpsArchivePackagingElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createArchive(element.getAttributeValue("name"));
        }

        @Override
        public void save(JpsArchivePackagingElement element, Element tag) {
            tag.setAttribute("name", element.getArchiveName());
        }
    }

    private static class DirectoryElementSerializer
    extends JpsPackagingElementSerializer<JpsDirectoryPackagingElement> {
        DirectoryElementSerializer() {
            super("directory", JpsDirectoryPackagingElement.class);
        }

        @Override
        public JpsDirectoryPackagingElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createDirectory(element.getAttributeValue("name"));
        }

        @Override
        public void save(JpsDirectoryPackagingElement element, Element tag) {
            tag.setAttribute("name", element.getDirectoryName());
        }
    }

    private static class ArtifactRootElementSerializer
    extends JpsPackagingElementSerializer<JpsArtifactRootElement> {
        ArtifactRootElementSerializer() {
            super("root", JpsArtifactRootElement.class);
        }

        @Override
        public JpsArtifactRootElement load(Element element) {
            return JpsPackagingElementFactory.getInstance().createArtifactRoot();
        }

        @Override
        public void save(JpsArtifactRootElement element, Element tag) {
        }
    }
}

