/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.bridges.ImplKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptorKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public abstract class ClassBodyCodegen
extends MemberCodegen<KtPureClassOrObject> {
    @NotNull
    public final KtPureClassOrObject myClass;
    @NotNull
    public final OwnerKind kind;
    @NotNull
    public final ClassDescriptor descriptor;

    protected ClassBodyCodegen(@NotNull KtPureClassOrObject myClass, @NotNull ClassContext context, @NotNull ClassBuilder v2, @NotNull GenerationState state2, @Nullable MemberCodegen<?> parentCodegen) {
        super(state2, parentCodegen, context, myClass, v2);
        this.myClass = myClass;
        this.kind = context.getContextKind();
        this.descriptor = SyntheticClassOrObjectDescriptorKt.findClassDescriptor(myClass, this.bindingContext);
    }

    @Override
    protected void generateBody() {
        ArrayList<KtObjectDeclaration> companions = new ArrayList<KtObjectDeclaration>();
        if (this.kind != OwnerKind.DEFAULT_IMPLS && this.kind != OwnerKind.ERASED_INLINE_CLASS) {
            for (KtDeclaration ktDeclaration : this.myClass.getDeclarations()) {
                if (!ClassBodyCodegen.shouldProcessFirst(ktDeclaration)) continue;
                if (ktDeclaration instanceof KtObjectDeclaration && ((KtObjectDeclaration)ktDeclaration).isCompanion()) {
                    companions.add((KtObjectDeclaration)ktDeclaration);
                    CodegenUtilKt.populateCompanionBackingFieldNamesToOuterContextIfNeeded((KtObjectDeclaration)ktDeclaration, this.context, this.state);
                    continue;
                }
                this.generateDeclaration(ktDeclaration);
            }
        }
        for (KtDeclaration ktDeclaration : this.myClass.getDeclarations()) {
            if (ClassBodyCodegen.shouldProcessFirst(ktDeclaration)) continue;
            this.generateDeclaration(ktDeclaration);
        }
        boolean generateNonClassMembers = this.shouldGenerateNonClassMembers();
        if (generateNonClassMembers) {
            this.generatePrimaryConstructorProperties();
            this.generateConstructors();
            this.generateDefaultImplsIfNeeded();
            this.generateErasedInlineClassIfNeeded();
            this.generateUnboxMethodForInlineClass();
        }
        for (KtObjectDeclaration companion : companions) {
            this.genClassOrObject(companion);
        }
        Collection<DeclarationDescriptor> collection = this.descriptor.getUnsubstitutedMemberScope().getContributedDescriptors(DescriptorKindFilter.CLASSIFIERS, MemberScope.Companion.getALL_NAME_FILTER());
        for (DeclarationDescriptor memberDescriptor : collection) {
            if (!(memberDescriptor instanceof SyntheticClassOrObjectDescriptor)) continue;
            this.genSyntheticClassOrObject((SyntheticClassOrObjectDescriptor)memberDescriptor);
        }
        if (generateNonClassMembers) {
            this.generateBridges();
        }
    }

    private void generateBridges() {
        if (DescriptorUtils.isInterface(this.descriptor)) {
            return;
        }
        for (DeclarationDescriptor memberDescriptor : DescriptorUtils.getAllDescriptors(this.descriptor.getDefaultType().getMemberScope())) {
            PropertySetterDescriptor setter2;
            CallableMemberDescriptor member;
            if (!(memberDescriptor instanceof CallableMemberDescriptor) || (member = (CallableMemberDescriptor)memberDescriptor).getKind().isReal() || ImplKt.findInterfaceImplementation(member) != null) continue;
            if (member instanceof FunctionDescriptor) {
                this.functionCodegen.generateBridges((FunctionDescriptor)member);
                continue;
            }
            if (!(member instanceof PropertyDescriptor)) continue;
            PropertyGetterDescriptor getter2 = ((PropertyDescriptor)member).getGetter();
            if (getter2 != null) {
                this.functionCodegen.generateBridges(getter2);
            }
            if ((setter2 = ((PropertyDescriptor)member).getSetter()) == null) continue;
            this.functionCodegen.generateBridges(setter2);
        }
    }

    private boolean shouldGenerateNonClassMembers() {
        return !(this.myClass instanceof KtClassOrObject) || this.state.getGenerateDeclaredClassFilter().shouldGenerateClassMembers((KtClassOrObject)this.myClass);
    }

    protected void generateConstructors() {
    }

    protected void generateDefaultImplsIfNeeded() {
    }

    protected void generateErasedInlineClassIfNeeded() {
    }

    protected void generateUnboxMethodForInlineClass() {
    }

    private static boolean shouldProcessFirst(KtDeclaration declaration) {
        return !(declaration instanceof KtProperty) && !(declaration instanceof KtNamedFunction);
    }

    protected void generateDeclaration(KtDeclaration declaration) {
        if (declaration instanceof KtProperty || declaration instanceof KtNamedFunction || declaration instanceof KtTypeAlias) {
            if (this.shouldGenerateNonClassMembers()) {
                this.genSimpleMember(declaration);
            }
        } else if (declaration instanceof KtClassOrObject) {
            if (declaration instanceof KtEnumEntry && !CodegenBinding.enumEntryNeedSubclass(this.bindingContext, (KtEnumEntry)declaration)) {
                return;
            }
            this.genClassOrObject((KtClassOrObject)declaration);
        }
    }

    private void generatePrimaryConstructorProperties() {
        ClassConstructorDescriptor constructor = (ClassConstructorDescriptor)CollectionsKt.firstOrNull(this.descriptor.getConstructors());
        if (constructor == null) {
            return;
        }
        boolean isAnnotation = this.descriptor.getKind() == ClassKind.ANNOTATION_CLASS;
        FunctionDescriptor expectedAnnotationConstructor = isAnnotation && constructor.isActual() ? CodegenUtil.findExpectedFunctionForActual(constructor) : null;
        for (KtParameter p : this.getPrimaryConstructorParameters()) {
            PropertyDescriptor propertyDescriptor;
            if (!p.hasValOrVar() || (propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, p)) == null) continue;
            if (isAnnotation) {
                this.propertyCodegen.generateConstructorPropertyAsMethodForAnnotationClass(p, propertyDescriptor, expectedAnnotationConstructor);
                continue;
            }
            this.propertyCodegen.generatePrimaryConstructorProperty(p, propertyDescriptor);
        }
    }

    @NotNull
    public List<KtParameter> getPrimaryConstructorParameters() {
        if (this.myClass instanceof KtClass) {
            return this.myClass.getPrimaryConstructorParameters();
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return InnerClassConsumer.Companion.classForInnerClassRecord(this.descriptor, false);
    }

    protected void generateDelegatesToDefaultImpl() {
        if (JvmCodegenUtil.isJvmInterface(this.descriptor)) {
            return;
        }
        for (Map.Entry<FunctionDescriptor, FunctionDescriptor> entry : CodegenUtil.getNonPrivateTraitMethods(this.descriptor).entrySet()) {
            FunctionDescriptor interfaceFun = entry.getKey();
            if (CodegenUtilKt.isDefinitelyNotDefaultImplsMethod(interfaceFun) || JvmAnnotationUtilKt.hasJvmDefaultAnnotation(interfaceFun)) continue;
            this.generateDelegationToDefaultImpl(interfaceFun, entry.getValue());
        }
    }

    private void generateDelegationToDefaultImpl(final @NotNull FunctionDescriptor interfaceFun, final @NotNull FunctionDescriptor inheritedFun) {
        this.functionCodegen.generateMethod(new JvmDeclarationOrigin(JvmDeclarationOriginKind.CLASS_MEMBER_DELEGATION_TO_DEFAULT_IMPL, DescriptorToSourceUtils.descriptorToDeclaration(interfaceFun), interfaceFun), inheritedFun, new FunctionGenerationStrategy.CodegenBased(this.state){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                DeclarationDescriptor containingDeclaration = interfaceFun.getContainingDeclaration();
                if (!DescriptorUtils.isInterface(containingDeclaration)) {
                    return;
                }
                DeclarationDescriptor declarationInheritedFun = inheritedFun.getContainingDeclaration();
                PsiElement classForInheritedFun = DescriptorToSourceUtils.descriptorToDeclaration(declarationInheritedFun);
                if (classForInheritedFun instanceof KtDeclaration) {
                    codegen.markLineNumber((KtElement)classForInheritedFun, false);
                }
                ClassDescriptor containingTrait = (ClassDescriptor)containingDeclaration;
                Type traitImplType = ClassBodyCodegen.this.typeMapper.mapDefaultImpls(containingTrait);
                FunctionDescriptor originalInterfaceFun = interfaceFun.getOriginal();
                Method traitMethod = ClassBodyCodegen.this.typeMapper.mapAsmMethod(originalInterfaceFun, OwnerKind.DEFAULT_IMPLS);
                this.putArgumentsOnStack(codegen, signature, traitMethod);
                InstructionAdapter iv = codegen.v;
                if (KotlinBuiltIns.isCloneable(containingTrait) && traitMethod.getName().equals("clone")) {
                    iv.invokespecial("java/lang/Object", "clone", "()Ljava/lang/Object;", false);
                } else {
                    iv.invokestatic(traitImplType.getInternalName(), traitMethod.getName(), traitMethod.getDescriptor(), false);
                }
                Type returnType2 = signature.getReturnType();
                StackValue.onStack(traitMethod.getReturnType(), originalInterfaceFun.getReturnType()).put(returnType2, iv);
                iv.areturn(returnType2);
            }

            private void putArgumentsOnStack(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature, @NotNull Method defaultImplsMethod) {
                InstructionAdapter iv = codegen.v;
                Type[] myArgTypes = signature.getAsmMethod().getArgumentTypes();
                Type[] toArgTypes = defaultImplsMethod.getArgumentTypes();
                boolean isErasedInlineClass = InlineClassesUtilsKt.isInlineClass(ClassBodyCodegen.this.descriptor) && ClassBodyCodegen.this.kind == OwnerKind.ERASED_INLINE_CLASS;
                int myArgI = 0;
                int argVar = 0;
                Type receiverType = ClassBodyCodegen.this.typeMapper.mapType(ClassBodyCodegen.this.descriptor);
                SimpleType interfaceKotlinType = ((ClassDescriptor)inheritedFun.getContainingDeclaration()).getDefaultType();
                StackValue.local(argVar, receiverType, ClassBodyCodegen.this.descriptor.getDefaultType()).put(AsmTypes.OBJECT_TYPE, interfaceKotlinType, iv);
                if (isErasedInlineClass) {
                    ++myArgI;
                }
                argVar += receiverType.getSize();
                int toArgI = 1;
                List<ParameterDescriptor> myParameters = this.getParameters(inheritedFun);
                List<ParameterDescriptor> toParameters = this.getParameters(interfaceFun);
                assert (myParameters.size() == toParameters.size()) : "Inconsistent value parameters between delegating fun " + inheritedFun + "and interface fun " + interfaceFun;
                Iterator<ParameterDescriptor> myParametersIterator = myParameters.iterator();
                Iterator<ParameterDescriptor> toParametersIterator = toParameters.iterator();
                while (myArgI < myArgTypes.length) {
                    Type myArgType = myArgTypes[myArgI];
                    Type toArgType = toArgTypes[toArgI];
                    KotlinType myArgKotlinType = myParametersIterator.hasNext() ? myParametersIterator.next().getType() : null;
                    KotlinType toArgKotlinType = toParametersIterator.hasNext() ? toParametersIterator.next().getType() : null;
                    StackValue.local(argVar, myArgType, myArgKotlinType).put(toArgType, toArgKotlinType, iv);
                    argVar += myArgType.getSize();
                    ++myArgI;
                    ++toArgI;
                }
                assert (toArgI == toArgTypes.length) : "Invalid trait implementation signature: " + signature + " vs " + defaultImplsMethod + " for " + interfaceFun;
            }

            private List<ParameterDescriptor> getParameters(FunctionDescriptor functionDescriptor) {
                ArrayList<ParameterDescriptor> valueParameterDescriptors = new ArrayList<ParameterDescriptor>(functionDescriptor.getValueParameters().size() + 1);
                ReceiverParameterDescriptor extensionReceiverParameter2 = functionDescriptor.getExtensionReceiverParameter();
                if (extensionReceiverParameter2 != null) {
                    valueParameterDescriptors.add(extensionReceiverParameter2);
                }
                valueParameterDescriptors.addAll(functionDescriptor.getValueParameters());
                return valueParameterDescriptors;
            }
        });
    }
}

