/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.TailRecursionKind;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class TailRecursionCodegen {
    @NotNull
    private final MethodContext context;
    @NotNull
    private final ExpressionCodegen codegen;
    @NotNull
    private final InstructionAdapter v;
    @NotNull
    private final GenerationState state;

    public TailRecursionCodegen(@NotNull MethodContext context, @NotNull ExpressionCodegen codegen, @NotNull InstructionAdapter v2, @NotNull GenerationState state2) {
        this.context = context;
        this.codegen = codegen;
        this.v = v2;
        this.state = state2;
    }

    public boolean isTailRecursion(@NotNull ResolvedCall<?> resolvedCall2) {
        TailRecursionKind status2 = this.state.getBindingContext().get(BindingContext.TAIL_RECURSION_CALL, resolvedCall2.getCall());
        return status2 != null && status2.isDoGenerateTailRecursion();
    }

    public void generateTailRecursion(ResolvedCall<?> resolvedCall2) {
        Object fd = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(resolvedCall2.getResultingDescriptor());
        assert (fd instanceof FunctionDescriptor) : "Resolved call doesn't refer to the function descriptor: " + fd;
        CallableMethod callable = (CallableMethod)this.codegen.resolveToCallable((FunctionDescriptor)fd, false, resolvedCall2);
        List<ResolvedValueArgument> arguments2 = resolvedCall2.getValueArgumentsByIndex();
        if (arguments2 == null) {
            throw new IllegalStateException("Failed to arrange value arguments by index: " + fd);
        }
        if (((FunctionDescriptor)fd).isSuspend()) {
            AsmUtil.pop((MethodVisitor)this.v, callable.getValueParameters().get(callable.getValueParameters().size() - 1).getAsmType());
        }
        this.assignParameterValues((CallableDescriptor)fd, callable, arguments2);
        if (callable.getExtensionReceiverType() != null) {
            if (resolvedCall2.getExtensionReceiver() != fd.getExtensionReceiverParameter().getValue()) {
                StackValue expression2 = this.context.getReceiverExpression(this.codegen.typeMapper);
                expression2.store(StackValue.onStack(callable.getExtensionReceiverType()), this.v, true);
            } else {
                AsmUtil.pop((MethodVisitor)this.v, callable.getExtensionReceiverType());
            }
        }
        if (callable.getDispatchReceiverType() != null) {
            AsmUtil.pop((MethodVisitor)this.v, callable.getDispatchReceiverType());
        }
        this.v.goTo(this.context.getMethodStartLabel());
    }

    private void assignParameterValues(CallableDescriptor fd, CallableMethod callableMethod, List<ResolvedValueArgument> valueArguments) {
        List<Type> types = callableMethod.getValueParameterTypes();
        for (ValueParameterDescriptor parameterDescriptor : Lists.reverse(fd.getValueParameters())) {
            ResolvedValueArgument arg = valueArguments.get(parameterDescriptor.getIndex());
            Type type2 = types.get(parameterDescriptor.getIndex());
            if (arg instanceof ExpressionValueArgument) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                KtExpression argumentExpression;
                ExpressionValueArgument ev = (ExpressionValueArgument)arg;
                ValueArgument argument = ev.getValueArgument();
                KtExpression ktExpression = argumentExpression = argument == null ? null : argument.getArgumentExpression();
                if (argumentExpression instanceof KtSimpleNameExpression && (resolvedCall2 = CallUtilKt.getResolvedCall(argumentExpression, this.state.getBindingContext())) != null && resolvedCall2.getResultingDescriptor().equals(parameterDescriptor.getOriginal())) {
                    AsmUtil.pop((MethodVisitor)this.v, type2);
                    continue;
                }
            } else if (arg instanceof DefaultValueArgument) {
                AsmUtil.pop((MethodVisitor)this.v, type2);
                DefaultParameterValueLoader.DEFAULT.genValue(parameterDescriptor, this.codegen).put(type2, this.v);
            } else if (!(arg instanceof VarargValueArgument)) {
                throw new UnsupportedOperationException("Unknown argument type: " + arg + " in " + fd);
            }
            this.store(parameterDescriptor, type2);
        }
    }

    private void store(ValueParameterDescriptor parameterDescriptor, Type type2) {
        int index2 = this.getParameterVariableIndex(parameterDescriptor);
        this.v.store(index2, type2);
    }

    private int getParameterVariableIndex(ValueParameterDescriptor parameterDescriptor) {
        int index2 = this.codegen.lookupLocalIndex(parameterDescriptor);
        if (index2 == -1) {
            index2 = this.codegen.lookupLocalIndex(parameterDescriptor.getOriginal());
        }
        if (index2 == -1) {
            throw new IllegalStateException("Failed to obtain parameter index: " + parameterDescriptor);
        }
        return index2;
    }
}

