/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer$WhenMappings;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J$\u0010\u0010\u001a\u00020\u0002\"\u0004\b\u0000\u0010\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00122\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010!\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010#\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020+2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsExpressionTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "()V", "isNativeInvoke", "", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "toDoubleConst", "", "f", "", "visitCall", "expression", "context", "visitConst", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitExpressionBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetVariable", "Lorg/jetbrains/kotlin/ir/expressions/IrSetVariable;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "data", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "backend.js"})
public final class IrElementToJsExpressionTransformer
implements BaseIrElementToJsNodeTransformer<JsExpression, JsGenerationContext> {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitVararg(@NotNull IrVararg expression2, @NotNull JsGenerationContext context) {
        Collection<JsExpression> collection;
        void $receiver$iv$iv;
        Object object;
        boolean $receiver$iv2;
        block5: {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Iterable $receiver$iv2 = expression2.getElements();
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv2) {
                    IrVarargElement it = (IrVarargElement)element$iv;
                    if (!(it instanceof IrSpreadElement)) continue;
                    bl = false;
                    break block5;
                }
                bl = $receiver$iv2 = true;
            }
        }
        if (_Assertions.ENABLED && !$receiver$iv2) {
            object = "Assertion failed";
            throw (Throwable)((Object)new AssertionError(object));
        }
        Iterable $receiver$iv2 = expression2.getElements();
        object = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            IrVarargElement $i$f$none = (IrVarargElement)item$iv$iv;
            collection = destination$iv$iv;
            JsExpression jsExpression = (JsExpression)it.accept(this, context);
            collection.add(jsExpression);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        return new JsArrayLiteral(list2);
    }

    @Override
    @NotNull
    public JsExpression visitExpressionBody(@NotNull IrExpressionBody body, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (JsExpression)body.getExpression().accept(this, context);
    }

    @Override
    @NotNull
    public JsExpression visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        IrFunction irFunction = expression2.getSymbol().getOwner();
        Object r = irFunction.accept(new IrFunctionToJsTransformer(), context);
        JsFunction $receiver = (JsFunction)r;
        $receiver.setName(null);
        return (JsExpression)r;
    }

    @Override
    @NotNull
    public <T> JsExpression visitConst(@NotNull IrConst<T> expression2, @NotNull JsGenerationContext context) {
        JsLiteral.JsValueLiteral jsValueLiteral;
        IrConstKind<T> kind;
        Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        IrConstKind<T> irConstKind = kind = expression2.getKind();
        if (irConstKind instanceof IrConstKind.String) {
            jsValueLiteral = new JsStringLiteral((String)((IrConstKind.String)kind).valueOf(expression2));
        } else if (irConstKind instanceof IrConstKind.Null) {
            jsValueLiteral = new JsNullLiteral();
        } else if (irConstKind instanceof IrConstKind.Boolean) {
            jsValueLiteral = new JsBooleanLiteral((Boolean)((IrConstKind.Boolean)kind).valueOf(expression2));
        } else if (irConstKind instanceof IrConstKind.Byte) {
            jsValueLiteral = new JsIntLiteral(((Number)((IrConstKind.Byte)kind).valueOf(expression2)).byteValue());
        } else if (irConstKind instanceof IrConstKind.Short) {
            jsValueLiteral = new JsIntLiteral(((Number)((IrConstKind.Short)kind).valueOf(expression2)).shortValue());
        } else if (irConstKind instanceof IrConstKind.Int) {
            jsValueLiteral = new JsIntLiteral(((Number)((IrConstKind.Int)kind).valueOf(expression2)).intValue());
        } else {
            if (irConstKind instanceof IrConstKind.Long) {
                throw (Throwable)new IllegalStateException("Long const should have been lowered at this point");
            }
            if (irConstKind instanceof IrConstKind.Char) {
                throw (Throwable)new IllegalStateException("Char const should have been lowered at this point");
            }
            if (irConstKind instanceof IrConstKind.Float) {
                jsValueLiteral = new JsDoubleLiteral(this.toDoubleConst(((Number)((IrConstKind.Float)kind).valueOf(expression2)).floatValue()));
            } else if (irConstKind instanceof IrConstKind.Double) {
                jsValueLiteral = new JsDoubleLiteral(((Number)((IrConstKind.Double)kind).valueOf(expression2)).doubleValue());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jsValueLiteral;
    }

    private final double toDoubleConst(float f) {
        double d;
        float f2 = f;
        if (Float.isInfinite(f2) || Float.isNaN(f2 = f)) {
            d = f;
        } else {
            String string = String.valueOf(f);
            d = Double.parseDouble(string);
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull JsGenerationContext context) {
        void $receiver$iv;
        JsStringLiteral initial$iv;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Iterable iterable = expression2.getArguments();
        JsExpression accumulator$iv = initial$iv = new JsStringLiteral("");
        for (Object element$iv : $receiver$iv) {
            void irExpr;
            IrExpression irExpression = (IrExpression)element$iv;
            JsExpression jsExpr = accumulator$iv;
            accumulator$iv = new JsBinaryOperation(JsBinaryOperator.ADD, jsExpr, (JsExpression)irExpr.accept(this, context));
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public JsExpression visitGetField(@NotNull IrGetField expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsName fieldName = context.getNameForSymbol(expression2.getSymbol());
        IrExpression irExpression = expression2.getReceiver();
        return new JsNameRef(fieldName, irExpression != null ? (JsExpression)irExpression.accept(this, context) : null);
    }

    @Override
    @NotNull
    public JsExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsNameRef jsNameRef = context.getNameForSymbol(expression2.getSymbol()).makeRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"context.getNameForSymbol\u2026ression.symbol).makeRef()");
        return jsNameRef;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JsInvocation visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        switch (IrElementToJsExpressionTransformer$WhenMappings.$EnumSwitchMapping$0[((IrClass)expression2.getSymbol().getOwner()).getKind().ordinal()]) {
            case 1: {
                JsName className2 = context.getNameForSymbol(expression2.getSymbol());
                String getInstanceName = className2.getIdent() + "_getInstance";
                return new JsInvocation((JsExpression)new JsNameRef(getInstanceName), new JsExpression[0]);
            }
        }
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public JsExpression visitSetField(@NotNull IrSetField expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsName fieldName = context.getNameForSymbol(expression2.getSymbol());
        IrExpression irExpression = expression2.getReceiver();
        JsNameRef dest = new JsNameRef(fieldName, irExpression != null ? (JsExpression)irExpression.accept(this, context) : null);
        JsExpression source = (JsExpression)expression2.getValue().accept(this, context);
        return JsAstUtilsKt.jsAssignment(dest, source);
    }

    @Override
    @NotNull
    public JsExpression visitSetVariable(@NotNull IrSetVariable expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsNameRef ref = new JsNameRef(context.getNameForSymbol(expression2.getSymbol()));
        JsExpression value = (JsExpression)expression2.getValue().accept(this, context);
        return new JsBinaryOperation(JsBinaryOperator.ASG, ref, value);
    }

    @Override
    @NotNull
    public JsExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull JsGenerationContext context) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JsNameRef jsNameRef = context.getNameForSymbol(expression2.getSymbol()).makeRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"context.getNameForSymbol\u2026ression.symbol).makeRef()");
        JsNameRef classNameRef = jsNameRef;
        JsNameRef callFuncRef = new JsNameRef(Namer.INSTANCE.getCALL_FUNCTION(), (JsExpression)classNameRef);
        boolean fromPrimary = context.getCurrentFunction() instanceof IrConstructor;
        if (fromPrimary) {
            jsExpression = new JsThisRef();
        } else {
            IrFunction irFunction = context.getCurrentFunction();
            if (irFunction == null) {
                Intrinsics.throwNpe();
            }
            JsNameRef jsNameRef2 = context.getNameForSymbol(((IrValueParameter)CollectionsKt.last(irFunction.getValueParameters())).getSymbol()).makeRef();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef2, (String)"context.getNameForSymbol\u2026.last().symbol).makeRef()");
            jsExpression = jsNameRef2;
        }
        JsExpression thisRef = jsExpression;
        List<JsExpression> arguments2 = JsAstUtilsKt.translateCallArguments(expression2, context);
        return new JsInvocation((JsExpression)callFuncRef, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)thisRef), (Iterable)arguments2));
    }

    @Override
    @NotNull
    public JsExpression visitCall(@NotNull IrCall expression2, @NotNull JsGenerationContext context) {
        JsExpression.JsExpressionHasArguments jsExpressionHasArguments;
        block13: {
            Object object;
            JsExpression jsExpression;
            block15: {
                List<JsExpression> arguments2;
                block14: {
                    JsExpression jsExtensionReceiver;
                    JsExpression jsDispatchReceiver;
                    IrFunctionSymbol symbol2;
                    block12: {
                        block9: {
                            Object object2;
                            JsExpression jsExpression2;
                            block11: {
                                block10: {
                                    IrClassSymbol irClassSymbol;
                                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                                    symbol2 = expression2.getSymbol();
                                    Function2<IrCall, JsGenerationContext, JsExpression> function2 = context.getStaticContext().getIntrinsics().get(symbol2);
                                    if (function2 != null) {
                                        Function2<IrCall, JsGenerationContext, JsExpression> function22;
                                        Function2<IrCall, JsGenerationContext, JsExpression> it = function22 = function2;
                                        return (JsExpression)it.invoke((Object)expression2, (Object)context);
                                    }
                                    IrExpression irExpression = expression2.getDispatchReceiver();
                                    jsDispatchReceiver = irExpression != null ? (JsExpression)irExpression.accept(this, context) : null;
                                    IrExpression irExpression2 = expression2.getExtensionReceiver();
                                    jsExtensionReceiver = irExpression2 != null ? (JsExpression)irExpression2.accept(this, context) : null;
                                    arguments2 = JsAstUtilsKt.translateCallArguments(expression2, context);
                                    if (this.isNativeInvoke(expression2)) {
                                        JsExpression jsExpression3 = jsDispatchReceiver;
                                        if (jsExpression3 == null) {
                                            Intrinsics.throwNpe();
                                        }
                                        return new JsInvocation(jsExpression3, arguments2);
                                    }
                                    IrClassSymbol irClassSymbol2 = expression2.getSuperQualifierSymbol();
                                    if (irClassSymbol2 == null) break block9;
                                    IrClassSymbol it = irClassSymbol = irClassSymbol2;
                                    JsNameRef jsNameRef = context.getNameForSymbol(it).makeRef();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)jsNameRef, (String)"context.getNameForSymbol(it).makeRef()");
                                    JsNameRef qualifierName = jsNameRef;
                                    JsName targetName = context.getNameForSymbol(symbol2);
                                    JsNameRef qPrototype = new JsNameRef(targetName, (JsExpression)JsAstUtilsKt.prototypeOf(qualifierName));
                                    JsNameRef callRef = new JsNameRef(Namer.INSTANCE.getCALL_FUNCTION(), (JsExpression)qPrototype);
                                    jsExpression2 = callRef;
                                    object2 = jsDispatchReceiver;
                                    if (object2 == null) break block10;
                                    JsExpression jsExpression4 = object2;
                                    JsExpression jsExpression5 = jsExpression2;
                                    JsExpression it2 = jsExpression4;
                                    List list2 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)it2), (Iterable)arguments2);
                                    jsExpression2 = jsExpression5;
                                    object2 = list2;
                                    if (object2 != null) break block11;
                                }
                                object2 = arguments2;
                            }
                            Object object3 = object2;
                            JsExpression jsExpression6 = jsExpression2;
                            return new JsInvocation(jsExpression6, (List<? extends JsExpression>)object3);
                        }
                        if (!(symbol2 instanceof IrConstructorSymbol)) break block12;
                        jsExpressionHasArguments = new JsNew(context.getNameForSymbol(symbol2).makeRef(), arguments2);
                        break block13;
                    }
                    JsName symbolName = context.getNameForSymbol(symbol2);
                    JsNameRef ref = jsDispatchReceiver != null ? new JsNameRef(symbolName, jsDispatchReceiver) : new JsNameRef(symbolName);
                    jsExpression = ref;
                    object = jsExtensionReceiver;
                    if (object == null) break block14;
                    JsExpression jsExpression7 = object;
                    JsExpression jsExpression8 = jsExpression;
                    JsExpression it = jsExpression7;
                    List list3 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)jsExtensionReceiver), (Iterable)arguments2);
                    jsExpression = jsExpression8;
                    object = list3;
                    if (object != null) break block15;
                }
                object = arguments2;
            }
            Object object4 = object;
            JsExpression jsExpression9 = jsExpression;
            jsExpressionHasArguments = new JsInvocation(jsExpression9, (List<? extends JsExpression>)object4);
        }
        return jsExpressionHasArguments;
    }

    @Override
    @NotNull
    public JsExpression visitWhen(@NotNull IrWhen expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object t = JsAstUtilsKt.toJsNode(expression2, this, context, visitWhen.1.INSTANCE);
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return (JsExpression)t;
    }

    @Override
    @NotNull
    public JsExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        switch (IrElementToJsExpressionTransformer$WhenMappings.$EnumSwitchMapping$1[expression2.getOperator().ordinal()]) {
            case 1: {
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("All type operator calls except IMPLICIT_CAST should be lowered at this point");
            }
        }
        return (JsExpression)expression2.getArgument().accept(this, data);
    }

    private final boolean isNativeInvoke(IrCall call2) {
        IrFunction irFunction = call2.getSymbol().getOwner();
        if (!(irFunction instanceof IrSimpleFunction)) {
            irFunction = null;
        }
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)irFunction;
        if (irSimpleFunction == null) {
            return false;
        }
        IrSimpleFunction simpleFunction = irSimpleFunction;
        Object object = simpleFunction.getDispatchReceiverParameter();
        if (object == null || (object = object.getType()) == null) {
            return false;
        }
        Object receiverType = object;
        if (simpleFunction.isSuspend()) {
            return false;
        }
        if (receiverType instanceof IrDynamicType) {
            return Intrinsics.areEqual((Object)call2.getOrigin(), (Object)IrStatementOrigin.INVOKE.INSTANCE);
        }
        return Intrinsics.areEqual((Object)simpleFunction.getName(), (Object)OperatorNameConventions.INVOKE) && IrTypeUtilsKt.isFunctionTypeOrSubtype((IrType)receiverType);
    }

    @Override
    @NotNull
    public JsExpression visitElement(@NotNull IrElement element, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    @NotNull
    public JsExpression visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeAlias(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitBlock(@NotNull IrBlock expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitBlockBody(@NotNull IrBlockBody body, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBlockBody(this, body, data);
    }

    @Override
    @NotNull
    public JsExpression visitBody(@NotNull IrBody body, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBody(this, body, data);
    }

    @Override
    @NotNull
    public JsExpression visitBranch(@NotNull IrBranch branch, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    @NotNull
    public JsExpression visitBreak(@NotNull IrBreak jump, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    @NotNull
    public JsExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    @NotNull
    public JsExpression visitCallableReference(@NotNull IrCallableReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitCatch(@NotNull IrCatch aCatch, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    @NotNull
    public JsExpression visitClass(@NotNull IrClass declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClass(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitComposite(@NotNull IrComposite expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitConstructor(@NotNull IrConstructor declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstructor(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitContinue(@NotNull IrContinue jump, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    @NotNull
    public JsExpression visitDeclaration(@NotNull IrDeclaration declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclaration(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public JsExpression visitElseBranch(@NotNull IrElseBranch branch, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    @NotNull
    public JsExpression visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumEntry(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitExpression(@NotNull IrExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitField(@NotNull IrField declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitField(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitFile(@NotNull IrFile declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFile(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitFunction(@NotNull IrFunction declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunction(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitLoop(@NotNull IrLoop loop2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public JsExpression visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitModuleFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPackageFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitProperty(@NotNull IrProperty declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitProperty(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitReturn(@NotNull IrReturn expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    @NotNull
    public JsExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitSyntheticBody(@NotNull IrSyntheticBody body, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSyntheticBody(this, body, data);
    }

    @Override
    @NotNull
    public JsExpression visitThrow(@NotNull IrThrow expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitTry(@NotNull IrTry aTry, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    @NotNull
    public JsExpression visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeParameter(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsExpression visitValueParameter(@NotNull IrValueParameter declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueParameter(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitVariable(@NotNull IrVariable declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitVariable(this, declaration, data);
    }

    @Override
    @NotNull
    public JsExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
    }
}

