/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.org.objectweb.asm.Type;

public class FieldInfo {
    private final Type fieldType;
    private final KotlinType fieldKotlinType;
    private final Type ownerType;
    private final String fieldName;
    private final boolean isStatic;

    @NotNull
    public static FieldInfo createForSingleton(@NotNull ClassDescriptor classDescriptor2, @NotNull KotlinTypeMapper typeMapper) {
        if (classDescriptor2 == null) {
            FieldInfo.$$$reportNull$$$0(0);
        }
        if (typeMapper == null) {
            FieldInfo.$$$reportNull$$$0(1);
        }
        if (!classDescriptor2.getKind().isSingleton() || DescriptorUtils.isEnumEntry(classDescriptor2)) {
            throw new UnsupportedOperationException("Can't create singleton field for class: " + classDescriptor2);
        }
        if (DescriptorUtils.isNonCompanionObject(classDescriptor2) || CompanionObjectMapping.INSTANCE.isMappedIntrinsicCompanionObject(classDescriptor2)) {
            FieldInfo fieldInfo = FieldInfo.createSingletonViaInstance(classDescriptor2, typeMapper, "INSTANCE");
            if (fieldInfo == null) {
                FieldInfo.$$$reportNull$$$0(2);
            }
            return fieldInfo;
        }
        ClassDescriptor ownerDescriptor = DescriptorUtils.getParentOfType(classDescriptor2, ClassDescriptor.class);
        assert (ownerDescriptor != null) : "Owner not found for class: " + classDescriptor2;
        Type ownerType = typeMapper.mapClass(ownerDescriptor);
        SimpleType fieldKotlinType = classDescriptor2.getDefaultType();
        Type fieldType = typeMapper.mapType(fieldKotlinType);
        FieldInfo fieldInfo = new FieldInfo(ownerType, fieldType, fieldKotlinType, classDescriptor2.getName().asString(), true);
        if (fieldInfo == null) {
            FieldInfo.$$$reportNull$$$0(3);
        }
        return fieldInfo;
    }

    @NotNull
    public static FieldInfo createSingletonViaInstance(@NotNull ClassDescriptor classDescriptor2, @NotNull KotlinTypeMapper typeMapper, @NotNull String name2) {
        if (classDescriptor2 == null) {
            FieldInfo.$$$reportNull$$$0(4);
        }
        if (typeMapper == null) {
            FieldInfo.$$$reportNull$$$0(5);
        }
        if (name2 == null) {
            FieldInfo.$$$reportNull$$$0(6);
        }
        Type owner = typeMapper.mapClass(classDescriptor2);
        SimpleType fieldKotlinType = classDescriptor2.getDefaultType();
        Type fieldType = typeMapper.mapType(fieldKotlinType);
        FieldInfo fieldInfo = new FieldInfo(owner, fieldType, fieldKotlinType, name2, true);
        if (fieldInfo == null) {
            FieldInfo.$$$reportNull$$$0(7);
        }
        return fieldInfo;
    }

    @NotNull
    public static FieldInfo createForHiddenField(@NotNull Type owner, @NotNull Type fieldType, @NotNull String fieldName) {
        if (owner == null) {
            FieldInfo.$$$reportNull$$$0(8);
        }
        if (fieldType == null) {
            FieldInfo.$$$reportNull$$$0(9);
        }
        if (fieldName == null) {
            FieldInfo.$$$reportNull$$$0(10);
        }
        FieldInfo fieldInfo = FieldInfo.createForHiddenField(owner, fieldType, null, fieldName);
        if (fieldInfo == null) {
            FieldInfo.$$$reportNull$$$0(11);
        }
        return fieldInfo;
    }

    @NotNull
    public static FieldInfo createForHiddenField(@NotNull Type owner, @NotNull Type fieldType, @Nullable KotlinType fieldKotlinType, @NotNull String fieldName) {
        if (owner == null) {
            FieldInfo.$$$reportNull$$$0(12);
        }
        if (fieldType == null) {
            FieldInfo.$$$reportNull$$$0(13);
        }
        if (fieldName == null) {
            FieldInfo.$$$reportNull$$$0(14);
        }
        FieldInfo fieldInfo = new FieldInfo(owner, fieldType, fieldKotlinType, fieldName, false);
        if (fieldInfo == null) {
            FieldInfo.$$$reportNull$$$0(15);
        }
        return fieldInfo;
    }

    private FieldInfo(@NotNull Type ownerType, @NotNull Type fieldType, @Nullable KotlinType fieldKotlinType, @NotNull String fieldName, boolean isStatic) {
        if (ownerType == null) {
            FieldInfo.$$$reportNull$$$0(16);
        }
        if (fieldType == null) {
            FieldInfo.$$$reportNull$$$0(17);
        }
        if (fieldName == null) {
            FieldInfo.$$$reportNull$$$0(18);
        }
        this.ownerType = ownerType;
        this.fieldType = fieldType;
        this.fieldKotlinType = fieldKotlinType;
        this.fieldName = fieldName;
        this.isStatic = isStatic;
    }

    @NotNull
    public Type getFieldType() {
        Type type2 = this.fieldType;
        if (type2 == null) {
            FieldInfo.$$$reportNull$$$0(19);
        }
        return type2;
    }

    @Nullable
    public KotlinType getFieldKotlinType() {
        return this.fieldKotlinType;
    }

    @NotNull
    public Type getOwnerType() {
        Type type2 = this.ownerType;
        if (type2 == null) {
            FieldInfo.$$$reportNull$$$0(20);
        }
        return type2;
    }

    @NotNull
    public String getOwnerInternalName() {
        String string = this.ownerType.getInternalName();
        if (string == null) {
            FieldInfo.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public String getFieldName() {
        String string = this.fieldName;
        if (string == null) {
            FieldInfo.$$$reportNull$$$0(22);
        }
        return string;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String toString() {
        return String.format("%s %s.%s : %s", this.isStatic ? "GETSTATIC" : "GETFIELD", this.ownerType.getInternalName(), this.fieldName, this.fieldType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/FieldInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 9: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 10: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/FieldInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createForSingleton";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingletonViaInstance";
                break;
            }
            case 11: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createForHiddenField";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnerType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnerInternalName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createForSingleton";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSingletonViaInstance";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createForHiddenField";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

