/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.EffectSystem;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class DataFlowAnalyzer {
    private final Iterable<AdditionalTypeChecker> additionalTypeCheckers;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final ModuleDescriptor module;
    private final KotlinBuiltIns builtIns;
    private final ExpressionTypingFacade facade;
    private final LanguageVersionSettings languageVersionSettings;
    private final EffectSystem effectSystem;
    private final DataFlowValueFactory dataFlowValueFactory;

    public DataFlowAnalyzer(@NotNull Iterable<AdditionalTypeChecker> additionalTypeCheckers, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull ModuleDescriptor module2, @NotNull KotlinBuiltIns builtIns2, @NotNull ExpressionTypingFacade facade, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull EffectSystem effectSystem, @NotNull DataFlowValueFactory factory2) {
        if (additionalTypeCheckers == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(0);
        }
        if (constantExpressionEvaluator == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(1);
        }
        if (module2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(2);
        }
        if (builtIns2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(3);
        }
        if (facade == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(4);
        }
        if (languageVersionSettings == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(5);
        }
        if (effectSystem == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(6);
        }
        if (factory2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(7);
        }
        this.additionalTypeCheckers = additionalTypeCheckers;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.module = module2;
        this.builtIns = builtIns2;
        this.facade = facade;
        this.languageVersionSettings = languageVersionSettings;
        this.effectSystem = effectSystem;
        this.dataFlowValueFactory = factory2;
    }

    @Nullable
    private FunctionDescriptor getOverriddenDescriptorFromClass(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(8);
        }
        if (descriptor2.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            return descriptor2;
        }
        Collection<? extends FunctionDescriptor> overriddenDescriptors = descriptor2.getOverriddenDescriptors();
        if (overriddenDescriptors.isEmpty()) {
            return descriptor2;
        }
        for (FunctionDescriptor functionDescriptor : overriddenDescriptors) {
            DeclarationDescriptor containingDeclaration = functionDescriptor.getContainingDeclaration();
            if (!DescriptorUtils.isClass(containingDeclaration) && !DescriptorUtils.isObject(containingDeclaration)) continue;
            return this.getOverriddenDescriptorFromClass(functionDescriptor);
        }
        return null;
    }

    private boolean typeHasOverriddenEquals(@NotNull KotlinType type2, @NotNull KtElement lookupElement) {
        if (type2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(9);
        }
        if (lookupElement == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(10);
        }
        Collection<? extends SimpleFunctionDescriptor> members = type2.getMemberScope().getContributedFunctions(OperatorNameConventions.EQUALS, new KotlinLookupLocation(lookupElement));
        for (FunctionDescriptor functionDescriptor : members) {
            KotlinType parameterType;
            KotlinType returnType2 = functionDescriptor.getReturnType();
            if (returnType2 == null || !KotlinBuiltIns.isBoolean(returnType2) || functionDescriptor.getValueParameters().size() != 1 || !KotlinBuiltIns.isNullableAny(parameterType = functionDescriptor.getValueParameters().iterator().next().getType())) continue;
            FunctionDescriptor fromSuperClass = this.getOverriddenDescriptorFromClass(functionDescriptor);
            if (fromSuperClass == null) {
                return false;
            }
            ClassifierDescriptor superClassDescriptor = (ClassifierDescriptor)fromSuperClass.getContainingDeclaration();
            return !KotlinBuiltIns.isAnyOrNullableAny(superClassDescriptor.getDefaultType());
        }
        return false;
    }

    public boolean typeHasEqualsFromAny(@NotNull KotlinType type2, @NotNull KtElement lookupElement) {
        TypeConstructor constructor;
        if (type2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(11);
        }
        if (lookupElement == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(12);
        }
        if (!(constructor = type2.getConstructor()).isFinal()) {
            return false;
        }
        return !this.typeHasOverriddenEquals(type2, lookupElement);
    }

    @NotNull
    public DataFlowInfo extractDataFlowInfoFromCondition(final @Nullable KtExpression condition, final boolean conditionValue, final ExpressionTypingContext context) {
        if (condition == null) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            if (dataFlowInfo == null) {
                DataFlowAnalyzer.$$$reportNull$$$0(13);
            }
            return dataFlowInfo;
        }
        final Ref result2 = new Ref(null);
        condition.accept(new KtVisitorVoid(){

            @Override
            public void visitIsExpression(@NotNull KtIsExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (conditionValue && !expression2.isNegated() || !conditionValue && expression2.isNegated()) {
                    result2.set((Object)context.trace.get(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression2));
                }
            }

            @Override
            public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
                IElementType operationToken;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey((Object)(operationToken = expression2.getOperationToken()))) {
                    DataFlowInfo dataFlowInfo = DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(expression2.getLeft(), conditionValue, context);
                    KtExpression expressionRight = expression2.getRight();
                    if (expressionRight != null) {
                        boolean and = operationToken == KtTokens.ANDAND;
                        DataFlowInfo rightInfo = DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(expressionRight, conditionValue, and == conditionValue ? (ExpressionTypingContext)context.replaceDataFlowInfo(dataFlowInfo) : context);
                        dataFlowInfo = and == conditionValue ? dataFlowInfo.and(rightInfo) : dataFlowInfo.or(rightInfo);
                    }
                    result2.set((Object)dataFlowInfo);
                } else {
                    DataFlowInfo expressionFlowInfo = DataFlowAnalyzer.this.facade.getTypeInfo(expression2, context).getDataFlowInfo();
                    KtExpression left = expression2.getLeft();
                    if (left == null) {
                        return;
                    }
                    KtExpression right = expression2.getRight();
                    if (right == null) {
                        return;
                    }
                    KotlinType lhsType = context.trace.getBindingContext().getType(left);
                    if (lhsType == null) {
                        return;
                    }
                    KotlinType rhsType = context.trace.getBindingContext().getType(right);
                    if (rhsType == null) {
                        return;
                    }
                    DataFlowValue leftValue = DataFlowAnalyzer.this.dataFlowValueFactory.createDataFlowValue(left, lhsType, context);
                    DataFlowValue rightValue = DataFlowAnalyzer.this.dataFlowValueFactory.createDataFlowValue(right, rhsType, context);
                    Boolean equals = null;
                    if (operationToken == KtTokens.EQEQ || operationToken == KtTokens.EQEQEQ) {
                        equals = true;
                    } else if (operationToken == KtTokens.EXCLEQ || operationToken == KtTokens.EXCLEQEQEQ) {
                        equals = false;
                    } else if (operationToken == KtTokens.ELVIS && DataFlowAnalyzer.this.languageVersionSettings.supportsFeature(LanguageFeature.BooleanElvisBoundSmartCasts) && right instanceof KtConstantExpression && KotlinBuiltIns.isBoolean(rhsType)) {
                        equals = KtPsiUtil.isFalseConstant(right);
                    }
                    if (equals != null) {
                        if (equals == conditionValue) {
                            boolean identityEquals = operationToken == KtTokens.EQEQEQ || operationToken == KtTokens.EXCLEQEQEQ || DataFlowAnalyzer.this.typeHasEqualsFromAny(lhsType, condition);
                            result2.set((Object)context.dataFlowInfo.equate(leftValue, rightValue, identityEquals, DataFlowAnalyzer.this.languageVersionSettings).and(expressionFlowInfo));
                        } else {
                            result2.set((Object)context.dataFlowInfo.disequate(leftValue, rightValue, DataFlowAnalyzer.this.languageVersionSettings).and(expressionFlowInfo));
                        }
                    } else {
                        result2.set((Object)expressionFlowInfo);
                    }
                }
            }

            @Override
            public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
                IElementType operationTokenType;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((operationTokenType = expression2.getOperationReference().getReferencedNameElementType()) == KtTokens.EXCL) {
                    KtExpression baseExpression = expression2.getBaseExpression();
                    if (baseExpression != null) {
                        result2.set((Object)DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(baseExpression, !conditionValue, context));
                    }
                } else {
                    this.visitExpression(expression2);
                }
            }

            @Override
            public void visitExpression(@NotNull KtExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                result2.set((Object)DataFlowAnalyzer.this.facade.getTypeInfo(expression2, context).getDataFlowInfo());
            }

            @Override
            public void visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2) {
                KtExpression body;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((body = expression2.getExpression()) != null) {
                    body.accept(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "expression";
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIsExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBinaryExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitUnaryExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitParenthesizedExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        DataFlowInfo infoFromEffectSystem = this.effectSystem.extractDataFlowInfoFromCondition(condition, conditionValue, context.trace, DescriptorUtils.getContainingModule(context.scope.getOwnerDescriptor()));
        if (result2.get() == null) {
            DataFlowInfo dataFlowInfo = context.dataFlowInfo.and(infoFromEffectSystem);
            if (dataFlowInfo == null) {
                DataFlowAnalyzer.$$$reportNull$$$0(14);
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = context.dataFlowInfo.and((DataFlowInfo)result2.get()).and(infoFromEffectSystem);
        if (dataFlowInfo == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(15);
        }
        return dataFlowInfo;
    }

    @Nullable
    public KotlinType checkType(@Nullable KotlinType expressionType, @NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(16);
        }
        if (context == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(17);
        }
        return this.checkType(expressionType, expression2, context, null, true);
    }

    @Nullable
    public KotlinType checkType(@Nullable KotlinType expressionType, @NotNull KtExpression expression2, @NotNull ResolutionContext context, boolean reportErrorForTypeMismatch) {
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(18);
        }
        if (context == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(19);
        }
        return this.checkType(expressionType, expression2, context, null, reportErrorForTypeMismatch);
    }

    @NotNull
    public KotlinTypeInfo checkType(@NotNull KotlinTypeInfo typeInfo, @NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        if (typeInfo == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(20);
        }
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(21);
        }
        if (context == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(22);
        }
        KotlinTypeInfo kotlinTypeInfo = typeInfo.replaceType(this.checkType(typeInfo.getType(), expression2, context));
        if (kotlinTypeInfo == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(23);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    private KotlinType checkTypeInternal(@NotNull KotlinType expressionType, @NotNull KtExpression expression2, @NotNull ResolutionContext c, @NotNull Ref<Boolean> hasError, boolean reportErrorForTypeMismatch) {
        if (expressionType == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(24);
        }
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(25);
        }
        if (c == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(26);
        }
        if (hasError == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(27);
        }
        if (TypeUtils.noExpectedType(c.expectedType) || !c.expectedType.getConstructor().isDenotable() || KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, c.expectedType)) {
            KotlinType kotlinType2 = expressionType;
            if (kotlinType2 == null) {
                DataFlowAnalyzer.$$$reportNull$$$0(28);
            }
            return kotlinType2;
        }
        if (expression2 instanceof KtConstantExpression && reportErrorForTypeMismatch) {
            ConstantValue<?> constantValue = this.constantExpressionEvaluator.evaluateToConstantValue(expression2, c.trace, c.expectedType);
            boolean error = new CompileTimeConstantChecker(c, this.module, true).checkConstantExpressionType(constantValue, (KtConstantExpression)expression2, c.expectedType);
            hasError.set((Object)error);
            KotlinType kotlinType3 = expressionType;
            if (kotlinType3 == null) {
                DataFlowAnalyzer.$$$reportNull$$$0(29);
            }
            return kotlinType3;
        }
        if (expression2 instanceof KtWhenExpression) {
            KotlinType kotlinType4 = expressionType;
            if (kotlinType4 == null) {
                DataFlowAnalyzer.$$$reportNull$$$0(30);
            }
            return kotlinType4;
        }
        SmartCastResult castResult = this.checkPossibleCast(expressionType, expression2, c);
        if (castResult != null) {
            KotlinType kotlinType5 = castResult.getResultType();
            if (kotlinType5 == null) {
                DataFlowAnalyzer.$$$reportNull$$$0(31);
            }
            return kotlinType5;
        }
        if (reportErrorForTypeMismatch && !DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(c, expression2, c.expectedType, expressionType) && !DiagnosticUtilsKt.reportTypeMismatchDueToScalaLikeNamedFunctionSyntax(c, expression2, c.expectedType, expressionType)) {
            c.trace.report(Errors.TYPE_MISMATCH.on(expression2, c.expectedType, expressionType));
        }
        hasError.set((Object)true);
        KotlinType kotlinType6 = expressionType;
        if (kotlinType6 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(32);
        }
        return kotlinType6;
    }

    @Nullable
    public KotlinType checkType(@Nullable KotlinType expressionType, @NotNull KtExpression expressionToCheck, @NotNull ResolutionContext c, @Nullable Ref<Boolean> hasError, boolean reportErrorForTypeMismatch) {
        if (expressionToCheck == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(33);
        }
        if (c == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(34);
        }
        if (hasError == null) {
            hasError = Ref.create((Object)false);
        } else {
            hasError.set((Object)false);
        }
        KtExpression expression2 = KtPsiUtil.safeDeparenthesize(expressionToCheck);
        this.recordExpectedType(c.trace, expression2, c.expectedType);
        if (expressionType == null) {
            return null;
        }
        KotlinType result2 = this.checkTypeInternal(expressionType, expression2, c, (Ref<Boolean>)hasError, reportErrorForTypeMismatch);
        if (Boolean.FALSE.equals(hasError.get())) {
            for (AdditionalTypeChecker checker : this.additionalTypeCheckers) {
                checker.checkType(expression2, expressionType, result2, c);
            }
        }
        return result2;
    }

    @Nullable
    public SmartCastResult checkPossibleCast(@NotNull KotlinType expressionType, @NotNull KtExpression expression2, @NotNull ResolutionContext c) {
        if (expressionType == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(35);
        }
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(36);
        }
        if (c == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(37);
        }
        DataFlowValue dataFlowValue2 = this.dataFlowValueFactory.createDataFlowValue(expression2, expressionType, c);
        return SmartCastManager.Companion.checkAndRecordPossibleCast(dataFlowValue2, c.expectedType, expression2, c, null, false);
    }

    public void recordExpectedType(@NotNull BindingTrace trace, @NotNull KtExpression expression2, @NotNull KotlinType expectedType) {
        if (trace == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(38);
        }
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(39);
        }
        if (expectedType == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(40);
        }
        if (expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            KotlinType normalizeExpectedType = expectedType == TypeUtils.UNIT_EXPECTED_TYPE ? this.builtIns.getUnitType() : expectedType;
            trace.record(BindingContext.EXPECTED_EXPRESSION_TYPE, expression2, normalizeExpectedType);
        }
    }

    @Nullable
    public KotlinType checkStatementType(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(41);
        }
        if (context == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(42);
        }
        if (!(TypeUtils.noExpectedType(context.expectedType) || KotlinBuiltIns.isUnit(context.expectedType) || KotlinTypeKt.isError(context.expectedType))) {
            context.trace.report(Errors.EXPECTED_TYPE_MISMATCH.on(expression2, context.expectedType));
            return null;
        }
        return this.builtIns.getUnitType();
    }

    @NotNull
    public KotlinTypeInfo illegalStatementType(@NotNull KtExpression expression2, @NotNull ExpressionTypingContext context, @NotNull ExpressionTypingInternals facade) {
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(43);
        }
        if (context == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(44);
        }
        if (facade == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(45);
        }
        facade.checkStatementType(expression2, (ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        context.trace.report(Errors.EXPRESSION_EXPECTED.on(expression2, expression2));
        KotlinTypeInfo kotlinTypeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        if (kotlinTypeInfo == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(46);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public static Collection<KotlinType> getAllPossibleTypes(@NotNull KtExpression expression2, @NotNull KotlinType type2, @NotNull ResolutionContext c) {
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(47);
        }
        if (type2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(48);
        }
        if (c == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(49);
        }
        DataFlowValue dataFlowValue2 = c.dataFlowValueFactory.createDataFlowValue(expression2, type2, c);
        return DataFlowAnalyzer.getAllPossibleTypes(type2, c, dataFlowValue2, c.languageVersionSettings);
    }

    @NotNull
    public static Collection<KotlinType> getAllPossibleTypes(@NotNull KotlinType type2, @NotNull ResolutionContext c, @NotNull DataFlowValue dataFlowValue2, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (type2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(50);
        }
        if (c == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(51);
        }
        if (dataFlowValue2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(52);
        }
        if (languageVersionSettings == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(53);
        }
        HashSet possibleTypes = Sets.newHashSet((Object[])new KotlinType[]{type2});
        possibleTypes.addAll(c.dataFlowInfo.getStableTypes(dataFlowValue2, languageVersionSettings));
        HashSet hashSet = possibleTypes;
        if (hashSet == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(54);
        }
        return hashSet;
    }

    @NotNull
    public KotlinTypeInfo createCheckedTypeInfo(@Nullable KotlinType type2, @NotNull ResolutionContext<?> context, @NotNull KtExpression expression2) {
        if (context == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(55);
        }
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(56);
        }
        KotlinTypeInfo kotlinTypeInfo = this.checkType(TypeInfoFactoryKt.createTypeInfo(type2, context), expression2, context);
        if (kotlinTypeInfo == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(57);
        }
        return kotlinTypeInfo;
    }

    @NotNull
    public KotlinTypeInfo createCompileTimeConstantTypeInfo(@NotNull CompileTimeConstant<?> value, @NotNull KtExpression expression2, @NotNull ExpressionTypingContext context) {
        KotlinType expressionType;
        if (value == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(58);
        }
        if (expression2 == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(59);
        }
        if (context == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(60);
        }
        if (value instanceof IntegerValueTypeConstant) {
            IntegerValueTypeConstant integerValueTypeConstant = (IntegerValueTypeConstant)value;
            if (context.contextDependency == ContextDependency.INDEPENDENT) {
                expressionType = integerValueTypeConstant.getType(context.expectedType);
                this.constantExpressionEvaluator.updateNumberType(expressionType, expression2, context.statementFilter, context.trace);
            } else {
                expressionType = integerValueTypeConstant.getUnknownIntegerType();
            }
        } else {
            expressionType = ((TypedCompileTimeConstant)value).getType();
        }
        KotlinTypeInfo kotlinTypeInfo = this.createCheckedTypeInfo(expressionType, context, expression2);
        if (kotlinTypeInfo == null) {
            DataFlowAnalyzer.$$$reportNull$$$0(61);
        }
        return kotlinTypeInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 54: 
            case 57: 
            case 61: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 54: 
            case 57: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalTypeCheckers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constantExpressionEvaluator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 4: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 5: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectSystem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: 
            case 11: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 54: 
            case 57: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer";
                break;
            }
            case 16: 
            case 18: 
            case 21: 
            case 25: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 47: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: 
            case 19: 
            case 22: 
            case 42: 
            case 44: 
            case 55: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 24: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionType";
                break;
            }
            case 26: 
            case 34: 
            case 37: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasError";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToCheck";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlowValue";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/types/expressions/DataFlowAnalyzer";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDataFlowInfoFromCondition";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "checkType";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "checkTypeInternal";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "illegalStatementType";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPossibleTypes";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckedTypeInfo";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompileTimeConstantTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenDescriptorFromClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "typeHasOverriddenEquals";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "typeHasEqualsFromAny";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 54: 
            case 57: 
            case 61: {
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkTypeInternal";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "checkPossibleCast";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "recordExpectedType";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkStatementType";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "illegalStatementType";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getAllPossibleTypes";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createCheckedTypeInfo";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createCompileTimeConstantTypeInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 46: 
            case 54: 
            case 57: 
            case 61: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

